;; coffee-risc machine description
;; Version history:    
;; 0.9  1.4.2004    By Markus Moisio    First Release
;;		 	 
;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;
;; Define attributes, copied from clipper, cris and others.
;;
;; instruction type
;;
;; unknown is temporary in order to generate 'cc clobber' until attribute
;; assignment is consistent
;;
(define_attr "type" "load,store,arith,branch,unknown,cmp,fadd,fmul,fdiv,fload,fstore,fconv,fsqrt,fcmp,fabs,fmov,fneg"
 (const_string "unknown"))

;; Condition code setting
;;
;; clobber	destroyed
;; unchanged	remains the same
;; set		set
;;
(define_attr "cc" "clobber,unchanged,set" (const_string "unchanged"))


;;For branch delay slot scheduling, taken from cris. Buggy so removed.
(define_attr "slottable" "no,yes,has_slot" (const_string "no"))

(define_delay (eq_attr "slottable" "has_slot")
  [(eq_attr "slottable" "yes") (nil) (nil)])



(define_constants
  [(UNSPECV_IMB		0)
   (UNSPECV_BLOCKAGE	1)
   (UNSPECV_SETJMPR	2)	; builtin_setjmp_receiver
   (UNSPECV_LONGJMP	3)	; builtin_longjmp
   (UNSPECV_TRAPB	4)
   (UNSPECV_PSPL	5)	; prologue_stack_probe_loop
   (UNSPECV_REALIGN	6)
   (UNSPECV_EHR		7)	; exception_receiver
   (UNSPECV_MCOUNT	8)
   (UNSPECV_FORCE_MOV	9)
   (UNSPECV_LDGP1	10)
   (UNSPECV_PLDGP2	11)	; prologue ldgp
   (UNSPECV_SET_TP	12)
   (UNSPECV_RPCC	13)
   (UNSPECV_SETJMPR_ER	14)	; builtin_setjmp_receiver fragment
   (CC_REG		32)
  ])


(define_predicate "sym_ref_mem_operand"
  (match_operand 0 "memory_operand")
{
  if(GET_CODE(op) == MEM)
    {
      rtx t1 = XEXP(op, 0);
      if(GET_CODE(t1) == SYMBOL_REF)
        {
          return 1;
        }
    }
  return 0;
})

;; Move patterns  

(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	  (match_operand:SI 1 "general_operand" ""))]
""
"
{	
	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
		operands[1] = force_reg (SImode, operands[1]);
}")
 

(define_insn "*movsi_internal_hwfp"
  [(set (match_operand:SI 0 "general_operand" "=r,r,r,m")
	  (match_operand:SI 1 "general_operand" "r,m,i,r"))]
""
"*
{
 int val;
 rtx temp, symbol, offset;
 
  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
    return \"ld\\t%0,%1\";		/* mem -> reg */

  if (which_alternative == 2)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else if (GET_CODE(operands[1]) == CONST)
	{
		temp = XEXP(operands[1], 0);
		if (GET_CODE(temp) == PLUS)
		{
			symbol = XEXP(temp,0);
			offset = XEXP(temp,1);
			
			if (GET_CODE(symbol) == SYMBOL_REF)
			{
				return \"ldra\\t%0,%a1\";
			}
			else
			{
				return \"ldri\\t%0,%1\";
			}
		}
	}
	else
	{
      		val = INTVAL (operands[1]);	/* known const ->reg */

/*
		if (val < 32768  && val >= -32768)
			return \"lli\\t%0,%c1\";
      		return \"lli\\t%0,%k1\\n\\tlui\\t%0,%j1\";
*/
		return \"ldri\\t%0,%1\";
	}
    }

  if (which_alternative == 3)		/* unknown const */
    return \"st\\t%1,%0\";
}"
[(set_attr "type" "arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
 (set_attr "slottable" "yes,yes,no,no")
])

(define_insn "*movsi_internal_swfp"
  [(set (match_operand:SI 0 "general_operand" "=r,r,r,m")
	  (match_operand:SI 1 "general_operand" "r,m,i,r"))]
"SWFP"
"*
{
 int val;
 rtx temp, symbol, offset;
 

  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
    return \"ld\\t%0,%1\";		/* mem -> reg */

  if (which_alternative == 2)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else if (GET_CODE(operands[1]) == CONST)
	{
		temp = XEXP(operands[1], 0);
		if (GET_CODE(temp) == PLUS)
		{
			symbol = XEXP(temp,0);
			offset = XEXP(temp,1);
			
			if (GET_CODE(symbol) == SYMBOL_REF)
			{
				return \"ldra\\t%0,%a1\";
			}
			else
			{
				return \"ldri\\t%0,%1\";
			}
		}
	}
	else
	{
      		val = INTVAL (operands[1]);	/* known const ->reg */

/*
		if (val < 32768  && val >= -32768)
			return \"lli\\t%0,%c1\";
      		return \"lli\\t%0,%k1\\n\\tlui\\t%0,%j1\";
*/
		return \"ldri\\t%0,%1\";
	}
    }

  if (which_alternative == 3)		/* unknown const */
    return \"st\\t%1,%0\";

}"
[(set_attr "type" "arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
 (set_attr "slottable" "yes,yes,no,no")
])

(define_expand "movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "")
	(match_operand:QI 1 "general_operand" ""))]
  ""
{

     if (!reload_completed &&
         (MEM == GET_CODE(operands[0]) || MEM == GET_CODE(operands[1])))
     {
       rtx address;
       rtx wordAddress;
       rtx const3;
       rtx shiftVal;
       rtx loadedValue;
       rtx addressMask;
	rtx topByteValue;
 	rtx signExtendedValue;

       /* warn_of_byte_access(); */

       /* Load the constant 3 into a register. */ 
       const3 = gen_reg_rtx(SImode);
       emit_insn(gen_rtx_SET(SImode, const3, GEN_INT(3)));

       /* Load the address mask with the bitwise complement of 3. */
       addressMask = gen_reg_rtx(SImode);
       emit_insn(gen_rtx_SET(SImode, addressMask, GEN_INT(-4)));

       /* Handle loads first, in case we are dealing with a mem := mem
        * instruction. */
       if (MEM == GET_CODE(operands[1]))
       {
	 /* Loads work as follows. The entire word containing the desired byte
          * is loaded. The bottom bit of the address indicates which
          * byte is required. The desired byte is moved into the most
          * significant byte, and then an arithmetic shift right
          * invoked to achieve sign extension. The desired byte is
          * moved to the MSB by XOR'ing the bottom address bit by 1,
          * multiplying the result by 8, and then shifting left by
          * that amount. Note that shifts only operate on the bottom
          * 4-bits of the source offset, so although the XOR may
          * produce a value which has its upper bits set, only bit 4
          * (i.e., the inverted, shifted bottom address bit) actually
          * gets used.
          */

         /* Ensure the address is in a register. */
         address = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, address, XEXP(operands[1], 0)));

         /* Compute the word address by masking out the bottom bit. */
         wordAddress = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(wordAddress, address, addressMask));

         /* Compute the shift value. This is the two bottom address bits,
          * inverted(not needed in bigendian), and multiplied by 8. */
         shiftVal = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(shiftVal, address, const3));
         emit_insn(gen_ashlsi3(shiftVal, shiftVal, GEN_INT(3)));

         /* Emit the memory load. */
         loadedValue = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, loadedValue, gen_rtx_MEM(SImode, wordAddress)));

	 /* Shift the desired byte to the most significant byte. */
	 topByteValue = gen_reg_rtx (SImode);
	 emit_insn (gen_ashlsi3 (topByteValue, loadedValue, shiftVal));

         /* Sign extend the top-byte back into the bottom byte. */
	 signExtendedValue = gen_reg_rtx(SImode);
         emit_insn(gen_ashrsi3(signExtendedValue, topByteValue, shiftVal));

         /* Final extraction of QI mode register. */
        operands[1] = gen_rtx_SUBREG(QImode, signExtendedValue, 0);

       }

       if (MEM == GET_CODE(operands[0]) && GET_CODE(operands[1]) != MEM)
       {
         rtx zeroingByteMask;
         rtx temp;
         rtx tempQiMode;
         rtx tempSiMode;

         /* Get the address. */
         address = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, address, XEXP(operands[0], 0)));

         /* Compute the word aligned address. */
         wordAddress = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(wordAddress, address, addressMask));

         /* Compute the shift value. Inverted in bigendian */
         shiftVal = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(shiftVal, address, const3));
	 emit_insn(gen_xorsi3(shiftVal, shiftVal, const3));
         emit_insn(gen_ashlsi3(shiftVal, shiftVal, GEN_INT(3)));

         /* Emit the memory load. */
         loadedValue = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, loadedValue, gen_rtx_MEM(SImode, wordAddress)));

         /* Zero out the destination bits by AND'ing with 0x000000FF
          * shifted appropriately and inverted. */
         zeroingByteMask = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, zeroingByteMask, GEN_INT(-256)));
         emit_insn(gen_lshrsi3(zeroingByteMask, zeroingByteMask, shiftVal));
	 emit_insn(gen_one_cmplsi2(zeroingByteMask, zeroingByteMask));
         emit_insn(gen_andsi3(loadedValue, loadedValue, zeroingByteMask));

	 /* Grab the incoming QI register, and ensure that the top bits
	  * are zeroed out. This is because the register may be
	  * storing a signed value, in which case the top-bits will be
	  * sign bits. These must be removed to ensure that the
	  * read-modify-write (which uses an OR) doesn't pick up those
	  * bits, instead of the original memory value which is being
	  * modified.
  	  */
         /*if (register_operand(operands[1],QImode))
         {
           tempSiMode = XEXP(operands[1], 0);
         }
         else
         {
           tempSiMode = operands[1];
         }*/
         //tempSiMode = force_reg(QImode, operands[1]);
         tempSiMode = simplify_gen_subreg(SImode, operands[1], QImode, 0);
         temp = gen_reg_rtx(SImode);
	 emit_insn(gen_rtx_SET(SImode, temp, tempSiMode));
         rtx lsbByteMask = gen_reg_rtx (SImode);
	 emit_insn (gen_rtx_SET (SImode, lsbByteMask, GEN_INT (0xFF)));
	 emit_insn (gen_andsi3 (temp, temp, lsbByteMask));

         /* Shift the incoming byte value by the appropriate amount,
          * and OR into the load value. */
         emit_insn(gen_ashlsi3(temp, temp, shiftVal));
         emit_insn(gen_iorsi3(loadedValue, loadedValue, temp));

         /* Rewrite the original assignment, to assign the new value
          * to the word address. */
         operands[0] = gen_rtx_MEM(SImode, wordAddress);
         operands[1] = loadedValue;

       }

     }
})

(define_expand "movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "")
	(match_operand:HI 1 "general_operand" ""))]
  ""
{

     if (!reload_completed &&
         (MEM == GET_CODE(operands[0]) || MEM == GET_CODE(operands[1])))
     {
       rtx address;
       rtx wordAddress;
       rtx const3;
       rtx shiftVal;
       rtx loadedValue;
       rtx addressMask;
	 rtx topHalfValue;
	 rtx signExtendedValue;

       /* warn_of_byte_access();*/

       /* Load the constant 3 into a register. */
       const3 = gen_reg_rtx(SImode);
       emit_insn(gen_rtx_SET(SImode, const3, GEN_INT(3)));

       /* Load the address mask with the bitwise complement of 3. */
       addressMask = gen_reg_rtx(SImode);
       emit_insn(gen_rtx_SET(SImode, addressMask, GEN_INT(-4)));

       /* Handle loads first, in case we are dealing with a mem := mem
        * instruction. */
       if (MEM == GET_CODE(operands[1]))
       {
	 /* Loads work as follows. The entire word containing the desired byte
          * is loaded. The bottom bit of the address indicates which
          * byte is required. The desired byte is moved into the most
          * significant byte, and then an arithmetic shift right
          * invoked to achieve sign extension. The desired byte is
          * moved to the MSB by XOR'ing the bottom address bit by 1,
          * multiplying the result by 8, and then shifting left by
          * that amount. Note that shifts only operate on the bottom
          * 4-bits of the source offset, so although the XOR may
          * produce a value which has its upper bits set, only bit 4
          * (i.e., the inverted, shifted bottom address bit) actually
          * gets used.
          */

         /* Ensure the address is in a register. */
         address = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, address, XEXP(operands[1], 0)));

         /* Compute the word address by masking out the bottom bit. */
         wordAddress = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(wordAddress, address, addressMask));

         /* Compute the shift value. This is the two bottom address bits,
          * inverted(not needed in bigendian), and multiplied by 8. */
         shiftVal = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(shiftVal, address, const3));
         emit_insn(gen_ashlsi3(shiftVal, shiftVal, GEN_INT(3)));

         /* Emit the memory load. */
         loadedValue = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, loadedValue, gen_rtx_MEM(SImode, wordAddress)));

	 /* Shift the desired byte to the most significant byte. */
	 topHalfValue = gen_reg_rtx (SImode);
	 emit_insn (gen_ashlsi3 (topHalfValue, loadedValue, shiftVal));

         /* Sign extend the top-byte back into the bottom byte. */
	 signExtendedValue = gen_reg_rtx(SImode);
         emit_insn(gen_ashrsi3(signExtendedValue, topHalfValue, shiftVal));

         /* Final extraction of QI mode register. */
        operands[1] = gen_rtx_SUBREG(HImode, signExtendedValue, 0);

       }

       if (MEM == GET_CODE(operands[0]) && GET_CODE(operands[1]) != MEM)
       {
         rtx zeroingByteMask;
         rtx temp;
         rtx tempHiMode;
         rtx tempSiMode;

         /* Get the address. */
         address = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, address, XEXP(operands[0], 0)));

         /* Compute the word aligned address. */
         wordAddress = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(wordAddress, address, addressMask));

         /* Compute the shift value. */
         shiftVal = gen_reg_rtx(SImode);
         emit_insn(gen_andsi3(shiftVal, address, const3));
/*	 emit_insn(gen_xorsi3(shiftVal, shiftVal, const3));*/
         emit_insn(gen_ashlsi3(shiftVal, shiftVal, GEN_INT(3)));

         /* Emit the memory load. */
         loadedValue = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, loadedValue, gen_rtx_MEM(SImode, wordAddress)));

         /* Zero out the destination bits by AND'ing with 0x0000FFFF
          * shifted appropriately and inverted. */
         zeroingByteMask = gen_reg_rtx(SImode);
         emit_insn(gen_rtx_SET(SImode, zeroingByteMask, GEN_INT(0xffff)));
         emit_insn(gen_ashlsi3(zeroingByteMask, zeroingByteMask, shiftVal));
	 emit_insn(gen_one_cmplsi2(zeroingByteMask, zeroingByteMask));
         emit_insn(gen_andsi3(loadedValue, loadedValue, zeroingByteMask));

	 /* Grab the incoming QI register, and ensure that the top bits
	  * are zeroed out. This is because the register may be
	  * storing a signed value, in which case the top-bits will be
	  * sign bits. These must be removed to ensure that the
	  * read-modify-write (which uses an OR) doesn't pick up those
	  * bits, instead of the original memory value which is being
	  * modified.
  	  */
         /*if (register_operand(operands[1],HImode))
         {
           tempSiMode = XEXP(operands[1], 0);
         }
         else
         {
           tempSiMode = operands[1];
         }*/
         //tempSiMode = force_reg(HImode, operands[1]);
         tempSiMode = simplify_gen_subreg(SImode, operands[1], HImode, 0);
         temp = gen_reg_rtx(SImode);
	 emit_insn(gen_rtx_SET(SImode, temp, tempSiMode));
         rtx lowerHalfByteMask = gen_reg_rtx (SImode);
	 emit_insn (gen_rtx_SET (SImode, lowerHalfByteMask, GEN_INT (0xFFFF)));
	 emit_insn (gen_andsi3 (temp, temp, lowerHalfByteMask));

         /* Shift the incoming byte value by the appropriate amount,
          * and OR into the load value. */
         emit_insn(gen_ashlsi3(temp, temp, shiftVal));
         emit_insn(gen_iorsi3(loadedValue, loadedValue, temp));

         /* Rewrite the original assignment, to assign the new value
          * to the word address. */
         operands[0] = gen_rtx_MEM(SImode, wordAddress);
         operands[1] = loadedValue;
       }
     }
})




;;(define_expand "movdf"
;;  [(set (match_operand:DF 0 "general_operand" "")
;;	(match_operand:DF 1 "general_operand" ""))]
 ;; ""
  ;;"
;;	if (GET_CODE (operands[0]) == MEM)
 ;;       	operands[1] = force_reg (DFmode, operands[1]);
  ;;"
;;)
(define_insn "movdf"
        [(set (match_operand:DF 0 "nonimmediate_operand" "=r, r, m, r")
              (match_operand:DF 1 "general_operand"      " r, m, r, i"))]
        ""
        "*
         return or32_output_move_double (operands);
        ")


;; Reload instructions.  See picochip_secondary_reload_class for an
;; explanation of why an SI mode register is used as a scratch.  The
;; memory operand must be stored in a register (i.e., it can't be an
;; offset to another register - this would require another scratch
;; register into which the address of the offset could be computed).

;; Reload instructions.  See picochip_secondary_reload for an
;; explanation of why an SI mode register is used as a scratch.  The
;; memory operand must be stored in a register (i.e., it can't be an
;; offset to another register - this would require another scratch
;; register into which the address of the offset could be computed).

(define_expand "reload_inqi"
  [(parallel [(match_operand:QI 0 "register_operand" "=&r")
              (match_operand:QI 1 "memory_operand" "m")
	      (match_operand:DI 2 "register_operand" "=&r")])]
  ""
{
  rtx scratch, seq;

  gcc_assert (GET_CODE (operands[1]) == MEM);

  if (picochip_word_aligned_memory_reference(XEXP(operands[1], 0)))
  {
    /* Aligned reloads are easy, since they can use word-loads. */
    seq = gen_synthesised_loadqi_aligned(operands[0], operands[1], scratch);
  }
  else
  {

    /* Get the scratch register.  Given an SI mode value, we have a
       choice of two SI mode scratch registers, so we can be sure that at
       least one of the scratch registers will be different to the output
       register, operand[0]. */

    if (REGNO (operands[0]) == REGNO (operands[2]))
      scratch = gen_rtx_REG (SImode, REGNO (operands[2]) + 1);
    else
      scratch = gen_rtx_REG (SImode, REGNO (operands[2]));

    /* Ensure that the scratch doesn't overlap either of the other
       two operands - however, the other two may overlap each
       other. */
    gcc_assert (REGNO(scratch) != REGNO(operands[0]));
    gcc_assert (REGNO(scratch) != REGNO(operands[1]));

    /* Emit the instruction using a define_insn. */
    seq = gen_synthesised_loadqi_unaligned(operands[0], operands[1], scratch);
  }
  emit_insn (seq);

  DONE;

})

(define_expand "reload_outqi"
  [(parallel [(match_operand 0 "memory_operand" "=m")
	      (match_operand:QI 1 "register_operand" "r")
	      (match_operand:DI 2 "register_operand" "=&r")])]
  ""
{
  rtx scratch1 = gen_rtx_REG(SImode, REGNO(operands[2]));
  rtx scratch2 = gen_rtx_REG(SImode, REGNO(operands[2]) + 1);
  rtx seq;

  gcc_assert (GET_CODE (operands[0]) == MEM);

  if (picochip_word_aligned_memory_reference(XEXP(operands[0], 0)))
    {
      rtx alignedAddr, bitShift;

      /* Convert the address of the known alignment into two operands
       * representing the aligned base address, and the number of shift bits
       * required to access the required value. */
      picochip_get_hi_aligned_mem(operands[0], &alignedAddr, &bitShift);

      /* Emit an aligned store of the source, with the given bit offset. */
      seq = gen_synthesised_storeqi_aligned(alignedAddr, operands[1], scratch1, scratch2, bitShift);

    }
  else
    {
      /* This isnt exercised at all. Moreover, with new devices, byte access
         is available in all variants. 
      gcc_unreachable();*/
    }

  emit_insn (seq);
  DONE;

})

(define_expand "reload_inhi"
  [(parallel [(match_operand:HI 0 "register_operand" "=&r")
              (match_operand:HI 1 "memory_operand" "m")
	      (match_operand:DI 2 "register_operand" "=&r")])]
  ""
{
  rtx scratch, seq;

  gcc_assert (GET_CODE (operands[1]) == MEM);

  if (picochip_word_aligned_memory_reference(XEXP(operands[1], 0)))
  {
    /* Aligned reloads are easy, since they can use word-loads. */
    seq = gen_synthesised_loadhi_aligned(operands[0], operands[1], scratch);
  }
  else
  {
  /* Get the scratch register.  Given an SI mode value, we have a
     choice of two SI mode scratch registers, so we can be sure that at
     least one of the scratch registers will be different to the output
     register, operand[0]. */

  if (REGNO (operands[0]) == REGNO (operands[2]))
    scratch = gen_rtx_REG (SImode, REGNO (operands[2]) + 1);
  else
    scratch = gen_rtx_REG (SImode, REGNO (operands[2]));

  /* Ensure that the scratch doesn't overlap either of the other
     two operands - however, the other two may overlap each
     other. */
  gcc_assert (REGNO(scratch) != REGNO(operands[0]));
  gcc_assert (REGNO(scratch) != REGNO(operands[1]));


    /* Emit the instruction using a define_insn. */
    seq = gen_synthesised_loadhi_unaligned(operands[0], operands[1], scratch);
  }
  emit_insn (seq);

  DONE;

})

(define_expand "reload_outhi"
  [(parallel [(match_operand 0 "memory_operand" "=m")
	      (match_operand:HI 1 "register_operand" "r")
	      (match_operand:DI 2 "register_operand" "=&r")])]
  ""
{
  rtx scratch1 = gen_rtx_REG(SImode, REGNO(operands[2]));
  rtx scratch2 = gen_rtx_REG(SImode, REGNO(operands[2]) + 1);
  rtx seq;

  gcc_assert (GET_CODE (operands[0]) == MEM);

  if (picochip_word_aligned_memory_reference(XEXP(operands[0], 0)))
    {
      rtx alignedAddr, bitShift;

      /* Convert the address of the known alignment into two operands
       * representing the aligned base address, and the number of shift bits
       * required to access the required value. */
      picochip_get_hi_aligned_mem(operands[0], &alignedAddr, &bitShift);

      /* Emit an aligned store of the source, with the given bit offset. */
      seq = gen_synthesised_storehi_aligned(alignedAddr, operands[1], scratch1, scratch2, bitShift);

    }
  else
    {
      /* This isnt exercised at all. Moreover, with new devices, byte access
         is available in all variants. 
      gcc_unreachable();*/
    }

  emit_insn (seq);
  DONE;

})


;; Given a memory operand whose alignment is known (the HImode aligned
;; base is operand 0, and the number of bits by which to shift is in
;; operand 5),
(define_expand "synthesised_storeqi_aligned"
  [; s1 = mem_op
   (set (match_operand:SI 2 "register_operand" "")
	(match_operand:SI 0 "memory_operand" ""))
   ; s1 = s1 and mask
   (set (match_dup 2) (and:SI (match_dup 2) (match_dup 5)))
   ; s2 = source << bitShift
   (set (match_dup 3)
	(ashift:SI (subreg:SI (match_operand:QI 1 "register_operand" "") 0)
		   (match_operand:SI 4 "const_int_operand" "")))
   ; s1 = s1 or s2
   (set (match_dup 2) (ior:SI (match_dup 2) (match_dup 3)))
   ; mem_op = s1
   (set (match_dup 0) (match_dup 2))]
  ""
{
  /* Create the byte mask 0xFF00. */
  operands[5] = gen_int_mode(((~0xFF) >> INTVAL (operands[4])), SImode);
})

;; Perform a byte load of an alignable memory operand.
; op0 = register to load. op1 = memory operand from which to load
; op2 = op1, aligned to HI, op3 = const bit shift required to extract byte,
; op4 = INTVAL(24 - op3)
(define_expand "synthesised_loadqi_aligned"
  [; Load memory operand into register
   (set (match_operand:SI 2 "register_operand" "=r")
	(match_dup 3))
   ; Shift required byte into top byte of word.
   (set (match_dup 2)
	(ashift:SI (match_dup 2)
		   (match_dup 4)))
   ; Arithmetic shift of byte to sign extend, and move to lowest register.
   (set (subreg:SI (match_dup 0) 0)
	(ashiftrt:SI (match_dup 2) 
		     (const_int 24)))
   (use (match_operand:QI 1 "picochip_alignable_memory_operand" "g"))]
  ""
{
  rtx alignedAddr, bitShift;

  /* Convert the address of the known alignment into two operands
   * representing the aligned base address, and the number of shift bits
   * required to access the required value. */
  picochip_get_hi_aligned_mem(operands[1], &alignedAddr, &bitShift);

  operands[3] = alignedAddr;
  operands[4] = GEN_INT(24 - INTVAL(bitShift));
})

(define_insn "synthesised_loadqi_unaligned"
  [(set (match_operand:QI 0 "register_operand" "=r")
        (match_operand:QI 1 "memory_operand" "m"))
   (clobber (match_operand:SI 2 "register_operand" "=&r"))]
  ""
  "// Synthesised loadqi %0 = Mem(%1) (Scratch %2)\n\tand\t%2,%1,-3\n\tld\t%0,%2,0\n\tand\t%2,%1,3\n\tsll\t%2,%2,3\n\tnot\t%2,%2\n\tadd\t%2,%2,1\n\tadd\t%2,%2,24\n\tsll\t%0,%2,%0\n\tsrai\t%0,%0,24"
)

(define_expand "synthesised_storehi_aligned"
  [; s1 = mem_op
   (set (match_operand:SI 2 "register_operand" "")
	(match_operand:SI 0 "memory_operand" ""))
   ; s1 = s1 and mask
   (set (match_dup 2) (and:SI (match_dup 2) (match_dup 5)))
   ; s2 = source << bitShift
   (set (match_dup 3)
	(ashift:SI (subreg:SI (match_operand:HI 1 "register_operand" "") 0)
		   (match_operand:SI 4 "const_int_operand" "")))
   ; s1 = s1 or s2
   (set (match_dup 2) (ior:SI (match_dup 2) (match_dup 3)))
   ; mem_op = s1
   (set (match_dup 0) (match_dup 2))]
  ""
{
  /* Create the byte mask 0x0000FFFF. */
  operands[5] = gen_int_mode(((~0xFFFF) >> INTVAL (operands[4])), SImode);
})

(define_expand "synthesised_loadhi_aligned"
  [; Load memory operand into register
   (set (match_operand:SI 2 "register_operand" "=r")
	(match_dup 3))
   ; Shift required byte into top byte of word.
   (set (match_dup 2)
	(ashift:SI (match_dup 2)
		   (match_dup 4)))
   ; Arithmetic shift of byte to sign extend, and move to lowest register.
   (set (subreg:SI (match_dup 0) 0)
	(ashiftrt:SI (match_dup 2) 
		     (const_int 16)))
   (use (match_operand:HI 1 "picochip_alignable_memory_operand" "g"))]
  ""
{
  rtx alignedAddr, bitShift;

  /* Convert the address of the known alignment into two operands
   * representing the aligned base address, and the number of shift bits
   * required to access the required value. */
  picochip_get_hi_aligned_mem(operands[1], &alignedAddr, &bitShift);

  operands[3] = alignedAddr;
  operands[4] = GEN_INT(16 - INTVAL(bitShift));
})

(define_insn "synthesised_loadhi_unaligned"
  [(set (match_operand:HI 0 "register_operand" "=r")
        (match_operand:HI 1 "memory_operand" "m"))
   (clobber (match_operand:SI 2 "register_operand" "=&r"))]
  ""
  "// Synthesised loadhi %0 = Mem(%1) (Scratch %2)\n\tand\t%2,%1,-3\n\tld\t%0,%2,0\n\tand\t%2,%1,3\n\tsll\t%2,%2,3\n\tnot\t%2,%2\n\tadd\t%2,%2,1\n\tadd\t%2,%2,24\n\tsll\t%0,%2,%0\n\tsrai\t%0,%0,16"
)

;; Machines which don't have byte access can copy registers, and load
;; constants, but can't access memory.  The define_expand for movqi
;; should already have rewritten memory accesses using word
;; operations.  The exception is qi reloads, which are handled using
;; the reload_? patterns.


(define_insn "*movqi_nobyte"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	(match_operand:QI 1 "nonmemory_operand" "r,i"))]
""
"@
mov\t%0,%1
ldri\t%0,%1"
[(set_attr "type" "load,load")
 (set_attr "cc" "unchanged,unchanged")
  (set_attr "slottable" "yes,no")
])

(define_insn "*movhi_nobyte"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(match_operand:HI 1 "nonmemory_operand" "r,i"))]
""
"@
mov\t%0,%1
ldri\t%0,%1"
[(set_attr "type" "load,load")
 (set_attr "cc" "unchanged,unchanged")
  (set_attr "slottable" "yes,no")
])


;;17.6.2005 MM: Added experimental support for FP-coprocessor 
;; tee splitin lisksi toinen SWFP varten

(define_expand "movsf"
  [(set (match_operand:SF 0 "general_operand" "")
	(match_operand:SF 1 "general_operand" ""))]
  ""
  "
{

	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
		operands[1] = force_reg (SFmode, operands[1]);

/*

	if (GET_CODE (operands[0]) == MEM)
	{	
		operands[1] = force_reg (SFmode, operands[1]);
	}
	else if (GET_CODE (operands[1]) == MEM)
	{	
		operands[0] = force_reg (SFmode, operands[0]);
	}
*/
}")

;;(define_insn "*movsf_hw"
;;  [(set (match_operand:SF 0 "general_operand" "=f,r,f,r,r,r,m")
;;	(match_operand:SF 1 "general_operand" "f,f,r,r,F,m,r"))]
;;  "HWFP"
;;"*
;;{
;;  if (which_alternative == 0)
;;    return \"fmov\\t%0,%1\";
;;
;;  if (which_alternative == 1)
;;    return \"movfc\\tmilk,%0,%1\";		/* reg -> freg */
;;
;;  if (which_alternative == 2)
;;    return \"movtc\\tmilk,%0,%1\";		/* freg -> reg */
;;
;;  if (which_alternative == 3)
;;    return \"mov\\t%0,%1\";		/* reg -> reg */
;;
;;  if (which_alternative == 4)
;;    {
;;	if ((GET_CODE (operands[1]) == LABEL_REF) || 
;;		(GET_CODE (operands[1]) == SYMBOL_REF))
;;	{
;;		return \"ldra\\t%0,%a1\";
;;	}
;;	else  
;;	{
;;		return \"ldri\\t%0,%1\";
;;	}
;;  }
;;
;;  if (which_alternative == 5)
;;    return \"ld\\t%0,%1\";		
;;
;;  if (which_alternative == 6)
;;    return \"st\\t%1,%0\";
;;}"
;;[(set_attr "type" "fmov,arith,arith,arith,load,load,store")
;; (set_attr "cc" "unchanged,unchanged,unchanged,unchanged,unchanged,unchanged,;;unchanged")
;;  (set_attr "slottable" "yes,yes,yes,no,yes,yes,yes")
;;])

(define_insn "*movsf_sw"
  [(set (match_operand:SF 0 "general_operand" "=r,r,r,m")
	(match_operand:SF 1 "general_operand" "r,F,m,r"))]
""
"*
{
  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else  
	{
		return \"ldri\\t%0,%1\";
	}
   }

  if (which_alternative == 2)
    return \"ld\\t%0,%1\";		

  if (which_alternative == 3)
    return \"st\\t%1,%0\";
}"
[(set_attr "type" "arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
  (set_attr "slottable" "yes,no,yes,no")
])


;;(define_insn "*movsf_hardware"
;;  [(set (match_operand:SF 0 "register_operand" "=f,r,f,r")
;;	(match_operand:SF 1 "nonmemory_operand" "r,f,f,r"))]
;;  "HWFP"
;;"@
;;movtc\\tmilk,%0,%1
;;movfc\\tmilk,%0,%1
;;fmov\\t%0,%1
;;mov\\t%0,%1"
;;[(set_attr "type" "arith,arith,fmov,arith")
;; (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes,yes,yes")
;;])


(define_insn "addsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(plus:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "r")))]
  ""
"fadd%#\\t%0,%1,%2"
[(set_attr "type" "fadd")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])


(define_insn "subsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(minus:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "r")))]
  ""
"fsub%#\\t%0,%1,%2"
[(set_attr "type" "fadd")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])


(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(mult:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "r")))]
  ""
"fmul%#\\t%0,%1,%2"
[(set_attr "type" "fmul")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "divsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(div:SF (match_operand:SF 1 "register_operand" "r")
		  (match_operand:SF 2 "register_operand" "r")))]
  ""
"fdiv%#\\t%0,%1,%2"
[(set_attr "type" "fdiv")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "sqrtsf2"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(sqrt:SF (match_operand:SF 1 "register_operand" "r")))]
  ""
"fsqrt%#\\t%0,%1"
[(set_attr "type" "fsqrt")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "abssf2"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(abs:SF (match_operand:SF 1 "register_operand" "r")))]
  ""
"fabs%#\\t%0,%1"
[(set_attr "type" "fabs")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "negsf2"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(neg:SF (match_operand:SF 1 "register_operand" "r")))]
  ""
"fneg%#\\t%0,%1"
[(set_attr "type" "fneg")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "floatsisf2"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(float:SF (match_operand:SI 1 "register_operand" "r")))]
  ""
"fcvt.s%#\\t%0,%1"
[(set_attr "type" "fconv")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "fix_truncsfsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(fix:SI (match_operand:SF 1 "register_operand" "r")))]
  ""
"fcvt.w%#\\t%0,%1"
[(set_attr "type" "fconv")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])


;; Arithmetic insns. addhi3, addqi3 not needed?
;; consts: I = signed immediate, M = unsigned immediate
(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r,r")
	(plus:SI (match_operand:SI 1 "register_operand" "r,r,r")
		(match_operand:SI 2 "nonmemory_operand" "r,I,M")))]
""
"@
add\\t%0,%1,%2
addi\\t%0,%1,%2
addiu\\t%0,%1,%2"
[(set_attr "type" "arith,arith,arith")
 (set_attr "cc" "unchanged,unchanged,set")
  (set_attr "slottable" "yes,yes,yes")
])

 
(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(minus:SI (match_operand:SI 1 "register_operand" "r,r")
		(match_operand:SI 2 "nonmemory_operand" "r,r")))]
""
"@
sub\\t%0,%1,%2
subu\\t%0,%1,%2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "clobber,set")
  (set_attr "slottable" "yes,yes")
])

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "register_operand" "r,r")
		(match_operand:SI 2 "nonmemory_operand" "r,I")))]
""
"@
muls\\t%0,%1,%2
muli\\t%0,%1,%c2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "clobber,clobber")
  (set_attr "slottable" "yes,yes")
])


;; HI-operands might need a sign extension
(define_insn "mulhisi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(mult:SI (match_operand:HI 1 "register_operand" "r")
		(match_operand:HI 2 "register_operand" "r")))]
""
"mulus_16\\t%1,%2,%3"
[(set_attr "type" "arith")
 (set_attr "cc" "clobber")
  (set_attr "slottable" "yes")
])


(define_insn "mulsi3_highpart"
[(set (match_operand:SI 0 "register_operand" "=r")
	(mult:SI (match_operand:SI 1 "register_operand" "r")
		(match_operand:SI 2 "register_operand" "r")))]
""
"muls\\t%0,%1,%2\\n\\tmulhi\\t%0"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])


;; No division or mod instructions, yet

(define_insn "andsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(and:SI (match_operand:SI 1 "register_operand" "%r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, M")))]
""
"@
and\\t%0,%1,%2
andi\\t%0,%1,%2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
  (set_attr "slottable" "yes,yes")
])


(define_insn "iorsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(ior:SI (match_operand:SI 1 "register_operand" "%r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, M")))]
""
"@
or\\t%0,%1,%2
ori\\t%0,%1,%2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
  (set_attr "slottable" "yes,yes")
])

(define_insn "xorsi3"
[(set (match_operand:SI 0 "register_operand" "=r")
	(xor:SI (match_operand:SI 1 "register_operand" "%r")
		(match_operand:SI 2 "register_operand" "r")))]
""
"xor\\t%0,%1,%2"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "ashlsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(ashift:SI (match_operand:SI 1 "register_operand" "r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, K")))]
""
"@
sll\\t%0,%1,%2
slli\\t%0,%1,%k2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
  (set_attr "slottable" "yes,yes")
])

(define_insn "ashrsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(ashiftrt:SI (match_operand:SI 1 "register_operand" "r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, K")))]
""
"@
sra\\t%0,%1,%2
srai\\t%0,%1,%k2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
  (set_attr "slottable" "yes,yes")
])

(define_insn "lshrsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(lshiftrt:SI (match_operand:SI 1 "register_operand" "r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, K")))]
""
"@
srl\\t%0,%1,%2
srli\\t%0,%1,%k2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
  (set_attr "slottable" "yes,yes")
])


(define_insn "one_cmplsi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(not:SI (match_operand:SI 1 "register_operand" "r")))]
""
"not\\t%0,%1"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

;; Make the 0 operand write-only, so 0&1 cannot be the same
;; First zero 0 and make 0-%1
(define_expand "negsi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(xor:SI (match_dup 0) (match_dup 0)))
 (set (match_dup 0)
	(minus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))]
""
"")
;;"xor\\t%0,%0,%0\\n\\tsub\\t%0,%0,%1"
;;[(set_attr "type" "arith")
;; (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
;;])

(define_insn "cmpsi"
[(set (cc0) 
	(compare (match_operand:SI 0 "register_operand" "r,r")
		(match_operand:SI 1 "general_operand" "r,L")))]
""
"@
cmp\\tc0,%0,%1
cmpi\\tc0,%0,%1"
[(set_attr "type" "cmp,cmp")
 (set_attr "cc" "set,set")
  (set_attr "slottable" "no,no")
])

(define_insn "cmpsf"
[(set (cc0) 
	(compare (match_operand:SF 0 "register_operand" "r")
		(match_operand:SF 1 "register_operand" "r")))
(clobber	 (match_scratch:SF 2 "=r"))]
""
"
\\tfc.ole0\\t%2,%0,%1\\n\\tnop\\n\\tnop
"
[(set_attr "type" "cmp")
 (set_attr "cc" "set")
  (set_attr "slottable" "no")
])

;;(define_insn "cmpsf"
;;[(set (cc0)	(compare (match_operand:SF 0 "register_operand" "r")
;;		(match_operand:SF 1 "register_operand" "r")))
;;(clobber	 (match_scratch:SF 2  "=r"))]
;;""
;;"*{
;;	enum rtx_code cmp_code; 
;;	last_cmp_was_float = 1;
;;	cmp_code = GET_CODE (next_cc0_user (insn));
;;	if (cmp_code == EQ)
;;	{
;;		return \"fc.eq%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
;;	}
;;	else if (cmp_code == NE)
;;	{
;;		return \"fc.eq%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
;;	}
;;	else if (cmp_code == GT)
;;	{
;;		return \"fc.olt%#\\t%2,%1,%0\\n\\tnop\\n\\tnop\";
;;	}	
;;	else if (cmp_code == LT)
;;	{
;;		return \"fc.olt%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
;;	}	
;;	else if (cmp_code == GE)
;;	{
;;		return \"fc.ole%#\\t%2,%1,%0\\n\\tnop\\n\\tnop\";
;;	}	
;;	else if (cmp_code == LE)
;;	{
;;		return \"fc.ole%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
;;	}	
;;}"
;;[(set_attr "type" "cmp")
;;(set_attr "cc" "set")
;;  (set_attr "slottable" "no")
;;])

;;(define_expand "cmpsf"
;;[(set (reg:CCFP CC_REG) 
;;	(compare:CCFP (match_operand:SF 0 "register_operand" "")
;;		(match_operand:SF 1 "register_operand" "")))]
;;""
;;"
;;	last_cmp_was_float = 1;
;;	cmpsf_op1 = operands[0];
;;	cmpsf_op2 = operands[1];
;;	DONE;
;;")

;;(define_expand "cmpsi"
;;[(set (reg:CC CC_REG) 
;;	(compare:CC (match_operand:SI 0 "register_operand" "")
;;		(match_operand:SI 1 "nonmemory_operand" "")))]
;;""
;;"
;;	last_cmp_was_float = 0;
;;	cmpsf_op1 = operands[0];
;;	cmpsf_op2 = operands[1];
;;	DONE;
;;")

;; -------------------------------------------------------------------------
;; SFmode comparisons
;; -------------------------------------------------------------------------

;;(define_insn "*cmpsf_eq"
;;  [(set (reg:CCFP CC_REG) (eq:CCFP (match_operand:SF 0 "register_operand" "r")
;;			    (match_operand:SF 1 "register_operand" "r")))
;;	(clobber (match_operand:SF 2 "register_operand" "=r"))]
;;  ""
;;  "fc.eq0\\t%2,%0,%1
;;  "
;;[(set_attr "type" "cmp")
;; (set_attr "cc" "set")
;;  (set_attr "slottable" "no")
;;])

;;(define_insn "*cmpsf_ole"
;;[(set (reg:CCFP CC_REG) (le:CCFP (match_operand:SF 0 "register_operand" "r")
;;			    (match_operand:SF 1 "register_operand" "r")))
;;	(clobber (match_operand:SF 2 "register_operand" "=r"))]
;;  ""
;;  "fc.ole0\\t%2,%0,%1
;;  "
;;[(set_attr "type" "cmp")
;; (set_attr "cc" "set")
;;  (set_attr "slottable" "no")
;;])

;;(define_insn "*cmpsf_olt"
;;  [(set (reg:CCFP CC_REG) (lt:CCFP (match_operand:SF 0 "register_operand" "r")
;;			    (match_operand:SF 1 "register_operand" "r")))
;;	(clobber (match_operand:SF 2 "register_operand" "=r"))]
;;  ""
;;  "fc.olt0\\t%2,%0,%1
;;  "
;;[(set_attr "type" "cmp")
;; (set_attr "cc" "set")
;;  (set_attr "slottable" "no")
;;])

;;(define_insn "*cmpsi"
;;    [(set (reg:CC CC_REG) 
;;	(compare:CC (match_operand:SI 0 "register_operand" "r")
;;			(match_operand:SI 1 "nonmemory_operand" "r")))]
;;  ""
;;  "
;;   cmp\\tc0,%0,%1
;;   cmpi\\tc0,%0,%1
;;  "
;;[(set_attr "type" "cmp")
;; (set_attr "cc" "set")
;;  (set_attr "slottable" "no")
;;])

;;(define_insn "cmpsi"
;;[(set (cc0) 
;;	(compare (match_operand:SI 0 "register_operand" "r, r")
;;		(match_operand:SI 1 "general_operand" "r, L")))]
;;""
;;"*{
;;	last_cmp_was_float = 0;
;;	enum rtx_code branch; 
;;	branch = GET_CODE(next_cc0_user(insn))
;;
;;	if (((branch == GTU) || (branch == LTU) || 
;;		(branch == GEU) || (branch == LEU)) && 
;;		(register_operand(operands[1],SImode)))
;;	{
;;		/* CHECK */
;;		return \"subu\\t%0,%0,%1\";
;;	}
;;	else
;;	{
;;		if (which_alternative == 0)
;;		{
;;			return \"cmp\\tc0,%0,%1\";
;;		}
;;		else
;;		{
;;			return \"cmpi\\tc0,%0,%1\";
;;		}
;;	}
;;	
;;}"
;;[(set_attr "type" "cmp,cmp")
;; (set_attr "cc" "set,set")
;;  (set_attr "slottable" "no,no")
;;])


;;(define_insn "tstsi"
;;[(set (cc0) 
;;	(match_operand:SI 0 "register_operand" "r"))]
;;""
;;"cmpi\\tc0,%0,0"
;;[(set_attr "type" "cmp")
;; (set_attr "cc" "set")
;;  (set_attr "slottable" "no")
;;])

;; Branch insns, taken from clipper. 

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "beq\\tc0,%l0%("
  [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bne\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bgt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

;; No unsigned comparisons. Needed so use the same as signed
(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
  "bgt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "blt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "blt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "begt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "begt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
 (set_attr "slottable" "has_slot")
])

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "belt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "belt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

;; Recognize reversed jumps.
(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
				      [(cc0)
				       (const_int 0)])
		      (pc)
		      (label_ref (match_operand 1 "" ""))))]
 ""
 "b%C0\\tc0,%l1%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])


;; Extension and truncation

(define_insn "extendqisi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI (match_operand:QI 1 "register_operand" "r")))]
""
"sexti\\t%0,%1,7"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "extendhisi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI (match_operand:HI 1 "register_operand" "r")))]
""
"sexti\\t%0,%1,15"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "yes")
])

(define_insn "extendqihi2"
[(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extend:HI (match_operand:QI 1 "register_operand" "r")))]
""
"slli\\t%0,%1,24\\n\\tsrai\\t%0,%0,16"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])

(define_insn "zero_extendhisi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI (match_operand:HI 1 "register_operand" "r")))]
""
"slli\\t%0,%1,16\\n\\tsrli\\t%0,%0,16"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])


(define_insn "zero_extendqisi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI (match_operand:QI 1 "register_operand" "r")))]
""
"slli\\t%0,%1,24\\n\\tsrli\\t%0,%0,24" 
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])

(define_insn "zero_extendqihi2"
[(set (match_operand:HI 0 "register_operand" "=r")
	(zero_extend:HI (match_operand:QI 1 "register_operand" "r")))]
""
"slli\\t%0,%1,24,\\n\\tsrli\\t%0,%0,16"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])

;; We could define bit-field extractions but seems they're not needed

;; Call  insns, taken from clipper. 
(define_insn "call"
  [(call (match_operand:SI 0 "sym_ref_mem_operand" "")
		 (match_operand 1 "" "i"))]
  ""
  "jal\\t%S0%("
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
  (set_attr "slottable" "has_slot")
])


;;(define_insn "call_value"
;;  [(set (match_operand:SI 0 "register_operand" "=r")
;;	(call (match_operand:SI 1 "sym_ref_mem_operand" "")
;;	      (match_operand 2 "" "")))]
;;  ""
;;  "jal\\t%S1%("	
;; [(set_attr "type" "branch")
;; (set_attr "cc" "clobber")
;;  (set_attr "slottable" "has_slot")
;;])

(define_insn "call_value"
  [(set (match_operand 0 "register_operand" "=r")
	(call (match_operand:SI 1 "sym_ref_mem_operand" "")
	      (match_operand 2 "" "")))]
  ""
  "jal\\t%S1%("	
 [(set_attr "type" "branch")
 (set_attr "cc" "clobber")
  (set_attr "slottable" "has_slot")
])

(define_insn "call_indirect"
  [(call (mem:SI (match_operand:SI 0 "register_operand" "r"))
                  (match_operand 1 "" "i"))]
  ""
  "jalr\\t%0%("
  [(set_attr "type" "branch")
   (set_attr "slottable" "has_slot")
  (set_attr "cc" "clobber")])

;;(define_insn "call_value_indirect"
;;  [(set (match_operand 0 "register_operand" "=r")
; ;                  (call (mem:SI (match_operand 1 "register_operand" "r"))
;;                         (match_operand 2 "" "i")))]
;;""
;;"jalr\\t%1%("
;;[(set_attr "type" "branch")
;;  (set_attr "slottable" "has_slot")
;;  (set_attr "cc" "clobber")])

(define_insn "call_value_indirect"
  [(set (match_operand 0 "register_operand" "=r")
                   (call (mem:SI (match_operand:SI 1 "register_operand" "r"))
                         (match_operand 2 "" "i")))]
""
"jalr\\t%1%("
[(set_attr "type" "branch")
  (set_attr "slottable" "has_slot")
  (set_attr "cc" "clobber")])


(define_insn "nop"
  [(const_int 0)]
""
"nop")

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "r"))]
""
"jmpr\\t%0%("
[(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "jump"
 [(set (pc) 
	(label_ref (match_operand 0 "" "")))]
""
"jmp\\t%l0%("
[(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

;; I think we use tablejump for now

(define_insn "tablejump"
  [(set (pc) (match_operand:SI 0 "register_operand" "r"))
	(use (label_ref (match_operand 1 "" "")))]
""
"jmpr\\t%0%("
[(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "absqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(abs:QI (match_operand:QI 1 "register_operand" "r")))]
""
"*
{
	return \"mov\t%0,%1\\n\\txor\\tr26,r26,r26\\n\\tcmp\\tc0,%1,r26\\n\\tbgt\\tc0,8\\n\\tnop\\n\\tsub\\t%0,r26,%1\";
/*
	operands[2] = const0_rtx;
	return \"cmpi\\tc0,%1,%2\\n\\tbgt\\tc0,4\\n\\tnop\\n\\tsub\\t%0,%1,%2\";*/
}"
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
  (set_attr "slottable" "no")
])

(define_insn "abshi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(abs:HI (match_operand:HI 1 "register_operand" "r")))]
""
"*
{
	return \"mov\\t%0,%1\\n\\txor\\tr26,r26,r26\\n\\tcmp\\tc0,%1,r26\\n\\tbgt\\tc0,8\\n\\tnop\\n\\tsub\\t%0,r26,%1\";
/*
	operands[2] = const0_rtx;
	return \"cmpi\\tc0,%1,%2\\n\\tbgt\\tc0,4\\n\\tnop\\n\\tsub\\t%0,%1,%2\";*/
}"
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
  (set_attr "slottable" "no")
])

(define_insn "abssi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(abs:SI (match_operand:SI 1 "register_operand" "r")))]
""
"*
{
	/*
	operands[2] = const0_rtx;
	*/
	return \"mov\\t%0,%1\\n\\txor\\tr26,r26,r26\\n\\tcmp\\tc0,%1,r26\\n\\tbgt\\tc0,8\\n\\tnop\\n\\tsub\\t%0,r26,%1\";
}"
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
  (set_attr "slottable" "no")
])

;; Given the memory address of a QImode value, and a scratch register,
;; store the memory operand into the given output operand.  The scratch
;; operand will not conflict with either of the operands.  The other
;; two operands may conflict with each other.


(define_expand "prologue"
  [(use (const_int 0))]
  ""
{
  coffee_expand_prologue ();
  DONE;
})

(define_expand "epilogue"
  [(use (const_int 0))]
  ""
{
  coffee_expand_epilogue ();
  DONE;
})

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] UNSPECV_BLOCKAGE)]
  ""
  ""
  [(set_attr "type" "unknown")])

(define_insn "temp_storeqi_unaligned"
  [(set (mem:QI (match_operand:SI 0 "register_operand" "=r"))
	(match_operand:QI 1 "register_operand" "r"))]
;;   (use (match_operand:SI 2 "register_operand" "r"))
;;   (use (match_operand:SI 3 "register_operand" "r"))]
  ""
  "andi\tr23,%0,0x3\n\tslli\tr23,r23,3\n\tldri\tr22,24\n\tsub\tr22,r22,r23\n\tldri\tr21,0xff\n\tsll\tr21,r21,r22\n\tnot\tr21,r21\n\tlli\tr20,0xfffc\n\tlui\tr20,0xffff\n\tand\tr20,r20,%0\n\tld\tr23,r20,0\n\tand\tr23,r23,r21\n\tsll\tr21,%1,r22\n\tor\tr23,r23,r21\n\tst\tr23,r20,0"
[(set_attr "type" "store")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])

(define_insn "temp_loadqi_unaligned"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(mem:QI (match_operand:SI 1 "general_operand" "g")))]
;;   (use (match_operand:SI 2 "register_operand" "r"))]
  ""
  "andi\tr23,%1,0x3\n\tslli\tr23,r23,3\n\tldri\tr22,24\n\tsub\tr22,r22,r23\n\tlli\tr20,0xfffc\n\tlui\tr20,0xffff\n\tand\tr20,r20,%1\n\tld\tr23,r20,0\n\tsrl\tr23,r23,r22\n\tandi\t%0,r23,0xff"
[(set_attr "type" "load")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])

(define_insn "temp_storehi_unaligned"
  [(set (mem:HI (match_operand:SI 0 "register_operand" "=r"))
	(match_operand:HI 1 "register_operand" "r"))]
;;   (use (match_operand:SI 2 "register_operand" "r"))
;;   (use (match_operand:SI 3 "register_operand" "r"))]
  ""
  "andi\tr23,%0,0x3\n\tslli\tr23,r23,3\n\tldri\tr22,16\n\tsub\tr22,r22,r23\n\tldri\tr21,0xffff\n\tsll\tr21,r21,r22\n\tnot\tr21,r21\n\tlli\tr20,0xfffc\n\tlui\tr20,0xffff\n\tand\tr20,r20,%0\n\tld\tr23,r20,0\n\tand\tr23,r23,r21\n\tsll\tr21,%1,r22\n\tor\tr23,r23,r21\n\tst\tr23,r20,0"
[(set_attr "type" "store")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])

(define_insn "temp_loadhi_unaligned"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(mem:HI (match_operand:SI 1 "register_operand" "r")))]
;   (use (match_operand:SI 2 "register_operand" "r"))]
  ""
  "andi\tr23,%1,0x3\n\tslli\tr23,r23,3\n\tldri\tr22,16\n\tsub\tr22,r22,r23\n\tlli\tr20,0xfffc\n\tlui\tr20,0xffff\n\tand\tr20,r20,%1\n\tld\tr23,r20,0\n\tsrl\tr23,r23,r22\n\tldri\tr20,0xffff\n\tand\t%0,r23,r20"
[(set_attr "type" "load")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "no")
])

(define_insn "temp_synthesised_storehi_unaligned"
  [(set (mem:HI (match_operand:SI 0 "register_operand" "=r"))
	(match_operand:HI 1 "register_operand" "r"))
   (use (match_operand:SI 2 "register_operand" "r"))
   (use (match_operand:SI 3 "register_operand" "r"))]
  ""
  "// Synthesised storehi")

(define_insn "temp_synthesised_loadhi_unaligned"
  [(set (match_operand:HI 0 "register_operand" "=r") 
	(mem:HI (match_operand:SI 1 "general_operand" "g")))
   (use (match_operand:SI 2 "register_operand" "r"))]
  ""
  "// Synthesised loadhi %0 = Mem(%1) (Scratch %2)\n\t\nAND.%# %1,-2,%2\n\t\nLDW (%2)0,%0 %| AND.%# %1,1,%2\n\t\nLSL.%# %2,3,%2\n\t\nSUB.%# 8,%2,%2\n\t\nLSL.%# %0,%2,%0\n\t\nASR.%# %0,8,%0")
