#include <stdio.h>
#include <string.h>

void reshuffle(char *s, int n){
  char tmp;
  int i;
  
  for (i = 0; i < n/8; i++){
    tmp = s[4*i];
    s[4*i] = s[4*i + 6];
    s[4*i + 6] = tmp;
    tmp = s[4*i + 1];
    s[4*i + 1] = s[4*i + 7];
    s[4*i + 7] = tmp;
    tmp = s[4*i + 2];
    s[4*i + 2] = s[4*i + 4];
    s[4*i + 4] = tmp;
    tmp = s[4*i + 3];
    s[4*i + 3] = s[4*i + 5];
    s[4*i + 5] = tmp;
    
  }

}

void hex2bin(char *s, int n, char *b){
  int i;
  
  for (i = 0; i < n; i++)
    switch(s[i]){

    case '0':
      b[4*i] = '0';
      b[4*i + 1] = '0';
      b[4*i + 2] = '0';
      b[4*i + 3] = '0';
      break;

    case '1':
      b[4*i] = '0';
      b[4*i + 1] = '0';
      b[4*i + 2] = '0';
      b[4*i + 3] = '1';
      break;

    case '2':
      b[4*i] = '0';
      b[4*i + 1] = '0';
      b[4*i + 2] = '1';
      b[4*i + 3] = '0';
      break;

    case '3':
      b[4*i] = '0';
      b[4*i + 1] = '0';
      b[4*i + 2] = '1';
      b[4*i + 3] = '1';
      break;

    case '4':
      b[4*i] = '0';
      b[4*i + 1] = '1';
      b[4*i + 2] = '0';
      b[4*i + 3] = '0';
      break;

    case '5':
      b[4*i] = '0';
      b[4*i + 1] = '1';
      b[4*i + 2] = '0';
      b[4*i + 3] = '1';
      break;

    case '6':
      b[4*i] = '0';
      b[4*i + 1] = '1';
      b[4*i + 2] = '1';
      b[4*i + 3] = '0';
      break;

    case '7':
      b[4*i] = '0';
      b[4*i + 1] = '1';
      b[4*i + 2] = '1';
      b[4*i + 3] = '1';
      break;

    case '8':
      b[4*i] = '1';
      b[4*i + 1] = '0';
      b[4*i + 2] = '0';
      b[4*i + 3] = '0';
      break;

    case '9':
      b[4*i] = '1';
      b[4*i + 1] = '0';
      b[4*i + 2] = '0';
      b[4*i + 3] = '1';
      break;

    case 'a':
      b[4*i] = '1';
      b[4*i + 1] = '0';
      b[4*i + 2] = '1';
      b[4*i + 3] = '0';
      break;

    case 'b':
      b[4*i] = '1';
      b[4*i + 1] = '0';
      b[4*i + 2] = '1';
      b[4*i + 3] = '1';
      break;

    case 'c':
      b[4*i] = '1';
      b[4*i + 1] = '1';
      b[4*i + 2] = '0';
      b[4*i + 3] = '0';
      break;

    case 'd':
      b[4*i] = '1';
      b[4*i + 1] = '1';
      b[4*i + 2] = '0';
      b[4*i + 3] = '1';
      break;

    case 'e':
      b[4*i] = '1';
      b[4*i + 1] = '1';
      b[4*i + 2] = '1';
      b[4*i + 3] = '0';
      break;

    case 'f':
      b[4*i] = '1';
      b[4*i + 1] = '1';
      b[4*i + 2] = '1';
      b[4*i + 3] = '1';
      break;

    }

  b[4*i] = '\0';

}

    

int main(int argc, char **argv){

  FILE *in, *out;
  int i, j;
  char s[256];
  char b[256];
  
  strcpy(s, argv[1]);
  in = fopen(s, "rb");
  strcat(s, ".bin");
  out = fopen(s, "w");

  while (!feof(in)){
    i=getw(in);
    sprintf(s, "%.8x", i);
    reshuffle(s, 8);
    hex2bin(s, 8, b);
    fprintf(out, "%s\n", b);
  }

  fclose(in);
  fclose(out);

  return 0;
  
}
  
