/************************************************************/
/***** Attention! This file is COFFEE ready.           ******/ 
/***** Among the modification, there is the merging of ******/ 
/***** ZBUFFER and FRAMEBUFFER and the need to read    ******/ 
/***** or write into them using the get* and set*      ******/ 
/***** functions. DON'T FORGET to do this when         ******/ 
/***** create a new COFFEE READY file                  ******/ 
/***** Another ***needed*** modification was the       ******/
/***** usage of fp division to execute integer         ******/
/***** divisions. The compiler doesn't do it autom.    ******/
/***** and some *@nasty@* things have to be done in    ******/
/***** C to bypass the problem (see deBoorSurface fun. ******/
/***** at the beginning, i.e.).                        ******/
/************************************************************/

#include "demo_nurbs.h"

char * malloc(unsigned int num){

  char* startaddr;

  if ((pointer + num) >= (char*) HEAP_END){
    exit(-1);
  }
  startaddr = pointer;
  pointer += num;
  return startaddr;

}

char * mallocFB(unsigned int num){

  char* startaddrFB;
  if ((pointerFB + num) >= (char*) VGA_END){
    pointerFB = (char*) VGA_ADDR;
  }
  startaddrFB = pointerFB;
  pointerFB += num;
  return startaddrFB;

}

void debugP(int x, int y, RGB cl){

  *(*(frameBuffer + y) + x) = cl;
  

}

void initVec3(float a, float b, float c, vec3 v3)
{
  
  v3[0] = a;
  v3[1] = b;
  v3[2] = c;

}

void copyVec4(vec4 dst, vec4 src)
{
  
  dst[0] = src[0];
  dst[1] = src[1];
  dst[2] = src[2];
  dst[3] = src[3];

}
void copyVec3(vec3 dst, vec3 src)
{
  
  dst[0] = src[0];
  dst[1] = src[1];
  dst[2] = src[2];

}

void clearRGB(RGB *value){
  
  *value = 0;
}

void initTMat(mat4 t){
  
  unsigned int i,j;
  for (i = 0; i < 4; i++)
    for (j = 0;  j< 4; j++){
      if (i == j)
	t[i][j] = 1;
      else
	t[i][j] = 0;
    }

}

void setRGB(RGB *value, long int red, long int green, long int blue){

  long int temp;
  if (blue < 0)
    temp = 0x1f;
  else
    temp = (blue >> 26) & 0x1f;
  if (green < 0)
    temp = ((temp & 0x1F) << 5) | 0x1f;
  else
    temp = ((temp & 0x1F) << 5) | ((green >> 26) & 0x1f);
  if (red < 0)
    temp = ((temp & 0x3FF) << 5) | 0x1f;
  else
    temp = ((temp & 0x3FF) << 5) | ((red >> 26) & 0x1f);
  *value = (*value & 0xffff0000) | (temp & 0xffff);

}

void setRGBc(RGB *value, RGB color){

  *value = color;

}

void setDepth(RGB *value, long int depth){

  long int depth_old;
  depth_old = *value & 0x00007FFF;
  depth >>= 1;
  depth = depth & 0x7FFF8000;
  *value = depth_old | depth;

}

void setRGB_Dep(RGB *value, long int red, long int green, long int blue, long int dp){

  long int temp;
  if (blue < 0)
    temp = 0x1f;
  else
    temp = (blue >> 26) & 0x1f;
  if (green < 0)
    temp = ((temp & 0x1F) << 5) | 0x1f;
  else
    temp = ((temp & 0x1F) << 5) | ((green >> 26) & 0x1f);
  if (red < 0)
    temp = ((temp & 0x3FF) << 5) | 0x1f;
  else
    temp = ((temp & 0x3FF) << 5) | ((red >> 26) & 0x1f);
  dp >>= 1;
  temp = (dp & 0x7fff8000) | (temp & 0x7fff);
  *value = temp;

}

void setRGBc_Dep(RGB *value, RGB cl, long int dp){

  long int temp = cl;
  dp >>= 1;
  temp = (dp & 0x7fff8000) | (temp & 0x7fff);
  *value = temp;

}

long int getDepth(RGB value) {

  long int depth;
  depth = (value << 1) & 0xFFFF0000;
  return depth;

}

void getRGB(RGB value, long int *red, long int *green, long int *blue){

    *red = (long int) (value & 0x1F) << 26;
    *green = (long int) ((value >> 5) & 0x1F) << 26;
    *blue = (long int) ((value >> 10) & 0x1F) << 26;
}

void getRGBc(RGB value, unsigned char *red, unsigned char *green, unsigned char *blue){
  
    *red = (unsigned char) ((value & 0x1F) << 3);
    *green = (unsigned char) (((value >> 5) & 0x1F) << 3);
    *blue = (unsigned char) (((value >> 10) & 0x1F) << 3);
}


void genNurbsSurface(vec4 *cps, float *U, float *V, int cpun, int cpvn, int ordu, int ordv, RGB cl, drawList *dl){
  nurbss *ns;
  char *nsa;
  int i;
  i = cpun*cpvn;
  ns = (nurbss *) malloc(sizeof(nurbss));
  (*ns).cpnum = i;
  (*ns).orderU = ordu;
  (*ns).orderV = ordv;
  (*ns).cps_src = cps;
  (*ns).cps = cps_new;
  for (i = 0; i < (cpun * cpvn); i++)
    copyVec4(cps_new[i], cps[i]);
  (*ns).knvU = U;
  (*ns).knvV = V;
  (*ns).cpstep = cpvn;
  (*ns).cs = cl;
  nsa = (char *) ns;
  addDrawList(nsa, NURBSS, dl);

}

void resetNurbsSurface(nurbss *ns){
  
  int i;
  for (i = 0; i < (*ns).cpnum; i++)
    copyVec4((*ns).cps[i], (*ns).cps_src[i]);
  
}

void addVx3C2Polygon(pygon *pg, float ax, float ay, float az, RGB cl){

  int idx = (*pg).vernum;
  (*pg).vx[idx][0] = ax;
  (*pg).vx[idx][1] = ay;
  (*pg).vx[idx][2] = az;
  (*pg).cs[idx] = cl;
  (*pg).vernum ++;

}

void rotateMat(mat4 t, float Th, int axis) {
  
  float cosTh, sinTh;
  float tmp[8];
  unsigned int i;
  cosTh = sin_cos(Th,0);
  sinTh = sin_cos(Th, 1);
  switch (axis) {
    
  case XAXIS:
    for (i = 0; i < 3; i++){
      tmp[i] = cosTh*t[i][1] + sinTh*t[i][2];
      tmp[i+4] = -sinTh*t[i][1] + cosTh*t[i][2];
    }
    for (i = 0; i < 3; i++){
      t[i][1] = tmp[i];
      t[i][2] = tmp[i + 4];
    }
    break;
  case YAXIS:
    for (i = 0; i < 3; i++){
      tmp[i] = cosTh*t[i][0] + sinTh*t[i][2];
      tmp[i+4] = -sinTh*t[i][0] + cosTh*t[i][2];
    }
    for (i = 0; i < 3; i++){
      t[i][0] = tmp[i];
      t[i][2] = tmp[i + 4];
    }
    break;
  case ZAXIS:
    for (i = 0; i < 3; i++){
      tmp[i] = cosTh*t[i][0] + sinTh*t[i][1];
      tmp[i+4] = -sinTh*t[i][0] + cosTh*t[i][1];
    }
    for (i = 0; i < 3; i++){
      t[i][0] = tmp[i];
      t[i][1] = tmp[i + 4];
    }
    break;
  }
    
    
  
}

void translateMat(mat4 t, float dx, float dy, float dz) {

  int j;
  for (j = 0;  j < 4; j++){
    t[j][0] = t[j][0] + dx*t[j][3];
    t[j][1] = t[j][1] + dy*t[j][3];
    t[j][2] = t[j][2] + dz*t[j][3];
  }

}


void scaleMat(mat4 t, float sx, float sy, float sz){
  int j;
  
  for (j = 0;  j < 4; j++){
    t[j][0] = sx*t[j][0];
    t[j][1] = sy*t[j][1];
    t[j][2] = sz*t[j][2];
  }
  
  

}

void perspProjection(mat4 t){

  int j;
  float tmp[4];
  for (j = 0;  j < 4; j++){
    t[j][0] = cota*t[j][0];
    t[j][1] = cota*t[j][1];
    tmp[j] = fpn*t[j][2] +fn*t[j][3];
    t[j][3] = -t[j][2];
  }
  for (j = 0;  j < 4; j++)
    t[j][2] = tmp[j];
}

void multiplyVec3Mat4(vec3 v3, mat4 m4){
  
  int i;
  for (i = 0; i < 3; i ++)
      v3[i] = v3[0]*m4[0][i] + v3[1]*m4[1][i] + v3[2]*m4[2][i] + m4[3][i];
}
  
void multiplyVec4Mat4(vec4 v4, mat4 m4){
  int i; 
  float tmp[4];
  for (i = 0; i < 4; i ++)
    tmp[i] = v4[0]*m4[0][i] + v4[1]*m4[1][i] + v4[2]*m4[2][i] + v4[3]*m4[3][i];
  for (i = 0; i < 4; i++)
    v4[i] = tmp[i];
}
    
void normVec4(vec4 v4){

  unsigned int i;
  for (i = 0; i < 3; i++)
    v4[i] = v4[i]/v4[3];
  
}

float sin_cos (float rad, short sc) {
	float out, tmp;
	int tmpint;
	
	tmp = 2048/(2*pi);
	tmp = rad * tmp;
	tmpint = (int) tmp;
	tmp -= tmpint;
	
	if (sc == 0)
	  tmpint = (tmpint + 512) % 2048;
      
	  
	out = Sin[tmpint] * (1 - tmp) + Sin[tmpint + 1] * tmp; //interpolation
	
	return out;
}

void deBoorSurfaceLR(vec3 sfps, vec4 *cps, int ncp, int n, int p, int q, float u, float v, float *U, float *V) {

  int c, d, s, t, i, j, k, r, h;
  float a, cpi, cpn;
  float c0, c1;
  int kun, kvn;
  float ncpf = ncp;
  float nf = n;
 


  kun = (int) ncpf/nf;
  kun = kun + p + 1;
  kvn = n + q + 1;


  //first step
  // detect the right interval and the knot multiplicity
  c = -1;
  s = 0;

  c1 = U[0];
  do {
    c++;
    c0 = c1;
    c1 = U[c+1];
    if (c0 == u)
      s++;
  }
  while((u < c0 || u >= c1) && (c+2) < kun);

  d = -1;
  t = 0;

  c1 = V[0];
  do {
    d++;
    c0 = c1;
    c1 = V[d+1];
    if (c0 == v)
      t++;
  }
  while((v < c0 || v >= c1) && (d+2) < kvn);
  
  
  if (p >= s){
    for (k = c - p; k <= c - s; k++){  
      h = q - t; 
     
      if (q >= t){ 
	for (r = d - q; r <= d - t;  r++){ 
	  copyVec4(cptmp1[r - d + q], cps[k*n + r]);
	}
	for (r = 1; r <= h; r++){
	  cpo[0] = cptmp1[r - 1][0];
	  cpo[1] = cptmp1[r - 1][1];
	  cpo[2] = cptmp1[r - 1][2];
	  cpo[3] = cptmp1[r - 1][3];
	  for (i = d-q+r; i <= d-t; i++){
	    a = (v - V[i])/(V[i + q - r + 1] - V[i]);
	    for (j = 0; j < 4; j++){
		cpi = cptmp1[i - d + q][j];
		cpn = (1 - a)*cpo[j] + a*cpi;
		cpo[j] = cpi;
		cptmp1[i - d + q][j] = cpn;
	    }
	  }
	}
	cptmp2[k - c + p][0] = cptmp1[-t + q][0];
	cptmp2[k - c + p][1] = cptmp1[-t + q][1];
	cptmp2[k - c + p][2] = cptmp1[-t + q][2];
	cptmp2[k - c + p][3] = cptmp1[-t + q][3];
      }
      else {
	cptmp2[k - c + p][0] = cps[k*n + (d-q)][0];
	cptmp2[k - c + p][1] = cps[k*n + (d-q)][1];
	cptmp2[k - c + p][2] = cps[k*n + (d-q)][2];
	cptmp2[k - c + p][3] = cps[k*n + (d-q)][3];
      }
    }
    h = p - s;
    for (r = 1; r <= h; r++){
      cpo[0] = cptmp2[r - 1][0];
      cpo[1] = cptmp2[r - 1][1];
      cpo[2] = cptmp2[r - 1][2];
      cpo[3] = cptmp2[r - 1][3];
      for (i = c-p+r; i <= c-s; i++){
	  a = (u - U[i])/(U[i + p - r + 1] - U[i]);
	  for (j = 0; j < 4; j++){
	    cpi = cptmp2[i - c + p][j];
	    cpn = (1 - a)*cpo[j] + a*cpi;
	    cpo[j] = cpi;
	    cptmp2[i - c + p][j] = cpn;
	  }
      }
    }
    sfps[0] = cptmp2[p - s][0]/cptmp2[p - s][3];
    sfps[1] = cptmp2[p - s][1]/cptmp2[p - s][3];
    sfps[2] = cptmp2[p - s][2]/cptmp2[p - s][3];
  }
  else {
    sfps[0] = cps[n*(c-p)  + (d-q)][0]/cps[n*(c-p)  + (d-q)][3];
    sfps[1] = cps[n*(c-p)  + (d-q)][1]/cps[n*(c-p)  + (d-q)][3];
    sfps[2] = cps[n*(c-p)  + (d-q)][2]/cps[n*(c-p)  + (d-q)][3];
  }
}


void initDrawList(drawList *dl){
  
  (*dl).primNum = 0;

}

void initFrameBuffer(){
  unsigned int i,j;
  RGB **fB;
  fB = (RGB **) malloc(SCREEN_H * sizeof(RGB *));
  for (i = 0; i < SCREEN_H; i++) {
    *(fB + i) = (RGB *) mallocFB(SCREEN_W * sizeof(RGB));
    for (j = 0; j < SCREEN_W; j++)
     *(*(fB + i) + j) = 0x40000000;
  }  
  frameBuffer = fB;
}

void clearFrameBuffer(){

  unsigned int i,j;
  RGB **fB = frameBuffer;
  for (i = 0; i < SCREEN_H; i++) {
    for (j = 0; j < SCREEN_W; j++)
      *(*(fB + i) + j) = 0x40000000;
  
  }
}


void addDrawList(char* addr, int type, drawList *dl){

  int length = (*dl).primNum;
  (*dl).primNum++;
  (*dl).primType[length] = type;
  (*dl).primAddr[length] = addr;

}

void transfRendDrawlist(drawList *dl, mat4 t){

  int i;
  translateMat(t, 0, 0, pjoffset);
  for (i = 0; i < (*dl).primNum; i++)
    transfRendColorPrim((*dl).primType[i], (*dl).primAddr[i], t);
    
}

void transfRendColorPrim(int type, char * addr, mat4 tmat) {
  int i;
  nurbss *ns;
  char *na;

  switch(type){

   case NURBSS:
    ns = (nurbss *) addr;
    perspProjection(tmat);
    for (i = 0; i < (*ns).cpnum; i++){
      multiplyVec4Mat4((*ns).cps[i], tmat);
    }
    na = addr;
    break;

  }

  renderColorPrim(type, na);
}

void initPolygon(pygon *pg){
  
  (*pg).vernum = 0;

}


void copyPolygon(pygon *py, pygon pf){
  int i;
  (*py).vernum = pf.vernum;
  for (i = 0; i < pf.vernum; i++){
    copyVec4((*py).vx[i], pf.vx[i]);
    (*py).cs[i] = pf.cs[i];
  }

}

void shadePrim(int type, char *addr) {
  pygon *p;
  int i;

  switch(type) {
  

  case PYGON:
    p = (pygon *) addr;
    for (i = 0; i < (*p).vernum; i++)
      (*p).cs[i] = shadeVertex((*p).vx[i][0], (*p).vx[i][1], (*p).vx[i][2], (*p).cs[i]);
    break;
  }

}

RGB shadeVertex(float ax, float ay, float az, RGB c){
  
  float I;
  float dist2;
  long int r,b,g;
  float lx, ly, lz;
  lx = lc[0];
  ly = lc[1];
  lz = lc[2];
  RGB tmp;
  dist2 = (ax - lx)*(ax - lx) + (ay - ly)*(ay - ly) + (az - lz)*(az - lz); 
  getRGB(c, &r, &g, &b);
  I = I0/dist2;

  r = r*I*cld + r*Id*cld;
  g = g*I*cld + g*Id*cld;
  b = b*I*cld + b*Id*cld;
  
  setRGB(&tmp, r, g, b);

  return tmp;
  
  
}


/***  render3DNurbsSurfaceNP ***/
void render3DNurbsSurface(vec4 *cps, float *U, float *V, int ncp, int n, int order1, int order2, RGB cl) {
  float u,v;
  vec3 sfp; 
  RGB color;
  int i;
  
  u = 0;
  v = 0;
  i=0;

  while (v < 1 - nsstep) {
    while(u < 1 - nsstep){
      deBoorSurfaceLR(sfp, cps, ncp, n, order1, order2, u, v, U, V);
      color = shadeVertex(sfp[0], sfp[1], sfp[2], cl); 
      draw3DVertexC(sfp[0], sfp[1], sfp[2], color);
      u += nsstep;
    }
    
    // **********************************************************************************************
    // *** last u interval; needed to avoid side effects (u += STEP can be slightly more than 1.0 ***
    // **********************************************************************************************
    u = 1.0;
    deBoorSurfaceLR(sfp, cps, ncp, n, order1, order2, u, v, U, V);
    color = shadeVertex(sfp[0], sfp[1], sfp[2], cl);
    draw3DVertexC(sfp[0], sfp[1], sfp[2], color);
    v += nsstep;
    u = 0;
    i++;

  }

  
  // **********************************************************************************************
  // *** last v interval; needed to avoid side effects (v += STEP can be slightly more than 1.0 ***
  // **********************************************************************************************
  v = 1;
  while(u < 1 - nsstep){
      deBoorSurfaceLR(sfp, cps, ncp, n, order1, order2, u, v, U, V);
      color = shadeVertex(sfp[0], sfp[1], sfp[2], cl);
      draw3DVertexC(sfp[0], sfp[1], sfp[2], color);
      u += nsstep;
  }


  // *****************************************************************
  u = 1.0;
  deBoorSurfaceLR(sfp, cps, ncp, n, order1, order2, u, v, U, V);
  color = shadeVertex(sfp[0], sfp[1], sfp[2], cl);
  draw3DVertexC(sfp[0], sfp[1], sfp[2], color);
  // *****************************************************************

}    

void renderColorPrim(int type, char * addr) {

  nurbss *ns;

  switch(type){
 
  case NURBSS:
    ns = (nurbss *) addr;
    render3DNurbsSurface((*ns).cps, (*ns).knvU, (*ns).knvV, (*ns).cpnum, (*ns).cpstep, (*ns).orderU, (*ns).orderV, (*ns).cs);
    resetNurbsSurface(ns);
    break;
  }

}
 

int resizeViewportWidth(float a){
  
  int x;
  if (a < view_maxx && a > view_minx){
    a += view_maxx;
    x = (int) (a * PD_W);
  }
  else 
    x = 320;
  return x;

}

int resizeViewportHeight(float b){

  int y;
  if (b < view_maxy && b > view_miny){
    b += view_maxy;
    y = (int) (b * PD_H);
    y = SCREEN_H - y;
  }
  else
    y = 240;
  return y;

}

void draw3DVertex(float x, float y, float z, long int r, long int g, long int b) {
      
  int xp, yp;
  long int zp;
  xp = resizeViewportWidth(x);
  yp = resizeViewportHeight(y);
  if (yp == 240 || xp == 320) {
    return;
  }
  z = z*32768;
  zp = (long int) z;
    if (zp >= (getDepth(*(*(zBuffer + yp) + xp)))){
      setRGB_Dep(*(frameBuffer + yp) + xp, r, g, b, zp);
    }
  
}

void draw3DVertexC(float x, float y, float z, RGB cl) {
      
  int xp, yp;
  long int zp;
  xp = resizeViewportWidth(x);
  yp = resizeViewportHeight(y);
  z = z*32768; 
  zp = (long int) z;
  if (zp >= (getDepth(*(*(zBuffer + yp) + xp)))){
    setRGBc_Dep(*(frameBuffer + yp) + xp, cl, zp);
  }

}

const float o5 = 0.5;
const float mo5 = -0.5;
const float mo8 = 0.5;
const float mu8 = -0.5;


int main()
{
  drawList* dl;
  mat4 tmat;
  vec4 *cps;
  dl = (drawList*) malloc(sizeof(drawList));
  
  initDrawList(dl);
  initFrameBuffer();
  zBuffer = frameBuffer;

  cps = (vec4 *) &cpsf[0]; 
  
  genNurbsSurface(cps, ku, kv, unum, vnum, uord, vord, ncl, dl);

  initTMat(tmat);
  scaleMat(tmat, 0.5, 0.5, 0.5);
  rotateMat(tmat, 3*pi/2, XAXIS);
  //translateMat(tmat, 0, 0.8, 0); 
  transfRendDrawlist(dl, tmat); 

  while(1);
  return 0;

}

