#define TRIANGLE 3
#define SQUARE 4
#define QUAD 5
#define PYGON 8
#define NURBSS 6
#define PG_MAXV 8
#define NC_MAXC 16
#define SCREEN_W 320
#define SCREEN_H 240
#define MIN_STEP 0.002 //2(viewport size) divided by 320 (screen width)and by 3(exp)
#define PIXEL_W 0.00625 //2(viewport size) divided by 320 (screen width)
#define PIXEL_H 0.00625 //2(viewport size) divided by 240 (screen width)  
#define PD_W 160 // SCREEN_W/VIEW_W
#define PD_H 160 // SCREEN_H/VIEW_H
#define WHITE 0x7fff
#define RED 0x1f
#define GREEN 0x3e0
#define BLUE 0x7c00
#define YELLOW 0x3ff
#define MAGENTA 0x7c1f
#define MAX_COLOR 0x7fff
#define NINF -100000
#define VIEW_W 2.0
#define VIEW_MAXX 1.0
#define VIEW_MINX -1.0
#define VIEW_H 1.5
#define VIEW_MAXY 0.75
#define VIEW_MINY -0.75
#define PI 3.141521

#define ALPHA 30.0
#define COTA 0.866 //cot(ALPHA)/2
#define NEARP -0.5 //-n
#define FARP -2.5 //-f
#define FPN 1.5 // f+n/f-n
#define FN 1.75 //2fn/f-n
#define XAXIS 0
#define YAXIS 1
#define ZAXIS 2
#define NXAXIS 3
#define NYAXIS 4
#define NZAXIS 5
#define CLP 0.75
#define CLD 0.25

#define VGA_ADDR 0x300000
#define VGA_END 0x34B000
#define HEAP_ADDR 0x000038c0
#define HEAP_END 0x000048c0
#define PJOFFSET -1.5

const float pd_H = PD_H;
const float pd_W = PD_W;
const float min_step = MIN_STEP;
const float pixel_w = PIXEL_W;
const float pixel_h = PIXEL_H;
const float view_w = VIEW_W;
const float view_maxx = VIEW_MAXX;
const float view_minx = VIEW_MINX;
const float view_h = VIEW_H;
const float view_maxy = VIEW_MAXY;
const float view_miny = VIEW_MINY;

const float cota = COTA;
const float nearp = NEARP;
const float farp = FARP;
const float fpn = FPN;
const float fn = FN;

const float clp = CLP;
const float cld = CLD;
const float I0 = 15;
const float Id = 1.0;

const float unit = 1.0;
const float pi = PI;
const float pjoffset = PJOFFSET;

#include "sin.h"

char* pointer = (char*) HEAP_ADDR;
char* pointerFB = (char*) VGA_ADDR;

typedef enum{false, true} bool;

typedef float vec2[2];

typedef float vec3[3];

typedef float vec4[4];

typedef bool bvec2[2];

typedef bool bvec3[3];

typedef bool bvec4[4];

typedef int ivec2[2];

typedef int ivec3[3];

typedef int ivec4[4];

typedef unsigned int RGB;

typedef vec2 mat2[2];

typedef vec3 mat3[3];

typedef vec4 mat4[4];

typedef struct {
  
  vec4 vx[PG_MAXV];
  RGB cs[PG_MAXV];
  int vernum;

}pygon;

typedef struct {
  
  vec4 *cps_src;
  vec4 *cps;
  float *knvU;
  float *knvV;
  RGB cs;
  int cpnum;
  int cpstep;
  int orderU;
  int orderV;

}nurbss;

typedef struct {
  
  int primNum;
  char *primAddr[5];
  int primType[5];

}drawList;

vec3 lc = {-3, 0, 0};

const float nsstep = 0.01;
const int steps_num = 100; //1.0/nsstep

//#include "paraboloid.h"
#include "sphere.h"

vec4 cpo;

RGB **frameBuffer;
RGB **zBuffer;

void initDrawList(drawList *dl);
void initFrameBuffer();
void initZBuffer();
void clearFrameBuffer();
void clearZBuffer();
void addDrawList(char* addr, int type, drawList *dl);
void transfRendDrawlist(drawList *dl, mat4 t);
void transfRendColorPrim(int type, char * addr, mat4 tmat);
void renderColorDrawlist(drawList *dl);
void draw3DColorSegment(float ax, float ay, float az, float bx, float by, float bz, RGB ca, RGB cb);
int resizeViewportWidth(float a);
int resizeViewportHeight(float b);
void drawTriangle(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, RGB ca, RGB cb, RGB cc);
void drawTriangleYPar(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, RGB ca, RGB cb, RGB cc, RGB COLOR);
void copyVec3(vec3 dst, vec3 src);
void copyVec4(vec4 dst, vec4 src);

void normDrawlist(drawList *dl);
void normPrim(int type, char * addr);
void draw3DVertexInt(int x, int y, float z, long int r, long int g, long int b);
void draw3DVertex(float x, float y, float z, long int r, long int g, long int b);
void draw3DVertexC(float x, float y, float z, RGB cl);
void duplDrawlist(drawList *dl, drawList *ddl);
void copyPrim(int type, char * addr, drawList *ddl);

/*** constructors ***/
void initVec4Norm(float a, float b, float c, vec4 v4);
void initVec3(float a, float b, float c, vec3 v3);
void initTMat(mat4 t);
void clearRGB(RGB *value);

void setRGB(RGB *value,  long int red, long int green, long int blue);

void getRGB(RGB value,  long int *red, long int *green, long int *blue);
void getRGBc(RGB value, unsigned char *red, unsigned char *green, unsigned char *blue);

void setScalingMat(mat4 sm, float sx, float sy, float sz);
void pushScalingMat(mat4 t, float sx, float sy, float sz);
void multiplyVec3Mat4(vec3 v3, mat4 m4);
void multiplyVec4Mat4(vec4 v4, mat4 m4);
void pushPerspProj(mat4 t);
void normVec4(vec4 v4);
void rotateMat(mat4 t, float Th, int axis);
float sin_cos (float deg, short sc);
void intersectRP(vec4 is, float ax, float ay, float az, float bx, float by, float bz, RGB *ci, RGB ca, RGB cb, float ix);
void shadePrim(int type, char *addr);
RGB shadeVertex(float ax, float ay, float az, RGB c);
void renderColorPrim(int type, char * addr);
void copyPolygon(pygon *py, pygon pf);
void clipPolygon(char *addr);
void clipPolygonOneEdge(char *addr, int normdir, float limit);
void intersectRP(vec4 is, float ax, float ay, float az, float bx, float by, float bz, RGB *ci, RGB ca, RGB cb, float ix);
void addVx3C2Polygon(pygon *pg, float ax, float ay, float az, RGB cl);
void deBoorSurface(vec3 sfps, vec4 *cps, int ncp, int n, int p, int q, float u, float v, float *U, float *V);
void deBoorSurfaceLR(vec3 sfps, vec4 *cps, int ncp, int n, int p, int q, float u, float v, float *U, float *V);
void render3DNurbsSurface(vec4 *cps, float *U, float *V, int ncp, int n, int order1, int order2, RGB cl);

void debugP(int x, int y, RGB cl);
