/************************************************************/
/***** Attention! This file is COFFEE ready.           ******/ 
/***** Among the modification, there is the merging of ******/ 
/***** ZBUFFER and FRAMEBUFFER and the need to read    ******/ 
/***** or write into them using the get* and set*      ******/ 
/***** functions. DON'T FORGET to do this when         ******/ 
/***** create a new COFFEE READY file                  ******/ 
/************************************************************/

#include "demo_single_file.h"

void debugP(int x, int y, RGB cl){

  *(*(frameBuffer + y) + x) = cl;
  

}

char * malloc(unsigned int num){

  char* startaddr;

  if ((pointer + num) >= (char*) HEAP_END){
    pointer = (char*) HEAP_ADDR;
  }
  startaddr = pointer;
  pointer += num;
  return startaddr;
}

char * mallocFB(unsigned int num){

  char* startaddrFB;
  if ((pointerFB + num) >= (char*) VGA_END){
    pointerFB = (char*) VGA_ADDR;
  }
  startaddrFB = pointerFB;
  pointerFB += num;
  return startaddrFB;
}

void initVec3(float a, float b, float c, vec3 v3)
{
  
  v3[0] = a;
  v3[1] = b;
  v3[2] = c;

}

void initVec4(float a, float b, float c, float d, vec4 v4)
{
  
  v4[0] = a;
  v4[1] = b;
  v4[2] = c;
  v4[3] = d;

}

void copyVec4(vec4 dst, vec4 src)
{
  
  dst[0] = src[0];
  dst[1] = src[1];
  dst[2] = src[2];
  dst[3] = src[3];

}

void initVec4Norm(float a, float b, float c, vec4 v4)
{
  
  v4[0] = a;
  v4[1] = b;
  v4[2] = c;
  v4[3] = 1.0;

}

void clearRGB(RGB *value){
  
  *value = 0;
}

void initTMat(mat4 t){
  
  unsigned int i,j;
  for (i = 0; i < 4; i++)
    for (j = 0;  j< 4; j++){
      if (i == j)
	t[i][j] = 1;
      else
	t[i][j] = 0;
    }

}

void setRGB(RGB *value, int red, int green, int blue){
  int temp;
  if (blue < 0)
    temp = 0x1f;
  else
    temp = (blue >> 11) & 0x1f;
  if (green < 0)
    temp = ((temp & 0x1F) << 5) | 0x1f;
  else
    temp = ((temp & 0x1F) << 5) | ((green >> 11) & 0x1f);
  if (red < 0)
    temp = ((temp & 0x3FF) << 5) | 0x1f;
  else
    temp = ((temp & 0x3FF) << 5) | ((red >> 11) & 0x1f);
  *value = (*value & 0xffff0000) | (temp & 0xffff);

}
void setDepth(RGB *value, int depth){
  int depth_old;
  depth_old = *value & 0x00007FFF;
  depth >>= 1;
  depth = depth & 0x7FFF8000;
  *value = depth_old | depth;

}

void setRGB_Dep(RGB *value, int red, int green, int blue, int dp){
  int temp;
  if (blue < 0)
    temp = 0x1f;
  else
    temp = (blue >> 11) & 0x1f;
  if (green < 0)
    temp = ((temp & 0x1F) << 5) | 0x1f;
  else
    temp = ((temp & 0x1F) << 5) | ((green >> 11) & 0x1f);
  if (red < 0)
    temp = ((temp & 0x3FF) << 5) | 0x1f;
  else
    temp = ((temp & 0x3FF) << 5) | ((red >> 11) & 0x1f);
  dp >>= 1;
  temp = (dp & 0x7fff8000) | (temp & 0x7fff);
  *value = temp;

}

int getDepth(RGB value) {

  int depth;
  depth = (value << 1) & 0xFFFF0000;
  return depth;

}

void getRGB(RGB value, int *red, int *green, int *blue){

    *red = (int) (value & 0x1F) << 11;
    *green = (int) ((value >> 5) & 0x1F) << 11;
    *blue = (int) ((value >> 10) & 0x1F) << 11;
}

void getRGBc(RGB value, unsigned char *red, unsigned char *green, unsigned char *blue){
  
    *red = (unsigned char) ((value & 0x1F) << 3);
    *green = (unsigned char) (((value >> 5) & 0x1F) << 3);
    *blue = (unsigned char) (((value >> 10) & 0x1F) << 3);
}


void genQuad(vec3 va, vec3 vb, vec3 vc, vec3 vd, RGB ca, RGB cb, RGB cc, RGB cd, drawList *dl)
{
  pygon *q;
  char* qa;
  q = (pygon *) malloc(sizeof(pygon));
  qa = (char*) q;
  (*q).vernum = 4;
  initVec4Norm(va[0], va[1], va[2], (*q).vx[0]);
  initVec4Norm(vb[0], vb[1], vb[2], (*q).vx[1]);
  initVec4Norm(vc[0], vc[1], vc[2], (*q).vx[2]);
  initVec4Norm(vd[0], vd[1], vd[2], (*q).vx[3]);
  (*q).cs[0] = ca;
  (*q).cs[1] = cb;
  (*q).cs[2] = cc;
  (*q).cs[3] = cd;
  addDrawList(qa, PYGON, dl);

}
void addVx3C2Polygon(pygon *pg, float ax, float ay, float az, RGB cl){

  int idx = (*pg).vernum;
  (*pg).vx[idx][0] = ax;
  (*pg).vx[idx][1] = ay;
  (*pg).vx[idx][2] = az;
  (*pg).cs[idx] = cl;
  (*pg).vernum ++;
}

void addVx2Polygon(pygon *pg, vec4 vx, RGB cl){

  int idx = (*pg).vernum;
  copyVec4((*pg).vx[idx], vx);
  (*pg).cs[idx] = cl;
  (*pg).vernum ++;
}


void rotateMat(mat4 t, float Th, int axis) {
  
  float cosTh, sinTh;
  float tmp[8];
  unsigned int i;
  cosTh = sin_cos(Th,0);
  sinTh = sin_cos(Th, 1);
  switch (axis) {
    
  case XAXIS:
    for (i = 0; i < 3; i++){
      tmp[i] = cosTh*t[i][1] + sinTh*t[i][2];
      tmp[i+4] = -sinTh*t[i][1] + cosTh*t[i][2];
    }
    for (i = 0; i < 3; i++){
      t[i][1] = tmp[i];
      t[i][2] = tmp[i + 4];
    }
    break;
  case YAXIS:
    for (i = 0; i < 3; i++){
      tmp[i] = cosTh*t[i][0] + sinTh*t[i][2];
      tmp[i+4] = -sinTh*t[i][0] + cosTh*t[i][2];
    }
    for (i = 0; i < 3; i++){
      t[i][0] = tmp[i];
      t[i][2] = tmp[i + 4];
    }
    break;
  case ZAXIS:
    for (i = 0; i < 3; i++){
      tmp[i] = cosTh*t[i][0] + sinTh*t[i][1];
      tmp[i+4] = -sinTh*t[i][0] + cosTh*t[i][1];
    }
    for (i = 0; i < 3; i++){
      t[i][0] = tmp[i];
      t[i][1] = tmp[i + 4];
    }
    break;
  }
    
    
  
}

void translateMat(mat4 t, float dx, float dy, float dz) {

  int j;
  for (j = 0;  j < 4; j++){
    t[j][0] = t[j][0] + dx*t[j][3];
    t[j][1] = t[j][1] + dy*t[j][3];
    t[j][2] = t[j][2] + dz*t[j][3];
  }

}


void scaleMat(mat4 t, float sx, float sy, float sz){
  int j;
  
  for (j = 0;  j < 4; j++){
    t[j][0] = sx*t[j][0];
    t[j][1] = sy*t[j][1];
    t[j][2] = sz*t[j][2];
  }
  
  

}

void perspProjection(mat4 t){

  int j;
  float tmp[4];
  for (j = 0;  j < 4; j++){
    t[j][0] = cota*t[j][0];
    t[j][1] = cota*t[j][1];
    tmp[j] = fpn*t[j][2] +fn*t[j][3];
    t[j][3] = -t[j][2];
  }
  for (j = 0;  j < 4; j++)
    t[j][2] = tmp[j];
}

void intersectRP(vec4 is, float ax, float ay, float az, float bx, float by, float bz, RGB *ci, RGB ca, RGB cb, float ix){

  float my, qy, mz, qz, iy, iz;
  int rda, rdb, gra, grb, bla, blb, ird, igr, ibl, mrd, mgr, mbl, qrd, qgr, qbl;

  getRGB(ca, &rda, &gra, &bla);
  getRGB(cb, &rdb, &grb, &blb);
  if (ax==bx) {
    return;
  }
  else {
    my = (by - ay)/(bx - ax);
    qy = ay - (my*ax);
    mz = (bz - az)/(bx - ax);
    qz = az - (mz*ax);
    mrd = (int) ((rdb - rda)/(bx - ax)); 
    qrd = (int) (rdb - (mrd*ax));
    mgr = (int) ((grb - gra)/(bx - ax));
    qgr = (int) (grb - (mgr*ax));
    mbl = (int) ((blb - bla)/(bx - ax));
    qbl = (int) (blb - (mbl*ax));
    iy = my*ix + qy;
    iz = mz*ix + qz;
    ird = (int) (mrd*ix + qrd);
    igr = (int) (mgr*ix + qgr);
    ibl = (int) (mbl*ix + qbl);
    setRGB(ci, ird, igr, ibl);
    initVec4Norm(ix, iy, iz, is);
  }
}

void multiplyVec3Mat4(vec3 v3, mat4 m4){
  
  int i;
  for (i = 0; i < 3; i ++)
      v3[i] = v3[0]*m4[0][i] + v3[1]*m4[1][i] + v3[2]*m4[2][i] + m4[3][i];
}
  
void multiplyVec4Mat4(vec4 v4, mat4 m4){
  int i; 
  float tmp[4];
  for (i = 0; i < 4; i ++)
    tmp[i] = v4[0]*m4[0][i] + v4[1]*m4[1][i] + v4[2]*m4[2][i] + v4[3]*m4[3][i];
  for (i = 0; i < 4; i++)
    v4[i] = tmp[i];
}
    
void normVec4(vec4 v4){

  unsigned int i;
  for (i = 0; i < 3; i++)
    v4[i] = v4[i]/v4[3];
  
}

float sin_cos (float deg, short sc) {
	float out, tmp;
	int tmpint;
	
	tmp = 2048/360;
	tmp = deg * tmp;
	tmpint = (int) tmp;
	tmp -= tmpint;
	
	if (sc == 0)
	  tmpint = (tmpint + 512) % 2048;
      
	  
	out = Sin[tmpint] * (1 - tmp) + Sin[tmpint + 1] * tmp; //interpolation
	
	return out;
}

void initDrawList(drawList *dl){
  
  (*dl).primNum = 0;

}

void initFrameBuffer(){
  unsigned int i,j;
  RGB **fB;
  fB = (RGB **) malloc(SCREEN_H * sizeof(RGB *));
  for (i = 0; i < SCREEN_H; i++) {
    *(fB + i) = (RGB *) mallocFB(SCREEN_W * sizeof(RGB));
    for (j = 0; j < SCREEN_W; j++)
     *(*(fB + i) + j) = 0x40000000;
  }  
  frameBuffer = fB;
}

void clearFrameBuffer(){

  unsigned int i,j;
  RGB **fB = frameBuffer;
  for (i = 0; i < SCREEN_H; i++) {
    for (j = 0; j < SCREEN_W; j++)
      *(*(fB + i) + j) = 0x40000000;
  
  }
}

void initZBuffer(){
  unsigned int i,j;
  RGB **zB;
  zB = (RGB **) malloc(SCREEN_W * sizeof(RGB *));
  for (i = 0; i < SCREEN_W; i++) {
    *(zB + i) = (RGB *) malloc(SCREEN_H * sizeof(RGB));
    for (j = 0; j < SCREEN_H; j++)
      *(*(zB + i) + j) = 0x80000000;
  }  
  zBuffer = zB;
}

void clearZBuffer(){

  unsigned int i,j;
  RGB **zB = zBuffer;
  for (i = 0; i < SCREEN_W; i++)
    for (j = 0; j < SCREEN_H; j++)
      setDepth(*(zB + i) + j, 0x80000000);
  
}

void addDrawList(char* addr, int type, drawList *dl){

  int length = (*dl).primNum;
  (*dl).primNum++;
  (*dl).primType[length] = type;
  (*dl).primAddr[length] = addr;

}

void transfRendDrawlist(drawList *dl, mat4 t){
  int i;
  translateMat(t, 0, 0, -1.5);
  for (i = 0; i < (*dl).primNum; i++)
    transfRendColorPrim((*dl).primType[i], (*dl).primAddr[i], t);
    
}

void transfRendColorPrim(int type, char * addr, mat4 tmat) {
  int i;
  pygon *p;
  pygon pn;
  char *na;
  
  switch(type){
  case PYGON:
    p = (pygon *) addr;
    na = (char *) &pn;
    copyPolygon(&pn, *p);
    for (i = 0; i < pn.vernum; i++){
      multiplyVec4Mat4(pn.vx[i], tmat);
      normVec4(pn.vx[i]);
    }
    for (i = 0; i < pn.vernum; i++)
      pn.cs[i] = shadeVertex(pn.vx[i][0], pn.vx[i][1],pn.vx[i][2],pn.cs[i]);
    for (i = 0; i < pn.vernum; i++){
      multiplyVec4Mat4(pn.vx[i], pmat);
      normVec4(pn.vx[i]);
    }
    break;


  }
  renderColorPrim(type, na);
}

void initPolygon(pygon *pg){
  
  (*pg).vernum = 0;

}


void copyPolygon(pygon *py, pygon pf){
  int i;
  (*py).vernum = pf.vernum;
  for (i = 0; i < pf.vernum; i++){
    copyVec4((*py).vx[i], pf.vx[i]);
    (*py).cs[i] = pf.cs[i];
  }

}

void shadePrim(int type, char *addr) {
  pygon *p;
  int i;

  switch(type) {
  

  case PYGON:
    p = (pygon *) addr;
    for (i = 0; i < (*p).vernum; i++)
      (*p).cs[i] = shadeVertex((*p).vx[i][0], (*p).vx[i][1], (*p).vx[i][2], (*p).cs[i]);
    break;
  }

}

RGB shadeVertex(float ax, float ay, float az, RGB c){
  
  float I;
  float dist2;
  int r,b,g;
  RGB tmp;
  dist2 = (ax - lx)*(ax - lx) + (ay - ly)*(ay - ly) + (az - lz)*(az - lz); 
  getRGB(c, &r, &g, &b);
  I = I0/dist2;

  r = r*I*cld + r*Id*cld;
  g = g*I*cld + g*Id*cld;
  b = b*I*cld + b*Id*cld;
  
  setRGB(&tmp, r, g, b);

  return tmp;
  
  
}


void draw3DColorSegment(float ax, float ay, float az, float bx, float by, float bz, RGB ca, RGB cb){

  float tmp, zd, pnz, yd;
  int rda, rdb, gra, grb, bla, blb, rdba, grba, blba;
  int pn;

  getRGB(ca, &rda, &gra, &bla);
  getRGB(cb, &rdb, &grb, &blb);
  
  if (ax==bx) {
    pn = (int) (pd_H*(ay - by));
    pnz = (pd_H*(ay - by));
    if (pn == 0)
      return;
    if (pn < 0){
     pn = -pn;
      pnz = -pnz;
    }
    rdba = (int) (rdb - rda)/pnz; 
    grba = (int) (grb - gra)/pnz; 
    blba = (int) (blb - bla)/pnz; 
    zd = (bz - az)/pnz;
    if (by > ay) {
      while (by > ay) {
	draw3DVertex(ax, ay, az, rda, gra, bla);
	rda += rdba;
	gra += grba;
	bla += blba;
	ay += pixel_h;
	az += zd;
      }
    }
    else {
      while (by <= ay) {
	draw3DVertex(ax, ay, az, rda, gra, bla);
	rda += rdba;
	gra += grba;
	bla += blba;
	ay -= pixel_h;
	az += zd;
      }
    }
  }
  else {
  if (ay==by) {
      pn = (int) (pd_W*(ax - bx));
      pnz = (pd_W*(ax - bx));
      if (pn == 0)
	return;
      if (pn < 0) {
	pn = -pn;
	pnz = -pnz;
      }
      rdba = (int) (rdb - rda)/pnz; 
      grba = (int) (grb - gra)/pnz; 
      blba = (int) (blb - bla)/pnz; 
      zd = (bz - az)/pnz; 
      if (bx > ax) {
      	while (bx > ax) {
	  //for (i = 0; i < pn; i++){
	  draw3DVertex(ax, ay, az, rda, gra, bla);
	  rda += rdba;
	  gra += grba;
	  bla += blba;
	  ax += pixel_w;
	  az += zd;
	}
      }
      else {
	while (bx <= ax) {
	  draw3DVertex(ax, ay, az, rda, gra, bla);
	  rda += rdba;
	  gra += grba;
	  bla += blba;
	  ax -= pixel_w;
	  az += zd;
	}
      }
  }
    else {
      tmp = ax;
      if (ax <= bx){
	pn = 0;
	pnz = 0;
	while (tmp <= bx) {
	  tmp += min_step; 
	  pn ++;
	  pnz ++;
	}
	rdba = (int) (rdb - rda)/pnz; 
	grba = (int) (grb - gra)/pnz; 
	blba = (int) (blb - bla)/pnz; 
	zd = (bz - az)/pnz;
	yd = (by - ay)/pnz;
	while (ax <= bx){
	  draw3DVertex(ax, ay, az, rda, gra, bla);
	  rda += rdba;
	  gra += grba;
	  bla += blba;
	  ax += min_step;
	  ay += yd;
	  az += zd;
	}
      }
      else {
	pn = 0;
	pnz = 0;
	while (tmp > bx) {
	  tmp -= min_step; 
	  pn ++;
	  pnz ++;
	}
	rdba = (int) ((rdb - rda)/pnz); 
	grba = (int) ((grb - gra)/pnz); 
	blba = (int) ((blb - bla)/pnz);
	zd = (bz - az)/pnz;
	yd = (by - ay)/pnz;
	while (ax > bx){
	  draw3DVertex(ax, ay, az, rda, gra, bla);
	  rda += rdba;
	  gra += grba;
	  bla += blba;
	  ax -= min_step;
	  ay += yd;
	  az += zd;
	}
      }
    }
      
  }
}

void renderColorPrim(int type, char * addr) {

  int i = 2;
  pygon *p;
  switch(type){
  
  

  case PYGON:
    p = (pygon *) addr;
    for (i = 1; i < (*p).vernum - 1; i++) 
      drawTriangle((*p).vx[0][0], (*p).vx[0][1], (*p).vx[0][2], (*p).vx[i][0], (*p).vx[i][1], (*p).vx[i][2], (*p).vx[i + 1][0], (*p).vx[i + 1][1], (*p).vx[i + 1][2], (*p).cs[0], (*p).cs[i], (*p).cs[i + 1]);
      
    break;
 
  }

}
 
void drawTriangle(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, RGB ca, RGB cb, RGB cc){

  int mr, mg, mb, qr, qb, qg, rda, rdb, rdc, gra, grb, grc, bla, blb, blc, tmpr, tmpb, tmpg;
  RGB tmpc;
  float m, mz, q, qz, tmpy, tmpz; 

  getRGB(ca, &rda, &gra, &bla);
  getRGB(cb, &rdb, &grb, &blb);
  getRGB(cc, &rdc, &grc, &blc);
  
  
  if (ax == bx && ax == cx){
    if (ay == by && by == cy){
      draw3DVertex(ax, ay, az, rda, gra, bla);
      
    }
    else {
      if (ay < by && ay < cy){
	if (by < cy){
	  draw3DColorSegment(ax, ay, az, cx, cy, cz, ca, cc);
	}
	else
	  draw3DColorSegment(ax, ay, az, bx, by, bz, ca, cb);
      }
      else {
	if (by < ay && by < cy){
	  if (ay < cy){
	    draw3DColorSegment(bx, by, bz, cx, cy, cz, cb, cc);
	  }
	  else
	    draw3DColorSegment(ax, ay, az, bx, by, bz, ca, cb);
	}
	else {
	  if (cy < by && cy < ay){
	    if (by < ay){
	      draw3DColorSegment(ax, ay, az, cx, cy, cz, ca, cc);
	    }
	    else
	      draw3DColorSegment(cx, cy, cz, bx, by, bz, cc, cb);
	  }
	  else {
	    draw3DVertex(ax, ay, az, rda, gra, bla);
	  }
	}
      }
    }
  }
  else {
    if (ax == bx || ax == cx || bx == cx){ 
      if (ax == bx)
	drawTriangleYPar(cx, cy, cz, bx, by, bz, ax, ay, az, cc, cb, ca);
      if (ax == cx)
	drawTriangleYPar(bx, by, bz, ax, ay, az, cx, cy, cz, cb, ca, cc);
      if (bx == cx)
	drawTriangleYPar(ax, ay, az, bx, by, bz, cx, cy, cz, ca, cb, cc);
    }
    else {
      if (ax < bx && ax < cx){
	if (bx < cx){
	  m = (cy - ay)/(cx - ax);
	  q = ay - (m*ax);
	  tmpy = m*bx + q;
	  mz = (cz - az)/(cx - ax);
	  qz = az - (mz*ax);
	  tmpz = mz*bx + qz;
	  mr = (rdc - rda)/(cx - ax);
	  qr = rda - (mr*ax);
	  tmpr = mr*bx + qr;
	  mg = (grc - gra)/(cx - ax);
	  qg = gra - (mg*ax);
	  tmpg = mg*bx + qg;
	  mb = (blc - bla)/(cx - ax);
	  qb = bla - (mb*ax);
	  tmpb = mb*bx + qb;      
	  setRGB(&tmpc, tmpr, tmpg, tmpb);
	  drawTriangleYPar(ax, ay, az, bx, by, bz, bx, tmpy, tmpz, ca, cb, tmpc);
	  drawTriangleYPar(cx, cy, cz, bx, by, bz, bx, tmpy, tmpz, cc, cb, tmpc);
	}
	else {
	  m = (by - ay)/(bx - ax);
	  q = ay - (m*ax);
	  tmpy = m*cx + q;
	  mz= (bz - az)/(bx - ax);
	  qz = az - (mz*ax);
	  tmpz = mz*cx + qz;
	  mr = (rdb - rda)/(bx - ax);
	  qr = rda - (mr*ax);
	  tmpr = mr*cx + qr;
	  mg = (grb - gra)/(bx - ax);
	  qg = gra - (mg*ax);
	  tmpg = mg*cx + qg;
	  mb = (blb - bla)/(bx - ax);
	  qb = bla - (mb*ax);
	  tmpb = mb*cx + qb;      
	  setRGB(&tmpc, tmpr, tmpg, tmpb);
	  drawTriangleYPar(ax, ay, az, cx, cy, cz, cx, tmpy, tmpz, ca, cc, tmpc);
	  drawTriangleYPar(bx, by, bz, cx, cy, cz, cx, tmpy, tmpz, cb, cc, tmpc);
	}
      }
			 
      if (bx < ax && bx < cx) {
	if (ax < cx){
	  m = (cy - by)/(cx - bx);
	  q = by - (m*bx);
	  tmpy = m*ax + q;
	  mz = (cz - bz)/(cx - bx);
	  qz = bz - (mz*bx);
	  tmpz = mz*ax + qz;
	  mr = (rdc - rdb)/(cx - bx);
	  qr = rdb - (mr*bx);
	  tmpr = mr*ax + qr;
	  mg = (grc - grb)/(cx - bx);
	  qg = grb - (mg*bx);
	  tmpg = mg*ax + qg;
	  mb = (blc - blb)/(cx - bx);
	  qb = blb - (mb*bx);
	  tmpb = mb*ax + qb;      
	  setRGB(&tmpc, tmpr, tmpg, tmpb);
	  drawTriangleYPar(bx, by, bz, ax, ay, az, ax, tmpy, tmpz, cb, ca, tmpc);
	  drawTriangleYPar(cx, cy, cz, ax, ay, az, ax, tmpy, tmpz, cc, ca, tmpc);
	}
	else {	  
	    m = (ay - by)/(ax - bx);
	    q = by - (m*bx);
	    tmpy = m*cx + q;
	    mz = (az - bz)/(ax - bx);
	    qz = bz - (mz*bx);
	    tmpz = mz*cx + qz;
	    mr = (rda - rdb)/(ax - bx);
	    qr = rdb - (mr*bx);
	    tmpr = mr*cx + qr;
	    mg = (gra - grb)/(ax - bx);
	    qg = grb - (mg*bx);
	    tmpg = mg*cx + qg;
	    mb = (bla - blb)/(ax - bx);
	    qb = blb - (mb*bx);
	    tmpb = mb*cx + qb;      
	    setRGB(&tmpc, tmpr, tmpg, tmpb);
	    drawTriangleYPar(bx, by, bz, cx, cy, cz, cx, tmpy, tmpz, cb, cc, tmpc);
	    drawTriangleYPar(ax, ay, az, cx, cy, cz, cx, tmpy, tmpz, ca, cc, tmpc);
	  }
      }
      if (cx < ax && cx < bx) {
	if (ax < bx){
	  m = (by - cy)/(bx - cx);
	  q = cy - (m*cx);
	  tmpy = m*ax + q;
	  mz = (bz - cz)/(bx - cx);
	  qz = cz - (mz*cx);
	  tmpz = mz*ax + qz;
	  mr = (rdb - rdc)/(bx - cx);
	  qr = rdc - (mr*cx);
	  tmpr = mr*ax + qr;
	  mg = (grb - grc)/(bx - cx);
	  qg = grc - (mg*cx);
	  tmpg = mg*ax + qg;
	  mb = (blb - blc)/(bx - cx);
	  qb = blc - (mb*cx);
	  tmpb = mb*ax + qb;      
	  setRGB(&tmpc, tmpr, tmpg, tmpb);
	  drawTriangleYPar(cx, cy, cz, ax, ay, az, ax, tmpy, tmpz, cc, ca, tmpc);
	  drawTriangleYPar(bx, by, bz, ax, ay, az, ax, tmpy, tmpz, cb, ca, tmpc);
	}
	else{
	  m = (ay - cy)/(ax - cx);
	  q = cy - (m*cx);
	  tmpy = m*bx + q;
	  mz = (az - cz)/(ax - cx);
	  qz = cz - (mz*cx);
	  tmpz = mz*bx + qz;
	  mr = (rda - rdc)/(ax - cx);
	  qr = rdc - (mr*cx);
	  tmpr = mr*bx + qr;
	  mg = (gra - grc)/(ax - cx);
	  qg = grc - (mg*cx);
	  tmpg = mg*bx + qg;
	  mb = (bla - blc)/(ax - cx);
	  qb = blc - (mb*cx);
	  tmpb = mb*bx + qb;      
	  setRGB(&tmpc, tmpr, tmpg, tmpb);
	  drawTriangleYPar(cx, cy, cz, bx, by, bz, bx, tmpy, tmpz, cc, cb, tmpc);
	  drawTriangleYPar(ax, ay, az, bx, by, bz, bx, tmpy, tmpz, ca, cb, tmpc);
	} 
      }
    }
  }
}

void drawTriangleYPar(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, RGB ca, RGB cb, RGB cc){

  int rda, rdb, rdc, gra, grb, grc, bla, blb, blc, rdda, rdcb, grda, grcb, blda, blcb;
  float zca, zcb, xca, yca;
  int pn;
  float pnz; 

  getRGB(ca, &rda, &gra, &bla);
  getRGB(cb, &rdb, &grb, &blb);
  getRGB(cc, &rdc, &grc, &blc);
  
  //*** hypothesis : bx == cx ***
  pn = (int) (pd_H*(cy - by));
  pnz = (pd_H*(cy - by));
  if (pn == 0)
    return;
  if (pn < 0){
    pn = -pn;
    pnz = -pnz;
  }
  rdda = (int) ((rdc - rda)/pnz); 
  rdcb = (int) ((rdc - rdb)/pnz); 
  grda = (int) ((grc - gra)/pnz); 
  grcb = (int) ((grc - grb)/pnz); 
  blda = (int) ((blc - bla)/pnz); 
  blcb = (int) ((blc - blb)/pnz); 
  zca = (cz - az)/pnz;
  zcb = (cz - bz)/pnz;
  yca = (cy - ay)/pnz;
  xca = (cx - ax)/pnz;
  if (by > cy) {
    while (by > cy) {
      draw3DColorSegment(ax, ay, az, bx, by, bz, ca, cb);
      rdb += rdcb;
      rda += rdda;
      grb += grcb;
      gra += grda;
      blb += blcb;
      bla += blda;
      az += zca;
      bz += zcb;
      setRGB(&ca, rda, gra, bla);
      setRGB(&cb, rdb, grb, blb);
      by -= pixel_h; 
      ax += xca;
      ay += yca;
    }
  }
  else {
    while (by <= cy) {
      draw3DColorSegment(ax, ay, az, bx, by, bz, ca, cb);
      rdb += rdcb;
      rda += rdda;
      grb += grcb;
      gra += grda;
      blb += blcb;
      bla += blda;
      az += zca;
      bz += zcb;
      setRGB(&ca, rda, gra, bla);
      setRGB(&cb, rdb, grb, blb);
      by += pixel_h;
      ax += xca;
      ay += yca;
    }
  }
}



int resizeViewportWidth(float a){
  
  int x;
  if (a < view_maxx && a > view_minx){
    a += view_maxx;
    x = (int) (a * pd_W);
  }
  else 
    x = 320;
  return x;

}

int resizeViewportHeight(float b){

  int y;
  if (b < view_maxy && b > view_miny){
    b += view_maxy;
    y = (int) (b * pd_H);
    y = (SCREEN_H-1) - y;
  }
  else
    y = 240;
  return y;

}

void draw3DVertex(float x, float y, float z, int r, int g, int b) {
      
  int xp, yp;
  int zp;
  xp = resizeViewportWidth(x);
  yp = resizeViewportHeight(y);
  if (yp == 240 || xp == 320) {
    return;
  }
  z = z*1024*1024*1024;
  zp = (int) z;
  if (zp > (getDepth(*(*(zBuffer + yp) + xp)))){
    setRGB_Dep(*(frameBuffer + yp) + xp, r, g, b, zp);
  }
  
}


const float o5 = 0.5;
const float mo5 = -0.5;
const float mo8 = 0.5;
const float mu8 = -0.5;


int main()
{
  drawList* dl;
  mat4 tmat;
  short int i;
  vec3 sq1[4];
  vec3 sq2[4];
 
  initVec3(mo5, mo5, mo8, sq1[0]); 
  initVec3(o5, mo5, mo8, sq1[1]);
  initVec3(o5, o5, mo8, sq1[2]);
  initVec3(mo5, o5, mo8, sq1[3]);
  initVec3(mo5, mo5, mu8, sq2[0]); 
  initVec3(o5, mo5, mu8, sq2[1]);
  initVec3(o5, o5, mu8, sq2[2]);
  initVec3(mo5, o5, mu8, sq2[3]);
  
  dl = (drawList*) malloc(sizeof(drawList));
  
  initDrawList(dl);
  initFrameBuffer();
  zBuffer = frameBuffer;

  initTMat(pmat);
  perspProjection(pmat);

  debugP(3, 3, RED);

  /*** ORIGINAL ***//*
  genQuad(sq2[0], sq2[1], sq2[2], sq2[3], WHITE, WHITE, WHITE, WHITE, dl);  
  genQuad(sq2[1], sq2[2], sq1[2], sq1[1], YELLOW, YELLOW, YELLOW, YELLOW, dl);
  genQuad(sq1[0], sq1[3], sq2[3], sq2[0], GREEN, GREEN, GREEN, GREEN, dl); 
  genQuad(sq2[2], sq2[3], sq1[3], sq1[2], BLUE, BLUE, BLUE, BLUE, dl); 
  genQuad(sq2[0], sq2[1], sq1[1], sq1[0], RED, RED, RED, RED, dl);*/
  /*** 2 FACES ***//*
  genQuad(sq2[0], sq2[1], sq2[2], sq2[3], YELLOW, BLUE, RED, GREEN, dl);  
  genQuad(sq2[1], sq2[2], sq1[2], sq1[1], YELLOW, YELLOW, YELLOW, YELLOW, dl); 
  genQuad(sq1[0], sq1[3], sq2[3], sq2[0], GREEN, GREEN, GREEN, GREEN, dl);  
  genQuad(sq2[2], sq2[3], sq1[3], sq1[2], BLUE, BLUE, BLUE, BLUE, dl);  
  genQuad(sq2[0], sq2[1], sq1[1], sq1[0], RED, RED, RED, RED, dl); 
  genQuad(sq1[0], sq1[1], sq1[2], sq1[3], YELLOW, BLUE, RED, GREEN, dl); */
  /***** 2 COLORS *****/
  genQuad(sq2[0], sq2[1], sq2[2], sq2[3], GREEN, BLUE, BLUE, BLUE, dl);  
  genQuad(sq2[1], sq2[2], sq1[2], sq1[1], BLUE, BLUE, GREEN, BLUE, dl); 
  genQuad(sq1[0], sq1[3], sq2[3], sq2[0], BLUE, BLUE, BLUE, GREEN, dl);  
  genQuad(sq2[2], sq2[3], sq1[3], sq1[2], BLUE, BLUE, BLUE, GREEN, dl);  
  genQuad(sq2[0], sq2[1], sq1[1], sq1[0], GREEN, BLUE, BLUE, BLUE, dl); 
  genQuad(sq1[0], sq1[1], sq1[2], sq1[3], BLUE, BLUE, GREEN, BLUE, dl);  
  /***************/

  while(1){
      
    initTMat(tmat); 
    scaleMat(tmat, 0.3, 0.3, 0.3);
    debugP(5, 5, RED);
    translateMat(tmat, 0.1, 0.1, 0.1);
    rotateMat(tmat, 2*i, YAXIS);
    rotateMat(tmat, 2*i, XAXIS);
    debugP(8, 8, RED);
    transfRendDrawlist(dl, tmat); 
    debugP(200, 200, GREEN);
    clearFrameBuffer();
    i++;
    if (i >= 180)
      i = 0;
  }

  return 0;

}

