#define TRIANGLE 3
#define SQUARE 4
#define QUAD 5
#define PYGON 6
#define PG_MAXV 11
#define NC_MAXC 16
#define SCREEN_W 320
#define SCREEN_H 240
#define MIN_STEP 0.002 //2(viewport size) divided by 320 (screen width)and by 3(exp)
#define PIXEL_W 0.00625 //2(viewport size) divided by 320 (screen width)
#define PIXEL_H 0.00625 //2(viewport size) divided by 240 (screen width)  
#define PD_W 160 // SCREEN_W/VIEW_W
#define PD_H 160 // SCREEN_H/VIEW_H
#define WHITE 0x7fff
#define RED 0x1f
#define GREEN 0x3e0
#define BLUE 0x7c00
#define YELLOW 0x3ff
#define ORANGE 0x21f
#define MAX_COLOR 0x7fff
#define NINF -1000
#define PJOFFSET -1.5
#define VIEW_W 2.0
#define VIEW_MAXX 1.0
#define VIEW_MINX -1.0
#define VIEW_H 1.5
#define VIEW_MAXY 0.75
#define VIEW_MINY -0.75

#define ALPHA 30.0
#define COTA 0.866 //cot(ALPHA)/2
#define NEARP -0.5 //-n
#define FARP -2.5 //-f
#define FPN 1.5 // f+n/f-n
#define FN 1.75 //2fn/f-n
#define XAXIS 0
#define YAXIS 1
#define ZAXIS 2
#define NXAXIS 3
#define NYAXIS 4
#define NZAXIS 5
#define CLP 0.75
#define CLD 0.25

#define VGA_ADDR 0x300000
#define VGA_END 0x34B000
#define HEAP_ADDR 0x00003110
#define HEAP_END 0x00004110

const float pd_W = PD_W;
const float pd_H = PD_H;

const float min_step = MIN_STEP;
const float pixel_w = PIXEL_W;
const float pixel_h = PIXEL_H;
const float view_w = VIEW_W;
const float view_maxx = VIEW_MAXX;
const float view_minx = VIEW_MINX;
const float view_h = VIEW_H;
const float view_maxy = VIEW_MAXY;
const float view_miny = VIEW_MINY;

const float cota = COTA;
const float nearp = NEARP;
const float farp = FARP;
const float fpn = FPN;
const float fn = FN;

const float clp = CLP;
const float cld = CLD;

const float lx = 0;
const float ly = 0;
const float lz = 1.5;
const float I0 = 15;
const float Id = 1.0;


char* pointer = (char*) HEAP_ADDR;
char* pointerFB = (char*) VGA_ADDR;

#include "sin.h"

typedef enum{false, true} bool;

typedef float vec2[2];

typedef float vec3[3];

typedef float vec4[4];

typedef bool bvec2[2];

typedef bool bvec3[3];

typedef bool bvec4[4];

typedef int ivec2[2];

typedef int ivec3[3];

typedef int ivec4[4];

typedef unsigned int RGB;

typedef vec2 mat2[2];

typedef vec3 mat3[3];

typedef vec4 mat4[4];


typedef struct {
  
  vec4 vx[PG_MAXV];
  RGB cs[PG_MAXV];
  int vernum;

}pygon;

typedef struct {
  
  int primNum;
  char *primAddr[8];
  int primType[8];

}drawList;

mat4 pmat;

RGB **frameBuffer;
RGB **zBuffer;

void initDrawList(drawList *dl);
void initFrameBuffer();
void initZBuffer();
void clearFrameBuffer();
void clearZBuffer();
void addDrawList(char* addr, int type, drawList *dl);
void transformPrim(int type, char * addr_i, char * addr_f, mat4 tmat);
void transformDrawlist(drawList *dl, drawList *ddl, mat4 t);
void renderColorDrawlist(drawList *dl);
void draw3DColorSegment(float ax, float ay, float az, float bx, float by, float bz, RGB ca, RGB cb);
int resizeViewportWidth(float a);
int resizeViewportHeight(float b);
void draw2DTriangle(float ax, float ay, float bx, float by, float cx, float cy, RGB ca, RGB cb, RGB cc);
void drawTriangle(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, RGB ca, RGB cb, RGB cc);
void normDrawlist(drawList *dl);
void normPrim(int type, char * addr);
void draw3DVertexInt(int x, int y, float z, int r, int g, int b);
void draw3DVertex(float x, float y, float z, int r, int g, int b);
void copyPrim(int type, char * addr, drawList *ddl);
void drawTriangleYPar(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, RGB ca, RGB cb, RGB cc);

/*** constructors ***/
void vec2_init(float a, float b, vec2 v2);
void vec3_init(float a, float b, float c, vec3 v3);
void initVec4Norm(float a, float b, float c, vec4 v4);
void initTMat(mat4 t);
void clearRGB(RGB *value);

void setRGB(RGB *value,  int red, int green, int blue);

void getRGB(RGB value,  int *red, int *green, int *blue);
void getRGBc(RGB value, unsigned char *red, unsigned char *green, unsigned char *blue);
int getDepth(RGB value);
void initVec4Norm(float a, float b, float c, vec4 v4);

void multiplyVec3Mat4(vec3 v3, mat4 m4);
void multiplyVec4Mat4(vec4 v4, mat4 m4);
void pushPerspProj(mat4 t);
void normVec4(vec4 v4);
void rotateMat(mat4 t, float Th, int axis);
float sin_cos (float deg, short sc);
void intersectRP(vec4 is, float ax, float ay, float az, float bx, float by, float bz, RGB *ci, RGB ca, RGB cb, float ix);
void transfRendDrawlist(drawList *dl, mat4 t);
void transfRendColorPrim(int type, char * addr, mat4 tmat);
void shadePrim(int type, char *addr);
RGB shadeVertex(float ax, float ay, float az, RGB c);
void renderColorPrim(int type, char * addr);
void copyPolygon(pygon *py, pygon pf);
void clipPolygon(char *addr);
void clipPolygonOneEdge(char *addr, int normdir, float limit);
void intersectRP(vec4 is, float ax, float ay, float az, float bx, float by, float bz, RGB *ci, RGB ca, RGB cb, float ix);
void addVx3C2Polygon(pygon *pg, float ax, float ay, float az, RGB cl);
void addVx2Polygon(pygon *pg, vec4 vx, RGB cl);
