
/*Made by Jarno Saarinen for Institute of Digital and Computer Systems*/
/*Coffee Linker for COFFEE RISC Processor*/
/*Version 1.6*/
/*This is the first version which does not need a script file to operate*/
/*does not check if the magic number is correct*/
/*produces COFF if the user wants it to*/

#include <stdlib.h>
#include <stdio.h>

/*STRUCTURES, DATA TYPES*/
/*this structure is to be written into the end of the output file to 
  show which addressess, in a section's raw data, refer to different 
  memories*/
struct Relocation {
  char SectionName_[20];           /*section's name*/
  unsigned long Offset_;           /*offset to section's raw data*/
  unsigned short BitPosition_;     /*address's starting position in byte,0-7*/
  unsigned short AddrLength_;      /*the length of the address*/
  char MemoryName_[20];
};

struct MemoryInfo {           /*a structure that contain information*/
  char MemoryName_[20];       /*about a memory block*/
  unsigned long int StartAddress_;
  unsigned long int EndAddress_;
  char MemoryType_[20];	
};

struct FilesAndPointers {   /*a structure that contains all the object file*/
  FILE* FilePtr_;           /*names and their file pointers*/
  char* File_;	
};

/*file header structure*/
struct filehdr {
  unsigned short f_magic;     /*magic number, should be 0xc0ff*/
  unsigned short f_nscns;     /*number of sections*/
  unsigned long f_timdat;     /*time and date stamp, in UNIX format*/
  unsigned long f_symptr;     /*file pointer to symbol table*/
  unsigned long f_nsyms;      /*number of symtab entries, lines*/
  unsigned short f_opthdr;    /*sizeof(optional header), in crasm always 0*/
  unsigned short f_flags;     /*flags*/
};

/*section header structure*/
struct scnhdr {
  char s_name[8];                 /*section name*/
  unsigned long s_paddr;          /*physical address*/
  unsigned long s_vaddr;          /*virtual address*/
  unsigned long s_size;           /*section size*/
  unsigned long s_scnptr;         /*file ptr to raw data for section*/
  unsigned long s_relptr;         /*file ptr to relocation*/
  unsigned long s_lnnoptr;        /*file ptr to line numbers*/
  unsigned short s_nreloc;        /*number of relocation entries*/
  unsigned short s_nlnno;         /*number of line number entries*/	
  unsigned long s_flags;          /*type and content flags*/
};

/*relocation entries, structure*/
struct reloc {
  unsigned long r_vaddr;       /*address of relocation*/
  unsigned long r_symndx;      /*symbol we're adjusting for*/
  unsigned short r_type;       /*type of relocation*/	
};

/*symbol table entries*/
struct syment {
  char e_name[8];               /*symbol name*/
  unsigned long e_value;        /*value of the symbol*/
  short e_scnum;                /*section number*/
  unsigned short e_type;        /*symbol type*/
  unsigned char e_sclass;       /*storage class*/
  unsigned char e_numaux;       /*number of auxiliary entries*/
};

struct SecInfo {
  short int MemTblIndex_;
  char FileName_[30];    /*file name*/
  char SecName_[30];     /*section name*/
  long int RunTimeAddr_;	   /*section's run time address*/
};

struct StringTable {
  unsigned long int StrTblLength_;
  char StrTbl_[300];
};

/*CONSTANTS*/
#define MAX_MEMORIES 10
#define MAX_FILES 20
#define FILHDR struct filehdr    
#define FILHSZ 20              /*size of the header in bytes*/
#define SCNHDR struct scnhdr
#define SCNHSZ 40
#define RELOC struct reloc
#define RELSZ 10         /*relocation entry size in bytes*/
#define SYMENT struct syment


/*GLOBALS*/
struct SecInfo Sections[100];  /*structures from script file*/
int SectionIndex;   /*index to the section table*/
struct MemoryInfo Memories[MAX_MEMORIES];   /*memories of the system*/
int MemoryAmount;          /*amount of memories*/
int MemoryIndex;          /*index to memorytable*/
/*table for object files and their pointers*/
struct FilesAndPointers FilePtrTbl[MAX_FILES]; 
FILE* ScrFilePointer;         /*pointer to the script file*/
FILE* TargetFilePtr;         /*pointer to the output file*/
FILE* RelFilePtr;            /*temporary place for relocation entries*/ 
unsigned long int TheAddress;    /*memory address*/
char Temp[201];         /*temporary place for a string*/
int ObjFileCount;    /*the amount of object files*/
char ScriptFile[20];
short int CoffeeDebug;       /*-d command line switch*/
short int ThereIsNoScrFile;   /*1 if script file is absent*/
short int ProduceCOFF;       /*1 if user wants COFF*/
struct StringTable TempStringTable; /*temp string table storage*/

/*PROCEDURES*/
int C_CheckFiles(int ParAmount, char* Parameters[]);
int C_ScriptFile(char* FileTable[], int Count);
int C_LegalMemoryName(char* Memory);
int C_OpenFiles(char* ComPar[], int Amount);
int C_DoRelocationAndWrite(char* File, char* Section, char* Memory);
int C_CmpStr(char string1[], char string2[]);
int C_Exponent(int number, int exp);
int C_CharToInt(char number);
int C_StringToInt(char* string);
int C_LineCharToInt(char addr);
unsigned int C_LineStringToInt(char address[]);
int C_WriteRelocation(struct Relocation RelInfo);
long C_FindSectionAddress(char SectionName[], char* MemName, char FileName[]);
void C_CopyString(char string1[], char string2[]);
void C_CloseAllFileCons();
void C_WriteRawData(char* data, long value, unsigned long offset,
		    unsigned short position, unsigned short length);
void C_GetStringName(char* file, char* name, int StrTblOffset);
int C_ReadScriptFile();
long int C_FindSymRunTimeAdd(SYMENT Symbol, char* File, char* Section, 
			     char* Memory);
void C_PrintByte(char* data, long offset, int mode);
void C_PrintSections();
int C_SaveScriptFile();
unsigned short int FindColonAmount(char String[]);
struct SecInfo ExtractScriptLine(char String[], 
				 unsigned short int ColonNumber);
long int C_FindSectionSize(char File[], char Section[]);
int C_CheckMemories();
void C_FillMemoriesTable();
int C_FillSectionsTable();
int C_CheckSections();
int C_WriteFileHeader();
int C_WriteSectionHeaders();
int C_FindStringLength(char String[]);
void C_SaveStrTblOffset(int offset, char SecName[]);

int main(int argc, char* argv[]) {
	
  int ArgvIndex = 0;          /*index to argv table*/
  int SecIndex = 0;           /*some indexes*/
  int OutputIndex = 0;
   
  TheAddress = 0; /*just in case*/
  ObjFileCount = 0;
  SectionIndex = 0;
  ThereIsNoScrFile = 0; /*global*/
  ProduceCOFF = 0;
  TempStringTable.StrTblLength_ = 4;

  /*checking the object file names*/
  OutputIndex = C_CheckFiles(argc, argv);
  if(OutputIndex == -1) {    
    exit(EXIT_FAILURE);
  }

  /*the index of the script file is placed into the ArgvIndex-variable*/
  ArgvIndex = C_ScriptFile(argv, argc);
  
  if(ArgvIndex > 0) {
    C_CopyString(ScriptFile, argv[ArgvIndex]);
    /*opening the script file for reading*/
    if((ScrFilePointer = fopen(argv[ArgvIndex], "r")) == NULL) {
      printf("Error: Error opening file %s.\n", argv[ArgvIndex]);
      exit(EXIT_FAILURE); 	
    }
  } else { /*ArgvIndex == 0*/
    ThereIsNoScrFile = 1; /*global*/
  }
  
  /*opening all the file connections, except the .scr file,*/ 
  /*the number of object files is places into*/
  /*the ObjFileCount-variable*/
  if((ObjFileCount = C_OpenFiles(argv, argc)) == 0) {
    C_CloseAllFileCons();    
    exit(EXIT_FAILURE);
  }
  
  /*opening the target file connection, binary*/
  if((TargetFilePtr = fopen(argv[OutputIndex], "wb")) == NULL) {
    printf("Error: Unable to open target file connection.\n");
    C_CloseAllFileCons();    
    exit(EXIT_FAILURE);	
  }
  
  if(ThereIsNoScrFile) {
    /*filling the memories-table*/
    C_FillMemoriesTable();

    /*filling the sections-table*/
    if(C_FillSectionsTable()) {
      printf("Unable to perform relocation. Check the file names in the ");
      printf("command line.\n");
      exit(EXIT_FAILURE);
    }
    
  } else { /*there is a script file*/
    /*reading from the beginning of the script file and saving the 
      memory info*/
    /*into the Memories table*/
    if(C_ReadScriptFile()) {
      printf("Error: Error in reading the script file.\n");
      exit(EXIT_FAILURE); 
    }
    
    if(C_CheckMemories()) {
      printf("You might want to alter the memory definitions.\n");
    }
    
    /*saving the sections and their run time addresses into the 
      Sections-table*/
    if(C_SaveScriptFile()) {
      printf("Error: Error in saving the script file.\n");
      exit(EXIT_FAILURE);
    }
  }

  if(ProduceCOFF == 1) {
    /*connection to the target file is open, TargetFilePtr*/
    /*writing the COFF file header to the target file*/
    if(C_WriteFileHeader()) {
      C_CloseAllFileCons();
      exit(EXIT_FAILURE);
    }

    /*writing the section headers to the target file*/
    if(C_WriteSectionHeaders()) {
      C_CloseAllFileCons();
      exit(EXIT_FAILURE);
    }
  }
  
  if(CoffeeDebug) {
    C_PrintSections();
  }

  SecIndex = 0;
  while(SecIndex < SectionIndex) {
    printf("Section '%s' in file '%s' is relocated to address '%ld'.\n",
	   Sections[SecIndex].SecName_, Sections[SecIndex].FileName_,
	   Sections[SecIndex].RunTimeAddr_);
    SecIndex = SecIndex + 1;
  }

  /*starting to go through the sections-table relocating sections*/
  SecIndex = 0;
  while(SecIndex < SectionIndex) {
    /*saving the address*/
    TheAddress = Sections[SecIndex].RunTimeAddr_;
    
    /*relocating*/
    if(C_DoRelocationAndWrite(Sections[SecIndex].FileName_, 
			      Sections[SecIndex].SecName_, 
			      Memories[Sections[SecIndex].MemTblIndex_].
			      MemoryName_)) {
      
      printf("Error: Unable to do relocation for section %s in file %s.\n",
	     Sections[SecIndex].SecName_, Sections[SecIndex].FileName_);
      exit(EXIT_FAILURE);
      
    }
    
    SecIndex = SecIndex + 1;
  }

  /*if the target file is in COFF format it is necessary to produce 
    the string table to the end of the file, TargetFilePtr should be
    in the right place (in the end of the file)*/
  if(ProduceCOFF == 1) {
    /*of course there has to be a string table..*/
    if(TempStringTable.StrTblLength_ > 4) {

      /*writing the length of the string table*/
      if((fwrite(&(TempStringTable.StrTblLength_), 4, 1, 
		 TargetFilePtr)) != 1) {
	printf("Error: Unable to write the string table to the targetfile.");
	printf("\n");
	return 1;
      }

      /*writing the actual string table*/
      if((fwrite(TempStringTable.StrTbl_, (TempStringTable.StrTblLength_)-4,
		 1, TargetFilePtr)) != 1) {
        printf("Error: Unable to write the string table to the targetfile.");
        printf("\n");
	return 1;
      }

    }

  }
  
  /*copying the relocation information to the end of the output file*/
  /*rewind(RelFilePtr);
    fread(&TmpRelVar, 1, 1, RelFilePtr);  
    while(TmpRelVar != EOF) {
    fwrite(&TmpRelVar, 1, 1, TargetFilePtr);
    fread(&TmpRelVar, 1, 1, RelFilePtr); 
    }*/
  
  /*fwrite(&TmpRelVar, 1, 1, TargetFilePtr);*/  /*writing the EOF*/
  
  /*closing the file connections*/  
  C_CloseAllFileCons();
  printf("Done...\n");
  exit(EXIT_SUCCESS);
  
}  /*main*/

/*a function that checks the command line parameters for errors*/
/*returns 0 if there are no errors*/
int C_CheckFiles(int ParAmount, char* Parameters[]) {
  int index = 1;
  int i = 0;
  int ScrCount = 0;
  int ObjCount = 0;
  int TargetIndex = 0;
  
  CoffeeDebug = 0;   /*Global variable*/
  
  if (ParAmount == 1) {      /*if there are no parameters*/      
    printf("Error: No command line parameters.\n");
    return -1;
  }
  
  if (ParAmount > (MAX_FILES + 4)) {            
    printf("Error: To many command line parameters.\n");
    return -1;
  }
  
  /*loop that checks all the files*/
  while(index < ParAmount) {
    if(Parameters[index][0] == '-' && Parameters[index][1] == 'o' && 
       Parameters[index][2] == '\0') {
      TargetIndex = index + 1;
      index = index + 2;
      continue;
    }
    
    /*if debug info is wanted*/
    if(Parameters[index][0] == '-' && Parameters[index][1] == 'd' &&
       Parameters[index][2] == '\0') {
      CoffeeDebug = 1;
      index = index + 1;
      continue; 
    }
    
    /*if COFF must be produced*/
    if(Parameters[index][0] == '-' && Parameters[index][1] == 'c' && 
       Parameters[index][2] == 'o' && Parameters[index][3] == 'f' &&
       Parameters[index][4] == 'f') {
      ProduceCOFF = 1 /*global*/;
      index = index + 1;
      continue;
    }
    
    /*loop that looks for the dot in the file given as a parameter*/
    while(Parameters[index][i] != '.') {  
      if(Parameters[index][i] == '\0') {
	printf("Error: Faulty object file name, '%s'.\n", Parameters[index]);
	return -1; 
      }
      
      i = i + 1;
      
    }
    
    if(i == 0) {     /*if the file name length is zero chars*/ 
      printf("Error: File name must be at least one char long.\n");
      return -1;
    } 
    
    /*if the file has as .obj ending*/
    if(Parameters[index][i+1] == 'o' && Parameters[index][i+2] == 'u' && 
       Parameters[index][i+3] == 't' && Parameters[index][i+4] == '\0') {
      ObjCount = ObjCount + 1;
      index = index + 1;
      i = 0;
      
      /*if the file has an .scr ending*/
    } else if(Parameters[index][i+1] == 's' && Parameters[index][i+2] == 'c' 
	      && Parameters[index][i+3] == 'r' && 
	      Parameters[index][i+4] == '\0'){
      ScrCount = ScrCount + 1;
      
      if(ScrCount == 2) {
	printf("Error: Too many .scr files. Only one is allowed.\n");
	return -1;
      }
      
      index = index + 1;
      i = 0;
      
      /*file has an faulty ending*/  
    } else {
      printf("Error: Faulty command line parameter ending in file '%s'.\n",
	     Parameters[index]);
      printf("File ending must be either .scr or .out.\n");
      return -1;    
    }
    
  }
  
  if(TargetIndex == 0) {
    printf("Error: No Output file name specified.\n");
    return -1;	  
  } 
  
  if(ObjCount == 0) {   /*if there are no object files*/
    printf("Error: No object files.\n");
    return -1;
  }
  
  return TargetIndex;
  
}   /*End of C_CheckFiles*/

/*a fuction that finds out which of the command line parameters is the*/
/*script file and returns an index to the argv-table*/
int C_ScriptFile(char* FileTable[], int Count) {
  int index = 1;
  int i = 0;
  
  while (index < Count) {
    
    if(FileTable[index][0] == '-') {
      index = index + 1; 	 
      continue;
    }
    
    while (FileTable[index][i] != '.') {
      i++;	
    }		
    
    if(FileTable[index][i+1] == 's') {
      return index;
    } else {
      index++;
      i = 0;
    }
    
  }
  
  return 0;  /*if there were no script file*/
  
}   /*end of C_ScriptFile*/

/*a fuction that finds out if the memory name given as a parameter is legal*/
/*returns an index to the memories table if the name is legal and -1 if not*/
int C_LegalMemoryName(char* Memory) {
  int index = 0;
  
  while(index < MemoryAmount) {
    if(!C_CmpStr(Memories[index].MemoryName_, Memory)) {
      return index;
    } else {
      index = index + 1;
    }
    
  }	
  
  return -1;
}

/*a function that opens a file connection to every object file*/
/*it saves the file pointers into a global table*/
/*returns zero if something goes wrong and the amount of file connections*/ 
/*opened if everything goes as planned*/
int C_OpenFiles(char* ComPar[], int Amount) {
  int index = 1, i = 0, index1 = 0;
  int FileConnections = 0;
  
  while(index < Amount) {

    if(ComPar[index][0] == '-' && ComPar[index][1] == 'o') {
      index = index + 2;
      continue;
    }
    /*COFF command line switch*/
    if(ComPar[index][0] == '-' && ComPar[index][1] == 'c' &&
    	ComPar[index][2] == 'o' && ComPar[index][3] == 'f' &&
    	ComPar[index][4] == 'f' && ComPar[index][5] == '\0') {
	    index = index + 1;
	    continue;
    }
    /*debug command line switch*/
    if(ComPar[index][0] == '-' && ComPar[index][1] == 'd' &&
    	ComPar[index][2] == '\0') {
	    index = index + 1;
	    continue; 
    }

    while(ComPar[index][i] != '\0') {
      if(ComPar[index][i] == '.') {
	if(ComPar[index][i+1] == 'o' && ComPar[index][i+2] == 'u'
	   && ComPar[index][i+3] == 't') {
	  FilePtrTbl[index1].FilePtr_ = fopen(ComPar[index], "rb");
	  FileConnections = FileConnections + 1;
	  
	  if(FilePtrTbl[index1].FilePtr_ == NULL) {
	    printf("Error: Unable to open file connection (%s).\n", 
	    				FilePtrTbl[index1].File_);
	    return 0;
	  }
	  
	  FilePtrTbl[index1].File_ = ComPar[index];
	  index1 = index1 + 1;
	  break;
	  
	} else {
	  break;
	}
      } else {
	i = i + 1;
      }
    }	
    
    index = index + 1;
    i = 0;
  }
  
  return FileConnections;	
  
}

/*returns zero if the names are the same*/
int C_CmpStr(char string1[], char string2[]) {
  int index = 0;

  while(string1[index] == string2[index]) {
    if((string1[index] == '\0' && string2[index] == '\0') || 
       (string1[index] == '\n' && string2[index] == '\n')) {
      return 0;
    } else {
      index = index + 1;
    }
  }

  if((string1[index] == '\n' && string2[index] == '\0') || 
     (string1[index] == '\0' && string2[index] == '\n')) {
    return 0;
  } else {
    return 1;
  }
}

/*a function that performs the relocation operation to a section 
  in a certain*/
/*file, then it writes the section into the target file*/
/*if the relocation is successful the function returns 0*/
/*function assumes that the TheAddress variable contains the right value*/
/*the function updates the TheAddress variable*/
int C_DoRelocationAndWrite(char* File, char* Section, char* Memory) {
  /*a few loop indexes*/
  int index = 0;
  unsigned short int index1 = 0, index2 = 0, index3 = 0, index4 = 0;
  int index5 = 0, index6 = 0;
  unsigned short int index7 = 0;
  unsigned short int indecs3 = 0;
  int IsFile = 0;
  
  FILE* TempFilePtr;
  SCNHDR SectionHeader;
  SCNHDR TmpSectionHdr;
  int SectionFound = 0, StringTablePtr = 0, ScnFound = 0;
  FILHDR FileHeader, TempFileHdr;
  char* raw_data;
  RELOC RelInfo;
  SYMENT SymEnt;
  SYMENT TempSym;
  long TempAddr = 0;
  unsigned short ShiftLength = 0;
  unsigned short Length = 0;
  unsigned short Position = 0;
  unsigned long TempSymValue = 0, TempVaddr = 0;
  int StrTblPtr = 0, StrTblPtr1 = 0, TempVariable = 0;
  char TempStr[201]; 
  char SecName[10]; 
  char SymName[50]; 
  char SymbolName[50]; 
  char ScnName[10];  
  int GlobalSymFound = 0;   
  /*struct Relocation RelocationInfo[100];*/
  /*int RelTblIndex = 0;*/
  unsigned short RelocationMode;
  unsigned int Subtractor;
  long int RunTimeAddress = 0, JumpOffset = 0;
  long int SymbolRunTimeAddr = 0;
  int TempIntLocation = 0;
  
   /*finding out the right file pointer*/
  while(index < ObjFileCount) {
    if(!C_CmpStr(FilePtrTbl[index].File_, File)) {
      IsFile = 1;
      break;	
    } else {
      index = index + 1;	
    }
  }
  
  if(!IsFile) {
    printf("Error: Filename '%s' is not an object file.\n", File);
    return 1;
  }

  /*opening temporary file connection to the object file at hand*/
  if((TempFilePtr = fopen(FilePtrTbl[index].File_, "rb")) == NULL) {
    printf("Error: Error while opening file connection to file %s.\n",
	   FilePtrTbl[index].File_);
    return 1;
  }
  
  rewind(FilePtrTbl[index].FilePtr_);  /*again to be on the safe side*/
  /*reading the file header, the variable index is in right place*/
  if(fread(&FileHeader, 20, 1, FilePtrTbl[index].FilePtr_) != 1) {
    printf("Error: Reading the file header in file '%s' failed.\n", File);
    return 1;	
  }
  
  /*if(FileHeader.f_magic != 49407) {
    printf("Error: The magic number is faulty in file %s.\n", 
	   FilePtrTbl[index].File_);
    return 1;	
    }*/
  
  if(FileHeader.f_opthdr != 0) {
    printf("Error: Size of the optional header should be zero (File: %s).\n", 
    				FilePtrTbl[index].File_);
    return 1;
  }
  
    
  /*a loop that goes through sections and finds the right one*/
  index1 = 0;
  while(index1 < FileHeader.f_nscns) {
    /*reading the section header*/
    fread(&SectionHeader, 40, 1, FilePtrTbl[index].FilePtr_);
    
    if(SectionHeader.s_name[0] == 0x5c) {    

      index3 = 0;
      while (index3 < 7) {
	SecName[index3] = SectionHeader.s_name[index3+1];
	index3 = index3 + 1;	
      }
      
      SecName[index3] = '\0';
      
      StrTblPtr = C_StringToInt(SecName);       /*turning into an integer*/
      C_GetStringName(FilePtrTbl[index].File_, SecName, StrTblPtr);
      /*comparing it to the section name to be relocated*/
      if(!C_CmpStr(SecName, Section)) {
	SectionFound = 1;
	break;
      } else {
	
	index1 = index1 + 1;
	/*putting the file pointer back to it's place*/
	/*fseek(FilePtrTbl[index].FilePtr_, 20+(index1*40), 0);*/
	
      }
      
    } else {
      
      C_CopyString(SecName, SectionHeader.s_name);
      
      if(!C_CmpStr(SecName, Section)) {
	SectionFound = 1;
	break;
      } else {
	index1 = index1 + 1;
      }
      
    }    
  }   /*while(index1 < FileHeader.f_nscns)*/
  
  if(!SectionFound) {  /*if the right section wasn't found..*/
    printf("Error: Unable to find section %s in file %s.\n", Section, File);
    return 1;	
  }
  

  /*SectionHeader variable contains the information of the section to be*/
  /*relocated*/		
  raw_data = (char*)malloc(SectionHeader.s_size);     /*allocating memory*/
  
  if(raw_data == NULL) {      /*if memory allocation failed*/
    printf("Error: Unable to allocate memory while relocating section %s", 
	   Section);
    printf(" in file %s.\n", File);
    return 1;	
  }
  
  fseek(FilePtrTbl[index].FilePtr_, SectionHeader.s_scnptr, 0);
  /*reading the section raw data to raw_data*/
  fread(raw_data, SectionHeader.s_size, 1, FilePtrTbl[index].FilePtr_);
  
  if(FileHeader.f_flags == 1) {   /*relocation info stripped from file*/
    
  } else if(FileHeader.f_flags == 4 || FileHeader.f_flags == 8) { 
    /*line numbers stripped from file, local symbols stripped from file*/
    
    
    /*finding the relocation info*/
    fseek(FilePtrTbl[index].FilePtr_, SectionHeader.s_relptr, 0);  
    index2 = 0;
    
    if(CoffeeDebug) {
      printf("Starting to relocate section %s.\n", Section);
    }
    
    /*loop goes through the section's relocation information*/
    while(index2 < SectionHeader.s_nreloc) {                       
      /*reading the first relocation entry into a variable*/
      fread(&RelInfo, 10, 1, FilePtrTbl[index].FilePtr_);

      /*printf("%d. Relocation.\n", index2 + 1);*/
      
      /*finding out what to do with the symbol's value*/
      ShiftLength = RelInfo.r_type & 248; /*the length of the shift to right*/
      ShiftLength = ShiftLength >> 3;

      /*printf("shift length: %d\n", ShiftLength);*/

      Length = RelInfo.r_type >> 8;         /*length of the immediate*/
      Length = Length & 31;

      /*printf("length of the value: %d\n", Length);*/

      Position = RelInfo.r_type >> 13;    /*byte position of the immediate*/
      Position = Position & 7;

      /*printf("bit position: %d\n", Position);*/

      /*Relocation mode is 0, 6 or 5: simple relocation, 32-bit PC-relative 
	relocation or 16-bit PC-relative relocation respectively*/
      RelocationMode = RelInfo.r_type & 7; /*extracting the relocation mode*/
      
      /*printf("relocation mode: %d\n", RelocationMode);*/

      /*finding the right symbol table entry*/
      fseek(FilePtrTbl[index].FilePtr_, FileHeader.f_symptr ,0);
      fseek(FilePtrTbl[index].FilePtr_, (RelInfo.r_symndx)*18,1);
      
      fread(&SymEnt, 18, 1, FilePtrTbl[index].FilePtr_);   
      /*reading the element*/
      
      /*if 32-bit or 16-bit PC-relative jump*/
      if(RelocationMode == 6 || RelocationMode == 5) {
	
	if(RelocationMode == 6) { /*32-bit*/
	  Subtractor = 4;
	  if(CoffeeDebug) {
	    printf("32-bit PC-relative relocation.\n");
	    printf("Command before relocation: ");
	    C_PrintByte(raw_data, RelInfo.r_vaddr, 0);
	  }
	} else {  /*16-bit*/
	  Subtractor = 2;
	  if(CoffeeDebug) {
	    printf("16-bit PC-relative relocation.\n");
	    printf("Command before relocation: ");
	    C_PrintByte(raw_data, RelInfo.r_vaddr, 1);
	  }
	}
	
	/*finding the address of the next command*/
	TempVaddr = RelInfo.r_vaddr;
	TempVaddr = TempVaddr + 1;
	while((TempVaddr % Subtractor) != 0) {
	  TempVaddr = TempVaddr + 1; 
	}
	
	/*TempVaddr is now the offset of the next command*/
	/*finding the running time address*/
	RunTimeAddress = C_FindSectionAddress(Section, Memory, File);
	
	if(RunTimeAddress == -1) {
	  printf("Error: Couldn't find running time address for ");
	  printf("section %s.\n", Section);
	  return 1;
	}
	
	if(CoffeeDebug) {
	  printf("According to script file, the run time address of");
	  printf(" the section %s is", Section);
	  printf(" %ld\n", RunTimeAddress);
	}
	
	TempVaddr = TempVaddr + RunTimeAddress;
	/*TempVaddr contains the running time address of the command 
	  after the jump command, the address of the first byte*/
	
	if(CoffeeDebug) {
	  printf("The run time address of the command after the jump");
	  printf(" is %ld.\n", TempVaddr);	
	  printf("Finding the run time address of the symbol value..\n");
	}
	
	/*finding the running time address of the symbol value*/
	SymbolRunTimeAddr = C_FindSymRunTimeAdd(SymEnt, File, Section, 
						Memory);
	/*SymbolRunTimeAddr contains now the target's running time address*/
	
	if(SymbolRunTimeAddr == -1) {
	  return 1;	
	}
	
	if(CoffeeDebug) {
	  printf("Symbol's run time address is %ld\n", SymbolRunTimeAddr);
	  printf("Calculating the jump offset and checking if it fits");
	  printf(" into 22 bits\n");	
	}
	
	JumpOffset = SymbolRunTimeAddr - TempVaddr;
	if(JumpOffset < -2097152 || JumpOffset > 2097151) {
	  printf("Error: Offset out of range in PC-relative jump.\n");
	  return 1;
	}
	
	if(CoffeeDebug) {
	  printf("Jump offset is %ld\n", JumpOffset);
	  printf("Next the jump offset is shifted and written into the");
	  printf(" raw data.\n");	
	}
	
	JumpOffset = JumpOffset >> ShiftLength;
	if(CoffeeDebug) {
	  printf("The value the linker writes to the data is %ld\n",
		 JumpOffset);
	}
	/*writing the relocation information into the raw_data*/
	C_WriteRawData(raw_data, JumpOffset, RelInfo.r_vaddr, Position, 
		       Length);
	
	if(CoffeeDebug) {
	  printf("Command after relocation: ");
	  
	  if(RelocationMode == 6) {    /*32*/
	    C_PrintByte(raw_data, RelInfo.r_vaddr, 0);
	  } else {     /*16-bit*/
	    C_PrintByte(raw_data, RelInfo.r_vaddr, 1);
	  }
	}
	
      } else if(RelocationMode == 0) {   /*normal relocation*/
      	TempSymValue = SymEnt.e_value;
	
	/*label or a regular symbol entry with e_scnum > 0*/
	if(SymEnt.e_sclass == 6  || (SymEnt.e_sclass == 2 && 
				     SymEnt.e_scnum > 0)) {
	  
	  if(CoffeeDebug) {
	    printf("Normal relocation\n");
	    printf("Command before relocation: ");
	    if((SectionHeader.s_flags >> 24) == 1) {  /*16-bit section*/
	      C_PrintByte(raw_data, RelInfo.r_vaddr, 1);
	    } else {
	      C_PrintByte(raw_data, RelInfo.r_vaddr, 0);  /*32-bit section*/
	    }
	  }
	  
	  
	  /*checking if the section number is faulty*/
	  if(SymEnt.e_scnum <= 0) {
	    printf("Error: If symbol's class is 6 (=label), "); 
	    printf("section number must >0.\n");
	    return 1;
	  }    
	  
	  /*finding the right section*/ 
	  fseek(TempFilePtr, 20, 0);
	  fseek(TempFilePtr, (SymEnt.e_scnum-1)*40, 1);
	  /*reading the section info into a variable*/
	  fread(&TmpSectionHdr, 40, 1, TempFilePtr);
	  
	  if(TmpSectionHdr.s_name[0] == 0x5c) {    /*to the string table*/
	    index7 = 0;
	    while (index7 < 7) {
	      ScnName[index7] = TmpSectionHdr.s_name[index7+1];
	      index7 = index7 + 1;	
	    }
	    
	    ScnName[index7] = '\0';
	    StringTablePtr = C_StringToInt(ScnName);/*turning into an int*/
	    /*finding the string table*/
	    fseek(TempFilePtr, 
		  FileHeader.f_symptr + FileHeader.f_nsyms*18, 0);
	    fseek(TempFilePtr, StringTablePtr, 1);
	    /*a loop that saves the section name into the ScnName variable*/
	    index7 = 0;
	    fread(&ScnName[index7], 1, 1, TempFilePtr);
	    while(ScnName[index7] != '\0') {  /*0x00 vai \0 ??*/
	      index7 = index7 + 1;
	      fread(&ScnName[index7], 1, 1, TempFilePtr);
	    }
	    
	  } else {    /*nimi on alle 8 merkki*/
	    
	    index7 = 0;
	    ScnName[index7] = TmpSectionHdr.s_name[index7];
	    while(index7 <= 7 && ScnName[index7] != 0) {
	      index7 = index7 + 1;
	      ScnName[index7] = TmpSectionHdr.s_name[index7];
	    } 
	    
	    ScnName[index7] = '\0';
	    
	  }
	  
	  /*ScnName contains the section name*/
	  /*going through the script file and finding out the start 
	    address*/
	  /*of the section in question*/
	  TempAddr = C_FindSectionAddress(ScnName, TempStr, 
					  FilePtrTbl[index].File_);
	  if(TempAddr == -1) {
	    printf("Error: Unable to find run time address for section %s\n",
		   ScnName);
	    return 1;
	  }
	  
	  if(CoffeeDebug) {
	    printf("Symbol has been defined in a section which has run");
	    printf(" time address");
	    printf(" %ld\n", TempAddr); 
	  }
	  
	  /*TempAddr contains now the section's running time address*/
	  /*section is the one where the global symbol has been defined*/
	  /*TempStr contains the memory name*/
	  
	  /*if the section isn't mapped into the same memory we have to*/
	  /*produce some relocation information*/
	  /*if(C_CmpStr(Memory, TempStr)) {
	    RelocationInfo[RelTblIndex].Offset_ = RelInfo.r_vaddr;
	    RelocationInfo[RelTblIndex].BitPosition_ = Position;
	    RelocationInfo[RelTblIndex].AddrLength_ = Length;
	    C_CopyString(RelocationInfo[RelTblIndex].SectionName_, SecName);
	    C_CopyString(RelocationInfo[RelTblIndex].MemoryName_, TempStr);
	    RelTblIndex = RelTblIndex + 1;
	    if(RelTblIndex == 100) {
	    printf("Error: Too much relocation.\n");
	    return 1;
	    }
	    
	    }*/
	  
	  TempSymValue = TempSymValue + TempAddr;
	  
	  	  
	  TempSymValue = TempSymValue >> ShiftLength;
	  
 	  if(CoffeeDebug) {
	    printf("Writing the value to the raw data.");
	    printf(" Value is %ld.\n", TempSymValue); 
	  }

	  
	  /*writing the relocation information into the raw_data*/
	  C_WriteRawData(raw_data, TempSymValue, RelInfo.r_vaddr, Position, 
			 Length);
	  
	  if(CoffeeDebug) {
	    printf("Command after relocation: ");
	    if((SectionHeader.s_flags >> 24) == 1) {  /*16-bit section*/
	      C_PrintByte(raw_data, RelInfo.r_vaddr, 1);
	    } else {
	      C_PrintByte(raw_data, RelInfo.r_vaddr, 0);  /*32-bit section*/
	    }
	  }
	  
	  
	} else if(SymEnt.e_sclass == 2) {	/*external (public) symbol*/
	  
	  
	  if(SymEnt.e_scnum == 0) {   /*global symbol*/
	    
	    if(ObjFileCount == 1) {
	      printf("Error: Found an external symbol but there is only ");
	      printf("one input object file.\n");
	      printf("Impossible to determine the value.\n");
	      return 1;
	    }
	    
	    /*let's find out where it is*/
	    ScnFound = 0;
	    
	    if(CoffeeDebug) {
	      printf("Symbol is global. Trying to find where it is.\n");
	      printf("Command before relocation: ");
	      if((SectionHeader.s_flags >> 24) == 1) {  /*16-bit section*/
	      	C_PrintByte(raw_data, RelInfo.r_vaddr, 1);
	      } else {
	      	C_PrintByte(raw_data, RelInfo.r_vaddr, 0);  /*32-bit section*/
	      }
	    }
	    
	    /*saving the name into the SymName variable*/
	    if(SymEnt.e_name[0] == 0) {       /*string table*/
	      
	      /*finding the string table*/
	      fseek(FilePtrTbl[index].FilePtr_, 
		    FileHeader.f_symptr+(FileHeader.f_nsyms*18), 0);
	      
	      index4 = 0;
	      while(index4 < 7) {
		SymName[index4] = SymEnt.e_name[index4 + 1];
		index4 = index4 + 1; 
	      }
	      
	      SymName[index4] = '\0';
	      
	      fseek(FilePtrTbl[index].FilePtr_, C_StringToInt(SymName), 
		    1);
	      
	      /*saving the symbol name into the SymName*/
	      index4 = 0;
	      fread(&SymName[index4], 1, 1, FilePtrTbl[index].FilePtr_);
	      while(SymName[index4] != '\0') {
		index4 = index4 + 1;
		fread(&SymName[index4], 1, 1, FilePtrTbl[index].FilePtr_);
	      }
	      
	      
	    } else {       /*e_name contains the name*/
	      
	      index4 = 0;
	      while(index4 < 8 && SymEnt.e_name[index4] != 0) {
		SymName[index4] = SymEnt.e_name[index4];
		index4 = index4 + 1;	
	      }
	      
	      SymName[index4] = '\0';   
	      
	    }
	    
	    if(CoffeeDebug) {
	      printf("Trying to find the symbol %s from the object files.\n",
		     SymName);	
	    }
	    
	    /*finding the symbol in the object files*/
	    GlobalSymFound = 0;
	    index6 = 0;
	    while(index6 < ObjFileCount) {
	      
	      if(index6 == index) {     /*skipping the relocation 
					  object file*/
		index6 = index6 + 1;
		continue;
	      }
	      
	      if(CoffeeDebug) {
		printf("Looking for symbol '%s' in file %s\n", SymName,
		       FilePtrTbl[index6].File_);
	      }
	      
	      
	      rewind(FilePtrTbl[index6].FilePtr_);     
	      fread(&TempFileHdr, 20, 1, FilePtrTbl[index6].FilePtr_);   
	      /*finding the symbols*/
	      fseek(FilePtrTbl[index6].FilePtr_, TempFileHdr.f_symptr, 0);
	      /*loop tries to find the right symbol*/
	      index7 = 0;
	      while(index7 < TempFileHdr.f_nsyms) {
		/*reading the symbol's information into a temp variable*/
		fread(&TempSym, 18, 1, FilePtrTbl[index6].FilePtr_);
		if(TempSym.e_name[0] == 0) {       /*string table*/
		  
		  /*finding the string table*/
		  fseek(FilePtrTbl[index6].FilePtr_, 
			(TempFileHdr.f_symptr)+(TempFileHdr.f_nsyms*18), 0);
		  
		  index4 = 0;
		  while(index4 < 7) {
		    SymbolName[index4] = TempSym.e_name[index4 + 1];
		    index4 = index4 + 1; 
		  }
		  
		  SymbolName[index4] = '\0';
		  
		  /*offset*/
		  StrTblPtr1 = C_StringToInt(SymbolName);
		  fseek(FilePtrTbl[index6].FilePtr_, StrTblPtr1, 1);
		  
		  /*saving the symbol name into the SymbolName variable*/
		  index4 = 0;
		  fread(&SymbolName[index4], 1, 1, 
			FilePtrTbl[index6].FilePtr_);
		  while(SymbolName[index4] != '\0') {
		    index4 = index4 + 1;
		    fread(&SymbolName[index4], 1, 1, 
			  FilePtrTbl[index6].FilePtr_);
		  }
		  
		  /*correcting the file pointer*/
		  fseek(FilePtrTbl[index6].FilePtr_, TempFileHdr.f_symptr, 0);
		  fseek(FilePtrTbl[index6].FilePtr_, (index7+1)*18, 1);
		  
		} else {       /*name in the e_name variable*/
		  
		  index4 = 0;
		  while(index4 < 8 && TempSym.e_name[index4] != 0) {
		    SymbolName[index4] = TempSym.e_name[index4];
		    index4 = index4 + 1;	
		  }
		  
		  SymbolName[index4] = '\0';   /*SymbolName has the name*/
		  
		}
		
		/*comparing the symbol names*/
		if(!C_CmpStr(SymbolName, SymName)) {     /*the same*/
		  
		  /*e_sclass must be 2 ja e_scnum >0*/
		  if(TempSym.e_sclass == 2 && TempSym.e_scnum > 0) {
		    GlobalSymFound = 1;
		    break;
		  } else { /*symbol wasn't found*/
		    TempVariable = TempSym.e_numaux;
		    
		    fseek(FilePtrTbl[index6].FilePtr_, TempVariable*18, 1);
		    
		    if(TempSym.e_numaux == 0) {
		      index7 = index7 + 1;
		    } else {
		      index7 = index7 + (TempVariable+1);
		    }
		    
		    continue;
		  }
		  
		} else {   /*the names are different*/
		  TempVariable = TempSym.e_numaux;
		  fseek(FilePtrTbl[index6].FilePtr_, TempVariable*18,
			1);
		  
		  if(TempSym.e_numaux == 0) {
		    index7 = index7 + 1;
		  } else {
		    index7 = index7 + (TempVariable+1);
		  }
		  
		  continue;	
		}
		
	      }
	      
	      if(GlobalSymFound == 0) {
		index6 = index6 + 1;
	      } else {
		break;
	      }   
	      
	    }   /*while(index6 < ObjFileCount)*/
	    
	    if(GlobalSymFound == 0) {    /*didn't find a value for the global 
					   symbol in object files*/
	      printf("Error: Couldn't find a value for a global symbol!\n");
	      return 1;
	    } else {      /*global symbol's value was found*/
	      
	      if(CoffeeDebug) {
		printf("Symbol was found in file %s.\n", 
		       FilePtrTbl[index6].File_);	
	      }
	      
	      /*index6 shows the right file and TempSym contains the 
		right symbol's information*/
	      /*finding out the section name*/
	      fseek(FilePtrTbl[index6].FilePtr_, 20, 0);
	      fseek(FilePtrTbl[index6].FilePtr_, (TempSym.e_scnum-1)*40, 1);
	      /*reading the section info to a variable*/
	      fread(&TmpSectionHdr, 40, 1, FilePtrTbl[index6].FilePtr_);
	      
	      if(TmpSectionHdr.s_name[0] == 0x5c) {    /*to the string table*/
		
		index7 = 0;
		while (index7 < 7) {
		  ScnName[index7] = TmpSectionHdr.s_name[index7+1];
		  index7 = index7 + 1;	
		}
		
		StringTablePtr = C_StringToInt(ScnName);       /*to integer*/
		C_GetStringName(FilePtrTbl[index6].File_, ScnName, 
				StringTablePtr);
		
	      } else {    /*name's length is under 8 chars*/
		
		index7 = 0;
		ScnName[index7] = TmpSectionHdr.s_name[index7];
		while(index7 <= 7 && ScnName[index7] != 0) {
		  index7 = index7 + 1;
		  ScnName[index7] = TmpSectionHdr.s_name[index7];
		} 
		
		ScnName[index7] = '\0';
		
	      }
	      
	      /*finding out where the section has been mapped, 
		ScnName contains the name*/
	      
	      TempAddr = C_FindSectionAddress(ScnName, TempStr, 
					      FilePtrTbl[index6].File_);
	      
	      if(TempAddr == -1) {
		printf("Error: Couldn't find section start address..\n");
		return 1;
	      }
	      
	      if(CoffeeDebug) {
		printf("The section in which the symbol is defined is %s",
		       ScnName);
		printf(" and it is located in file %s.\n", 
		       FilePtrTbl[index6].File_);
		printf("Section's run time address is %ld.\n", TempAddr);
	      }
	      
	      
	      /*TempAddr contains the running time address*/	
	      /*TempSym contains the symbol information*/
	      /*TempStr contains the memory name*/
	      /*if the memory names are different we are forced to write*/
	      /*some relocation information*/
	      /*if(C_CmpStr(Memory, TempStr)) {
		RelocationInfo[RelTblIndex].Offset_ = RelInfo.r_vaddr;
		RelocationInfo[RelTblIndex].BitPosition_ = Position;
		RelocationInfo[RelTblIndex].AddrLength_ = Length;
		C_CopyString(RelocationInfo[RelTblIndex].SectionName_, 
		SecName);
		C_CopyString(RelocationInfo[RelTblIndex].MemoryName_, 
		TempStr);
		RelTblIndex = RelTblIndex + 1;
		if(RelTblIndex == 100) {
		printf("Error: Too much relocation.\n");
		return 1;
		}
		
		}*/
	      
	      TempSymValue = TempSymValue + TempAddr;
	      
	      TempSymValue = TempSymValue >> ShiftLength;
	      
	      if(CoffeeDebug) {
		printf("Writing the value to the raw data.\n"); 
	      }
	      
	      C_WriteRawData(raw_data, TempSymValue, RelInfo.r_vaddr, 
			     Position, Length);   
	      
	      if(CoffeeDebug) {
	    	printf("Command after relocation: ");
	    	if((SectionHeader.s_flags >> 24) == 1) {  /*16-bit section*/
		  C_PrintByte(raw_data, RelInfo.r_vaddr, 1);
	    	} else {
		  C_PrintByte(raw_data, RelInfo.r_vaddr, 0);/*32-bit section*/
	    	}
	      }
	      
	      
	    }  /*else (GlobalSymbolFound != 0)*/			
	    
	  } else {
	    printf("Error: Faulty section number in file %s.\n", 
		   FilePtrTbl[index].File_);
	    return 1;	
	  }
	  
	} else {
	  TempIntLocation = SymEnt.e_sclass;
	  printf("Error: Error in %s's symbol table entry.\n", 
		 FilePtrTbl[index].File_);
	  printf("e_sclass should be 3,2 or 6.\n");
	  printf("In file %s there is a symbol table entry ", 
		 FilePtrTbl[index].File_);
	  printf("which has an e_sclass value of %d.\n", TempIntLocation);
	  return 1;	
	}
	
      } else {
	printf("Error: Error in relocation entry's r_type field.\n");
	printf("It should be 000, 110 or 101.\n");
	return 1; 
      }
      
      index2 = index2 + 1;
      /*file pointer to the next relocation entry*/
      fseek(FilePtrTbl[index].FilePtr_, SectionHeader.s_relptr, 0);
      fseek(FilePtrTbl[index].FilePtr_, index2*10, 1);
    }   /*loop that goes through relocation information*/
    
    
  } else {   /*f_flags is faulty*/
    printf("Error: Error in %s's f_flags number.\n", FilePtrTbl[index].File_);
    return 1;	
  }
  
  if(ProduceCOFF == 0) {
    /*raw_data is now ready to be written to the target file*/
    /*char* Temp -variable contains the name of the memory*/
    index5 = 0;
    while(index5 < MemoryAmount) {
      if(!C_CmpStr(Memories[index5].MemoryName_, Temp)) {
	break; 
      } else {
	index5 = index5 + 1;
      }
    }
    
    /*index5 is an index to the memories table*/
    /*writing all the stuff into the target file*/
    
    indecs3 = 0;
    /*writing all the bytes before '\0'*/
    while(Memories[index5].MemoryType_[indecs3] != '\0') {
      if((fwrite(&Memories[index5].MemoryType_[indecs3], 1, 1, 
		 TargetFilePtr)) != 1) {
	printf("Error: Unable to write memory type to the targetfile.\n");
	return 1;
      }
      
      indecs3 = indecs3 + 1;
      
    }
    
    /*writing the '\0'*/
    if((fwrite(&Memories[index5].MemoryType_[indecs3], 1, 1, 
	       TargetFilePtr)) != 1) {
      printf("Error: Unable to write memory type to the targetfile.\n");
      return 1;
    }
    
    indecs3 = 0;
    
    while(Memories[index5].MemoryName_[indecs3] != '\0') {
      if((fwrite(&Memories[index5].MemoryName_[indecs3], 1, 1, 
		 TargetFilePtr)) != 1) {
	printf("Error: Unable to write memory name to the targetfile.\n");
	return 1;
      }
      
      indecs3 = indecs3 + 1;
      
    }
    
    if((fwrite(&Memories[index5].MemoryName_[indecs3], 1, 1, 
	       TargetFilePtr)) != 1) {
      printf("Error: Unable to write memory name to the targetfile.\n");
      return 1;
    }
    
    /*should we turn the starting address into a hexadecimal*/
    if((fwrite(&TheAddress, 4, 1, TargetFilePtr)) != 1) {
      printf("Error: Unable to write starting address to the targetfile.\n");
      return 1;
    }
    
    
    /*section's size in bytes*/
    if((fwrite(&SectionHeader.s_size, 4, 1, TargetFilePtr)) != 1) {
      printf("Error: Unable to write data size to the targetfile.\n");
      return 1;
    }
    
    /*section's mode, 16-bit, 32-bit, main*/
    if((fwrite(&SectionHeader.s_flags, 4, 1, TargetFilePtr)) != 1) {
      printf("Error: Unable to write section flags to the targetfile.\n");
      return 1;
    }
    
    /*RelTblIndex = 0;*/
    /*the amount of relocation information*/
    /*if((fwrite(&RelTblIndex, 4, 1, TargetFilePtr)) != 1) {
      printf("Error: Unable to write relocation amount to the targetfile.\n");
      return 1;
      }*/
    
    /*section's raw data*/
    if((fwrite(raw_data, SectionHeader.s_size, 1, TargetFilePtr)) != 1) {
      printf("Error: Unable to write raw data to the targetfile.\n");
      return 1;
    }
  } else { /*The output file should be in COFF format*/

    /*the file header and the section headers have already been written*/

    /*let's write the raw data of the section to the target file*/
    if((fwrite(raw_data, SectionHeader.s_size, 1, TargetFilePtr)) != 1) {
      printf("Error: Unable to write raw data to the targetfile.\n");
      return 1;
    }
    
  }

  free(raw_data);
  
  /*if(RelTblIndex > 0) {*/
    /*writing the relocation information*/
    /*RelTblIndex = RelTblIndex - 1;
    while(RelTblIndex >= 0) {
      fwrite(&RelocationInfo[RelTblIndex], sizeof(struct Relocation), 1, 
	     TargetFilePtr);
      RelTblIndex = RelTblIndex - 1;
    }
    
    RelTblIndex = 0;
    
  }*/
  
  /*updatind the address*/
  TheAddress = TheAddress + SectionHeader.s_size;
  /*if memory has ended*/
  if(Memories[MemoryIndex].EndAddress_ < TheAddress) {
    printf("Error: Out of memory.\n");
    return 1;	
  }
  
  
  fclose(TempFilePtr);
  return 0;
}

/*counts and returns number^exp*/
int C_Exponent(int number, int exp) {
  
  int index = 1;
  int result = number;
  
  if(exp == 0) {
    return 1;
  }
  
  if(exp == 1) {
    return number;
  }
  
  while(index < exp) {
    result = result*number;
    index = index + 1;
  }
  
  return result;
  
}  /*end of C_Exponent*/

/*turns a char variable into an integer*/
int C_CharToInt(char number) {
  int var = 0;
  var = number;

  return var;
}

/*assumes that the string is 7 chars long*/
int C_StringToInt(char* string) {
  int numbers[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
  int index = 6;
  int index1 = 0;
  int number = 0;

  while(index >= 0) {
    numbers[index1] = (string[index] & 15);
    numbers[index1+1] = string[index] >> 4;
    
    index = index - 1;
    index1 = index1 + 2;
  }
  
  /*numbers-taulukko sislt nyt lukuja jotka on hexakertoimia*/
  index = 0;
  while(index <= 13) {
    number = number + (numbers[index] * C_Exponent(16,index));
    index = index + 1;
  }
  
  return number;
}


/*function that converts a char into an int*/
int C_LineCharToInt(char addr) {
  if(addr == '0') {
    return 0;
  } else if(addr == '1') {
    return 1;
  }	else if(addr == '2') {
    return 2;	
  }	else if(addr == '3') {
    return 3;	
  } else if(addr == '4') {
    return 4;	
  } else if(addr == '5') {
    return 5;	
  } else if(addr == '6') {
    return 6;	
  } else if(addr == '7') {
    return 7;	
  } else if(addr == '8') {
    return 8;	
  } else if(addr == '9') {
    return 9;	
  } else if(addr == 'a' || addr == 'A') {
    return 10;	
  } else if(addr == 'b' || addr == 'B') {
    return 11;	
  } else if(addr == 'c' || addr == 'C') {
    return 12;	
  } else if(addr == 'd' || addr == 'D') {
    return 13;	
  } else if(addr == 'e' || addr == 'E') {
    return 14;	
  } else {
    return 15;	
  }	
}

/*function that converts an address, which is presented 
as hexadecimal numbers*/
/*and saved into a char table, into an integer*/
/*this is used when one reads a line from the script file*/
unsigned int C_LineStringToInt(char address[]) {
  unsigned int number = 0;
  int index = 0;
  int index1 = 0;

  while(address[index] != '\0' && address[index] != '\n') {
    index = index + 1;	
  }

  /*loop that counts the address to the number variable*/
  index = index - 1;
  while(address[index] != 'x') {
    number = number + C_LineCharToInt(address[index])*C_Exponent(16,index1);
    index1 = index1 + 1;
    index = index - 1;		
  }	
  
  return number;   /*returning the final result*/
  
}

/*function that writes relocation information into the relocation.out file*/
/*function returns 1 if something goes wrong, 0 if everything is in order*/
int C_WriteRelocation(struct Relocation RelInfo) {
  int index = 0;
  
  /*writing the section name into the file*/
  while(RelInfo.SectionName_[index] != '\0') {
    if((fwrite(&RelInfo.SectionName_[index], 1, 1, 
	       RelFilePtr)) != 1) {
      printf("Error: Unable to write relocation info into the ");
      printf("relocation.out file.\n");
      return 1;

    }

    index = index + 1;
  }

  if((fwrite(&RelInfo.SectionName_[index], 1, 1,
	     RelFilePtr)) != 1) {
    printf("Error: Unable to write relocation info into the ");
    printf("relocation.out file.\n");
    return 1;

  }

  index = 0;

  /*writing the raw data offset into the relocation file*/
  if((fwrite(&RelInfo.Offset_, 4, 1,
             RelFilePtr)) != 1) {
    printf("Error: Unable to write relocation info into the ");
    printf("relocation.out file.\n");
    return 1;

  }
  
  /*writing the bit position into the relocation file*/
  if((fwrite(&RelInfo.BitPosition_, 2, 1,
             RelFilePtr)) != 1) {
    printf("Error: Unable to write relocation info into the ");
    printf("relocation.out file.\n");
    return 1;

  }

  /*writing the address length into the relocation file*/
  if((fwrite(&RelInfo.AddrLength_, 2, 1,
             RelFilePtr)) != 1) {
    printf("Error: Unable to write relocation info into the ");
    printf("relocation.out file.\n");
    return 1;

  }

  /*writing the memory name into the file*/
  while(RelInfo.MemoryName_[index] != '\0') {
    if((fwrite(&RelInfo.MemoryName_[index], 1, 1,
               RelFilePtr)) != 1) {
      printf("Error: Unable to write relocation info into the ");
      printf("relocation.out file.\n");
      return 1;

    }

    index = index + 1;
  }

  if((fwrite(&RelInfo.MemoryName_[index], 1, 1,
             RelFilePtr)) != 1) {
    printf("Error: Unable to write relocation info into the ");
    printf("relocation.out file.\n");
    return 1;

  }

  return 0;

} /*end of C_WriteRelocation*/

/*copies string2 into the string1*/
void C_CopyString(char string1[], char string2[]) {
  int index = 0;

  while(string2[index] != '\0') {
    string1[index] = string2[index];
    index = index + 1;
  }

  string1[index] = string2[index];
}

/*closes all file connections*/
void C_CloseAllFileCons() {
	int indx = 0;		
		
  fclose(ScrFilePointer);
  fclose(RelFilePtr);
  fclose(TargetFilePtr);
    
  while(indx < ObjFileCount) {
    fclose(FilePtrTbl[indx].FilePtr_);
    indx = indx + 1;
  }

}

void C_WriteRawData(char* data, long value, unsigned long offset,
		    unsigned short position, unsigned short length) {
  
  int ByteCount = 0;
  char Byte[] = {0,0,0,0};
  char TmpByte;
  long TmpValue = 0;
  short TmpLength = 0;
  
  /*finding out the amount of bytes*/
  TmpLength = length - (position + 1);
  if(TmpLength <= 0) {
    ByteCount = 1;
  } else if(1 <= TmpLength && TmpLength <= 8) {
    ByteCount = 2;
  } else if(9 <= TmpLength && TmpLength <= 16) {
    ByteCount = 3;
  } else {
    ByteCount = 4;
  }

  /*printf("WriteRawData: Writing value %ld into the raw data.\n", value);*/

  if(CoffeeDebug) {
    printf("Bytecount = %d\n", ByteCount);
  }
  
  /*saving the address into a char table*/		
  if(length < (position+1)) {
    
    TmpValue = value;
    TmpValue = TmpValue << ((position+1) - length);
    Byte[0] = TmpValue;
    TmpByte = data[offset];
    TmpByte = TmpByte >> (position+1);
    TmpByte = TmpByte << (position+1);
    Byte[0] = Byte[0] + TmpByte;
    TmpByte = data[offset];
    TmpByte = TmpByte << (8 - ((position+1) - length));
    TmpByte = TmpByte >> (8 - ((position+1) - length));
    Byte[0] = Byte[0] + TmpByte;
    data[offset] = Byte[0];
    
  } else {
    
    TmpValue = value;
    if(CoffeeDebug) {
      printf("TmpValue = value => TempValue = %ld\n", TmpValue);
    }

    if(length < 25) {
      if(ByteCount == 1) {   /*Length = (Position+1)*/
	
	Byte[0] = TmpValue;	
	TmpByte = data[offset];
	TmpByte = TmpByte >> (position+1);
	TmpByte = TmpByte << (position+1);
	Byte[0] = Byte[0] + TmpByte;
	data[offset] = Byte[0];
	
      } else if(ByteCount == 2) {
	
	Byte[0] = TmpValue >> (length - (position+1));
	TmpValue = TmpValue << (8 - (length-(position+1)));
	TmpValue = TmpValue & 255;
	Byte[1] = TmpValue;
	TmpByte = data[offset];
	TmpByte = TmpByte >> (position+1);
	TmpByte = TmpByte << (position+1);
	Byte[0] = Byte[0] + TmpByte;
	TmpByte = data[offset+1];
	TmpByte = TmpByte << (length - (position+1));
	TmpByte = TmpByte >> (length - (position+1));
	Byte[1] = Byte[1] + TmpByte;
	data[offset] = Byte[0];
	data[offset+1] = Byte[1];
	
      } else {   /*ByteCount = 3*/
	
	Byte[0] = TmpValue >> (length - (position+1));
	TmpValue = TmpValue << (8 - (length - 8 - (position+1)));
	Byte[2] = TmpValue & 255;
	TmpValue = TmpValue >> 8;
	Byte[1] = TmpValue & 255;
	/*saving to raw_data*/
	data[offset+1] = Byte[1];
	TmpByte = data[offset];
	TmpByte = TmpByte >> (position + 1);
	TmpByte = TmpByte << (position + 1);
	Byte[0] = Byte[0] + TmpByte;
	data[offset] = Byte[0];
	TmpByte = data[offset+2];
	TmpByte = TmpByte >> (8-(length-(position+1)-8));
	TmpByte = TmpByte << (8-(length-(position+1)-8));
	Byte[2] = Byte[2] + TmpByte;
	data[offset+2] = Byte[2];
	
      }
      
    } else {        /*length = 25*/
      
      Byte[0] = TmpValue >> (25 - (position+1));
      TmpValue = TmpValue >> (25 - 16 - (position+1)); 
      Byte[2] = TmpValue & 255;
      TmpValue = TmpValue >> 8;
      Byte[1] = TmpValue & 255;
      TmpValue = value;
      TmpValue = TmpValue << (32 - (25-16-(position+1)));
      TmpValue = TmpValue >> (32 - (25-16-(position+1)));
      TmpValue = TmpValue << (8 - (25-16-(position+1)));
      Byte[3] = TmpValue;       /*??*/
      
      /*updating raw_data*/
      TmpByte = data[offset];
      TmpByte = TmpByte >> (position+1);
      TmpByte = TmpByte << (position+1);
      Byte[0] = Byte[0] + TmpByte;
      TmpByte = data[offset+3];
      TmpByte = TmpByte << (25-16-(position+1));
      TmpByte = TmpByte >> (25-16-(position+1));
      Byte[3] = Byte[3] + TmpByte;
      data[offset] = Byte[0];
      data[offset+1] = Byte[1];
      data[offset+2] = Byte[2];
      data[offset+3] = Byte[3];
      
    } 	
  }
  if(CoffeeDebug) {
    printf("Bytes after writing are '%x' '%x' '%x' '%x'\n", data[offset], 
	   data[offset+1], data[offset+2], data[offset+3]);
  }
}

/*function should look for a section from string table and place it into the*/
/*name-table*/
void C_GetStringName(char* file, char* name, int StrTblOffset) {
  FILE* FilePointer;
  int index = 0;
  FILHDR FileHeader;
  
  if((FilePointer = fopen(file, "rb")) == NULL) {
    printf("Error: Error in opening temporary file connection.\n");
    exit(EXIT_FAILURE); 	/*??*/
  }
  
  if(fread(&FileHeader, 20, 1, FilePointer) != 1) {
    printf("Error: Reading the file header failed.\n");
    exit(EXIT_FAILURE);;	
  }
  
  fseek(FilePointer, 
	FileHeader.f_symptr + FileHeader.f_nsyms*18, 0);
  fseek(FilePointer, StrTblOffset, 1);
  
  fread(&name[index], 1, 1, FilePointer);
  while(name[index] != '\0') {
    index = index + 1;
    fread(&name[index], 1, 1, FilePointer);
  }
  
  fclose(FilePointer);
}

/*function tries to find the running time address for a section named*/
/*SectionName (given as a parameter)*/
/*it returns -1 if the mapping info can't be found and the running time*/
/*address if everything goes fine*/
long C_FindSectionAddress(char SectionName[], char* MemName, 
			  char FileName[]) {

  int index = 0;
  
  while(C_CmpStr(Sections[index].SecName_, SectionName) || 
	C_CmpStr(Sections[index].FileName_, FileName)) {
    index = index + 1;
    
    if(index == SectionIndex) {
      return -1;
    }
  }
  /*what's that honey?*/
  C_CopyString(MemName, Memories[Sections[index].MemTblIndex_].MemoryName_);
  
  return Sections[index].RunTimeAddr_;	
}

/*function checks the correctness of the beginning of the script file*/
/*returns 0 if everything is ok, 1 if not*/
int C_ReadScriptFile() {
  int MemoryIndex = 0;
  
  /*reading the first line of the script file, which should contain*/
  /*the word MEMORY and the amount of memories*/
  fgets(Temp, 7, ScrFilePointer);  
  if(Temp[0] != 'M' || Temp[1] != 'E' || Temp[2] != 'M' || Temp[3] != 'O' ||
     Temp[4] != 'R' || Temp[5] != 'Y') {
    printf("Error: Error in scriptfile in the memory definition.\n");
    C_CloseAllFileCons();
    return 1;
  }
  
  /*reading the amount of memories into a global variable, MemoryAmount*/
  fscanf(ScrFilePointer, "%d", &MemoryAmount);
  if(MemoryAmount == 0 || MemoryAmount > MAX_MEMORIES) {
    printf("Error: Error in scriptfile. Too many memories.\n");
    C_CloseAllFileCons();    
    return 1;
  }
  
  /*reading and saving the memory info from the script file*/
  while(MemoryIndex < MemoryAmount) {
    fscanf(ScrFilePointer, "%s", Memories[MemoryIndex].MemoryName_);
    fscanf(ScrFilePointer, "%lx", &Memories[MemoryIndex].StartAddress_);
    fscanf(ScrFilePointer, "%lx", &Memories[MemoryIndex].EndAddress_);
    fscanf(ScrFilePointer, "%s", Memories[MemoryIndex].MemoryType_);
    MemoryIndex = MemoryIndex + 1;
  }
  
  return 0;

}

/*function tries to find the symbol's, that has been give nas a parameter,
running time address. If it succeeds it returns the address and if it doesn't 
the return value is -1*/
long int C_FindSymRunTimeAdd(SYMENT Symbol, char* File, char* Section, 
			     char* Memory) {
	
  FILE* FilePointer;
  char ScnName[20];
  long int RunTimeAddr = 0;
  SCNHDR SectionHeader;	
  int index3 = 0;
  int StrTblPtr = 0;
  FILHDR FileHeader;
  int index4 = 0, index6 = 0;
  unsigned int index7 = 0;
  char SymName[20];
  int GlobalSymFound = 0;
  FILHDR TempFileHdr;
  SYMENT TempSym;
  char SymbolName[20];
  int StrTblPtr1 = 0;
  int TempVariable = 0;
  SCNHDR TmpSectionHdr;
  int StringTablePtr = 0;
  
  /*opening temporary file connection to the object file*/ 
  if((FilePointer = fopen(File, "rb")) == NULL) {
    printf("Error: Error in opening temporary file connection.\n");
    return -1; 	/*??*/
  }
  
  fread(&FileHeader, 20, 1, FilePointer);
  
  if(Symbol.e_sclass == 6  || (Symbol.e_sclass == 2 && 
			       Symbol.e_scnum > 0)) {                        
    /*symbol defined in a section which is in the file in question*/	 
    
    
    fseek(FilePointer, (Symbol.e_scnum-1)*40, 1);
    fread(&SectionHeader, 40, 1, FilePointer);
    /*SectionHeader variable contains now the right section header*/
    
    if(SectionHeader.s_name[0] == 0x5c) {   /*to the string table*/   
      
      index3 = 0;
      while (index3 < 7) {
	ScnName[index3] = SectionHeader.s_name[index3+1];
	index3 = index3 + 1;	
      }
      
      ScnName[index3] = '\0';
      
      StrTblPtr = C_StringToInt(ScnName);       /*turning into an integer*/
      C_GetStringName(File, ScnName, StrTblPtr);
      
    } else {
      C_CopyString(ScnName, SectionHeader.s_name);
    }
    
    /*ScnName contains now the right section name*/
    /*long C_FindSectionAddress(char SectionName[], char* MemName, 
      char FileName[]);*/
    RunTimeAddr = C_FindSectionAddress(ScnName, Memory, File);
    if(RunTimeAddr == -1) {
      printf("Error: Couldn't find running time address for section %s.\n", 
	     ScnName);
      fclose(FilePointer);
      return -1;
      
    }
    
    if(CoffeeDebug) {
      printf("Symbol is in section %s which is in file %s\n", ScnName, File);
      printf("Run time address of the section is %ld\n", RunTimeAddr); 
    }

    
    /*adding the symbol's value*/
    RunTimeAddr = RunTimeAddr + Symbol.e_value;
    
    
    fclose(FilePointer);
    return RunTimeAddr;  	
    
  } else if(Symbol.e_sclass == 2 && Symbol.e_scnum == 0) {  /*global symbol*/
    
    if(Symbol.e_name[0] == 0) {       /*string table*/
      
      /*finding the string table*/
      fseek(FilePointer, 
	    FileHeader.f_symptr+(FileHeader.f_nsyms*18), 0);
      
      index4 = 0;
      while(index4 < 7) {
	SymName[index4] = Symbol.e_name[index4 + 1];
	index4 = index4 + 1; 
      }
      
      SymName[index4] = '\0';
      
      fseek(FilePointer, C_StringToInt(SymName), 
	    1);
      
      /*saving the symbol name into the SymName*/
      index4 = 0;
      fread(&SymName[index4], 1, 1, FilePointer);
      while(SymName[index4] != '\0') {
	index4 = index4 + 1;
	fread(&SymName[index4], 1, 1, FilePointer);
      }
      
      
    } else {       /*e_name contains the name*/
      
      index4 = 0;
      while(index4 < 8 && Symbol.e_name[index4] != 0) {
	SymName[index4] = Symbol.e_name[index4];
	index4 = index4 + 1;	
      }
      
      SymName[index4] = '\0';   
      
    }
    
    /*SymName contains the symbol name*/
    /*trying to find it in another file*/
    GlobalSymFound = 0;
    index6 = 0;
    while(index6 < ObjFileCount) {
      
      rewind(FilePtrTbl[index6].FilePtr_);     
      fread(&TempFileHdr, 20, 1, FilePtrTbl[index6].FilePtr_);   
      /*finding the symbols*/
      fseek(FilePtrTbl[index6].FilePtr_, TempFileHdr.f_symptr, 0);
      /*loop tries to find the right symbol*/
      index7 = 0;
      while(index7 < TempFileHdr.f_nsyms) {
	/*reading the symbol's information into a temp variable*/
	fread(&TempSym, 18, 1, FilePtrTbl[index6].FilePtr_);
	if(TempSym.e_name[0] == 0) {       /*string table*/
	  
	  /*finding the string table*/
	  fseek(FilePtrTbl[index6].FilePtr_, 
		(TempFileHdr.f_symptr)+(TempFileHdr.f_nsyms*18), 0);
	  
	  index4 = 0;
	  while(index4 < 7) {
	    SymbolName[index4] = TempSym.e_name[index4 + 1];
	    index4 = index4 + 1; 
	  }
	  
	  SymbolName[index4] = '\0';
	  
	  /*offset*/
	  StrTblPtr1 = C_StringToInt(SymbolName);
	  fseek(FilePtrTbl[index6].FilePtr_, StrTblPtr1, 1);
	  
	  /*saving the symbol name into the SymbolName variable*/
	  index4 = 0;
	  fread(&SymbolName[index4], 1, 1, 
		FilePtrTbl[index6].FilePtr_);
	  while(SymbolName[index4] != '\0') {
	    index4 = index4 + 1;
	    fread(&SymbolName[index4], 1, 1, 
		  FilePtrTbl[index6].FilePtr_);
	  }
	  
	  /*correcting the file pointer*/
	  fseek(FilePtrTbl[index6].FilePtr_, TempFileHdr.f_symptr, 0);
	  fseek(FilePtrTbl[index6].FilePtr_, (index7+1)*18, 1);
	  
	} else {       /*name in the e_name variable*/
	  
	  index4 = 0;
	  while(index4 < 8 && TempSym.e_name[index4] != 0) {
	    SymbolName[index4] = TempSym.e_name[index4];
	    index4 = index4 + 1;	
	  }
	  
	  SymbolName[index4] = '\0';   /*SymbolName has the name*/
	  
	}
	
	/*comparing the symbol names*/
	if(!C_CmpStr(SymbolName, SymName)) {     /*the same*/
	  
	  /*e_sclass must be 2 ja e_scnum >0*/
	  if(TempSym.e_sclass == 2 && TempSym.e_scnum > 0) {
	    GlobalSymFound = 1;
	    break;
	  } else { /*symbol wasn't found*/
	    TempVariable = TempSym.e_numaux;
	    
	    fseek(FilePtrTbl[index6].FilePtr_, TempVariable*18, 1);
	    
	    if(TempSym.e_numaux == 0) {
	      index7 = index7 + 1;
	    } else {
	      index7 = index7 + (TempVariable+1);
	    }
	    
	    continue;
	  }
	  
	} else {   /*the names are different*/
	  TempVariable = TempSym.e_numaux;
	  
	  fseek(FilePtrTbl[index6].FilePtr_, TempVariable*18,
		1);
	  
	  if(TempSym.e_numaux == 0) {
	    index7 = index7 + 1;
	  } else {
	    index7 = index7 + (TempVariable+1);
	  }
	  
	  continue;	
	}
	
      }
      
      if(GlobalSymFound == 0) {
	index6 = index6 + 1;
      } else {
	break;
      }   
      
    }   /*while(index6 < ObjFileCount)*/
    
    if(GlobalSymFound == 0) {    /*didn't find a value for the global 
				   symbol in object files*/
      printf("Error: Couldn't find a value for a global symbol!\n");
      return -1;
    } else {      /*global symbol's value was found*/
      
      /*index6 shows the right file and TempSym contains the 
	right symbol's information*/
      /*finding out the section name*/
      fseek(FilePtrTbl[index6].FilePtr_, 20, 0);
      fseek(FilePtrTbl[index6].FilePtr_, (TempSym.e_scnum-1)*40, 1);
      /*reading the section info to a variable*/
      fread(&TmpSectionHdr, 40, 1, FilePtrTbl[index6].FilePtr_);
      
      if(TmpSectionHdr.s_name[0] == 0x5c) {    /*to the string table*/
	
	index7 = 0;
	while (index7 < 7) {
	  ScnName[index7] = TmpSectionHdr.s_name[index7+1];
	  index7 = index7 + 1;	
	}
	
	StringTablePtr = C_StringToInt(ScnName);       /*to integer*/
	C_GetStringName(FilePtrTbl[index6].File_, ScnName, 
			StringTablePtr);
	
      } else {    /*name's length is under 8 chars*/
	
	index7 = 0;
	ScnName[index7] = TmpSectionHdr.s_name[index7];
	while(index7 <= 7 && ScnName[index7] != 0) {
	  index7 = index7 + 1;
	  ScnName[index7] = TmpSectionHdr.s_name[index7];
	} 
	
	ScnName[index7] = '\0';
	
      }
      
      /*finding out where the section has been mapped, 
	ScnName contains the name*/
      RunTimeAddr = C_FindSectionAddress(ScnName, Memory, 
					 FilePtrTbl[index6].File_);
      
      if(RunTimeAddr == -1) {
	printf("Error: Couldn't find run time address for section %s\n", 
	       ScnName);
	return -1;
      }
      
      /*RunTimeAddr contains the running time address*/	
      /*TempSym contains the symbol information*/
      /*TempStr contains the memory name*/
      /*if the memory names are different we are forced to write*/
      /*some relocation information*/
      
    }  /*else (GlobalSymbolFound != 0)*/
    
    if(CoffeeDebug) {
      printf("Symbol is in section %s which is in file %s\n", ScnName, 
	     FilePtrTbl[index6].File_);
      printf("Run time address of the section is %ld\n", RunTimeAddr);	  
    }
    
    /*adding the symbol's value*/
    RunTimeAddr = RunTimeAddr + TempSym.e_value;
  
    fclose(FilePointer);
    return RunTimeAddr;			
    
  } else {
    
    printf("Error: Symbol has a faulty e_sclass value in file %s.\n", File);
    fclose(FilePointer);
    return -1;
    
  }
  
}

/*function prints the whole command word to which the offset points*/
/*if mode == 0 -> 32-bit coding, if mode == 1, 16-bit coding*/
void C_PrintByte(char* data, long offset, int mode) {
		
  long DataOffset = 0;
  int Subtractor = 0;
  int index = 7;
  char TempChar;
  int TempInt = 0;
  
  if(mode == 0) {     /*32-bit*/
    Subtractor = 4;
  } else {           /*16-bit*/
    Subtractor = 2;	
  }
  
  DataOffset = offset;
  
  while((DataOffset % Subtractor) != 0) {
    DataOffset = DataOffset - 1;
  }
  
  while(Subtractor > 0) {
    
    index = 7;
    while(index >= 0) {
      TempChar = data[DataOffset];
      TempChar = TempChar >> index;
      TempChar = TempChar & 1;
      TempInt = TempChar;
      printf("%d", TempInt);
      index = index - 1;
    }
    
    DataOffset = DataOffset + 1;
    Subtractor = Subtractor - 1;
  }
  
  printf("\n");
}

/*function goes through every object file and prints some information 
about it*/
void C_PrintSections() {
	
  int index = 0;
  FILHDR FileHeader;
  FILE* FilePtr;
  unsigned short index1 = 0;
  SCNHDR SectionHdr;
  char SecName[20];
  int index3 = 0, StrTblPtr = 0;
  int MainAmount = 0, BigBitAmount = 0, SmallBitAmount = 0;
  
  while(index < ObjFileCount) {
    
    /*opening temporary file connection*/
    if((FilePtr = fopen(FilePtrTbl[index].File_, "rb")) == NULL) {
      printf("Error: Error opening file %s.\n", FilePtrTbl[index].File_);
      return; 	
    }
    
    /*reading the header*/
    fread(&FileHeader, 20, 1, FilePtr);
    /*printing the number of sections*/
    printf("File %s contains %d sections:\n", FilePtrTbl[index].File_, 
	   FileHeader.f_nscns);
    
    index1 = 0;			
    while(index1 < FileHeader.f_nscns) {
      
      printf("Section %d:\n", index1 + 1);
      fread(&SectionHdr, 40, 1, FilePtr);  /*reading the section header*/
      
      if(SectionHdr.s_name[0] == 0x5c) {    
	
      	index3 = 0;
      	while (index3 < 7) {
	  SecName[index3] = SectionHdr.s_name[index3+1];
	  index3 = index3 + 1;	
      	}
	
	SecName[index3] = '\0';
	
      	StrTblPtr = C_StringToInt(SecName);       /*turning into an integer*/
      	C_GetStringName(FilePtrTbl[index].File_, SecName, StrTblPtr);
      	
      } else {
	
	C_CopyString(SecName, SectionHdr.s_name);
	
      }
      
      /*SecName contains the section name*/
      printf("Section's name: %s\n", SecName);
      printf("Section's size: %ld tavua\n", SectionHdr.s_size);	
      
      if((SectionHdr.s_flags >> 24) == 0) { /*main section*/
	printf("Mode: main section\n");
	MainAmount = MainAmount + 1;
      } else if((SectionHdr.s_flags >> 24) == 16) {  /*32-bit*/
	printf("Mode: 32-bit sub section\n");
	BigBitAmount = BigBitAmount + 1;
      } else {   	  /*16-bit*/
	printf("Mode: 16-bit sub section\n");
	SmallBitAmount = SmallBitAmount + 1;
      }
      
      printf("Section has %d relocation entries\n", 
	     SectionHdr.s_nreloc); 
      
      index1 = index1 + 1;
    }
    
    printf("File contains %d 16-bit subsections, %d 32-bit ", 
	   SmallBitAmount, BigBitAmount);
    printf("subsections ja %d main sections.\n", MainAmount);    
    
    index = index + 1;
    fclose(FilePtr);
    
  }
  
}

/*saves the section definitions from the script file into a memory structure*/
/*Sections-table*/
/*returns 1 if something goes wrong and 0 if everything goes fine*/
/*assumes that the script file pointer is in the beginning of the section*/
/*definitions*/
int C_SaveScriptFile() {
	
  char Tempstr[201];
  int index = 0, index6 = 0;
  int index2 = 0, index3 = 0, index5 = 0, index4 = 0, StrTblPtr = 0;
  int SectionFound = 0, MemIdx = 0;
  char TmpMemName[50];
  unsigned short int ColonAmount = 0;
  struct SecInfo SectionInformation;
  FILHDR TempFileHdr;
  SCNHDR TempSecHdr;
  char SecName[100];
  long int TmpIntPlace = 0;

  rewind(ScrFilePointer);
  fgets(Tempstr, 200, ScrFilePointer);

  /*MEMORY should be found*/
  if(Tempstr[0] != 'M' || Tempstr[1] != 'E' || Tempstr[2] != 'M' || 
     Tempstr[3] != 'O' || Tempstr[4] != 'R' || Tempstr[5] != 'Y') {
    printf("Error: Error in script file. Keyword MEMORY should be found.\n");
    return 1;
  }

  if(Tempstr[6] != ' ') {
    printf("Error: Error in the beginning of the script file.");
    printf("\nCheck spacing after the keyword MEMORY.\n");
    return 1;
  }  
  /*reading away the memory definitions*/
  index6 = 0;
  while(index6 < MemoryAmount) {
    fgets(Tempstr, 200, ScrFilePointer);
    index6 = index6 + 1;
  }
  
  index = 0;
  while(index < MemoryAmount/*global, set by C_ReadScriptFile()*/) {
    
    /*ScrFilePointer should be at the right place, right after the memory 
      definitions*/    
    /*reading the empty line*/
    fgets(Tempstr, 200, ScrFilePointer/*global*/);

    /*reading the SECTIONS-line*/
    fgets(Tempstr, 200, ScrFilePointer/*global*/);

    if(Tempstr[0] == '}') {
      printf("All the memory areas were not mapped.\n");
      break;
    }

    if(Tempstr[0] != 'S' || Tempstr[1] != 'E' || Tempstr[2] != 'C' || 
       Tempstr[3] != 'T' || Tempstr[4] != 'I' || Tempstr[5] != 'O' ||
       Tempstr[6] != 'N' || Tempstr[7] != 'S') {
      printf("Error in linker script. Keyword should be SECTIONS.\n");
      printf("Tempstr = %s\n", Tempstr);
      return 1;
    }
    
    /*saving the memory name into a variable*/
    index2 = 9;
    index3 = 0;
    while(Tempstr[index2] != '\0' && Tempstr[index2] != '\n') {
      TmpMemName[index3] = Tempstr[index2];
      index3 = index3 + 1;
      index2 = index2 + 1; 
    }
    
    TmpMemName[index3] = '\0'; /*TmpMemName contains the memory name*/

    /*int C_LegalMemoryName(char* Memory);*/
    
    if(C_LegalMemoryName(TmpMemName) == -1) {
      printf("Error: Illegal memory name in script file: %s\n", TmpMemName);
      return 1;
    }
    
    /*finding out the index to the memories table*/
    index3 = 0;
    while(C_CmpStr(TmpMemName, Memories[index3].MemoryName_)) {
      index3 = index3 + 1; 
    }
    
    /*updating the TheAddress variable*/
    /*TheAddress is a global variable*/
    TheAddress = Memories[index3].StartAddress_;
    
    /*TheAddress contains now the starting address of the memory area to
      be mapped next !!!!!!!!!!!!!!!!*/
    
    fgets(Tempstr, 200, ScrFilePointer);  /*reading a line*/
    if(Tempstr[0] != '{') {
      printf("Error in script file. A brace should be found.\n");
      return 1;
    }
    
    /*reading the section definitions*/
    while(Tempstr[0] != '}') {
      
      fgets(Tempstr, 200, ScrFilePointer);  /*reading a line*/
      
      if(Tempstr[0] == '}') {
	break;
      }
      
      ColonAmount = FindColonAmount(Tempstr);/*finding out the colon amount*/
      
      if(ColonAmount != 1 && ColonAmount != 2) {
	printf("Error: Faulty amount of colons in script file.\n");
	return 1;
      }
      
      SectionInformation = ExtractScriptLine(Tempstr, ColonAmount);
      SectionInformation.MemTblIndex_ = MemIdx;   	
      /*SectionInformation contains all fields in the right format*/
      /*file name can be a *, run time address should be correct*/
      
      if(SectionInformation.FileName_[0] == '*') {
	index2 = 0;
	
	while(index2 < ObjFileCount/*global*/) {
	  /*file pointer to the beginning of the file*/
	  rewind(FilePtrTbl[index2].FilePtr_);
	  /*read the file header*/
	  fread(&TempFileHdr, 20, 1, FilePtrTbl[index2].FilePtr_);
	  /*loop that reads the section headers and finds the right one*/
	  SectionFound = 0;
	  index4 = 0;
	  while(index4 < TempFileHdr.f_nscns) {
	    fread(&TempSecHdr, 40, 1, FilePtrTbl[index2].FilePtr_);
	    
	    if(TempSecHdr.s_name[0] == 0x5c) {     /*to the string table*/    
	      index5 = 0;
	      while (index5 < 7) {
		SecName[index5] = TempSecHdr.s_name[index5+1];
		index5 = index5 + 1;	
	      }
	      
	      SecName[index5] = '\0';
	      
	      StrTblPtr = C_StringToInt(SecName);  /*turning into an integer*/
	      C_GetStringName(FilePtrTbl[index2].File_, SecName, StrTblPtr);
	      
	    } else {
	      C_CopyString(SecName, TempSecHdr.s_name);
	    }
	    
	    /*section name is in the SecName variable*/    
	    if(!C_CmpStr(SecName, SectionInformation.SecName_)) { /*the same*/
	      SectionFound = 1;
	      break;
	    } else {  /*different*/
	      index4 = index4 + 1;
	      continue;
	    }
	    
	  }
	  
	  if(SectionFound == 1) { /*if section has been found*/
	    /*TempSecHdr contains the right section header*/
	    C_CopyString(SectionInformation.FileName_,
			 FilePtrTbl[index2].File_);
	    SectionInformation.RunTimeAddr_ = TheAddress;
	    SectionInformation.MemTblIndex_ = MemIdx;
	    Sections[SectionIndex] = SectionInformation;
	    SectionIndex = SectionIndex + 1;/*global*/
	    TheAddress = TheAddress + TempSecHdr.s_size;
	    
	    fseek(FilePtrTbl[index2].FilePtr_,0,0);
	    index2 = index2 + 1;
	    continue;
	  } else {  /*if it has not*/
	    fseek(FilePtrTbl[index2].FilePtr_,0,0);
	    index2 = index2 + 1;
	    continue;
	  }
	  
	  /*loop also updates TheAddress variable and places the section*/
	  /*information into the global table*/
	  
	} /*while(index2 < ObjFileCount)*/
	
      } else {    /*a real file name*/
	SectionInformation.MemTblIndex_ = MemIdx;
	Sections[SectionIndex] = SectionInformation;
	
	SectionIndex = SectionIndex + 1;
	TmpIntPlace = C_FindSectionSize(SectionInformation.FileName_,
				      SectionInformation.SecName_);
	
	
	if(TmpIntPlace == -1) {
	  printf("An error occurred while trying to find out the size");
	  printf(" of the section");
	  printf(" %s which is located in file %s.\n", 
		 SectionInformation.SecName_,SectionInformation.FileName_ );
	  return 1;
	}
  
	/*updating the address*/
	TheAddress = TheAddress + TmpIntPlace;
      }	
      
      
    }  /*while(TempStr[0] != '}')*/
    
    index = index + 1;
    MemIdx = MemIdx + 1; /**/
    
  }  /*while(index < MemoryAmount)*/
  
  rewind(ScrFilePointer);
  return 0;
  
}

unsigned short int FindColonAmount(char String[]) {
  unsigned short int Amount = 0;
  int index = 0;
  
  while(String[index] != '\0' && String[index] != '\n') {
    if(String[index] == ':') {
      Amount = Amount + 1;
    }
    
    index = index + 1;
  }	
  
  return Amount;
}

struct SecInfo ExtractScriptLine(char String[], 
				 unsigned short int ColonNumber) {
  struct SecInfo SectionInfo;
  int index = 0, index1 = 0;
  char Address[20];
  int TempInt = 0;
  
  /*saving the file name*/
  while(String[index] != ':') {
    SectionInfo.FileName_[index] = String[index];
    index = index + 1;	
  }
  
  SectionInfo.FileName_[index] = '\0';
  index = index + 1;
  
  index1 = 0;
  if(ColonNumber == 1) {
    /*saving the section name*/
    while(String[index] != '\0' && String[index] != '\n') {
      SectionInfo.SecName_[index1] = String[index];
      index= index + 1;
      index1 = index1 + 1;
    }
    
    SectionInfo.SecName_[index1] = '\0';
    
    /*saving the run time address*/
    SectionInfo.RunTimeAddr_ = TheAddress/*global*/;
    
  } else {      /*ColonNumber == 2*/
    
    /*saving the section name*/
    while(String[index] != ':') {
      SectionInfo.SecName_[index1] = String[index];
      index = index + 1;
      index1 = index1 + 1;
    }
    
    SectionInfo.SecName_[index1] = '\0';
    
    index = index + 1;
    index1 = 0;
    while(String[index] != '\0' && String[index] != '\n') {
      Address[index1] = String[index];
      index = index + 1;
      index1 = index1 + 1;
    }
    
    Address[index1] = '\0';
    /*saving the run time address*/
    TempInt = C_LineStringToInt(Address);
    SectionInfo.RunTimeAddr_ = TempInt;
    TheAddress = TempInt;
  }
  
  return SectionInfo;
}

/*if not found returns 0*/
long int C_FindSectionSize(char File[], char Section[]) {

  int index3 = 0;
  unsigned short int index2 = 0;
  FILE* TmpFilePtr;
  SCNHDR SectionHeader;
  char SecName[50];
  int StrTblPtr = 0;
  int SectionFound = 0;
  FILHDR FileHeader;

  
  /*opening temporary file connection*/
  if((TmpFilePtr = fopen(File, "rb")) == NULL) {
    printf("Unable to open file binary file connection while");
    printf(" trying to find out the size of the section %s ", Section);
    printf("which is located in file %s.\n", File);
    return -1;
  }
  
  fread(&FileHeader, 20, 1, TmpFilePtr);  /*reading the file header*/
  
  /*loop that goes through section headers*/
  SectionFound = 0;
  while(index2 < FileHeader.f_nscns) {
    /*reading the section header*/
    fread(&SectionHeader, 40, 1, TmpFilePtr);

    if(SectionHeader.s_name[0] == 0x5c) {     /*to the string table*/    
      index3 = 0;
      while (index3 < 7) {
	SecName[index3] = SectionHeader.s_name[index3+1];
	index3 = index3 + 1;	
      }
      
      SecName[index3] = '\0';
      
      StrTblPtr = C_StringToInt(SecName);    /*turning into an integer*/
      C_GetStringName(File, SecName, StrTblPtr);
      
    } else {
      C_CopyString(SecName, SectionHeader.s_name);
    }

    /*section name is in the SecName variable*/    
    if(!C_CmpStr(SecName, Section)) { /*the same*/
      SectionFound = 1;
      break;
    } else {  /*different*/
      index2 = index2 + 1;
      continue;
    }
    
  }

  /*closing the temporary file connection*/
  fclose(TmpFilePtr);
  /*if the right section has been found the size is returned, otherwise zero*/
  if(SectionFound == 0) {
    printf("Error: Could not find section %s in file %s.\n", Section, 
	   File);
    return -1;
  } else {
    return (long int)SectionHeader.s_size;	
  }
  
}

int C_CheckMemories() {

  int index = 0, index1 = 0;
  int return_value = 0;

  /*if there is only one memory area..*/
  if(MemoryAmount == 1) {
    return return_value;
  }
  
  index = 0;
  while(index <= (MemoryAmount - 1)) {

    /*if the start address is bigger than the end address*/
    if(Memories[index].StartAddress_ > Memories[index].EndAddress_) {
      printf("Check the addresses in %s's memory definition.\n",
	     Memories[index].MemoryName_);
      printf("Line %d in the script file.\n", index + 2);
      return_value = 1;
    }

    if(Memories[index].StartAddress_ == Memories[index].EndAddress_) {
      printf("%s's memory area is zero bytes.\n",
             Memories[index].MemoryName_);
      return_value = 1;
    }

    if(index == (MemoryAmount - 1)) {
      break;
    }

    index1 = index + 1;
    /*loop that checks if there are similar names*/
    while(index1 < MemoryAmount) {
      /*if the areas have the same name*/
      if(!C_CmpStr(Memories[index].MemoryName_, 
		   Memories[index1].MemoryName_)) {
	printf("There are two memory areas which have the same name.\n");
	printf("The name is %s\n", Memories[index].MemoryName_);
	return_value = 1;
      }

      index1 = index1 + 1;
    }

    index1 = index + 1;
    /*loop that checks if there are overlapping memory areas*/
    while(index1 < MemoryAmount) {
      /*if the areas have the same name*/
      if(!((Memories[index].StartAddress_ < Memories[index1].StartAddress_
	  && Memories[index].EndAddress_ < Memories[index1].StartAddress_)
	 ||
	 (Memories[index].StartAddress_ > Memories[index1].EndAddress_))) {
        printf("There are two overlapping memory areas.\n");
        printf("The names of the memory areas are %s and %s.\n",
	       Memories[index].MemoryName_, Memories[index1].MemoryName_);
	return_value = 1;
      }
      
      index1 = index1 + 1;
    }

    index = index + 1;
    
  }

  return return_value;

}

/*function fills the global memories-table with one memory area in the 
  case of a missing script file*/
void C_FillMemoriesTable() {
  /*the name of the memory is main*/
  Memories[0].MemoryName_[0] = 'm';
  Memories[0].MemoryName_[1] = 'a';
  Memories[0].MemoryName_[2] = 'i';
  Memories[0].MemoryName_[3] = 'n';
  Memories[0].MemoryName_[4] = '\0';	
  
  /*it starts from address zero*/
  Memories[0].StartAddress_ = 0;
  
  /*and ends to address 0xffffffff*/
  Memories[0].EndAddress_ = (C_Exponent(2,32) - 1);
  
  /*the type of the memory is totalmemory*/
  Memories[0].MemoryType_[0] = 't';
  Memories[0].MemoryType_[1] = 'o';
  Memories[0].MemoryType_[2] = 't';
  Memories[0].MemoryType_[3] = 'a';
  Memories[0].MemoryType_[4] = 'l';
  Memories[0].MemoryType_[5] = 'm';
  Memories[0].MemoryType_[6] = 'e';
  Memories[0].MemoryType_[7] = 'm';
  Memories[0].MemoryType_[8] = 'o';
  Memories[0].MemoryType_[9] = 'r';
  Memories[0].MemoryType_[10] = 'y';
  Memories[0].MemoryType_[11] = '\0';
  
}

/*function fills the global sections-table with all the .data and 
  .text sections*/
/*returns 0 if everything goes fine*/
int C_FillSectionsTable() {

  int index = 0, index1 = 0, index3 = 0;
  FILE* TempFilePointer;
  FILHDR FileHdr;
  char SecName[30];
  SCNHDR SecHdr;
  int StrTblPtr = 0;
  char TempString[10];
  unsigned long int MemoryAddress = 0;

  TempString[0] = '.';
  TempString[1] = 't';
  TempString[2] = 'e';
  TempString[3] = 'x';
  TempString[4] = 't';
  TempString[5] = '\0';

  /*starting to go through input object files*/
  SectionIndex = 0;/*global*/
  while(index < ObjFileCount/*global*/) {

    /*opening temporary file connection*/
    if((TempFilePointer = fopen(FilePtrTbl[index].File_, "rb")) == NULL) {
      printf("Unable to open file connection to file %s.\n", 
	     FilePtrTbl[index].File_);
      return 1;
    }
    
    /*reading the header*/
    fread(&FileHdr, 20, 1, TempFilePointer);

    /*starting to go through sections*/
    index1 = 0;
    while(index1 < FileHdr.f_nscns) {
      /*reading the section header*/
      fread(&SecHdr, 40, 1, TempFilePointer);

      /*saving the name into SecName variable*/
      if(SecHdr.s_name[0] == 0x5c) {   /*to the string table*/   
      
	index3 = 0;
	while (index3 < 7) {
	  SecName[index3] = SecHdr.s_name[index3+1];
	  index3 = index3 + 1;
	}
      
	SecName[index3] = '\0';
      
	StrTblPtr = C_StringToInt(SecName);       /*turning into an integer*/
	C_GetStringName(FilePtrTbl[index].File_, SecName, StrTblPtr);
      
      } else {
	C_CopyString(SecName, SecHdr.s_name);
      }
      /*secname contains the name*/

      /*comparing the name to .data*/
      if(C_CmpStr(SecName, TempString)) {
	index1 = index1 + 1;
	continue;
      } else { /*the names are the same*/
	Sections[SectionIndex].MemTblIndex_ = 0;
	C_CopyString(Sections[SectionIndex].FileName_, 
		     FilePtrTbl[index].File_);
	C_CopyString(Sections[SectionIndex].SecName_, TempString);
	Sections[SectionIndex].RunTimeAddr_ = MemoryAddress;
	SectionIndex = SectionIndex + 1;
	MemoryAddress = MemoryAddress + SecHdr.s_size;
	index1 = index1 + 1;
	continue;
      }
      
    }

    index = index + 1;
    fclose(TempFilePointer);
  }

  index = 0;
  index1 = 0;
  TempString[1] = 'd';
  TempString[2] = 'a';
  TempString[3] = 't';
  TempString[4] = 'a';
  TempString[5] = '\0';

  while(index < ObjFileCount/*global*/) {

    /*opening temporary file connection*/
    if((TempFilePointer = fopen(FilePtrTbl[index].File_, "rb")) == NULL) {
      printf("Unable to open file connection to file %s.\n", 
	     FilePtrTbl[index].File_);
      return 1;
    }
    
    /*reading the header*/
    fread(&FileHdr, 20, 1, TempFilePointer);

    /*starting to go through sections*/
    index1 = 0;
    while(index1 < FileHdr.f_nscns) {
      /*reading the section header*/
      fread(&SecHdr, 40, 1, TempFilePointer);
      
      /*saving the name into SecName variable*/
      if(SecHdr.s_name[0] == 0x5c) {   /*to the string table*/   
	
	index3 = 0;
	while (index3 < 7) {
	  SecName[index3] = SecHdr.s_name[index3+1];
	  index3 = index3 + 1;
	}
      
	SecName[index3] = '\0';
      
	StrTblPtr = C_StringToInt(SecName);       /*turning into an integer*/
	C_GetStringName(FilePtrTbl[index].File_, SecName, StrTblPtr);
      
      } else {
	C_CopyString(SecName, SecHdr.s_name);
      }
      /*secname contains the name*/

      /*comparing the name to .data*/
      if(C_CmpStr(SecName, TempString)) {
	index1 = index1 + 1;
	continue;
      } else { /*the names are the same*/
	Sections[SectionIndex].MemTblIndex_ = 0;
	C_CopyString(Sections[SectionIndex].FileName_, 
		     FilePtrTbl[index].File_);
	C_CopyString(Sections[SectionIndex].SecName_, TempString);
	Sections[SectionIndex].RunTimeAddr_ = MemoryAddress;
	SectionIndex = SectionIndex + 1;
	MemoryAddress = MemoryAddress + SecHdr.s_size;
	index1 = index1 + 1;
	continue;
      }
      
    }

    index = index + 1;
    fclose(TempFilePointer);
  }

  return 0;

}

/*returns 1 if something is wrong*/
int C_CheckSections() {

  int index = 0, index1 = 0;
  long int size = 0, size1 = 0;
  
  while(index < SectionIndex) {

    size = C_FindSectionSize(Sections[index].FileName_, 
			     Sections[index].SecName_);

    if(size == -1) {
      printf("Error: Could not determine the size of section %s.\n", 
	     Sections[index].SecName_);
      return 1;
    }

    /*checking if memory runs out*/
    if(((unsigned long)(Sections[index].RunTimeAddr_ + size - 1)) > 
       Memories[Sections[index].MemTblIndex_].EndAddress_) {

      printf("Error: Section %s in file %s does not fit into memory area",
	     Sections[index].SecName_, Sections[index].FileName_);
      printf(" '%s'.\n", Memories[Sections[index].MemTblIndex_].MemoryName_);
      
      return 1;
    }

    /*checking if the section datas are overlapping*/
    index1 = 0;
    while(index1 < SectionIndex/*global*/) { /*going through sections-table*/
      /*if the sections belong to the same memory area*/
      if((Sections[index1].MemTblIndex_ == Sections[index].MemTblIndex_)
	 && (index != index1)) {
	
	size1 = C_FindSectionSize(Sections[index1].FileName_,
				  Sections[index1].SecName_);

	if(size1 == -1) {
	  printf("Error: Could not determine the size of section %s.\n",
		 Sections[index].SecName_);
	  return 1;
	}


	if(((Sections[index].RunTimeAddr_ + size - 1) >= 
	   Sections[index1].RunTimeAddr_) 
	   && ((Sections[index].RunTimeAddr_ + size - 1) <= 
	       (Sections[index1].RunTimeAddr_ + size1 - 1))) {
	  printf("Error: Sections %s and %s are overlapping.\n",
		 Sections[index].SecName_, Sections[index1].SecName_);
	  return 1;
	} else if((Sections[index].RunTimeAddr_ >= 
		  Sections[index1].RunTimeAddr_) && 
		  (Sections[index].RunTimeAddr_ <= 
		   (Sections[index1].RunTimeAddr_ + size1 - 1))) {
	  printf("Error: Sections %s and %s are overlapping.\n",
		 Sections[index].SecName_, Sections[index1].SecName_);
	  return 1;
	} else if((Sections[index].RunTimeAddr_ <= 
		   Sections[index1].RunTimeAddr_) && 
		  ((Sections[index].RunTimeAddr_ + size - 1) >= 
		   (Sections[index1].RunTimeAddr_ + size1 - 1))) {
	  printf("Error: Sections %s and %s are overlapping.\n",
		 Sections[index].SecName_, Sections[index1].SecName_);
	  return 1;
	} else {
	  index1 = index1 + 1;
	}
	

      } else {
	index1 = index1 + 1;
      }
    }  /*while(index1 < SectionIndex)*/

    index = index + 1;

  } /*while(index < SectionIndex)*/

  return 0;

}

/*returns 0 if everything goes fine, 1 if it doesn't*/
int C_WriteFileHeader() {
  /*TargetFilePtr*/
  FILHDR FileHdr;
  FILHDR TmpFileHdr;
  SCNHDR TmpSecHdr;
  int index = 0, index7 = 0, SectionFound = 0, StringTablePtr = 0;
  short int index1 = 0;
  FILE* TmpFilePtr;
  unsigned short int SecIndex = 0;
  char ScnName[30];
  unsigned long TempContainer = 0, SecSizes = 0;

  /*filling the fields of the header*/
  FileHdr.f_magic = 49407; /*0xc0ff*/ 
  FileHdr.f_timdat = 0;
  /*FileHdr.f_symptr = 0;*/
  FileHdr.f_nsyms = 0;
  FileHdr.f_opthdr = 0;
  FileHdr.f_flags = 1; /*relocation info stripped from file*/
  
  SecIndex = (unsigned short)SectionIndex /*global*/;

  /*calculating the value of the f_nscns, including subsections*/
  while(index < SectionIndex /*global*/) {

    /*opening a file connection to the file at hand*/
    if((TmpFilePtr = fopen(Sections[index].FileName_, "rb")) == NULL) {
      printf("Error: Error in opening file connection to file %s.\n", 
	     Sections[index].FileName_);
      return 1; 
    }

    rewind(TmpFilePtr);

    /*reading the file header*/
    fread(&TmpFileHdr, 20, 1, TmpFilePtr);

    /*loop that finds the right section header*/
    index1 = 0;
    SectionFound = 0;
    while(index1 < TmpFileHdr.f_nscns) {
      /*reading the section header*/
      fread(&TmpSecHdr, 40, 1, TmpFilePtr);

      /*saving the name to ScnName*/
      if(TmpSecHdr.s_name[0] == 0x5c) {    /*to the string table*/
	
	index7 = 0;
	while (index7 < 7) {
	  ScnName[index7] = TmpSecHdr.s_name[index7+1];
	  index7 = index7 + 1;
	}
	
	StringTablePtr = C_StringToInt(ScnName);       /*to integer*/
	C_GetStringName(Sections[index].FileName_, ScnName, 
			StringTablePtr);
	
      } else {    /*name's length is under 8 chars*/
	
	index7 = 0;
	ScnName[index7] = TmpSecHdr.s_name[index7];
	while(index7 <= 7 && ScnName[index7] != 0) {
	  index7 = index7 + 1;
	  ScnName[index7] = TmpSecHdr.s_name[index7];
	} 
	
	ScnName[index7] = '\0';
	
      }

      /*ScnName contains the name of the section*/
      if(!C_CmpStr(ScnName, Sections[index].SecName_)) { /*same*/
	SectionFound = 1;
	break;
      } else {
	index1 = index1 + 1;
      }

    }

    if(SectionFound == 1) {
      /*TmpSecHdr contains the right section*/
      SecSizes = SecSizes + TmpSecHdr.s_size;
      TempContainer = 0;
      TempContainer = TmpSecHdr.s_flags >> 8;
      TempContainer = TempContainer & 65535;
      /*TempContainer contains the amount of subsections*/
      SecIndex = SecIndex + TempContainer;
    } else {
      printf("Error: Could not find section %s in file %s.\n", 
	     Sections[index].SecName_, Sections[index].FileName_);
      return 1;
    }

    fclose(TmpFilePtr);
    index = index + 1;
  }

  /*saving the number of sections and writing the header to the 
   target file*/
  FileHdr.f_nscns = SecIndex;
  FileHdr.f_symptr = 20 + SecIndex*40 + SecSizes;

  if((fwrite(&FileHdr, 20, 1, TargetFilePtr)) != 1) {
    printf("Error: Unable to write the file header to the targetfile.\n");
    return 1;
  }

  return 0;

}

/*returns 0 if everything goes fine and 1 if not*/
int C_WriteSectionHeaders() {

  FILHDR TmpFileHdr;
  SCNHDR TmpSecHdr;
  SCNHDR SecHdr;
  int index = 0, index7 = 0, SectionFound = 0, StringTablePtr = 0;
  int StrTblPtr = 0, index3 = 0;
  short int index1 = 0, index2 = 0;
  FILE* TmpFilePtr;
  char ScnName[30];
  unsigned long TempContainer = 0, SectionPointer = 0, Offset = 0;
  unsigned long int Offset1 = 0;

  while(index < SectionIndex/*global*/) {

    /*opening a file connection to the file at hand*/
    if((TmpFilePtr = fopen(Sections[index].FileName_, "rb")) == NULL) {
      printf("Error: Error in opening file connection to file %s.\n", 
	     Sections[index].FileName_);
      return 1; 
    }

    rewind(TmpFilePtr);

    /*reading the file header*/
    fread(&TmpFileHdr, 20, 1, TmpFilePtr);
    Offset = 20 + ((TmpFileHdr.f_nscns)*40);

    /*loop that finds the right section header*/
    index1 = 0;
    SectionFound = 0;
    while(index1 < TmpFileHdr.f_nscns) {
      /*reading the section header*/
      fread(&TmpSecHdr, 40, 1, TmpFilePtr);

      /*saving the name to ScnName*/
      if(TmpSecHdr.s_name[0] == 0x5c) {    /*to the string table*/
	
	index7 = 0;
	while (index7 < 7) {
	  ScnName[index7] = TmpSecHdr.s_name[index7+1];
	  index7 = index7 + 1;
	}
	
	StringTablePtr = C_StringToInt(ScnName);       /*to integer*/
	C_GetStringName(Sections[index].FileName_, ScnName, 
			StringTablePtr);
	
      } else {    /*name's length is under 8 chars*/
	
	index7 = 0;
	ScnName[index7] = TmpSecHdr.s_name[index7];
	while(index7 <= 7 && ScnName[index7] != 0) {
	  index7 = index7 + 1;
	  ScnName[index7] = TmpSecHdr.s_name[index7];
	} 
	
	ScnName[index7] = '\0';
	
      }

      /*ScnName contains the name of the section*/
      if(!C_CmpStr(ScnName, Sections[index].SecName_)) { /*same*/
	SectionFound = 1;
	break;
      } else {
	index1 = index1 + 1;
      }

    }

    if(SectionFound == 1) {
      /*TmpSecHdr contains the right section header*/

      /*let's make some modifications to the header before writing*/
      TmpSecHdr.s_relptr = 0;
      TmpSecHdr.s_lnnoptr = 0;
      TmpSecHdr.s_nreloc = 0;
      TmpSecHdr.s_nlnno = 0;
      TmpSecHdr.s_vaddr = 0;

      /*s_paddr field will contain the run time address of the section*/
      TmpSecHdr.s_paddr = Sections[index].RunTimeAddr_;

      /*calculating the section pointer*/
      TmpSecHdr.s_scnptr = Offset + SectionPointer;

      /*if the name is in the string table..*/
      /*ScnName contains the name in EVERY case*/
      if(TmpSecHdr.s_name[0] == 0x5c) {
	
	/*saving the string table offset to the s_name variable*/
	C_SaveStrTblOffset(TempStringTable.StrTblLength_, TmpSecHdr.s_name);
	
	index2 = 0;
	while(ScnName[index2] != '\0') {
	  TempStringTable.StrTbl_[(TempStringTable.StrTblLength_) - 4 + 
				  index2] = ScnName[index2];
	  index2 = index2 + 1;
	}
	
	/*adding '\0' too to the end*/
	TempStringTable.StrTbl_[(TempStringTable.StrTblLength_) - 4 +
				index2] = ScnName[index2];

	/*updating the string table length*/
        TempStringTable.StrTblLength_ = TempStringTable.StrTblLength_ +
          C_FindStringLength(ScnName);

      }
            
      /*writing the main section header to the target file*/
      if((fwrite(&TmpSecHdr, 40, 1, TargetFilePtr)) != 1) {
	printf("Error: Unable to write the section header to the");
	printf(" targetfile.\n");
	return 1;
      }

      TempContainer = 0;
      /*finding out if it has subsections*/
      TempContainer = TmpSecHdr.s_flags >> 8;
      TempContainer = TempContainer & 65535; /*0xffff*/

      /*Tempcontainer contains the amount of subsections*/
      Offset1 = 0;
      while(TempContainer > 0) {
	/*reading the subsection header..*/
	fread(&SecHdr, 40, 1, TmpFilePtr);

	/*making some modifications*/
	SecHdr.s_relptr = 0;
	SecHdr.s_lnnoptr = 0;
	SecHdr.s_nreloc = 0;
	SecHdr.s_nlnno = 0;
	SecHdr.s_vaddr = 0;
	SecHdr.s_paddr = 0;  /*need not to fill the run time address*/
	
	SecHdr.s_scnptr = Offset + SectionPointer + Offset1;
	Offset1 = Offset1 + SecHdr.s_size;

	/*if the name is in the string table..*/
	if(SecHdr.s_name[0] == 0x5c) {

	  /*saving the string table offset to the s_name variable*/
	  C_SaveStrTblOffset(TempStringTable.StrTblLength_, SecHdr.s_name);

	  index3 = 0;
	  while (index3 < 7) {
	    ScnName[index3] = SecHdr.s_name[index3+1];
	    index3 = index3 + 1;
	  }
      
	  ScnName[index3] = '\0';
      
	  StrTblPtr = C_StringToInt(ScnName);  /*turning into an integer*/
	  C_GetStringName(Sections[index].FileName_, ScnName, StrTblPtr);

	  index2 = 0;
	  while(ScnName[index2] != '\0') {
	    TempStringTable.StrTbl_[(TempStringTable.StrTblLength_) - 4 +
				    index2] = ScnName[index2];
	    index2 = index2 + 1;
	  }

	  /*adding '\0' too to the end*/
	  TempStringTable.StrTbl_[(TempStringTable.StrTblLength_) - 4 +
				  index2] = ScnName[index2];

	  /*updating the string table length*/
	  TempStringTable.StrTblLength_ = TempStringTable.StrTblLength_ +
	    C_FindStringLength(ScnName);

	}

	/*..and writing it to the target file*/
	if((fwrite(&SecHdr, 40, 1, TargetFilePtr)) != 1) {
	  printf("Error: Unable to write subsection header to the ");
	  printf("targetfile.\n");
	  return 1;
	}

	TempContainer = TempContainer - 1;
      }

      SectionPointer = SectionPointer + TmpSecHdr.s_size;

    } else {
      printf("Error: Could not find section %s in file %s.\n", 
	     Sections[index].SecName_, Sections[index].FileName_);
      return 1;
    }

    fclose(TmpFilePtr);
    index = index + 1;

  }

  return 0;
}

/*finds out the length of the string given as a parameter, including 
 '\0'*/
int C_FindStringLength(char String[]) {

  int index = 0;
  while(String[index] != '\0' ) {
    index = index + 1;
  }

  index = index + 1;
  return index;
}

/*turns the offset into a string and places it into the SecName table*/
void C_SaveStrTblOffset(int offset, char SecName[]) {

  int tempoffset = 0;
  
  tempoffset = offset;
  SecName[0] = 0x5c;
  
  SecName[7] = tempoffset & 255; /*11111111 binary*/
  tempoffset = tempoffset >> 8;
  
  SecName[6] = tempoffset & 255;
  tempoffset = tempoffset >> 8;

  SecName[5] = tempoffset & 255;
  tempoffset = tempoffset >> 8;

  SecName[4] = tempoffset & 255;

  SecName[3] = 0;
  SecName[2] = 0;
  SecName[1] = 0;
}
