/* COFFEE-specific support for 32-bit ELF
   Copyright 2005, 2006 Free Software Foundation, Inc.

   This file is part of BFD, the Binary File Descriptor library.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

#include "bfd.h"
#include "sysdep.h"
#include "libbfd.h"
#include "elf-bfd.h"
#include "elf/coffee.h"



/* Apply R_COFFEE_LO16 and R_COFFEE_HI16 relocs.  */

static bfd_reloc_status_type
coffee_elf_ld16_reloc (bfd *abfd, arelent *reloc_entry, asymbol *symbol,
                       void *data, asection *input_section,
                       bfd *output_bfd, char **error_message)
{
  bfd_vma relocation = 0;
  bfd_vma insn = 0;

  /* If this is a relocatable link (output_bfd test tells us), just
     call the generic function.  Any adjustment will be done at final
     link time.  */
  if (output_bfd != NULL)
    return bfd_elf_generic_reloc (abfd, reloc_entry, symbol, data,
                                  input_section, output_bfd, error_message);

  if (reloc_entry->address > bfd_get_section_limit (abfd, input_section))
    return bfd_reloc_outofrange;

  /* Get symbol value.  */
  if (!bfd_is_com_section (symbol->section))
    relocation = symbol->value;

  relocation += symbol->section->output_section->vma;
  relocation += symbol->section->output_offset;
  relocation += reloc_entry->addend;

  /* Select the correct half of the value, place the MSB as the LSB,
     and position the final relocation as specified.  */
  relocation >>= (bfd_vma) reloc_entry->howto->rightshift;
  relocation = ((relocation & 0x7fff) << 1) | ((relocation >> 15) & 0x1);
  relocation <<= (bfd_vma) reloc_entry->howto->bitpos;

  /* Read in the data to be relocated and apply the relocation.  */
  insn = bfd_get_32 (abfd, (bfd_byte *) data + reloc_entry->address);
  insn &= ~reloc_entry->howto->dst_mask;
  insn |= relocation & reloc_entry->howto->dst_mask;
  bfd_put_32 (abfd, insn, (bfd_byte *) data + reloc_entry->address);
  return bfd_reloc_ok;
}

/* Values of type 'enum elf_coffee_reloc_type' are used to index this
   array, so it must be declared in the order of that type.  */
static reloc_howto_type coffee_elf_howto_table[] =
{
  /* This reloc does nothing.  */
  HOWTO (R_COFFEE_NONE,		/* type */
	 0,			/* rightshift */
	 0,			/* size (0 = byte, 1 = short, 2 = long) */
	 0,			/* bitsize */
	 FALSE,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_dont, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_COFFEE_NONE",	/* name */
	 FALSE,			/* partial_inplace */
	 0,			/* src_mask */
	 0x00000000,		/* dst_mask */
	 FALSE),		/* pcrel_offset */

  /* A 32 bit absolute relocation.  */
  HOWTO (R_COFFEE_ADDR32,	/* type */
	 0,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 32,			/* bitsize */
	 FALSE,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_dont, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_COFFEE_ADDR32",	/* name */
	 FALSE,			/* partial_inplace */
	 0,			/* src_mask */
	 0xffffffff,		/* dst_mask */
	 FALSE),		/* pcrel_offset */
 
  /* A 32 bit PC-relative relocation.  */
  HOWTO (R_COFFEE_REL32,	/* type */
	 0,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 32,			/* bitsize */
	 TRUE,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_dont, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_COFFEE_REL32",	/* name */
	 FALSE,			/* partial_inplace */
	 0,			/* src_mask */
	 0xffffffff,		/* dst_mask */
	 TRUE),			/* pcrel_offset */

  /* Low 16 bits of symbol value.  */
  HOWTO (R_COFFEE_LO16,		/* type */
	 0,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 16,			/* bitsize */
	 FALSE,			/* pc_relative */
	 9,			/* bitpos */
	 complain_overflow_dont, /* complain_on_overflow */
	 coffee_elf_ld16_reloc,	/* special_function */
	 "R_COFFEE_LO16",	/* name */
	 FALSE,			/* partial_inplace */
	 0,			/* src_mask */
	 0x01fffe00,		/* dst_mask */
	 FALSE),		/* pcrel_offset */

  /* High 16 bits of symbol value.  */
  HOWTO (R_COFFEE_HI16,		/* type */
	 16,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 16,			/* bitsize */
	 FALSE,			/* pc_relative */
	 9,			/* bitpos */
	 complain_overflow_dont, /* complain_on_overflow */
	 coffee_elf_ld16_reloc,	/* special_function */
	 "R_COFFEE_HI16",	/* name */
	 FALSE,			/* partial_inplace */
	 0,			/* src_mask */
	 0x01fffe00,		/* dst_mask */
	 FALSE),		/* pcrel_offset */

  /* A 22 bit COFFEE branch.  */
  HOWTO (R_COFFEE_BR22,		/* type */
	 1,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 22,			/* bitsize */
	 TRUE,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_signed, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_COFFEE_BR22",	/* name */
	 FALSE,			/* partial_inplace */
	 0,			/* src_mask */
	 0x003fffff,		/* dst_mask */
	 TRUE),			/* pcrel_offset */

  /* A 25 bit COFFEE jump.  */
  HOWTO (R_COFFEE_JMP25,	/* type */
	 1,			/* rightshift */
	 2,			/* size (0 = byte, 1 = short, 2 = long) */
	 25,			/* bitsize */
	 TRUE,			/* pc_relative */
	 0,			/* bitpos */
	 complain_overflow_signed, /* complain_on_overflow */
	 bfd_elf_generic_reloc,	/* special_function */
	 "R_COFFEE_JMP25",	/* name */
	 FALSE,			/* partial_inplace */
	 0,			/* src_mask */
	 0x01ffffff,		/* dst_mask */
	 TRUE)			/* pcrel_offset */
};

/* Map BFD reloc types to COFFEE ELF reloc types.  */

static reloc_howto_type *
coffee_elf_reloc_type_lookup (bfd *abfd ATTRIBUTE_UNUSED,
                              bfd_reloc_code_real_type code)
{
  /* Note that the coffee_elf_howto_table is indexed by the R_
     constants.  Thus, the order that the howto records appear in the
     table *must* match the order of the relocation types defined in
     include/elf/coffee.h.  */

  switch (code)
    {
    case BFD_RELOC_NONE:
      return &coffee_elf_howto_table[ (int) R_COFFEE_NONE];
    case BFD_RELOC_32:
      return &coffee_elf_howto_table[ (int) R_COFFEE_ADDR32];
    case BFD_RELOC_32_PCREL:
      return &coffee_elf_howto_table[ (int) R_COFFEE_REL32];
    case BFD_RELOC_LO16:
      return &coffee_elf_howto_table[ (int) R_COFFEE_LO16];
    case BFD_RELOC_HI16:
      return &coffee_elf_howto_table[ (int) R_COFFEE_HI16];
    case BFD_RELOC_COFFEE_BRANCH:
      return &coffee_elf_howto_table[ (int) R_COFFEE_BR22];
    case BFD_RELOC_COFFEE_JUMP:
      return &coffee_elf_howto_table[ (int) R_COFFEE_JMP25];

    default:
      break;
    }
  return NULL;
}

/* Retrieve a howto ptr using an internal relocation entry.  */

static void
coffee_elf_info_to_howto (bfd *abfd ATTRIBUTE_UNUSED,
                          arelent *cache_ptr,
                          Elf_Internal_Rela *dst)
{
  unsigned int r_type = ELF32_R_TYPE (dst->r_info);
  BFD_ASSERT (r_type < (unsigned int) R_COFFEE_max);
  cache_ptr->howto = &coffee_elf_howto_table[r_type];
}

/* Perform a single relocation.  By default we use the standard BFD
   routines, when possible.  */

static bfd_reloc_status_type
coffee_final_link_relocate (reloc_howto_type *howto,
                            bfd *input_bfd,
                            asection *input_section,
                            bfd_byte *contents,
                            Elf_Internal_Rela *rel,
                            bfd_vma relocation)
{
  bfd_reloc_status_type r = bfd_reloc_ok;
  bfd_vma insn;

  switch (ELF32_R_TYPE (rel->r_info))
    {
    case R_COFFEE_LO16:
    case R_COFFEE_HI16:
      relocation += rel->r_addend;

      /* Select the correct half of the value, place the MSB as the LSB,
         and position the final relocation as specified.  */
      relocation >>= (bfd_vma) howto->rightshift;
      relocation = ((relocation & 0x7fff) << 1) | ((relocation >> 15) & 0x1);
      relocation <<= (bfd_vma) howto->bitpos;

      /* Read in the data to be relocated and apply the relocation.  */
      insn = bfd_get_32 (input_bfd, contents + rel->r_offset);
      insn &= ~howto->dst_mask;
      insn |= relocation & howto->dst_mask;
      bfd_put_32 (input_bfd, insn, contents + rel->r_offset);
      break;

    default:
      r = _bfd_final_link_relocate (howto, input_bfd, input_section,
                                    contents, rel->r_offset,
                                    relocation, rel->r_addend);
      break;
    }

  return r;
}

/* The RELOCATE_SECTION function is called by the new ELF backend linker
   to handle the relocations for a section.

   The relocs are always passed as Rela structures; if the section
   actually uses Rel structures, the r_addend field will always be
   zero.

   This function is responsible for adjusting the section contents as
   necessary, and (if using Rela relocs and generating a relocatable
   output file) adjusting the reloc addend as necessary.

   This function does not have to worry about setting the reloc
   address or the reloc symbol index.

   LOCAL_SYMS is a pointer to the swapped in local symbols.

   LOCAL_SECTIONS is an array giving the section in the input file
   corresponding to the st_shndx field of each local symbol.

   The global hash table entry for the global symbols can be found
   via elf_sym_hashes (input_bfd).

   When generating relocatable output, this function must handle
   STB_LOCAL/STT_SECTION symbols specially.  The output symbol is
   going to be the section symbol corresponding to the output
   section, which means that the addend must be adjusted
   accordingly.  */

static bfd_boolean
coffee_elf_relocate_section (bfd *output_bfd ATTRIBUTE_UNUSED,
                             struct bfd_link_info *info,
                             bfd *input_bfd,
                             asection *input_section,
                             bfd_byte *contents,
                             Elf_Internal_Rela *relocs,
                             Elf_Internal_Sym *local_syms,
                             asection **local_sections)
{
  Elf_Internal_Shdr *symtab_hdr;
  struct elf_link_hash_entry **sym_hashes;
  Elf_Internal_Rela *rel;
  Elf_Internal_Rela *relend;

  if (info->relocatable)
    return TRUE;

  symtab_hdr = &elf_tdata (input_bfd)->symtab_hdr;
  sym_hashes = elf_sym_hashes (input_bfd);

  relend = relocs + input_section->reloc_count;
  for (rel = relocs; rel < relend; rel++)
    {
      int r_type;
      unsigned long r_symndx;
      reloc_howto_type *howto;
      struct elf_link_hash_entry *h;
      Elf_Internal_Sym *sym;
      asection *sec;
      const char *sym_name;
      bfd_vma relocation;
      bfd_reloc_status_type r;

      r_type = ELF32_R_TYPE (rel->r_info);
      r_symndx = ELF32_R_SYM (rel->r_info);
      howto = coffee_elf_howto_table + r_type;

      h = NULL;
      sym = NULL;
      sec = NULL;

      if (r_symndx < symtab_hdr->sh_info)
        {
          sym = local_syms + r_symndx;
          sec = local_sections[r_symndx];
          sym_name = bfd_elf_sym_name (input_bfd, symtab_hdr, sym, sec);
          relocation = _bfd_elf_rela_local_sym (output_bfd, sym, &sec, rel);
        }
      else
        {
          bfd_boolean unresolved_reloc, warned;
          RELOC_FOR_GLOBAL_SYMBOL (info, input_bfd, input_section, rel,
                                   r_symndx, symtab_hdr, sym_hashes,
                                   h, sec, relocation,
                                   unresolved_reloc, warned);
          sym_name = h->root.root.string;

          if (unresolved_reloc)
            {
              (*_bfd_error_handler)
                (_("%B(%s+0x%lx): unresolvable %s relocation against symbol `%s'"),
                input_bfd,
                bfd_get_section_name (input_bfd, input_section),
                (long) rel->r_offset,
                howto->name,
                sym_name);
              return FALSE;
            }
        }

      r = coffee_final_link_relocate (howto, input_bfd, input_section,
                                      contents, rel, relocation);

      if (r != bfd_reloc_ok)
        {
          const char *msg = NULL;

          switch (r)
            {
            case bfd_reloc_overflow:
              r = info->callbacks->reloc_overflow
                (info, (h ? &h->root : NULL), sym_name, howto->name,
                 (bfd_vma) 0, input_bfd, input_section, rel->r_offset);
              break;

            case bfd_reloc_undefined:
              r = info->callbacks->undefined_symbol
                (info, sym_name, input_bfd, input_section,
                 rel->r_offset, TRUE);
              break;

            case bfd_reloc_outofrange:
              msg = _("internal error: out of range error");
              break;

            case bfd_reloc_notsupported:
              msg = _("internal error: unsupported relocation error");
              break;

            case bfd_reloc_dangerous:
              msg = _("internal error: dangerous relocation error");
              break;

            default:
              msg = _("internal error: unknown relocation error");
              break;
            }

          if (msg)
            r = info->callbacks->warning
              (info, msg, sym_name, input_bfd, input_section, rel->r_offset);

          if (!r)
            return FALSE;
        }
    }

  return TRUE;
}

#define TARGET_BIG_SYM			bfd_elf32_coffee_vec
#define TARGET_BIG_NAME			"elf32-coffee"

#define ELF_ARCH			bfd_arch_coffee
#define ELF_MACHINE_CODE		EM_COFFEE
#define ELF_MAXPAGESIZE			1

#define bfd_elf32_bfd_reloc_type_lookup	coffee_elf_reloc_type_lookup
#define elf_info_to_howto		coffee_elf_info_to_howto

#define elf_backend_relocate_section	coffee_elf_relocate_section
#define elf_backend_rela_normal		1

#include "elf32-target.h"
