/* tc-coffee.h -- Header file for tc-coffee.c.
   Copyright 2005, 2006 Free Software Foundation, Inc.

   This file is part of GAS, the GNU Assembler.

   GAS is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GAS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GAS; see the file COPYING.  If not, write to the Free
   Software Foundation, 51 Franklin Street - Fifth Floor, Boston, MA
   02110-1301, USA.  */

/* Documentation for the GAS backend interface can be found in the file
   "internals.texi". The comments below originate mostly from there.  */

/* By convention, you should define this macro in the @file{.h} file.
   For example, @file{tc-m68k.h} defines @code{TC_M68K}.  You might have to
   use this if it is necessary to add CPU specific code to the object format
   file.  */
#define TC_COFFEE

/* This macro is the BFD architecture to pass to @code{bfd_set_arch_mach}.  */
#define TARGET_ARCH bfd_arch_coffee

/* This macro is the BFD machine number to pass to @code{bfd_set_arch_mach}.
   If it is not defined, GAS will use 0.  */
//#define TARGET_MACH 0

/* This macro is the BFD target name to use when creating the output file.
   This will normally depend upon the @code{OBJ_@var{FMT}} macro.  */
#define TARGET_FORMAT "elf32-coffee"

/* You should define this macro to be non-zero if the target is big endian,
   and zero if the target is little endian.  */
#define TARGET_BYTES_BIG_ENDIAN 1

/* This should just call either @code{number_to_chars_bigendian} or
   @code{number_to_chars_littleendian}, whichever is appropriate.
   On targets like the MIPS which support options to change the endianness,
   which function to call is a runtime decision.  On other targets,
   @code{md_number_to_chars} can be a simple macro.  */
#define md_number_to_chars number_to_chars_bigendian

/* If you define this macro, GAS will warn about the use of nonstandard
   escape sequences in a string.  */
//#define ONLY_STANDARD_ESCAPES

/* Permit temporary numeric labels.  */
#define LOCAL_LABELS_FB 1

/* .-foo gets turned into PC relative relocs.  */
#define DIFF_EXPR_OK

/* We don't need to handle .word strangely.  */
#define WORKING_DOT_WORD

/* Values passed to md_apply_fix don't include the symbol value.  */
#define MD_APPLY_SYM_VALUE(FIX) 0

/* Keep relocations relative to the GOT, or non-PC relative.  */
//#define tc_fix_adjustable(FIX) coffee_fix_adjustable (FIX)

/* Fixup expressions against a symbol in the current section
   are not forced to emit relocs.  */
//#define TC_FORCE_RELOCATION_LOCAL(FIX) 0

/* No shared lib support, so we don't need to ensure externally
   visible symbols can be overridden.  */
//#define EXTERN_FORCE_RELOC 0

/* Call md_pcrel_from_section(), not md_pcrel_from().  */
//#define MD_PCREL_FROM_SECTION(FIX, SEC) md_pcrel_from_section (FIX, SEC)
//extern long md_pcrel_from_section PARAMS ((struct fix *, segT));

/* A string to use on the header line of a listing.
   The default value is simply @code{"GAS LISTING"}.  */
#define LISTING_HEADER "COFFEE GAS"

/* The number of bytes to put into a word in a listing.  This affects the way
   the bytes are clumped together in the listing.  For example, a value of 2
   might print @samp{1234 5678} where a value of 1 would print
   @samp{12 34 56 78}.  The default value is 4.  */
//#define LISTING_WORD_SIZE 4
/* The number of words of data to print on the first line of a listing for a
   particular source line, where each word is @code{LISTING_WORD_SIZE} bytes.
   The default value is 1.  */
//#define LISTING_LHS_WIDTH 1
/* Like @code{LISTING_LHS_WIDTH}, but applying to the second and subsequent
   line of the data printed for a particular source line.
   The default value is 1.  */
//#define LISTING_LHS_WIDTH_SECOND 4
/* The maximum number of continuation lines to print in a listing for
   a particular source line.  The default value is 4.  */
//#define LISTING_LHS_CONT_LINES 4
/* The maximum number of characters to print from one line of the input file.
   The default value is 100.  */
//#define LISTING_RHS_WIDTH 100
