/* COFFEE ELF support for BFD.
   Copyright 2005, 2006 Free Software Foundation, Inc.

   This file is part of BFD, the Binary File Descriptor library.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

#ifndef _ELF_COFFEE_H
#define _ELF_COFFEE_H

#include "elf/reloc-macros.h"

/* Relocations  --  elf32-coffee.c depends on these being consecutive.  */
START_RELOC_NUMBERS (elf_coffee_reloc_type)
  RELOC_NUMBER (R_COFFEE_NONE, 0)
  RELOC_NUMBER (R_COFFEE_ADDR32, 1)
  RELOC_NUMBER (R_COFFEE_REL32, 2)
  RELOC_NUMBER (R_COFFEE_LO16, 3)
  RELOC_NUMBER (R_COFFEE_HI16, 4)
  RELOC_NUMBER (R_COFFEE_BR22, 5)
  RELOC_NUMBER (R_COFFEE_JMP25, 6)
END_RELOC_NUMBERS (R_COFFEE_max)

#endif /* _ELF_COFFEE_H */
