/* coffee.h -- Header file for COFFEE opcode and register tables
   Copyright 2005, 2006 Free Software Foundation, Inc.
   
   This file is part of GDB, GAS, and the GNU binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

/* The COFFEE opcode table (and other related data) is defined in
   the opcodes library in coffee-opc.c.  If you change anything here, make
   sure you fix up that file, and vice versa.  */

#ifndef COFFEE_H
#define COFFEE_H

/* Registers.  */
#define MAX_REG		31
#define MAX_CREG	7
#define MAX_COPREG	31
#define MAX_MILKREG	31

/* Opcode attribute flags.  */
#define F_CEX		1	/* conditionally executable */
#define F_BRANCH	2	/* branch instruction */
#define F_SHIFT		4	/* shift instruction */
#define F_MILK		8	/* milk-coprocessor instruction */

/* Macros for setting insn opcode in correct format.  */
#define OP(x)		((unsigned) ((x) & 0x3f) << 26) /* opcode field */
#define RD(x)		(((x) & 0x1f) << 0)  /* dreg field */
#define RA(x)		(((x) & 0x1f) << 5) /* sreg1 field */
#define RB(x)		(((x) & 0x1f) << 10) /* sreg2 field */
#define CEX(x)		(((x) & 0x1) << 25) /* conditional execution bit */
#define SM(x)		(((x) & 0x1) << 18) /* shift mode select bit */

#define OPC_MASK	OP(0x3F) /* mask for opcode field */
#define NOP		0xE800E800 /* NOP insn */

/* The structure used to hold information for an opcode.  */
struct coffee_opcode
{
  const char *name;
  unsigned long opcode;
  const char *args;
  char flags;
};
extern const struct coffee_opcode coffee_opcodes[];
extern const struct coffee_opcode milk_opcodes[];

/* The structure for registers.  */
struct coffee_reg
{
  const char *name;
  unsigned int value;
};
extern const struct coffee_reg coffee_regs[];
extern const struct coffee_reg milk_regs[];

/* The structure for condition codes.  */
struct coffee_condcode
{
  const char *cond;
  unsigned int code;
};
extern const struct coffee_condcode coffee_condcodes[];

#define SIGNED_EXTRACT(insn,size,pos) (((int)((insn) << (32-size-pos))) >> (32-size))
#define UNSIGNED_EXTRACT(insn,size,pos) (((insn) >> pos) & ((1 << size)-1))

#endif
