#ifndef _ARITH_OPER_H
#define _ARITH_OPER_H

//Function that performs 32*32bit = 64 bit unsigned multiplication
unsigned long multiply_32bit(unsigned long operand1,unsigned long operand2, 
			     unsigned long& mresult_hi);

// Function to convert signed number to unsigned format
unsigned long convert_sign_unsign( signed long operand);

//Function to convert unsigned multiplication result to signed format
signed long mult_signed(int sign, unsigned long mult_result_lo, unsigned long mult_result_hi, signed long& mult_res_sign_hi);

//Function add performs the adding operation 
long add(long operand1, long operand2, bool& overflow, bool& underflow, int& C,int& Z , int& N, bool& addr_oflow);

//Function sub performs the substract operation 
long sub(long operand1, long operand2, bool& overflow, bool& underflow, int& C,int& Z , int& N, bool cmp_opr );

//Function and performs bitwise and operation
unsigned long and_f(unsigned long operand1, unsigned long operand2);

//Function or performs bitwise or operation
unsigned long or_f(unsigned long operand1, unsigned long operand2);

//Function xor performs bitwise xor operation
unsigned long xor_f(unsigned long operand1, unsigned long operand2);

//Function not performs bitwise not operation
unsigned long not_f(unsigned long operand);

//Function conb performs concatenate operation
unsigned long conb(unsigned long operand1, unsigned long operand2);

//Function conh performs concatenate operation
unsigned long conh(unsigned long operand1, unsigned long operand2);

//Function exb performs a bitfield extraction operation
unsigned long exb(unsigned long operand1, unsigned long operand2);

//Function exbfi performs a bitfield extraction operation
unsigned long exbf(unsigned long operand1, unsigned long operand2);

//Function exh performs a halfword extraction operation
unsigned long exh(unsigned long operand1, unsigned int select);

//Function that performs power calculation(not an instruction)
unsigned long power(unsigned long operand1, unsigned long powe);

//Function sext performs a sign extension operation
unsigned long sext(unsigned long operand1, unsigned int position);

//Function sll performs shift left logical operation
unsigned long sll(unsigned long operand1, unsigned long operand2, int& Z, int& N , int& C);

//Function srl performs shift right logical operation
unsigned long srl(unsigned long operand1, unsigned long operand2);

//Function sra performs shift right arithmetic operation
unsigned long sra(unsigned long operand1, unsigned int amount);




#endif
