// Core Control Block window
// Copyright (C) 2004  Tuukka Kasanko
// tuukka.kasanko@tut.fi
// Tampere University of Technology
// Institute of Digital and Computer Systems
// PO BOX 553
// FIN-33101 Tampere
// Finland
 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// --------------------------------------------------------------------------
// Revision history:
//  7.10.2004  Radix selection implemented.
// --------------------------------------------------------------------------

#include <iostream>
#include "ccb.h"
#include <string>


ccb::ccb()
{
  set_title("Core Control Block");
  set_border_width(0);
  set_default_size(400, 800);

  add(m_ScrolledWindow);

  // Add the ccb tree view with the popup window.
  m_ScrolledWindow.add(myTreeView);

  m_ScrolledWindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  show_all_children();
}


ccb::~ccb()
{
}


// Set a value to a CCB register.
void ccb::set_value(unsigned int regnum, unsigned long value)
{
  myTreeView.set_value(regnum, value);
}


