// A TreeView with popup and radix selection for the CCB window.

#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
// #include <cmath>
#include "arith_oper.h"
#include "ccbtreeview.hh"



ccbTreeView::ccbTreeView()
{

  // Create the Tree model:
  m_refTreeModel = Gtk::ListStore::create(m_Columns);
  set_model(m_refTreeModel);

  //Fill the TreeView's model
  Gtk::TreeModel::Row row;

  // Create rows for registers and set values
  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "0h";
  row[m_Columns.m_name] = "CCB_BASE";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "1h";
  row[m_Columns.m_name] = "REGSPC_END";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "2h";
  row[m_Columns.m_name] = "COP0_INT_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "3h";
  row[m_Columns.m_name] = "COP1_INT_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "4h";
  row[m_Columns.m_name] = "COP2_INT_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "5h";
  row[m_Columns.m_name] = "COP_3_INT_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "6h";
  row[m_Columns.m_name] = "EXT_INT0_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "7h";
  row[m_Columns.m_name] = "EXT_INT1_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "8h";
  row[m_Columns.m_name] = "EXT_INT2_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "9h";
  row[m_Columns.m_name] = "EXT_INT3_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "Ah";
  row[m_Columns.m_name] = "EXT_INT4_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "Bh";
  row[m_Columns.m_name] = "EXT_INT5_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "Ch";
  row[m_Columns.m_name] = "EXT_INT6_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "Dh";
  row[m_Columns.m_name] = "EXT_INT7_VEC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "Eh";
  row[m_Columns.m_name] = "INT_MODE_IL";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "Fh";
  row[m_Columns.m_name] = "INT_MODE_UM";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "10h";
  row[m_Columns.m_name] = "INT_MASK";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "11h";
  row[m_Columns.m_name] = "INT_SERV";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "12h";
  row[m_Columns.m_name] = "INT_PEND";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "13h";
  row[m_Columns.m_name] = "EXT_INT_PRI";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "14h";
  row[m_Columns.m_name] = "COP_INT_PRI";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "15h";
  row[m_Columns.m_name] = "EXCEPTION_CS";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "16h";
  row[m_Columns.m_name] = "EXCEPTION_PC";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "17h";
  row[m_Columns.m_name] = "EXCEPTION_PSR";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "18h";
  row[m_Columns.m_name] = "DMEM_BOUND_LO";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "19h";
  row[m_Columns.m_name] = "DMEM_BOUND_HI";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "1Ah";
  row[m_Columns.m_name] = "IMEM_BOUND_LO";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "1Bh";
  row[m_Columns.m_name] = "IMEM_BOUND_HI";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "1Ch";
  row[m_Columns.m_name] = "MEMP_CONF";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "1Dh";
  row[m_Columns.m_name] = "SYSTEM_ADDR";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "1Eh";
  row[m_Columns.m_name] = "EXCEP_ADDR";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "1Fh";
  row[m_Columns.m_name] = "BUS_CONF";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "20h";
  row[m_Columns.m_name] = "COP_CONF";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "21h";
  row[m_Columns.m_name] = "TMR0_CNT";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "22h";
  row[m_Columns.m_name] = "TMR0_MAX_CNT";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "23h";
  row[m_Columns.m_name] = "TMR1_CNT";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "24h";
  row[m_Columns.m_name] = "TMR1_MAX_CNT";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "25h";
  row[m_Columns.m_name] = "TMR_CONF";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "26h";
  row[m_Columns.m_name] = "RETI_ADDR";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "27h";
  row[m_Columns.m_name] = "RETI_PSR";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  row = *(m_refTreeModel->append());
  row[m_Columns.m_offset] = "28h";
  row[m_Columns.m_name] = "RETI_CR0";
  row[m_Columns.m_value] = "0";
  row[m_Columns.m_reg_radix] = "unsigned";

  // Add the TreeView's view columns:
  append_column("Offset", m_Columns.m_offset);
  append_column("Name", m_Columns.m_name);
  append_column("Value", m_Columns.m_value);
  append_column("Radix", m_Columns.m_reg_radix);

  // Fill popup menu
  {
    Gtk::Menu::MenuList& menulist = m_Menu_Popup.items();
    menulist.push_back( Gtk::Menu_Helpers::MenuElem("binary",
      SigC::slot(*this, &ccbTreeView::on_popup_binary) ) );

    menulist.push_back( Gtk::Menu_Helpers::MenuElem("unsigned",
      SigC::slot(*this, &ccbTreeView::on_popup_decimal) ) );

    menulist.push_back( Gtk::Menu_Helpers::MenuElem("signed",
      SigC::slot(*this, &ccbTreeView::on_popup_signed) ) );

    menulist.push_back( Gtk::Menu_Helpers::MenuElem("hexadecimal",
      SigC::slot(*this, &ccbTreeView::on_popup_hexadecimal) ) );
  }

  m_Menu_Popup.accelerate(*this);

}


ccbTreeView::~ccbTreeView()
{
}


bool ccbTreeView::on_button_press_event(GdkEventButton* event)
{
  // Call base class, to allow normal handling,
  // such as allowing the row to be selected by the right-click:
  bool return_value = TreeView::on_button_press_event(event);

  // Then do our custom stuff:
  if( (event->type == GDK_BUTTON_PRESS) && (event->button == 3) )
  {
    m_Menu_Popup.popup(event->button, event->time);
  }

  return return_value;
}


// Set the value of the register.
void ccbTreeView::set_value(unsigned int regnum, unsigned long value)
{

  // parameter 'value' casted to unsigned.
  unsigned int unsigned_value = static_cast<unsigned int>(value);

  Gtk::TreeModel::Children children = m_refTreeModel->children();
  // iter points to the first row.
  Gtk::TreeModel::Children::iterator iter = children.begin();
  // Find the right row
  for(unsigned int i = 0; i < regnum; i++){
    iter++;
  }
  // Put the elements to the row
  Gtk::TreeModel::Row row = *iter;

  std::ostringstream my_stream;

  // Select between signed and unsigned representation.
  if((row[m_Columns.m_reg_radix] == "signed"))
  {
    my_stream << value;
  }
  else
  {
    my_stream << unsigned_value;
  }

  Glib::ustring my_string;
  my_string = my_stream.str();

  // If radix is binary, convert the given value into binary before assignment.
  if((row[m_Columns.m_reg_radix] == "bin"))
  {
    dec_to_bin(my_string);    
  }

  // If radix is hexadecimal, convert the given value before assignment.
  if((row[m_Columns.m_reg_radix] == "hex"))
  {
    dec_to_bin(my_string);
    Glib::ustring temp_str2 = "";
    Glib::ustring sub_str = "";
    for(int i = 0; i < 8; i++)
    {
      sub_str = my_string.substr((4*i),4);
      temp_str2 += bin_to_hex(sub_str);
    }
    my_string = temp_str2;
  }

  row[m_Columns.m_value] = my_string;

}


// Signal handler for selecting binary representation.
void ccbTreeView::on_popup_binary()
{

  Glib::RefPtr<Gtk::TreeView::Selection> refSelection = get_selection();
  if(refSelection)
  {
    Gtk::TreeModel::iterator iter = refSelection->get_selected();
    if(iter)
    {
      Glib::ustring radix_val = (*iter)[m_Columns.m_reg_radix];

      // If radix already binary, do nothing.
      if(radix_val == "bin")
      {
	return;
      }

      Glib::ustring temp_str = (*iter)[m_Columns.m_value];

      if(radix_val == "unsigned")
      {
	dec_to_bin(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "bin";
      }

      if(radix_val == "signed")
      {
	signed_to_bin(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "bin";
      }

      if(radix_val == "hex")
      {
	hex_to_bin(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "bin";
      }
    }
  }

}


// Signal handler for selecting decimal representation.
void ccbTreeView::on_popup_decimal()
{

  int number = 0;
  Glib::RefPtr<Gtk::TreeView::Selection> refSelection = get_selection();
  if(refSelection)
  {
    Gtk::TreeModel::iterator iter = refSelection->get_selected();
    if(iter)
    {
      Glib::ustring radix_val = (*iter)[m_Columns.m_reg_radix];

      // If radix already decimal, do nothing.
      if(radix_val == "unsigned")
      {
	return;
      }

      Glib::ustring temp_str = (*iter)[m_Columns.m_value];

      if(radix_val == "bin")
      {
	bin_to_dec(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "unsigned";
      }

      if(radix_val == "signed")
      {
	signed_to_bin(temp_str);
	bin_to_dec(temp_str);	
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "unsigned";
      }

      if(radix_val == "hex")
      {      
	hex_to_bin(temp_str);
	bin_to_dec(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "unsigned";
      }
    }
  }

}


// Signal handler for selecting hexadecimal representation.
void ccbTreeView::on_popup_signed()
{

  int number = 0;
  Glib::RefPtr<Gtk::TreeView::Selection> refSelection = get_selection();
  if(refSelection)
  {
    Gtk::TreeModel::iterator iter = refSelection->get_selected();
    if(iter)
    {
      Glib::ustring radix_val = (*iter)[m_Columns.m_reg_radix];

      // If radix already signed, do nothing.
      if(radix_val == "signed")
      {
	return;
      }

      Glib::ustring temp_str = (*iter)[m_Columns.m_value];

      if(radix_val == "bin")
      {
	bin_to_signed(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "signed";
      }

      if(radix_val == "unsigned")
      {
	dec_to_bin(temp_str);
	bin_to_signed(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "signed";
      }

      if(radix_val == "hex")
      {      
	hex_to_bin(temp_str);
	bin_to_signed(temp_str);
	(*iter)[m_Columns.m_value] = temp_str;
	(*iter)[m_Columns.m_reg_radix] = "signed";
      }
    }
  }

}


// Signal handler for selecting hexadecimal representation.
void ccbTreeView::on_popup_hexadecimal()
{
  Glib::RefPtr<Gtk::TreeView::Selection> refSelection = get_selection();
  if(refSelection)
  {
    Gtk::TreeModel::iterator iter = refSelection->get_selected();
    if(iter)
    {
      Glib::ustring radix_val = (*iter)[m_Columns.m_reg_radix];

      // If radix already hexadecimal, do nothing.
      if(radix_val == "hex")
      {
	return;
      }

      Glib::ustring temp_str = (*iter)[m_Columns.m_value];

      if(radix_val == "bin")
      {
	Glib::ustring temp_str2 = "";
	Glib::ustring sub_str = "";
	for(int i = 0; i < 8; i++)
	{
	  sub_str = temp_str.substr((4*i),4);
	  temp_str2 += bin_to_hex(sub_str);
	}
	(*iter)[m_Columns.m_value] = temp_str2;
	(*iter)[m_Columns.m_reg_radix] = "hex";
      }

      if(radix_val == "unsigned")
      {
	dec_to_bin(temp_str);

	Glib::ustring temp_str2 = "";
	Glib::ustring sub_str = "";
	for(int i = 0; i < 8; i++)
	{
	  sub_str = temp_str.substr((4*i),4);
	  temp_str2 += bin_to_hex(sub_str);
	}
	(*iter)[m_Columns.m_value] = temp_str2;
	(*iter)[m_Columns.m_reg_radix] = "hex";
      }

      if(radix_val == "signed")
      {
	signed_to_bin(temp_str);

	Glib::ustring temp_str2 = "";
	Glib::ustring sub_str = "";
	for(int i = 0; i < 8; i++)
	{
	  sub_str = temp_str.substr((4*i),4);
	  temp_str2 += bin_to_hex(sub_str);
	}
	(*iter)[m_Columns.m_value] = temp_str2;
	(*iter)[m_Columns.m_reg_radix] = "hex";
      }

    }
  }

}


// Returns a hexadecimal character corresponding to the four bit string.
// Does not modify the passed string.
char ccbTreeView::bin_to_hex(Glib::ustring& value)
{

  if( value == "0000" )
    return '0';
  if( value == "0001" )
    return '1';
  if( value == "0010" )
    return '2';
  if( value == "0011" )
    return '3';
  if( value == "0100" )
    return '4';
  if( value == "0101" )
    return '5';
  if( value == "0110" )
    return '6';
  if( value == "0111" )
    return '7';
  if( value == "1000" )
    return '8';
  if( value == "1001" )
    return '9';
  if( value == "1010" )
    return 'a';
  if( value == "1011" )
    return 'b';
  if( value == "1100" )
    return 'c';
  if( value == "1101" )
    return 'd';
  if( value == "1110" )
    return 'e';
  if( value == "1111" )
    return 'f';

  return 'X';

}


// Convert binary to decimal
void ccbTreeView::bin_to_dec(Glib::ustring& binary)
{

  unsigned int index = 0;
  unsigned int number = 0;
  for(unsigned int i = 31; i > 0; i--)
  {
    if(binary.at(i) == '1')
    {
      number += power(2, index);
    }
    index += 1;
  }

  if(binary.at(0) == '1')
  {
    number += power(2, 31);
  }

  // Convert integer to string
  std::ostringstream my_stream;
  my_stream << number;
  std::string my_string;
  my_string = my_stream.str();
  binary = my_string;

}


// Convert binary to unsigned.
void ccbTreeView::bin_to_signed(Glib::ustring& binary)
{

  unsigned int index = 0;
  int number = 0;
  for(unsigned int i = 31; i > 0; i--)
  {
    if(binary.at(i) == '1')
    {
      number += power(2, index);
    }
    index += 1;
  }

  if(binary.at(0) == '1')
  {
    number += power(2, 31);
  }

  // Convert integer to string
  std::ostringstream my_stream;
  my_stream << number;
  std::string my_string;
  my_string = my_stream.str();
  binary = my_string;

}


// Convert decimal to binary.
void ccbTreeView::dec_to_bin(Glib::ustring& decimal)
{

  std::istringstream str(decimal);
  unsigned int number = 0;
  str >> number;

  std::string temp_str = "";
  for(int i=0; i < 32; i++) {
    if((number & power(2,31-i))  != 0) { 
      temp_str = temp_str + '1';
    }else{
      temp_str = temp_str + '0';
    }
  } 

  decimal = temp_str;

}


// Convert signed to binary.
void ccbTreeView::signed_to_bin(Glib::ustring& decimal)
{



  std::istringstream str(decimal);
  unsigned int number = 0;
  str >> number;

  std::string temp_str = "";
  for(int i=0; i < 32; i++) {
    if((number & power(2,31-i))  != 0) { 
      temp_str = temp_str + '1';
    }else{
      temp_str = temp_str + '0';
    }
  } 

  decimal = temp_str;

}


// Convert hexadecimal to binary.
void ccbTreeView::hex_to_bin(Glib::ustring& hexadecimal)
{

  Glib::ustring::value_type one_char = 'g';
  std::string temp_str = "";

  for(int i = 0; i < 8; i++)
  {
    one_char = hexadecimal.at(i);
    switch(one_char)
    {
    case '0':
      temp_str += "0000";
      break;
    case '1':
      temp_str += "0001";
      break;
    case '2':
      temp_str += "0010";
      break;
    case '3':
      temp_str += "0011";
      break;
    case '4':
      temp_str += "0100";
      break;
    case '5':
      temp_str += "0101";
      break;
    case '6':
      temp_str += "0110";
      break;
    case '7':
      temp_str += "0111";
      break;
    case '8':
      temp_str += "1000";
      break;
    case '9':
      temp_str += "1001";
      break;
    case 'a':
      temp_str += "1010";
      break;
    case 'b':
      temp_str += "1011";
      break;
    case 'c':
      temp_str += "1100";
      break;
    case 'd':
      temp_str += "1101";
      break;
    case 'e':
      temp_str += "1110";
      break;
    case 'f':
      temp_str += "1111";
      break;
    }    
  }

  hexadecimal = temp_str;

}

