// Condition Register window
// Copyright (C) 2004  Tuukka Kasanko
// tuukka.kasanko@tut.fi
// Tampere University of Technology
// Institute of Digital and Computer Systems
// PO BOX 553
// FIN-33101 Tampere
// Finland
  
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
  
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <iostream>
#include "cond_registers.h"
#include <string>


cond_registers::cond_registers()
{
  set_title("Condition Register Values");
  set_border_width(0);
  set_default_size(280, 230);

  add(m_ScrolledWindow);

  m_ScrolledWindow.add(m_TreeView);

  m_ScrolledWindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  // Create the Tree model:
  m_refTreeModel = Gtk::ListStore::create(m_Columns);
  m_TreeView.set_model(m_refTreeModel);

  //Fill the TreeView's model
  Gtk::TreeModel::Row row;

  // Create rows for registers and initialize values to zero.
  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C0";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C1";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C2";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C3";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C4";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C5";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C6";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "C7";
  row[m_Columns.m_reg_value] = 0;

  row = *(m_refTreeModel->append());
  row[m_Columns.m_reg_id] = "PC";
  row[m_Columns.m_reg_value] = 0;

  // Add the TreeView's view columns:
  m_TreeView.append_column("Register", m_Columns.m_reg_id);
  m_TreeView.append_column("Value", m_Columns.m_reg_value);

  show_all_children();
}


cond_registers::~cond_registers()
{
}


void cond_registers::set_value(unsigned int regnum, int value)
{
  
  Gtk::TreeModel::Children children = m_refTreeModel->children();
  // iter points to the first row.
  Gtk::TreeModel::Children::iterator iter = children.begin();
  // Find the right row
  for(unsigned int i = 0; i < regnum; i++){
    iter++;
  }
  // Put the elements to the row
  Gtk::TreeModel::Row row = *iter;
  // Set the value
  row[m_Columns.m_reg_value] = value;
}


int cond_registers::get_value(unsigned int regnum)
{

  Gtk::TreeModel::Children children = m_refTreeModel->children();
  // iter points to the first row.
  Gtk::TreeModel::Children::iterator iter = children.begin();
  // Find the right row
  for(unsigned int i = 0; i < regnum; i++){
    iter++;
  }
  // row has the elements
  Gtk::TreeModel::Row row = *iter;
  
  int number = row[m_Columns.m_reg_value];


  return number;
}
