#ifndef COND_REGISTERS_H
#define COND_REGISTERS_H

#include <gtkmm.h>


class cond_registers : public Gtk::Window
{
 public:
  cond_registers();
  virtual ~cond_registers();
  // Get a value of a register
  int get_value(unsigned int regnum);
  // Set a value to a register
  void set_value(unsigned int regnum, int value);

 protected:
  // Tree model columns
  class ModelColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:
    ModelColumns()
    {
      add(m_reg_id);
      add(m_reg_value);
    }
    
    // Gtk::TreeModelColumn<int> m_reg_id;
    Gtk::TreeModelColumn<Glib::ustring> m_reg_id;
    Gtk::TreeModelColumn<int> m_reg_value;

  };

  ModelColumns m_Columns;

  Gtk::ScrolledWindow m_ScrolledWindow;
  Gtk::TreeView m_TreeView;
  Glib::RefPtr<Gtk::ListStore> m_refTreeModel;
};

#endif
