// Coprocessor register window
// Copyright (C) 2004  Tuukka Kasanko
// tuukka.kasanko@tut.fi
// Tampere University of Technology
// Institute of Digital and Computer Systems
// PO BOX 553
// FIN-33101 Tampere
// Finland
  
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
  
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <iostream>
#include "copros_registers.h"
#include <string>


copros_registers::copros_registers()
{
  set_title("Coprocessor Registers");
  set_border_width(0);
  set_default_size(800, 800);

  add(m_ScrolledWindow);

  m_ScrolledWindow.add(m_TreeView);

  m_ScrolledWindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  // Create the Tree model:
  m_refTreeModel = Gtk::ListStore::create(m_Columns);
  m_TreeView.set_model(m_refTreeModel);

  //Fill the TreeView's model
  Gtk::TreeModel::Row row;

  // Create rows for registers and initialize values to zero.
  for(unsigned int i = 0; i < 32 ; i++){
    row = *(m_refTreeModel->append());

    row[m_Columns.m_copros0_reg_id] = i;
    row[m_Columns.m_copros0_reg_value] = 0;

    row[m_Columns.m_copros1_reg_id] = i;
    row[m_Columns.m_copros1_reg_value] = 0;

    row[m_Columns.m_copros2_reg_id] = i;
    row[m_Columns.m_copros2_reg_value] = 0;

    row[m_Columns.m_copros3_reg_id] = i;
    row[m_Columns.m_copros3_reg_value] = 0;
  }

  // Add the TreeView's view columns:
  m_TreeView.append_column("Copros0 Register", m_Columns.m_copros0_reg_id);
  m_TreeView.append_column("Value", m_Columns.m_copros0_reg_value);

  m_TreeView.append_column("Copros1 Register", m_Columns.m_copros1_reg_id);
  m_TreeView.append_column("Value", m_Columns.m_copros1_reg_value);

  m_TreeView.append_column("Copros2 Register", m_Columns.m_copros2_reg_id);
  m_TreeView.append_column("Value", m_Columns.m_copros2_reg_value);

  m_TreeView.append_column("Copros3 Register", m_Columns.m_copros3_reg_id);
  m_TreeView.append_column("Value", m_Columns.m_copros3_reg_value);

  show_all_children();
}


copros_registers::~copros_registers()
{
}


// Set a value to a register
void copros_registers::set_value(unsigned int copros_number, unsigned int register_number, unsigned long reg_value)
{
  // Get the rows
  Gtk::TreeModel::Children children = m_refTreeModel->children();
  // iter points to the first row.
  Gtk::TreeModel::Children::iterator iter = children.begin();
  // Find the right row
  for(unsigned int i = 0; i < register_number; i++){
    iter++;
  }
  // Put the elements to the row
  Gtk::TreeModel::Row row = *iter;

  // Find the column and set the value
  switch(copros_number){
  case 0:
    row[m_Columns.m_copros0_reg_value] = reg_value;
    break;
  case 1:
    row[m_Columns.m_copros1_reg_value] = reg_value;
    break;
  case 2:
    row[m_Columns.m_copros2_reg_value] = reg_value;
    break;
  case 3:
    row[m_Columns.m_copros3_reg_value] = reg_value;
  }
}


// Get a value from a register
unsigned long copros_registers::get_value(unsigned int copros_number, unsigned int register_number)
{
  // Get the rows
  Gtk::TreeModel::Children children = m_refTreeModel->children();
  // iter points to the first row.
  Gtk::TreeModel::Children::iterator iter = children.begin();
  // Find the right row
  for(unsigned int i = 0; i < register_number; i++){
    iter++;
  }
  // row has the elements
  Gtk::TreeModel::Row row = *iter;

  switch (copros_number){
  case 0:
    return row[m_Columns.m_copros0_reg_value];
  case 1:
    return row[m_Columns.m_copros1_reg_value];
  case 2:
    return row[m_Columns.m_copros2_reg_value];
  case 3:
    return row[m_Columns.m_copros3_reg_value];
  }
}

