#ifndef COPROS_REGISTERS_H
#define COPROS_REGISTERS_H

#include <gtkmm.h>


class copros_registers : public Gtk::Window
{
 public:
  copros_registers();
  virtual ~copros_registers();

  // Set a value to a register
  void set_value(unsigned int copros_number, unsigned int register_number, unsigned long reg_value);

  // Get a value from a register
  unsigned long get_value(unsigned int copros_number, unsigned int register_number);

 protected:
  // Tree model columns
  class ModelColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:
    ModelColumns()
    {
      add(m_copros0_reg_id);
      add(m_copros0_reg_value);

      add(m_copros1_reg_id);
      add(m_copros1_reg_value);

      add(m_copros2_reg_id);
      add(m_copros2_reg_value);

      add(m_copros3_reg_id);
      add(m_copros3_reg_value);
    }
    
    Gtk::TreeModelColumn<unsigned int> m_copros0_reg_id;
    Gtk::TreeModelColumn<unsigned long> m_copros0_reg_value;

    Gtk::TreeModelColumn<unsigned int> m_copros1_reg_id;
    Gtk::TreeModelColumn<unsigned long> m_copros1_reg_value;

    Gtk::TreeModelColumn<unsigned int> m_copros2_reg_id;
    Gtk::TreeModelColumn<unsigned long> m_copros2_reg_value;

    Gtk::TreeModelColumn<unsigned int> m_copros3_reg_id;
    Gtk::TreeModelColumn<unsigned long> m_copros3_reg_value;
  };

  ModelColumns m_Columns;

  Gtk::ScrolledWindow m_ScrolledWindow;
  Gtk::TreeView m_TreeView;
  Glib::RefPtr<Gtk::ListStore> m_refTreeModel;

};

#endif
