// Data Memory Window of the ISS
// Copyright (C) 2004  Tuukka Kasanko
// tuukka.kasanko@tut.fi
// Tampere University of Technology
// Institute of Digital and Computer Systems
// PO BOX 553
// FIN-33101 Tampere
// Finland
 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// --------------------------------------------------------------------------
// Revision history:
// 9.9.2004   store corrected.
// --------------------------------------------------------------------------


#include "dissassembler.h"
#include <iostream>
#include "data_mem_window.h"
#include <string>
#include <fstream>
#include "memory_models.h"

data_mem_window::data_mem_window()
{
  set_title("Data Memory Content");
  set_border_width(0);
  set_default_size(300, 600);

  add(m_ScrolledWindow);

  m_ScrolledWindow.add(m_TreeView);

  m_ScrolledWindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  // Create the Tree model:
  m_refTreeModel = Gtk::ListStore::create(m_Columns);
  m_TreeView.set_model(m_refTreeModel);

  // Add the TreeView's view columns:
  m_TreeView.append_column("Address", m_Columns.m_addr);
  m_TreeView.append_column("Data", m_Columns.m_data);

  show_all_children();
}


data_mem_window::~data_mem_window()
{
}


// "Store data" to the window 
void data_mem_window::store(unsigned long address, std::string data)
{

  bool data_inserted = false;

  // Get the kids
  Gtk::TreeModel::Children children = m_refTreeModel->children();
  // iter points to the first row.
  Gtk::TreeModel::Children::iterator iter = children.begin();

  // Put the elements to a row
  Gtk::TreeModel::Row row = *iter;
  // Gtk::TreeModel::Row previous_row = *iter;

  // Let's try to find the row containing the address
  while(row != children.end()){
    // If address maches with an existing one, replace the data
    if(row[m_Columns.m_addr] == address){
      row[m_Columns.m_data] = data;
      data_inserted = true;
      break;
    }
    // If address does not match, place the data into the righ slot.
    if(row[m_Columns.m_addr] > address){
      row = *(m_refTreeModel->insert(row));
      row[m_Columns.m_addr] = address;
      row[m_Columns.m_data] = data;      
      data_inserted = true;
      break;      
    }
    row++;
  }

  // If data was not inserted, append a new slot and put it there.
  if(!data_inserted){
    row = *(m_refTreeModel->append());
    row[m_Columns.m_addr] = address;
    row[m_Columns.m_data] = data;
  }

}


// Initialize the window with the map.
void data_mem_window::initialize(std::map<unsigned long,std::string>* p_data_memory_map){

  std::map<unsigned long,std::string>::iterator iter = p_data_memory_map->begin();
  Gtk::TreeModel::Row row;
  std::string line = "";

  while(iter != p_data_memory_map->end()){
    row = *(m_refTreeModel->append());
    row[m_Columns.m_addr] = (*iter).first;
    line = (*iter).second;
    row[m_Columns.m_data] = line;
    ++iter;
  }
}


// Clear the window == remove everything from the window.
void data_mem_window::clear(){
  m_refTreeModel->clear();
}




