#ifndef DATA_MEM_WINDOW_H
#define DATA_MEM_WINDOW_H

#include <gtkmm.h>
#include <string>


class data_mem_window : public Gtk::Window
{
 public:
  data_mem_window();
  virtual ~data_mem_window();

  // Initialize the window with the map.
  void initialize(std::map<unsigned long,std::string>* p_data_memory_map);

  // Display data in the data memory window
  void store(unsigned long address, std::string data);

  // Remove everything from the window
  void clear();

 protected:
  // Tree model columns
  class ModelColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:
    ModelColumns()
    {
      add(m_addr);
      add(m_data);
    }
    
    Gtk::TreeModelColumn<unsigned long> m_addr;
    Gtk::TreeModelColumn<Glib::ustring> m_data;
  };

 private:
  ModelColumns m_Columns;
  Gtk::ScrolledWindow m_ScrolledWindow;
  Gtk::TreeView m_TreeView;
  Glib::RefPtr<Gtk::ListStore> m_refTreeModel;
};

#endif
