// Dissassembler for the COFFEE RISC core
// Tampere University of Technology
// Institute of Digital and Computer Systems
// PO BOX 553
// FIN-33101 Tampere
// Finland
  
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
  
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include <string>
#include <iostream>
#include <cstdlib>
#include <cmath>
#include <fstream>
#include <iomanip>
#include <sstream>
using namespace std;
#include "dissassembler.h"
#include "coffee_model.h"
#include "arith_oper.h"

string give_register_number(string value) {
  unsigned long temp= 0;
  int string_length = value.length() - 1;
  ostringstream temp2; 
  for ( int i = string_length; i>=0;i--) {
    if (value[i] == '1') {
      temp = temp + power(2,string_length-i);
    } else {
      temp = temp;
    }
  }
  temp2 <<temp;
  return temp2.str();
}
  
string give_negative_number(string value) {
  long temp= 0;
  int string_length = value.length() - 1;
  ostringstream temp2; 
  for ( int i = string_length; i>=0;i--) {
    if (value[i] == '1') {
      temp = temp + power(2,string_length-i);
    } else {
      temp = temp;
    }
  }
  temp = temp<< 31-string_length;
  temp = temp >> 31-string_length;
  temp2 <<temp;
  return temp2.str();
}



string get_condional_int_number(string cond,string conditional_value, string unconditional_value, bool negative_possible) {

  if(cond=="1"){
    if(conditional_value[0] == '1' && negative_possible){
      return give_negative_number(conditional_value);
    }else{
      return give_register_number(conditional_value);
    }
  }else{
    if(unconditional_value[0] =='1' && negative_possible){
      return give_negative_number(unconditional_value);
    }else{
      return give_register_number(unconditional_value);
    }
  }
}


string give_registers_and_immediates(INSTRUCTIONS inst, string bitinst) {
  // number -1 means that no register operands in instruction
  string temp = ""; 
  string condition = "";
  int mode = 0;
  if(bitinst.length() > 16){
    mode = 32;
  }else{
    mode = 16;
  }
  switch (inst) {
    case ADD:
      if(mode == 32) {
	temp  = "r" +  give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" +  give_register_number("11"+  bitinst.substr(13,3));
	temp += ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   
     
    case ADDI:

      if(mode == 32) {
        condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp += ", " + get_condional_int_number(condition,bitinst.substr(13,9),bitinst.substr(7,15) ,true);
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
 	temp += ", " + get_condional_int_number("0",bitinst.substr(6,7),bitinst.substr(6,7) ,true);
   
      }
      return temp;
      break;

    case ADDIU:

      if(mode == 32) {
	condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp += ", " + get_condional_int_number(condition,bitinst.substr(13,9),bitinst.substr(7,15) ,false);
	
      }else{
	temp  = "r" +  give_register_number("11"+  bitinst.substr(13,3));
	temp += ", " + get_condional_int_number("0",bitinst.substr(6,7),bitinst.substr(6,7) ,false);
      }
      return temp;
      break;

    case ADDU :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case AND :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
        temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case ANDI :
      if(mode == 32) {
	condition = bitinst[6];
        temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp += ", " + get_condional_int_number(condition,bitinst.substr(13,9),bitinst.substr(7,15) ,false);
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp += ", " + get_condional_int_number("0",bitinst.substr(6,7),bitinst.substr(6,7) ,false);
      }
      return temp;
      break;
     

    case BC :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp += ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp += get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;
 
    case BEGT :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp += ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp += get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case BELT :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp += ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp += get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case BEQ :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp += ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp += get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case BGT:
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp += ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp += get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case BLT :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp += ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp += get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case BNE :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp +=  ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp += get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;
    
    case BNC :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp +=  ", " +get_condional_int_number(condition,bitinst.substr(10,22),bitinst.substr(10,22) ,true);
	
      }else{
	temp +=  get_condional_int_number("1",bitinst.substr(6,10),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case CHRS :
      if(mode == 32) {
	condition = bitinst[6];
	temp +=  get_condional_int_number(condition,bitinst.substr(20,2),bitinst.substr(20,2) ,false);
	
      }else{
	temp += get_condional_int_number("0",bitinst.substr(11,2),bitinst.substr(11,2) ,false);
      }
      return temp;
      break;

    case CMP :

      if(mode == 32) {
        temp  = "c" + give_register_number(bitinst.substr(7,3));    
	temp  += ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{

	temp  = "r" + give_register_number("11" + bitinst.substr(6,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(13,3));
      }
      return temp;
      break;

    case CMPI :

      if(mode == 32) {
	condition = bitinst[6];
	temp  = "c" + give_register_number(bitinst.substr(7,3));
	temp  += ", r" + give_register_number(bitinst.substr(22,5));
        string combined = bitinst.substr(27,5) + bitinst.substr(10,12); 
        temp +=  ", " + get_condional_int_number(condition,combined,combined ,true);
	
	
      }else{
	temp  = "r" + give_register_number("11" + bitinst.substr(6,3));
	temp += ", " + get_condional_int_number("0",bitinst.substr(9,7),bitinst.substr(9,7) ,true);
      }
      return temp;
      break;
    case CONB :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case CONH :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case COP :
      temp += get_condional_int_number("0",bitinst.substr(6,2),bitinst.substr(6,2) ,false);
      temp += get_condional_int_number("0",bitinst.substr(8,24),bitinst.substr(8,24) ,false);
      return temp;
      break;

    case DI :

      return "";
      break;

    case EI :

      return "";
      break;

    case EXB :

      if(mode == 32) {
	condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp += ", " + get_condional_int_number(condition,bitinst.substr(20,2),bitinst.substr(20,2) ,false);
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11"+  bitinst.substr(6,3));
	temp += ", " + get_condional_int_number("0",bitinst.substr(11,2),bitinst.substr(11,2) ,false);
      }
      return temp;
      break;

    case EXBF:

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case EXBFI :
      if(mode == 32) {
	condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp += ", " + get_condional_int_number(condition,bitinst.substr(11,6),bitinst.substr(11,6) ,false);
	temp += ", " + get_condional_int_number(condition,bitinst.substr(17,5),bitinst.substr(17,5) ,false);
      }
      return temp;
      break;   

    case EXH :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
        temp += ", " + give_register_number(bitinst.substr(21,1));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11"+  bitinst.substr(6,3));
      }
      return temp;
      break;

    case JAL:
      if(mode == 32) {
	condition = bitinst[6];
        temp = get_condional_int_number(condition,bitinst.substr(7,25),bitinst.substr(7,25) ,true);
      }else{
        temp =  get_condional_int_number("0",bitinst.substr(6,25),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case JALR:
      if(mode == 32) {
        temp  = "r" + give_register_number(bitinst.substr(22,5));
      }else{
        temp  = "r" + give_register_number("11"+  bitinst.substr(6,3));
      }

      return temp;
      break;

    case JMP :
      if(mode == 32) {
	condition = bitinst[6];
        temp = get_condional_int_number(condition,bitinst.substr(7,25),bitinst.substr(7,25) ,true);
      }else{
        temp =  get_condional_int_number("0",bitinst.substr(6,25),bitinst.substr(6,10) ,true);
      }
      return temp;
      break;

    case JMPR :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(22,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(6,3));
      }
      return temp;
      break;
      

    case LD :

      if(mode == 32) {
	condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
        temp += ", " + get_condional_int_number(condition,bitinst.substr(13,9),bitinst.substr(7,15) ,true);
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11"+  bitinst.substr(6,3));
	temp += ", " + get_condional_int_number("0",bitinst.substr(9,4),bitinst.substr(9,4) ,true);
      }
      return temp;
      break;

    case LLI :

     if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", " + give_register_number(bitinst.substr(22,1) +bitinst.substr(7,15));
	
     }
     return temp;
      break;      

    case LUI :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", " + give_register_number(bitinst.substr(22,1) +bitinst.substr(7,15));
	
      }
      return temp;
      break;

    case MOV :

     if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11"+  bitinst.substr(6,3));
      }
     return temp;
      break;

    case MOVFC :

      if(mode == 32) {
        temp =  give_register_number(bitinst.substr(20,2));
        temp  += ", r" + give_register_number(bitinst.substr(27,5));
        temp  += ", cr" + give_register_number(bitinst.substr(15,5));
	
	
      }else{
	temp =  give_register_number(bitinst.substr(11,2));
	temp  += ", r" + give_register_number("11" + bitinst.substr(13,3));
        temp  += ", cr" + give_register_number(bitinst.substr(6,5));
	
      }
      return temp;
      break;

    case MOVTC :

      if(mode == 32) {
        temp =  give_register_number(bitinst.substr(20,2));
        temp  += ", cr" + give_register_number(bitinst.substr(15,5));
	temp  += ", r" + give_register_number(bitinst.substr(22,5));
	
	
      }else{
	temp =  give_register_number(bitinst.substr(14,2));
	temp  += ", cr" + give_register_number(bitinst.substr(9,5));
	temp  += ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;

    case MULHI :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
      }
      return temp;
      break;

    case MULI :

      if(mode == 32) {
	condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
        temp += ", " + get_condional_int_number(condition,bitinst.substr(13,9),bitinst.substr(7,15) ,true);
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
        temp += ", " + get_condional_int_number("0",bitinst.substr(6,7),bitinst.substr(6,7) ,true);
      }
      return temp;
      break;

    case MULS :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case MULS_16 :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
        temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case MULU :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case MULU_16 :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case MULUS :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case MULUS_16 :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case NOP :

      return "";
      return temp;
      break;

    case NOT :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11"+  bitinst.substr(6,3));
      }
      return temp;
      break;

    case OR :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case ORI :

      if(mode == 32) {
	condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp += ", " + get_condional_int_number(condition,bitinst.substr(13,9),bitinst.substr(7,15) ,false);
	
      }else{
        temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp += ", " + get_condional_int_number("0",bitinst.substr(6,7),bitinst.substr(6,7) ,true);
      }
      return temp;
      break;

    case RCON :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(22,5));
	
      }else{
	temp  = "r" +  give_register_number("11"+  bitinst.substr(6,3));
      }
      return temp;
      break;

    case RETI :

      return "";
      break;

    case RETU :

      return "";
      break;

    case SCALL:

      return "";
      break;

    case SCON :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
      }
      return temp;
      break;

    case SEXT :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" +  give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
        temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case SEXTI :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp += ", r" +  give_register_number(bitinst.substr(22,5));
        temp += ", " + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
        temp += ", " + give_register_number(bitinst.substr(8,5));
      }
      return temp;
      break;   

    case SLL :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
        temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;

    case SLLI :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", " + give_register_number(bitinst.substr(16,6));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
        temp += ", " + give_register_number(bitinst.substr(6,6));
	
      }
      return temp;
      break;   

    case SRA :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;

    case SRAI :

       if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", " + give_register_number(bitinst.substr(16,6));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
        temp += ", " + give_register_number(bitinst.substr(6,6));
	
      }
      return temp;
      break;   

    case SRL :

       if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;

   case SRLI :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", " + give_register_number(bitinst.substr(16,6));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
        temp += ", " + give_register_number(bitinst.substr(6,6));
	
      }
      return temp;
      break;   

   case ST :

      if(mode == 32) {
	condition = bitinst[6];
	temp  = "r" + give_register_number(bitinst.substr(17,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
        temp += ", " + get_condional_int_number(condition,bitinst.substr(27,5)+bitinst.substr(13,4),bitinst.substr(27,5)+bitinst.substr(7,10) ,true);
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11"+  bitinst.substr(6,3));
	temp += ", " + get_condional_int_number("0",bitinst.substr(9,4),bitinst.substr(9,4) ,true);
      }
      return temp;
      break;   

   case SUB :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case SUBU :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   

    case SWM :
      if(mode == 32) {
	temp =  give_register_number(bitinst.substr(16,6));
	
      }else{
        temp =  give_register_number(bitinst.substr(7,6));
	
      }
      return temp;
      break;

    case TRAP :
      if(mode == 32) {
	temp =  give_register_number(bitinst.substr(17,5));
	
      }else{
        temp =  give_register_number(bitinst.substr(8,5));
	
      }
      return temp;
      break;

    case XOR :

      if(mode == 32) {
	temp  = "r" + give_register_number(bitinst.substr(27,5));
	temp +=  ", r" + give_register_number(bitinst.substr(22,5));
	temp +=  ", r" + give_register_number(bitinst.substr(17,5));
	
      }else{
	temp  = "r" + give_register_number("11"+  bitinst.substr(13,3));
	temp +=  ", r" + give_register_number("11" + bitinst.substr(6,3));
      }
      return temp;
      break;   
  default:
    return "";

  }
}




INSTRUCTIONS give_instruction(string opcode, string& inst) {
  
  string temp = opcode.substr(0,6);
  int value = 0;
  int mode = 0;
  if(opcode.length() > 16){
    mode = 32;
  }else{
    mode = 16;
  }
  //Calculating number value of opcode for switch
  if(temp[0] == '1') {
    value += 32;
  }
  if(temp[1] == '1') {
    value += 16;
  }
  if(temp[2] == '1') {
    value += 8;
  }
  if(temp[3] == '1') {
    value += 4;
  }
  if(temp[4] == '1') {
    value += 2;
  }
  if(temp[5] == '1') {
    value += 1;
  }
  switch (value) {
    case 0:
      inst = "ADDU ";
      return ADDU;
    case 1:
      inst = "ADD ";
      return ADD;
    case 2:
      inst = "AND ";
      return AND;
    case 3:
      inst = "CONB ";
      return CONB;
    case 4:
      inst = "CONH ";
      return CONH;
    case 5:
      inst = "MULS ";
      return MULS;
    case 6:
      inst = "MULU ";
      return MULU;
    case 7:
      inst = "MULUS ";
      return MULUS;
    case 8:
      inst = "MULS_16 ";
      return MULS_16;
    case 9:
      inst = "MULU_16 ";
      return MULU_16;
    case 10:
      inst = "MULUS_16 ";
      return MULUS_16;
    case 11:
      inst = "OR ";
      return OR;
    case 12:
      inst = "SEXT ";
      return SEXT;
    case 13:
      if (mode == 32) {
	if (opcode[13] == '1') {
	  inst = "SLL ";
          return SLL;
        } else {
	  inst = "SLLI ";
	  return SLLI;
        }
      } else {
        if (opcode[12] == '1') {
	  inst = "SLL ";
          return SLL;
        } else {
	  inst = "SLLI ";
	  return SLLI;
        }
      }
    case 14:
      if (mode == 32) {
	if (opcode[13] == '1') {
	  inst = "SRA ";
          return SRA;
        } else {
	  inst = "SRAI ";
	  return SRAI;
	}
      } else {
        if (opcode[12] == '1') {
	  inst = "SRA ";
          return SRA;
        } else {
	  inst = "SRAI ";
	  return SRAI;
	}
      }
    case 15:
      if (mode == 32) {
	if (opcode[13] == '1') {
	  inst = "SRL ";
          return SRL;
        } else {
	  inst = "SRLI ";
	  return SRLI;
	}
      } else {
        if (opcode[12] == '1') {
	  inst = "SRL ";
          return SRL;
        } else {
	  inst = "SRLI ";
	  return SRLI;
	}
      }
    case 16:
      inst = "SUB ";
      return SUB;
    case 17:
      inst = "SUBU ";
      return SUBU;
    case 18:
      inst = "XOR ";
      return XOR;
    case 19:
      inst = "MOV ";
      return MOV;
    case 20:
      inst = "NOT ";
      return NOT;
    case 21:
      inst = "DI";
      return DI;
    case 22:
      inst = "EI";
      return EI;
    case 23:
      inst = "RETI";
      return RETI;
    case 24:
      inst = "TRAP ";
      return TRAP;
    case 25:
      inst = "CMP ";
      return CMP;
    case 26:
      inst = "EXBF ";
      return EXBF;
    case 27:
      inst = "JMPR ";
      return JMPR;
    case 28:
      inst = "SCON ";
      return SCON;
    case 29:
      inst = "MULHI ";
      return MULHI;
    case 30:
      inst = "RCON ";
      return RCON;
    case 31:
      inst = "RETU";
      return RETU;
    case 32:
      inst = "BC ";
      return BC;
    case 33:
      inst = "BEGT ";
      return BEGT;
    case 34:
      inst = "BELT ";
      return BELT;
    case 35:
      inst = "BEQ ";
      return BEQ;
    case 36:
      inst = "BGT ";
      return BGT;
    case 37:
      inst = "BLT ";
      return BLT;
    case 38:
      inst = "BNE ";
      return BNE;
    case 39:
      inst = "BNC ";
      return BNC;
    case 40:
      inst = "ADDIU ";
      return ADDIU;
    case 41:
      inst = "ANDI ";
      return ANDI;
    case 42:
      inst = "ORI ";
      return ORI;
    case 43:
      inst = "SEXTI ";
      return SEXTI;
    case 44:
      inst = "MOVFC ";
      return MOVFC;
    case 45:
      inst = "ADDI ";
      return ADDI;
    case 46:
      inst = "MULI ";
      return MULI;
    case 47:
      inst = "SWM ";
      return SWM;
    case 48:
      inst = "EXB ";
      return EXB;
    case 49:
      inst = "EXH ";
      return EXH;
    case 50:
      inst = "LD ";
      return LD;
    case 51:
      inst = "CHRS ";
      return CHRS;
    case 52:
      inst = "ST ";
      return ST;
    case 53:
      inst = "JALR ";
      return JALR;
    case 54:
      inst = "MOVTC ";
      return MOVTC;
    case 55:
      inst = "CMPI ";
      return CMPI;
    case 56:
      inst = "JMP ";
      return JMP;
    case 57:
      inst = "JAL ";
      return JAL;
    case 58:
      inst = "NOP";
      return NOP;
    case 59:
      inst = "SCALL";
      return SCALL;
    case 60:
      inst = "COP";
      return COP;
    case 61:
      inst = "EXBFI ";
      return EXBFI;
    case 62:
      inst = "LLI ";
      return LLI;
    case 63:
      inst = "LUI ";
      return LUI;
    default:
      inst = "NOP";
      return NOP;
  }
}










string dissassemble(string binary_inst) {
 
  string inst = ""; 
  INSTRUCTIONS temp = give_instruction(binary_inst,inst); 
  int mode = 0;
  if(binary_inst.length() > 16){
    mode = 32;
  }else{
    mode = 16;
  }
  inst += give_registers_and_immediates(temp,binary_inst);
  //checking if conditional exceution instruction
  if(!(temp == CHRS or temp == CMP or
      temp == CMPI or temp == COP or temp == DI or temp == EI or temp == JAL or 
      temp == JMP or temp == LLI or temp == LUI or temp == NOP or 
      temp == RCON or temp == RETI or temp == RETU or temp == SCON or 
      temp == SWM or temp == TRAP or temp == BC or temp == BEGT or temp == BELT or temp == BEQ 
     or temp == BGT or temp == BLT or temp == BNE or temp == BNC)) {
    if(mode == 32 && binary_inst[6] == '1') {
      string condition= "";
      if(binary_inst.substr(10,3) == "000") {
        condition = "c, ";
      }else if(binary_inst.substr(10,3) == "001") {
	condition = "egt, ";
      }else if(binary_inst.substr(10,3) == "010") {
	condition = "elt, ";
      }else if(binary_inst.substr(10,3) == "011") {
	condition = "eq, ";
      }else if(binary_inst.substr(10,3) == "100") {
	condition = "gt, ";
      }else if(binary_inst.substr(10,3) == "101") {
	condition = "lt, ";
      }else if(binary_inst.substr(10,3) == "110") {
	condition = "ne, ";
      }else{
	condition = "nc, ";
      }
      
      inst = "if(" + condition + "c"+ give_register_number(binary_inst.substr(7,3)) + ")   " + inst;
    }
  }
  return inst;
}

  
