// Instruction Memory Window of the ISS
// Copyright (C) 2004  Tuukka Kasanko
// tuukka.kasanko@tut.fi
// Tampere University of Technology
// Institute of Digital and Computer Systems
// PO BOX 553
// FIN-33101 Tampere
// Finland
 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// -------------------------------------------------------------------------
// Revision history:
// 22.9.2004  Popup window added which enables Setting and deleting breakpoints. 
// -------------------------------------------------------------------------


#include "dissassembler.h"
#include <iostream>
#include "inst_mem_window.h"
#include <string>
#include <fstream>
#include "treeview_withpopup.h"


inst_mem_window::inst_mem_window()
{
  set_title("Instruction Memory Content");
  set_border_width(0);
  set_default_size(300, 800);

  add(m_ScrolledWindow);

  // Add the Tree view which has a popup window
  m_ScrolledWindow.add(m_TreeView);

  m_ScrolledWindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  show_all_children();
}


inst_mem_window::~inst_mem_window()
{
}


void inst_mem_window::set_instruction(unsigned int address, std::string instruction){
  m_TreeView.set_instruction(address, instruction);
}


void inst_mem_window::select_instr(unsigned long addr){
  m_TreeView.select_instr(addr);
}


// Returns the address of the last instruction
unsigned long inst_mem_window::addr_of_last_instr(){
  return m_TreeView.addr_of_last_instr();
}


// Initialize the window with the map pointed to.
void inst_mem_window::initialize(std::map<unsigned long,std::string>* p_instr_memory_map){
  m_TreeView.initialize(p_instr_memory_map);
}


// Clear the window == remove everything from the window.
void inst_mem_window::clear(){
  m_TreeView.clear();
}


// Scroll the window so that the selected row becomes visible.
void inst_mem_window::make_visible(){
  m_TreeView.make_visible();
}


// Checks wether there is a breakpoint defined for the given address or not.
bool inst_mem_window::check_breakpoint(unsigned long addr){
  return(m_TreeView.check_breakpoint(addr));
}

