#ifndef INST_MEM_WINDOW_H
#define INST_MEM_WINDOW_H

#include <gtkmm.h>
#include <string>
#include "treeview_withpopup.h"

class inst_mem_window : public Gtk::Window
{
 public:
  inst_mem_window();
  virtual ~inst_mem_window();

  // Set instruction and address at the first row
  void set_instruction(unsigned int address, std::string instruction);

  // Select an instruction according to the given address.
  void select_instr(unsigned long addr);

  // Initialize the window with the map.
  void initialize(std::map<unsigned long,std::string>* p_instr_memory_map);

  // Clear the window == remove everything from the window.
  void clear();

  // Scroll the window so that the selected row becomes visible
  void make_visible();

  // Return the address of last instruction in the tree view
  unsigned long addr_of_last_instr();

  // Checks wether there is a breakpoint defined for the given address or not.
  bool check_breakpoint(unsigned long addr);

 private:

  Gtk::ScrolledWindow m_ScrolledWindow;
  TreeView_WithPopup m_TreeView;

};

#endif
