#ifndef MEMORY_MODELS_H
#define MEMORY_MODELS_H
#include <string>
#include <map>
#include <iostream>
#include <fstream>
#include <iomanip>


class memory_models{
 public:
   memory_models();
   ~memory_models();

   // Read in a COFF file and initialize memories from it.
   bool initialize_memories(std::string filename);

   // Initialize instruction memory from the given file
   bool initialize_inst_mem(std::string filename);

   // Clear the instruction memory.
   void clear_instr_mem();

   // Clear the data memory.
   void clear_data_mem();

   // Initialize data memory from the given file
   bool initialize_data_mem(std::string filename);   

   std::string read_instr_mem(unsigned long address); 

   std::string read_data_mem(unsigned long address);

   bool write_data_mem(unsigned long address, std::string data);

   bool is_instr_mem_file_open();

   bool is_data_mem_file_open();

   unsigned long gimme_last_updated_data_address();

   std::string gimme_last_updated_data();

   // Returns a pointer to the data memory map
   std::map<unsigned long,std::string>* data_memory_map();

   // Returns a pointer to the instruction memory map
   std::map<unsigned long,std::string>* instruction_memory_map();

 private:
   // int some;
   std::ifstream i_mem;
   std::fstream d_mem;
   // True if file has been opened, false if not.
   // Not very elegant, but it works.
   bool i_mem_file_open;
   bool d_mem_file_open;
   // unsigned long i_file_size;
   // unsigned long d_file_size;
   std::map <unsigned long, std::string> data_memory;
   std::map <unsigned long, std::string> instruction_memory;
   // Address of the data which was last updated.
   unsigned long last_updated_data_address;
   // Data which was last updated.
   std::string last_updated_data;
};
#endif
