// A TreeView with popup and radix selection for register windows.


#ifndef REGTREEVIEW_H
#define REGTREEVIEW_H

#include <gtkmm.h>

class RegTreeView : public Gtk::TreeView
{

public:
  RegTreeView();
  virtual ~RegTreeView();

  // Override Signal handler:
  virtual bool on_button_press_event(GdkEventButton *ev);

  // Get a value of a register
  // int get_value(unsigned int regnum);

  // Set all register values to zero and radix to decimal.
  void reset();

  // Set a value to a register
  void set_value(unsigned int regnum, int value);

  // Signal handler for selecting binary representation.
  void on_popup_binary();

  // Signal handler for selecting decimal representation.
  void on_popup_decimal();

  // Signal handler for selecting hexadecimal representation.
  void on_popup_hexadecimal();

  // Signal handler for selecting signed representation.
  void on_popup_signed();

  // Tree model columns
  class ModelColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:
    ModelColumns()
    {
      add(m_reg_id);
      add(m_reg_value);
      add(m_reg_radix);
    }
    
    Gtk::TreeModelColumn<int> m_reg_id;
    Gtk::TreeModelColumn<Glib::ustring> m_reg_value;
    Gtk::TreeModelColumn<Glib::ustring> m_reg_radix;

  };

private:

  // Convert a 4 bit string into a hexadecimal character
  char bin_to_hex(Glib::ustring& value);

  // Convert hexadecimal string into a binary string
  void hex_to_bin(Glib::ustring& hexadecimal);

  // Convert decimal number string into a binary string
  void dec_to_bin(Glib::ustring& decimal);

  // Convert binary string into a decimal number string
  void bin_to_dec(Glib::ustring& binary);

  void signed_to_bin(Glib::ustring& decimal);

  // Convert binary string into a signed number string
  void bin_to_signed(Glib::ustring& binary);

  ModelColumns m_Columns;

  Gtk::ScrolledWindow m_ScrolledWindow;
  Glib::RefPtr<Gtk::ListStore> m_refTreeModel;

  Glib::RefPtr<Gtk::TreeSelection> refTreeSelection;
  Glib::RefPtr<Gtk::TreeModel> p_TreeModel;
  Gtk::TreeModel::Path m_path;
  Gtk::TreeModel::iterator m_iter;
  Gtk::Menu m_Menu_Popup;

};

#endif 
