#ifndef TOPWINDOW_H
#define TOPWINDOW_H
#include "user_registers.h"
#include "su_registers.h"
#include "cond_registers.h"
#include "inst_mem_window.h"
#include "memory_models.h"
#include "dissassembler.h"
#include "coffee_model.h"
#include "copros_registers.h"
#include "ccb.h"
#include "data_mem_window.h"
#include "inst_mem_window.h"
#include <iostream>
#include <cstdlib>
#include <string>
#include <fstream>
#include <iomanip>
#include <gtkmm/button.h>
#include <gtkmm/box.h>
#include <gtkmm/window.h>
#include <sigc++/class_slot.h>
#include <glibmm.h>
#include <gtkmm/stock.h>


class topwindow : public Gtk::Window
{
 public:
  topwindow();
  virtual ~topwindow();

 private:
  bool running;
  void boot_the_model();
  void update_register_windows();
  void continuous_run();
  unsigned long previous_data_addr;
  std::string previous_data;
  // Data windows
  user_registers user_register_window;
  su_registers super_user_register_window;
  cond_registers cond_register_window;
  copros_registers copros_window;
  //  menuwindow menu_window;
  inst_mem_window instruction_memory_window;
  ccb ccb_window;
  data_mem_window data_memory_window;
  coffee_model core_model;
  memory_models memories;
  // Gdk::EventMask eventtimaski;

  // protected:
  // Buttons
  virtual void on_button_clicked(Glib::ustring data);
  virtual void on_int_button_clicked(Glib::ustring data);
  // virtual void on_open_instr_mem();
  // virtual void on_open_data_mem();
  virtual void on_open_file();
  virtual void on_quit();
  Gtk::HBox m_hbox;
  Gtk::HBox m_hbox2;
  Gtk::HBox m_hbox3;
  Gtk::VBox m_vbox;
  Gtk::MenuBar m_MenuBar;
  Gtk::Menu File, Open;  //, Save, Quit;
  Gtk::Button step, run, stop, reset; //, imemfileopen, dmemfileopen;
  Gtk::Button int0, int1, int2, int3, int4, int5, int6, int7;
  Gtk::Button cop_int0, cop_int1, cop_int2, cop_int3;
  std::string tmp_str;

};

#endif
