// A TreeView with a popup window.
// ----------------------------------------------------------------------------
// Revision history:
// 5.1.2004   select_instr-function corrected to work properly also in
//            the 16-bit mode.
// 7.1.2004   check_breakpoint-function corrected for the 16-bit mode.
// ----------------------------------------------------------------------------

#include <iostream>
#include <string>
#include <fstream>
#include "treeview_withpopup.h"
#include "dissassembler.h"

TreeView_WithPopup::TreeView_WithPopup()
{
  //Create the Tree model:
  m_refTreeModel = Gtk::ListStore::create(m_Columns);
  set_model(m_refTreeModel);

  //Add the TreeView's view columns:
  append_column("Address", m_Columns.m_inst_addr);
  append_column("Instruction", m_Columns.m_inst);
  append_column("Breakpoints", m_Columns.m_breakpoint);

  addr_of_last_instr_ = 0;

  //Fill popup menu:
  {
    Gtk::Menu::MenuList& menulist = m_Menu_Popup.items();
    menulist.push_back( Gtk::Menu_Helpers::MenuElem("Set breakpoint",
      SigC::slot(*this, &TreeView_WithPopup::on_popup_set) ) );
    menulist.push_back( Gtk::Menu_Helpers::MenuElem("Delete breakpoint",
      SigC::slot(*this, &TreeView_WithPopup::on_popup_delete) ) );
  }
  m_Menu_Popup.accelerate(*this);  

}


TreeView_WithPopup::~TreeView_WithPopup()
{
}


bool TreeView_WithPopup::on_button_press_event(GdkEventButton* event)
{
  // Call base class, to allow normal handling,
  // such as allowing the row to be selected by the right-click:
  bool return_value = TreeView::on_button_press_event(event);

  // Then do our custom stuff:
  if( (event->type == GDK_BUTTON_PRESS) && (event->button == 3) )
  {
    m_Menu_Popup.popup(event->button, event->time);
  }

  return return_value;
}


// Set a breakpoint
void TreeView_WithPopup::on_popup_set(){
  Glib::RefPtr<Gtk::TreeView::Selection> refSelection = get_selection();
  if(refSelection)
  {
    Gtk::TreeModel::iterator iter = refSelection->get_selected();
    if(iter)
    {
      unsigned int id = (*iter)[m_Columns.m_inst_addr];
      (*iter)[m_Columns.m_breakpoint] = "Breakpoint";
    }
  }
}


// Delete a breakpoint
void TreeView_WithPopup::on_popup_delete(){
  Glib::RefPtr<Gtk::TreeView::Selection> refSelection = get_selection();
  if(refSelection)
  {
    Gtk::TreeModel::iterator iter = refSelection->get_selected();
    if(iter)
    {
      unsigned int id = (*iter)[m_Columns.m_inst_addr];
      (*iter)[m_Columns.m_breakpoint] = "";
    }
  }
}


// Set instruction into the TreeView
void TreeView_WithPopup::set_instruction(unsigned int address, std::string instruction)
{
  Gtk::TreeModel::Children children = m_refTreeModel->children();
  // iter points to the first row.
  Gtk::TreeModel::Children::iterator iter = children.begin();
  // Put the elements to the row
  Gtk::TreeModel::Row row = *iter;
  // Set the instruction 
  row[m_Columns.m_inst_addr] = address;
  row[m_Columns.m_inst] = instruction;
}


// Select (highlight) an instruction
void TreeView_WithPopup::select_instr(unsigned long addr)
{

  refTreeSelection = get_selection();
  Gtk::TreeModel::Row row = m_refTreeModel->children()[(addr/4)];
  if(row){
    if(row[m_Columns.m_inst_addr] == addr){
      refTreeSelection->select(row);
    }
    else{
      while(row[m_Columns.m_inst_addr] != addr){
	row++;
      }
      refTreeSelection->select(row);
    }
  }

}


// Returns the address of the last instruction
unsigned long TreeView_WithPopup::addr_of_last_instr(){
  return addr_of_last_instr_;
}


// Initialize the window with the map pointed to.
void TreeView_WithPopup::initialize(std::map<unsigned long,std::string>* p_instr_memory_map){
  
  std::map<unsigned long,std::string>::iterator iter = p_instr_memory_map->begin();
  Gtk::TreeModel::Row row;
  std::string line = "";
  addr_of_last_instr_ = 0;

  while(iter != p_instr_memory_map->end()){
    row = *(m_refTreeModel->append());
    row[m_Columns.m_inst_addr] = (*iter).first;
    addr_of_last_instr_ = (*iter).first;
    row[m_Columns.m_breakpoint] = "";
    line = (*iter).second;
    row[m_Columns.m_inst] = dissassemble(line);    
    ++iter;
  }

}


// Clear the window == remove everything from the window.
void TreeView_WithPopup::clear(){
  addr_of_last_instr_ = 0;
  m_refTreeModel->clear();
}


// Scroll the window so that the selected row becomes visible.
void TreeView_WithPopup::make_visible(){
  // p_TreeModel = m_TreeView.get_model();
  p_TreeModel = get_model();
  m_iter = refTreeSelection->get_selected();
  m_path = p_TreeModel->get_path(m_iter);
  // m_TreeView.scroll_to_row(m_path);
  scroll_to_row(m_path);
}


// Checks wether there is a breakpoint defined for the given address or not.
bool TreeView_WithPopup::check_breakpoint(unsigned long addr){

  Gtk::TreeModel::Row row = m_refTreeModel->children()[(addr/4)];
  if(row){
    if(row[m_Columns.m_inst_addr] == addr){
      if(row[m_Columns.m_breakpoint] != ""){
	return true;
      }
      else{
	return false;
      }
    }
    else{
      while(row[m_Columns.m_inst_addr] != addr){
	row++;
      }
      if(row[m_Columns.m_breakpoint] != ""){
	return true;
      }
      else{
	return false;
      }
    }
  }

}
