// TreeView with a popup window. This class also implements the functionality
// needed in the instruction memory window.

#ifndef TREEVIEW_WITHPOPUP_H
#define TREEVIEW_WITHPOPUP_H

#include <gtkmm.h>

class TreeView_WithPopup : public Gtk::TreeView
{
public:
  TreeView_WithPopup();
  virtual ~TreeView_WithPopup();

  // Override Signal handler:
  virtual bool on_button_press_event(GdkEventButton *ev);

  // Signal handler for setting a breakpoint
  virtual void on_popup_set();

  // Signal handler for deleting a breakpoint
  virtual void on_popup_delete();

  // Set instruction and address at the first row
  void set_instruction(unsigned int address, std::string instruction);

  // Select an instruction according to the given address.
  void select_instr(unsigned long addr);

  // Initialize the window with the map.
  void initialize(std::map<unsigned long,std::string>* p_instr_memory_map);

  // Clear the window == remove everything from the window.
  void clear();

  // Scroll the window so that the selected row becomes visible
  void make_visible();

  // Return the address of last instruction in the tree view
  unsigned long addr_of_last_instr();

  // Checks wether there is a breakpoint defined for the given address or not.
  bool check_breakpoint(unsigned long addr);

  // Other widgets
  // Tree model columns
  class ModelColumns : public Gtk::TreeModel::ColumnRecord
  {
  public:
    ModelColumns()
    {
      add(m_inst_addr);
      add(m_inst);
      add(m_breakpoint);
    }
    Gtk::TreeModelColumn<unsigned int> m_inst_addr;
    Gtk::TreeModelColumn<Glib::ustring> m_inst;
    Gtk::TreeModelColumn<Glib::ustring> m_breakpoint;
  };

 private:

  ModelColumns m_Columns;

  Gtk::ScrolledWindow m_ScrolledWindow;
  // Gtk::TreeView m_TreeView;
  Glib::RefPtr<Gtk::TreeSelection> refTreeSelection;
  Glib::RefPtr<Gtk::ListStore> m_refTreeModel;
  Glib::RefPtr<Gtk::TreeModel> p_TreeModel;
  Gtk::TreeModel::Path m_path;
  Gtk::TreeModel::iterator m_iter;

  // Gtk::TreeView::Selection m_tree_selection;

  // Gtk::TreeSelection m_selection;
  Gtk::Menu m_Menu_Popup;

  //  private:
  unsigned long addr_of_last_instr_;

};

#endif 
