// User register window
// Copyright (C) 2004  Tuukka Kasanko
// tuukka.kasanko@tut.fi
// Tampere University of Technology
// Institute of Digital and Computer Systems
// PO BOX 553
// FIN-33101 Tampere
// Finland
  
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
  
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <iostream>
#include "user_registers.h"
#include <string>


user_registers::user_registers()
{
  set_title("User Registers");
  set_border_width(0);
  set_default_size(200, 800);

  add(m_ScrolledWindow);

  m_ScrolledWindow.add(myTreeView);

  m_ScrolledWindow.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

  /*
  // Create the Tree model:
  m_refTreeModel = Gtk::ListStore::create(m_Columns);
  m_TreeView.set_model(m_refTreeModel);

  //Fill the TreeView's model
  Gtk::TreeModel::Row row;

  // Create rows for registers and initialize values to zero.
  for(unsigned int i = 0; i < 32 ; i++){
    row = *(m_refTreeModel->append());
    row[m_Columns.m_reg_id] = i;
    row[m_Columns.m_reg_value] = 0;
  }

  // Add the TreeView's view columns:
  m_TreeView.append_column("Register", m_Columns.m_reg_id);
  m_TreeView.append_column("Value", m_Columns.m_reg_value);
  */

  show_all_children();
}


user_registers::~user_registers()
{
}

void user_registers::reset()
{
  myTreeView.reset();
}



void user_registers::set_value(unsigned int regnum, int value)
{
  myTreeView.set_value(regnum, value);
}


/*
int user_registers::get_value(unsigned int regnum)
{

  int number = myTreeView.get_value(regnum);

  return number;
}
*/
