;; COFFEE-risc machine description
;; Version history:    
;; 0.9  1.4.2004    By Markus Moisio    First Release
;;		 	 
;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;
;; Define attributes, copied from clipper, cris and others.
;;
;; instruction type
;;
;; unknown is temporary in order to generate 'cc clobber' until attribute
;; assignment is consistent
;;
(define_attr "type" "load,store,arith,branch,unknown,cmp,fadd,fmul,fdiv,fload,fstore,fconv,fsqrt,fcmp,fabs,fmov,fneg"
 (const_string "unknown"))

;; Condition code setting
;;
;; clobber	destroyed
;; unchanged	remains the same
;; set		set
;;
(define_attr "cc" "clobber,unchanged,set" (const_string "unchanged"))


;; For branch delay slot scheduling, taken from cris. Buggy so removed.
;;(define_attr "slottable" "no,yes,has_slot" (const_string "no"))

;;(define_delay (eq_attr "slottable" "has_slot")
;;  [(eq_attr "type" "!branch,!cmp") (nil) (nil)])


;; Functional units. Currently alu, fpu, memory. 

(define_function_unit "memory" 1 0 (eq_attr "type" "load,fload,store,fstore") 2 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fadd") 5 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fmul") 3 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fdiv") 12 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fconv") 2 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fsqrt") 11 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fcmp") 1 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fneg") 1 0)

(define_function_unit "fpu" 1 0 (eq_attr "type" "fabs") 1 0)

(define_function_unit "alu" 1 0 (eq_attr "type" "arith") 3 0)

(define_function_unit "alu" 1 0 (eq_attr "type" "branch") 3 0)

(define_function_unit "alu" 1 0 (eq_attr "type" "load") 3 0)

(define_function_unit "alu" 1 0 (eq_attr "type" "store") 3 0)

(define_function_unit "alu" 1 0 (eq_attr "type" "fload") 3 0)

(define_function_unit "alu" 1 0 (eq_attr "type" "fstore") 3 0)

(define_function_unit "alu" 1 0 (eq_attr "type" "cmp") 3 0)


;; Move patterns  


(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
	  (match_operand:DI 1 "general_operand" ""))]
""
"
{	
	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
		operands[1] = force_reg (DImode, operands[1]);
}")

(define_insn ""
  [(set (match_operand:DI 0 "memory_operand" "=o")
	(match_operand:DI 1 "register_operand" "r"))]
  ""
  "*
{
  rtx xops[4];
  xops[0] = operands[0];
  xops[1] = adj_offsettable_operand (operands[0], 4);
  xops[2] = operands[1];
  xops[3] = gen_rtx (REG, SImode, REGNO (operands[1]) + 1);
  output_asm_insn (\"st\\t%2,%0\;\\n\\tst\\t%3,%1\", xops);
  return \"\";
}"
[(set_attr "type" "store")
 (set_attr "cc" "unchanged")])


(define_insn "*movdi_internal"
  [(set (match_operand:DI 0 "register_operand" "=r,r,r")
	(match_operand:DI 1 "general_operand"   "r,n,m"))]
  ""
  "*
{
	rtx xoperands[2],yoperands[2];

	xoperands[0] = gen_rtx (REG, SImode, REGNO (operands[0]) + 1);

  	if (which_alternative == 0)		/* r -> r */
    	{
      		output_asm_insn (\"mov\\t%0,%1\", operands);
      		xoperands[1] = gen_rtx (REG, SImode, REGNO (operands[1]) + 1);
      		output_asm_insn (\"mov\\t%0,%1\", xoperands);
      		return \"\";
    	}
  	if (which_alternative == 1)		/* i -> r */
    	{
      		if (GET_CODE (operands[1]) == CONST_INT)
		{
		/*
	  		output_asm_insn (\"loadi   %1,%0\", operands);
	  		output_asm_insn (\"loadq   $0,%0\", xoperands);
		*/
	  		return \"ldri\\t%0,%1\";
		}

		if ((GET_CODE (operands[1]) == LABEL_REF) || 
			(GET_CODE (operands[1]) == SYMBOL_REF))
		{
			return \"ldra\\t%0,%a1\";
		}

		if ((GET_CODE (operands[1]) == MEM) && 
			(GET_CODE (XEXP(operands[1],0)) == SYMBOL_REF))
		{
			return \"ldra\\t%0,%a1\";
		}
	
		if ((GET_CODE (operands[1]) == CONST_DOUBLE))
	      	{
			yoperands[0] = operands[0];
      			yoperands[1] = GEN_INT (CONST_DOUBLE_HIGH (operands[1]));
      			output_asm_insn (\"ldri\\t%0,%1\", yoperands);

 	     		xoperands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
      			output_asm_insn (\"ldri\\t%0,%1\", xoperands);
      			return \"\";
		}
		/* MM: check endianess */

		abort();
	}

	if (which_alternative == 2)
	{
					/* m -> r */
		output_asm_insn (\"ld\\t%0,%1\", operands);
  		xoperands[1] = adj_offsettable_operand (operands[1], 4);
  		output_asm_insn (\"ld\\t%0,%1\", xoperands);
  		return \"\";
	}
/*
	if (which_alternative == 3)
	{
		output_asm_insn (\"st\\t%1,%0\", operands);
  		xoperands[1] = adj_offsettable_operand (operands[0], 4);
  		output_asm_insn (\"st\\t%1,%0\", xoperands);
  		return \"\";
	}
*/
}" 
[(set_attr "type" "arith,load,load")
  (set_attr "cc" "unchanged,unchanged,unchanged")])


(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	  (match_operand:SI 1 "general_operand" ""))]
""
"
{	
	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
		operands[1] = force_reg (SImode, operands[1]);
}")
 

(define_insn "*movsi_internal_hwfp"
  [(set (match_operand:SI 0 "general_operand" "=r,r,r,m,f,r,f")
	  (match_operand:SI 1 "general_operand" "r,m,i,r,f,f,r"))]
""
"*
{
 int val;
 rtx temp, symbol, offset;
 

  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
    return \"ld\\t%0,%1\";		/* mem -> reg */

  if (which_alternative == 2)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else if (GET_CODE(operands[1]) == CONST)
	{
		temp = XEXP(operands[1], 0);
		if (GET_CODE(temp) == PLUS)
		{
			symbol = XEXP(temp,0);
			offset = XEXP(temp,1);
			
			if (GET_CODE(symbol) == SYMBOL_REF)
			{
				return \"ldra\\t%0,%a1\";
			}
			else
			{
				return \"ldri\\t%0,%1\";
			}
		}
	}
	else
	{
      		val = INTVAL (operands[1]);	/* known const ->reg */

/*
		if (val < 32768  && val >= -32768)
			return \"lli\\t%0,%c1\";
      		return \"lli\\t%0,%k1\\n\\tlui\\t%0,%j1\";
*/
		return \"ldri\\t%0,%1\";
	}
    }

  if (which_alternative == 3)		/* unknown const */
    return \"st\\t%1,%0\";

  if (which_alternative == 4)
    return \"fmov\\t%0,%1\";

  if (which_alternative == 5)
    return \"movfc\\tmilk,%0,%1\";		/* reg -> freg */

  if (which_alternative == 6)
    return \"movtc\\tmilk,%0,%1\";		/* freg -> reg */

}"
[(set_attr "type" "arith,load,load,store,fmov,arith,arith")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged,unchanged,unchanged,unchanged")
;; (set_attr "slottable" "yes,yes,no,yes")
])

(define_insn "*movsi_internal_swfp"
  [(set (match_operand:SI 0 "general_operand" "=r,r,r,m")
	  (match_operand:SI 1 "general_operand" "r,m,i,r"))]
"SWFP"
"*
{
 int val;
 rtx temp, symbol, offset;
 

  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
    return \"ld\\t%0,%1\";		/* mem -> reg */

  if (which_alternative == 2)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else if (GET_CODE(operands[1]) == CONST)
	{
		temp = XEXP(operands[1], 0);
		if (GET_CODE(temp) == PLUS)
		{
			symbol = XEXP(temp,0);
			offset = XEXP(temp,1);
			
			if (GET_CODE(symbol) == SYMBOL_REF)
			{
				return \"ldra\\t%0,%a1\";
			}
			else
			{
				return \"ldri\\t%0,%1\";
			}
		}
	}
	else
	{
      		val = INTVAL (operands[1]);	/* known const ->reg */

/*
		if (val < 32768  && val >= -32768)
			return \"lli\\t%0,%c1\";
      		return \"lli\\t%0,%k1\\n\\tlui\\t%0,%j1\";
*/
		return \"ldri\\t%0,%1\";
	}
    }

  if (which_alternative == 3)		/* unknown const */
    return \"st\\t%1,%0\";

}"
[(set_attr "type" "arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
;; (set_attr "slottable" "yes,yes,no,yes")
])

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_operand" "")
	  (match_operand:HI 1 "general_operand" ""))]
""
"
{	
	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
		operands[1] = force_reg (HImode, operands[1]);
}")

(define_insn "movhi_internal"
  [(set (match_operand:HI 0 "general_operand" "=r,r,r,m")
	  (match_operand:HI 1 "general_operand" "r,m,i,r"))]
""
"*
{
 int val;

  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
    return \"ld\\t%0,%1\";		/* mem -> reg */

  if (which_alternative == 2)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF)|| 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else
	{
      		val = INTVAL (operands[1]);	/* known const ->reg */

/*
		if (val < 32768  && val >= -32768)
			return \"lli\\t%0,%c1\";
      		return \"lli\\t%0,%k1\\n\\tlui\\t%0,%j1\";
*/
		return \"ldri\\t%0,%1\";
	}
    }

  if (which_alternative == 3)		/* unknown const */
    return \"st\\t%1,%0\";
}"
[(set_attr "type" "arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
;; (set_attr "slottable" "yes,yes,yes,yes")
])

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	  (match_operand:QI 1 "general_operand" ""))]
""
"
{	
	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
		operands[1] = force_reg (QImode, operands[1]);
}")

(define_insn "*movqi_internal"
  [(set (match_operand:QI 0 "general_operand" "=r,r,r,m")
	  (match_operand:QI 1 "general_operand" "r,m,i,r"))]
""
"*
{
 int val;

  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
	{
		return \"addi\\tr23,%1\\n\\tandi\\tr24,r23,0x7ffc\\n\\tld\\tr24,r24,0\\n\\tandi\\tr23,0x0003\\n\\texb\\t%0,r24,%X1\"; 
/*	return \"ld\\t%0,%1\"; */
	}

  if (which_alternative == 2)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else
	{
      		val = INTVAL (operands[1]);	/* known const ->reg */

/*
		if (val < 32768  && val >= -32768)
			return \"lli\\t%0,%c1\";
      		return \"lli\\t%0,%k1\\n\\tlui\\t%0,%j1\";
*/
		return \"ldri\\t%0,%1\";
	}
    }

  if (which_alternative == 3)		/* unknown const */
	{
    		return \"addi\\tr23,%0\\n\\tandi\\tr24,r23,0x0003\\n\\tslli\\tr24,r24,3\\n\\txor\\tr25,r25,r25\\n\\tldri\\tr25,0xff\\n\\tsll\\tr25,r25,r24\\n\\tnot\\tr25,r25\\n\\tandi\\tr26,%1,0xff\\n\\tsll\\tr26,r26,r24\\n\\tandi\\tr23,r23,0x7ffc\\n\\tld\\tr24,r23,0\\n\\tand\\tr24,r24,r25\\n\\tor\\tr24,r24,r26\\n\\tst\\tr24,r23,0\";
	}
}"
[(set_attr "type" "arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
;; (set_attr "slottable" "yes,yes,no,yes")
])



;;17.6.2005 MM: Added experimental support for FP-coprocessor 
;; tee splitin lisksi toinen SWFP varten

(define_expand "movsf"
  [(set (match_operand:SF 0 "general_operand" "")
	(match_operand:SF 1 "general_operand" ""))]
  ""
  "
{
/*
	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
		operands[1] = force_reg (SFmode, operands[1]);

*/

	if (GET_CODE (operands[0]) == MEM)
	{	
		operands[1] = force_reg (SFmode, operands[1]);
	}
	else if (GET_CODE (operands[1]) == MEM)
	{	
		operands[0] = force_reg (SFmode, operands[0]);
	}
}")

(define_insn "*movsf_hw"
  [(set (match_operand:SF 0 "general_operand" "=f,r,f,r,r,r,m")
	(match_operand:SF 1 "general_operand" "f,f,r,r,F,m,r"))]
  "HWFP && (register_operand (operands[0], SFmode)
    || register_operand (operands[1], SFmode))"
"*
{
  if (which_alternative == 0)
    return \"fmov\\t%0,%1\";

  if (which_alternative == 1)
    return \"movfc\\tmilk,%0,%1\";		/* reg -> freg */

  if (which_alternative == 2)
    return \"movtc\\tmilk,%0,%1\";		/* freg -> reg */

  if (which_alternative == 3)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 4)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else  
	{
		return \"ldri\\t%0,%1\";
	}
   }

  if (which_alternative == 5)
    return \"ld\\t%0,%1\";		

  if (which_alternative == 6)
    return \"st\\t%1,%0\";

}"
[(set_attr "type" "fmov,arith,arith,arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged,unchanged,unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes,yes,yes,yes,yes,yes")
])

(define_insn "*movsf_sw"
  [(set (match_operand:SF 0 "general_operand" "=r,r,r,m")
	(match_operand:SF 1 "general_operand" "r,F,m,r"))]
"SWFP && (register_operand (operands[0], SFmode)
    || register_operand (operands[1], SFmode))"
"*
{
  if (which_alternative == 0)
    return \"mov\\t%0,%1\";		/* reg -> reg */

  if (which_alternative == 1)
    {
	if ((GET_CODE (operands[1]) == LABEL_REF) || 
		(GET_CODE (operands[1]) == SYMBOL_REF))
	{
		return \"ldra\\t%0,%a1\";
	}
	else  
	{
		return \"ldri\\t%0,%1\";
	}
   }

  if (which_alternative == 2)
    return \"ld\\t%0,%1\";		

  if (which_alternative == 3)
    return \"st\\t%1,%0\";
}"
[(set_attr "type" "arith,load,load,store")
 (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes,yes,yes")
])


;;(define_insn "*movsf_hardware"
;;  [(set (match_operand:SF 0 "register_operand" "=f,r,f,r")
;;	(match_operand:SF 1 "nonmemory_operand" "r,f,f,r"))]
;;  "HWFP"
;;"@
;;movtc\\tmilk,%0,%1
;;movfc\\tmilk,%0,%1
;;fmov\\t%0,%1
;;mov\\t%0,%1"
;;[(set_attr "type" "arith,arith,fmov,arith")
;; (set_attr "cc" "unchanged,unchanged,unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes,yes,yes")
;;])

(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "general_operand" ""))]
  ""
  "
{  
/*
  	if ((reload_in_progress || reload_completed)
      	&& CONSTANT_P (operands[1]))
    		operands[1] = force_const_mem (SFmode, operands[1]);

	if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) != REG)
	{
		
		operands[1] = force_reg (DFmode, operands[1]);
	}
*/
  if ((reload_in_progress || reload_completed)
      && CONSTANT_P (operands[1]))
    operands[1] = force_const_mem (DFmode, operands[1]);
/*
  if (GET_CODE (operands[0]) == MEM)
    {
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	operands[1] = force_reg (DFmode,
				 force_const_mem (DFmode, operands[1]));
      else if (GET_CODE (operands[1]) != REG)
	operands[1] = force_reg (DFmode, operands[1]);
    }

  else if (GET_CODE (operands[1]) == CONST_DOUBLE)
    operands[1] = force_const_mem (DFmode, operands[1]);
*/
}")

(define_insn ""
  [(set (match_operand:DF 0 "memory_operand" "=o")
	(match_operand:DF 1 "register_operand" "r"))]
  ""
  "*
{
  rtx xops[4];
  xops[0] = operands[0];
  xops[1] = adj_offsettable_operand (operands[0], 4);
  xops[2] = operands[1];
  xops[3] = gen_rtx (REG, SFmode, REGNO (operands[1]) + 1);
  output_asm_insn (\"st\\t%2,%0\;\\n\\tst\\t%3,%1\", xops);
  return \"\";
}"
[(set_attr "type" "store")
 (set_attr "cc" "unchanged")])


(define_insn ""
  [(set (match_operand:DF 0 "register_operand" "=r")
	(match_operand:DF 1 "memory_operand" "o"))]
  ""
  "*
{
  rtx xops[4];
  xops[0] = operands[0];
  xops[1] = adj_offsettable_operand (operands[1], 4);
  xops[2] = operands[1];
  xops[3] = gen_rtx (REG, SFmode, REGNO (operands[0]) + 1);
  output_asm_insn (\"ld\\t%0,%2\;\\n\\tld\\t%3,%1\", xops);
  return \"\";
}"
[(set_attr "type" "load")
 (set_attr "cc" "unchanged")])

;;(define_insn ""
;;  [(set (match_operand:DF 0 "register_operand" "=r")
;;	(match_operand:DF 1 "memory_operand" "m"))]
;;  ""
;;  "*
;;{
;;	if (GET_CODE (operands[1]) == SYMBOL_REF)
;;	{
;;		return \"ldra\\t%0,%a1\";
;;	}
;;	else
;;	{
;;		return \"ld\\t%0,%1\";
;;	}
;;}"
;;[(set_attr "type" "load")
;; (set_attr "cc" "unchanged")])


(define_insn "*movdf_internal"
  [(set (match_operand:DF 0 "general_operand" "=r,r")
	(match_operand:DF 1 "general_operand" "r,i"))]
  ""
  "*
{
  rtx xoperands[2],yoperands[2];

  xoperands[0] = gen_rtx (REG, SFmode, REGNO (operands[0]) + 1);

  if (which_alternative == 0)
    	{
      		/* r -> r */
      		output_asm_insn (\"mov\\t%1,%0\", operands);
      		xoperands[1] = gen_rtx (REG, SFmode, REGNO (operands[1]) + 1);
      		output_asm_insn (\"mov\\t%1,%0\",xoperands);
      		return \"\";
	}

/*
  if (which_alternative == 1)
  {
  	rtx xops[4];
  	xops[0] = operands[0];
  	xops[1] = adj_offsettable_operand (operands[0], 4);
  	xops[2] = operands[1];
  	xops[3] = gen_rtx (REG, SFmode, REGNO (operands[1]) + 1);
  	output_asm_insn (\"st\\t%2,%0\\n\\tst\\t%3,%1\", xops);
  	return \"\";    
  }
*/
/*
  if (which_alternative == 1)	 m -> r 
    {
      rtx xops[4];
      xops[0] = operands[0];
      xops[1] = gen_rtx (REG, SFmode, REGNO (operands[0]) + 1);
      xops[2] = operands[1];
      xops[3] = adj_offsettable_operand (operands[1], 4);
      output_asm_insn (\"ld\\t%0,%2\;ld\\t%1,%3\", xops);
      return \"\";
    }
*/
  if (which_alternative == 1)	/* i -> r */
    {
      yoperands[0] = operands[0];
      yoperands[1] = GEN_INT (CONST_DOUBLE_HIGH (operands[1]));
      output_asm_insn (\"ldri\\t%0,%1\", yoperands);

      xoperands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
      output_asm_insn (\"ldri\\t%0,%1\", xoperands);
      return \"\";
    }
}"
[(set_attr "type" "arith,load")
 (set_attr "cc" "unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes")
])

;;(define_split
;;  [(set (match_operand:SF 0 "memory_operand" "")
;;	(match_operand:SF 1 "register_operand" "f"))
;;   (clobber (match_operand:SF 2 "register_operand" "r"))]
;;  "reload_completed && HWFP && IS_FP_REG(REGNO(operands[1]))"
;;  [(set (match_dup 2) (match_dup 1))
;;   (set (match_dup 0) (match_dup 2))]
;;""
;;)

;;(define_split
;;  [(set (match_operand:SF 0 "register_operand" "=f")
;;	(match_operand:SF 1 "memory_operand" ""))
;;   (clobber (match_operand:SF 2 "register_operand" "r"))]
;;  "reload_completed && HWFP && IS_FP_REG(REGNO(operands[0]))"
;;  [(set (match_dup 2) (match_dup 1))
;;   (set (match_dup 0) (match_dup 2))]
;;""
;;)

;;(define_expand "reload_insf"
;;  [(set (match_operand:SF 0 "register_operand" "=f")
;;	(match_operand:SF 1 "memory_operand" ""))
;;   (clobber (match_operand:SF 2 "register_operand" "=&r"))]
;;"HWFP"
;;"
;;{DONE;
;;}
;;")

;;(define_expand "reload_outsf"
;;  [(set (match_operand:SF 0 "memory_operand" "=m")
;;	(match_operand:SF 1 "register_operand" "f"))
;;   (clobber (match_operand:SF 2 "register_operand" "=&r"))]
;;"HWFP"	
;;"
;;{DONE;
;;}
;;")

;;(define_expand "reload_insi"
;;  [(set (match_operand:SI 0 "register_operand" "=f")
;;	(match_operand:SI 1 "memory_operand" ""))
;;   (clobber (match_operand:SI 2 "register_operand" "=&r"))]
;;"HWFP"
;;"
;;{DONE;
;;}
;;")

;;(define_expand "reload_outsi"
;;  [(set (match_operand:SI 0 "memory_operand" "=m")
;;	(match_operand:SI 1 "register_operand" "f"))
;;   (clobber (match_operand:SI 2 "register_operand" "=&r"))]
;;"HWFP"	
;;"
;;{DONE;
;;}
;;")




(define_insn "addsf3"
  [(set (match_operand:SF 0 "fp_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "fp_reg_operand" "f")
		  (match_operand:SF 2 "fp_reg_operand" "f")))]
  "HWFP"
"fadd%#\\t%0,%1,%2"
[(set_attr "type" "fadd")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])


(define_insn "subsf3"
  [(set (match_operand:SF 0 "fp_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "fp_reg_operand" "f")
		  (match_operand:SF 2 "fp_reg_operand" "f")))]
  "HWFP"
"fsub%#\\t%0,%1,%2"
[(set_attr "type" "fadd")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])


(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(mult:SF (match_operand:SF 1 "register_operand" "f")
		  (match_operand:SF 2 "register_operand" "f")))]
  "HWFP"
"fmul%#\\t%0,%1,%2"
[(set_attr "type" "fmul")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "divsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(div:SF (match_operand:SF 1 "register_operand" "f")
		  (match_operand:SF 2 "register_operand" "f")))]
  "HWFP"
"fdiv%#\\t%0,%1,%2"
[(set_attr "type" "fdiv")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "sqrtsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "register_operand" "f")))]
  "HWFP"
"fsqrt%#\\t%0,%1"
[(set_attr "type" "fsqrt")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "abssf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(abs:SF (match_operand:SF 1 "register_operand" "f")))]
  "HWFP"
"fabs%#\\t%0,%1"
[(set_attr "type" "fabs")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "negsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(neg:SF (match_operand:SF 1 "register_operand" "f")))]
  "HWFP"
"fneg%#\\t%0,%1"
[(set_attr "type" "fneg")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "floatsisf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(float:SF (match_operand:SI 1 "register_operand" "f")))]
  "HWFP"
"fcvt.s%#\\t%0,%1"
[(set_attr "type" "fconv")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "fix_truncsfsi2"
  [(set (match_operand:SI 0 "register_operand" "=f")
	(fix:SI (match_operand:SF 1 "register_operand" "f")))]
  "HWFP"
"fcvt.w%#\\t%0,%1"
[(set_attr "type" "fconv")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])


;; Arithmetic insns. addhi3, addqi3 not needed?
;; consts: I = signed immediate, M = unsigned immediate
(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r,r")
	(plus:SI (match_operand:SI 1 "register_operand" "r,r,r")
		(match_operand:SI 2 "nonmemory_operand" "r,I,M")))]
""
"@
add\\t%0,%1,%2
addi\\t%0,%1,%2
addiu\\t%0,%1,%2"
[(set_attr "type" "arith,arith,arith")
 (set_attr "cc" "unchanged,unchanged,set")
;;  (set_attr "slottable" "yes,yes,yes")
])

 
(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(minus:SI (match_operand:SI 1 "register_operand" "r,r")
		(match_operand:SI 2 "nonmemory_operand" "r,r")))]
""
"@
sub\\t%0,%1,%2
subu\\t%0,%1,%2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "clobber,set")
;;  (set_attr "slottable" "yes,yes")
])

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "register_operand" "r,r")
		(match_operand:SI 2 "nonmemory_operand" "r,I")))]
""
"@
muls\\t%0,%1,%2
muli\\t%0,%1,%c2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "clobber,clobber")
;;  (set_attr "slottable" "yes,yes")
])


;; HI-operands might need a sign extension
(define_insn "mulhisi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(mult:SI (match_operand:HI 1 "register_operand" "r")
		(match_operand:HI 2 "register_operand" "r")))]
""
"mulus_16\\t%1,%2,%3"
[(set_attr "type" "arith")
 (set_attr "cc" "clobber")
;;  (set_attr "slottable" "yes")
])


(define_insn "mulsi3_highpart"
[(set (match_operand:SI 0 "register_operand" "=r")
	(mult:SI (match_operand:SI 1 "register_operand" "r")
		(match_operand:SI 2 "register_operand" "r")))]
""
"muls\\t%0,%1,%2\\n\\tmulhi\\t%0"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "no")
])


;; No division or mod instructions, yet

(define_insn "andsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(and:SI (match_operand:SI 1 "register_operand" "%r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, M")))]
""
"@
and\\t%0,%1,%2
andi\\t%0,%1,%2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes")
])


(define_insn "iorsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(ior:SI (match_operand:SI 1 "register_operand" "%r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, M")))]
""
"@
or\\t%0,%1,%2
ori\\t%0,%1,%2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes")
])

(define_insn "xorsi3"
[(set (match_operand:SI 0 "register_operand" "=r")
	(xor:SI (match_operand:SI 1 "register_operand" "%r")
		(match_operand:SI 2 "register_operand" "r")))]
""
"xor\\t%0,%1,%2"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "ashlsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(ashift:SI (match_operand:SI 1 "register_operand" "r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, K")))]
""
"@
sll\\t%0,%1,%2
slli\\t%0,%1,%k2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes")
])

(define_insn "ashrsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(ashiftrt:SI (match_operand:SI 1 "register_operand" "r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, K")))]
""
"@
sra\\t%0,%1,%2
srai\\t%0,%1,%k2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes")
])

(define_insn "lshrsi3"
[(set (match_operand:SI 0 "register_operand" "=r, r")
	(lshiftrt:SI (match_operand:SI 1 "register_operand" "r, r")
		(match_operand:SI 2 "nonmemory_operand" "r, K")))]
""
"@
srl\\t%0,%1,%2
srli\\t%0,%1,%k2"
[(set_attr "type" "arith,arith")
 (set_attr "cc" "unchanged,unchanged")
;;  (set_attr "slottable" "yes,yes")
])


(define_insn "one_cmplsi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(not:SI (match_operand:SI 1 "register_operand" "r")))]
""
"not\\t%0,%1"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

;; Make the 0 operand write-only, so 0&1 cannot be the same
;; First zero 0 and make 0-%1
(define_insn "negsi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(neg:SI (match_operand:SI 1 "register_operand" "r")))]
""
"xor\\t%0,%0,%0\\n\\tsub\\t%0,%0,%1"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

;;(define_insn "cmpsi"
;;[(set (cc0) 
;;	(compare (match_operand:SI 0 "register_operand" "r, r")
;;		(match_operand:SI 1 "register_operand" "r, J")))]
;;""
;;"@
;;cmp\\tc0,%0,%1
;;cmpi\\tc0,%0,%1"
;;[(set_attr "type" "cmp,cmp")
;; (set_attr "cc" "set,set")
;;  (set_attr "slottable" "no,no")
;;])

(define_insn "cmpsf"
[(set (cc0)	(compare (match_operand:SF 0 "register_operand" "f")
		(match_operand:SF 1 "register_operand" "f")))
(clobber	 (match_scratch:SF 2  "=f"))]
"HWFP"
"*{
	last_cmp_was_float = 1;
	enum rtx_code cmp_code = GET_CODE (next_cc0_user (insn));
	if (cmp_code == EQ)
	{
		return \"fc.eq%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
	}
	else if (cmp_code == NE)
	{
		return \"fc.eq%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
	}
	else if (cmp_code == GT)
	{
		return \"fc.olt%#\\t%2,%1,%0\\n\\tnop\\n\\tnop\";
	}	
	else if (cmp_code == LT)
	{
		return \"fc.olt%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
	}	
	else if (cmp_code == GE)
	{
		return \"fc.ole%#\\t%2,%1,%0\\n\\tnop\\n\\tnop\";
	}	
	else if (cmp_code == LE)
	{
		return \"fc.ole%#\\t%2,%0,%1\\n\\tnop\\n\\tnop\";
	}	
}"
[(set_attr "type" "cmp")
(set_attr "cc" "set")
;;  (set_attr "slottable" "yes")
])

;;(define_expand "cmpsi"
;;[(set (cc0) 
;;	(compare (match_operand:SI 0 "register_operand" "")
;;		(match_operand:SI 1 "general_operand" "")))]
;;""
;;"
;;{
;;	last_cmp_was_float = 0;
;;	enum rtx_code branch = GET_CODE(next_cc0_user(insn));
;;
;;	if ((branch == GTU) || (branch == LTU) || 
;;		(branch == LEU) || (branch == GEU))
;;	{
;;		if (GET_CODE(operands[1]) == CONST_INT)
;;			operands[1] = force_reg (SImode, operands[1]);	
;;	}
;;}
;;")


(define_insn "cmpsi"
[(set (cc0) 
	(compare (match_operand:SI 0 "register_operand" "r, r")
		(match_operand:SI 1 "general_operand" "r, L")))]
""
"*
{
	last_cmp_was_float = 0;
	enum rtx_code branch = GET_CODE(next_cc0_user(insn));

	if ((branch == GTU) || (branch == LTU) || 
		(branch == GEU) || (branch == LEU) && 
		register_operand(operands[1],SImode))
	{
		/* CHECK */
		return \"subu\\t%0,%0,%1\";
	}
	else
	{
		if (which_alternative == 0)
		{
			return \"cmp\\tc0,%0,%1\";
		}
		else
		{
			return \"cmpi\\tc0,%0,%1\";
		}
	}
	
}"
[(set_attr "type" "cmp,cmp")
 (set_attr "cc" "set,set")
;;  (set_attr "slottable" "no,no")
])


(define_insn "tstsi"
[(set (cc0) 
	(match_operand:SI 0 "register_operand" "r"))]
""
"cmpi\\tc0,%0,0"
[(set_attr "type" "cmp")
 (set_attr "cc" "set")
;;  (set_attr "slottable" "no")
])

;; Extension and truncation

(define_insn "extendqisi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI (match_operand:QI 1 "register_operand" "r")))]
""
"sexti\\t%0,%1,7"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "extendhisi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI (match_operand:HI 1 "register_operand" "r")))]
""
"sexti\\t%0,%1,15"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "yes")
])

(define_insn "extendqihi2"
[(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extend:HI (match_operand:QI 1 "register_operand" "r")))]
""
"sexti\\t%0,%1,7\\n\\tlui\\t%1,0xffff\\n\\tand\\t%0,%1,%0"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "no")
])

(define_insn "zero_extendhisi2"
[(parallel [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI (match_operand:HI 1 "register_operand" "r")))
	(clobber (match_dup 0))])]
""
"lui\\t%0,0\\n\\tconh\\t%0,%0,%1"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "no")
])


(define_insn "zero_extendqisi2"
[(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI (match_operand:QI 1 "register_operand" "r")))]
""
"slli\\t%1,%1,24\\n\\tsrli\\t%0,%1,24" 
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "no")
])

(define_insn "zero_extendqihi2"
[(set (match_operand:HI 0 "register_operand" "=r")
	(zero_extend:HI (match_operand:QI 1 "register_operand" "r")))]
""
"lli\\t%0,0\\n\\tconb\\t%0,%0,%1"
[(set_attr "type" "arith")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "no")
])

;; We could define bit-field extractions but seems they're not needed

;; Branch insns, taken from clipper. 

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "beq\\tc0,%l0%("
  [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bne\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bgt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

;; No unsigned comparisons. Needed so use the same as signed
(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bgt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "blt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "blt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "begt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "begt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "belt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "belt\\tc0,%l0%("
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

;; Recognize reversed jumps.
(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
				      [(cc0)
				       (const_int 0)])
		      (pc)
		      (label_ref (match_operand 1 "" ""))))]
 ""
 "b%C0\\tc0,%l1%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

;; Call  insns, taken from clipper. 
(define_insn "call"
  [(call (match_operand:SI 0 "sym_ref_mem_operand" "")
		 (match_operand 1 "" "i"))]
  ""
  "jal\\t%S0%("
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
;;  (set_attr "slottable" "has_slot")
])


;;(define_insn "call_value"
;;  [(set (match_operand:SI 0 "register_operand" "=r")
;;	(call (match_operand:SI 1 "sym_ref_mem_operand" "")
;;	      (match_operand 2 "" "")))]
;;  ""
;;  "jal\\t%S1%("	
;; [(set_attr "type" "branch")
;; (set_attr "cc" "clobber")
;;  (set_attr "slottable" "has_slot")
;;])

(define_insn "call_value"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(call (match_operand:SI 1 "sym_ref_mem_operand" "")
	      (match_operand 2 "" "")))]
  ""
  "jal\\t%S1%("	
 [(set_attr "type" "branch")
 (set_attr "cc" "clobber")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "call_indirect"
  [(call (mem:SI (match_operand 0 "register_operand" "r"))
                  (match_operand 1 "" "i"))]
  ""
  "jalr\\t%0%("
  [(set_attr "type" "branch")
;;   (set_attr "slottable" "has_slot")
  (set_attr "cc" "clobber")])

;;(define_insn "call_value_indirect"
;;  [(set (match_operand 0 "register_operand" "=r")
; ;                  (call (mem:SI (match_operand 1 "register_operand" "r"))
;;                         (match_operand 2 "" "i")))]
;;""
;;"jalr\\t%1%("
;;[(set_attr "type" "branch")
;;  (set_attr "slottable" "has_slot")
;;  (set_attr "cc" "clobber")])

(define_insn "call_value_indirect"
  [(set (match_operand:SI 0 "register_operand" "=r")
                   (call (mem:SI (match_operand 1 "register_operand" "r"))
                         (match_operand 2 "" "i")))]
""
"jalr\\t%1%("
[(set_attr "type" "branch")
;;  (set_attr "slottable" "has_slot")
  (set_attr "cc" "clobber")])


(define_insn "nop"
  [(const_int 0)]
""
"nop")

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "r"))]
""
"jmpr\\t%0%("
[(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "jump"
 [(set (pc) 
	(label_ref (match_operand 0 "" "")))]
""
"jmp\\t%0%("
[(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

;; I think we use tablejump for now

(define_insn "tablejump"
  [(set (pc) (match_operand:SI 0 "register_operand" "r"))
	(use (label_ref (match_operand 1 "" "")))]
""
"jmpr\\t%0%("
[(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "absqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(abs:QI (match_operand:QI 1 "register_operand" "r")))]
""
"*
{
	return \"xor\\tr26,r26,r26\\n\\tcmp\\tc0,%1,r26\\n\\tbgt\\tc0,4\\n\\tnop\\n\\tsub\\t%0,r26,%1\";
/*
	operands[2] = const0_rtx;
	return \"cmpi\\tc0,%1,%2\\n\\tbgt\\tc0,4\\n\\tnop\\n\\tsub\\t%0,%1,%2\";*/
}"
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "abshi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(abs:HI (match_operand:HI 1 "register_operand" "r")))]
""
"*
{
	return \"xor\\tr26,r26,r26\\n\\tcmp\\tc0,%1,r26\\n\\tbgt\\tc0,4\\n\\tnop\\n\\tsub\\t%0,r26,%1\";
/*
	operands[2] = const0_rtx;
	return \"cmpi\\tc0,%1,%2\\n\\tbgt\\tc0,4\\n\\tnop\\n\\tsub\\t%0,%1,%2\";*/
}"
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
;;  (set_attr "slottable" "has_slot")
])

(define_insn "abssi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(abs:SI (match_operand:SI 1 "register_operand" "r")))]
""
"*
{
	/*
	operands[2] = const0_rtx;
	*/
	return \"xor\\tr26,r26,r26\\n\\tcmp\\tc0,%1,r26\\n\\tbgt\\tc0,4\\n\\tnop\\n\\tsub\\t%0,r26,%1\";
}"
[(set_attr "type" "branch")
 (set_attr "cc" "clobber")
;;  (set_attr "slottable" "has_slot")
])

(define_expand "prologue"
  [(const_int 0)]
  ""
  "coffee_expand_prolog (); DONE;")

(define_expand "epilogue"
  [(return)]
  ""
  "coffee_expand_epilog ();")




