	;; Unsigned division. Operands in r0,r1, result in r0, remainder in r1. r0=r0/r1.
	.text
	.code32
	.align 2
	.proc __udivsi3
	.global __udivsi3
__udivsi3:
	st	r2,r28,-4
	st	r3,r28,-8
	ldri	r2, 0
	ldri	r3, 1
	cmp	c0,r1,r2	; div by zero check
	beq	c0, _div_by_zero
_udivsi3_shift:
	slli	r1,r1,1
	slli	r3,r3,1	
	cmp	c0,r0,r1
	begt	c0, _udivsi3_shift
	nop
	srli	r1,r1,1
	srli	r3,r3,1

_udivsi3_test:	cmp	c0,r0,r1
	begt	c0,_udivsi3_subtract
	nop
	srli	r1,r1,1
	srli	r3,r3,1
	cmpi	c0,r3,1
	beq	c0,_exit
	nop
	jmp	_udivsi3_test
	nop
_udivsi3_subtract:
	sub	r0,r0,r1
	add	r2,r2,r3
	cmpi	c0,r3,1
	bne	c0,_udivsi3_test
	nop
_udivsi3_exit:	
	mov	r0,r2
	ld	r2,r28,-4
	ld	r3,r28,-8
	jmpr	r31
	nop
_div_by_zero:
	ld	r2,r28,-4
	ld	r3,r28,-8
	trap	5
	nop
	nop
	jmpr	r31
	nop
.endproc	__udivsi3


	;; Signed division. Operands in r0,r1, result in r0. r0=r0/r1.
	
	.text
	.code32
	.align 2
	.proc __divsi3
	.global __divsi3
__divsi3:
	st	r31,r28,-4
	st	r28,r28,-8
	st	r2,r28,-12
	st	r3,r28,-16
	st	r4,r28,-20
	addi	r28,r28,-20

_cnv_unsig:
	mov	r2,r0
	mov	r3,r1
	ldri	r4,0
	srli	r2,r2,31
	cmpi	c0,r2,1
	bne	c0,_r0_pos
	nop
	not	r0,r0
	addi	r0,r0,1
	ori	r4,r4,2
_r0_pos:
	srli	r3,r3,31
	cmpi	c0,r3,1
	bne	c0,_r1_pos
	nop
	not	r1,r1
	addi	r1,r1,1
	ori	r4,r4,1
_r1_pos:
	jal	__udivsi3
	nop
	cmpi	c0,r4,0
	beq	c0,_exit2
	nop
	cmpi	c0,r4,3
	beq	c0,_exit2
	nop
	not	r0,r0
	addi	r0,r0,1
	
_exit2:
	addi	r28,r28,20
	ld	r4,r28,20
	ld	r3,r28,16
	ld	r2,r28,12	
	ld	r28,r28,8
	ld	r31,r28,4
	jmpr	r31
	nop

	;; Signed modulo. Operands in r0,r1, result in r0. r0=r0%r1.
	.text
	.code32
	.align 2
	.proc __modsi3
	.global __modsi3
__modsi3:
	st	r31,r28,-4
	st	r28,r28,-8
	st	r2,r28,-12
	st	r3,r28,-16
	st	r4,r28,-20
	addi	r28,r28,-20

_cnv_unsig2:
	mov	r2,r0
	mov	r3,r1
	ldri	r4,0
	srli	r2,r2,30
	cmpi	c0,r2,1
	bne	c0,_r0_pos2
	nop
	not	r0,r0
	addi	r0,r0,1
	ori	r4,r4,2
_r0_pos2:
	srli	r3,r3,30
	cmpi	c0,r3,1
	bne	c0,_r1_pos2
	nop
	not	r1,r1
	addi	r1,r1,1
	ori	r4,r4,1
_r1_pos2:
	jal	_umodsi3
	nop
	cmpi	c0,r4,0
	beq	c0,_exit3
	nop
	cmpi	c0,r4,3
	beq	c0,_exit3
	nop
	not	r0,r0
	addi	r0,r0,1
	
_exit3:
	ld	r4,r28,20
	ld	r3,r28,16
	ld	r2,r28,12	
	ld	r28,r28,8
	ld	r31,r28,4
	jmpr	r31
	nop
.endproc __modsi3
	
	;; Unsigned modulo. Operands in r0,r1, result in r0. r0=r0%r1.
	.text
	.code32
	.align 2
	.proc __umodsi3
	.global __umodsi3
__umodsi3:
	st	r2,r28,-4
	st	r3,r28,-8
	ldri	r2, 0
	ldri	r3, 1
	cmp	c0,r1,r2	; div by zero check
	beq	c0, _div_by_zero2
_umodsi3_shift:
	slli	r1,r1,1
	slli	r3,r3,1	
	cmp	c0,r0,r1
	begt	c0, _umodsi3_shift
	nop
	srli	r1,r1,1
	srli	r3,r3,1

_umodsi3_test:	cmp	c0,r0,r1
	begt	c0,_umodsi3_subtract
	nop
	srli	r1,r1,1
	srli	r3,r3,1
	cmpi	c0,r3,1
	beq	c0,_umodsi3_exit
	nop
	jmp	_umodsi3_test
	nop
_umodsi3_subtract:
	sub	r0,r0,r1
	add	r2,r2,r3
	cmpi	c0,r3,1
	bne	c0,_umodsi3_test
	nop
_umodsi3_exit:	ld	r2,r28,-4
	ld	r3,r28,-8
	jmpr	r31
	nop
_div_by_zero2:
	ld	r2,r28,-4
	ld	r3,r28,-8
	trap	5
	nop
	nop
	jmpr	r31
	nop
	
.endproc	__umodsi3
