/*  COFFEE-risc machine description  
 *   Version history:    
 *  0.9  1.4.2004   By Markus Moisio    First Release
 *		      	   
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "tree.h"
#include "rtl.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "real.h"
#include "insn-config.h"
#include "conditions.h"
#include "output.h"
#include "insn-attr.h"
#include "flags.h"
#include "expr.h"
#include "function.h"
#include "recog.h"
#include "toplev.h"
#include "ggc.h"
#include "tm_p.h"
#include "target.h"
#include "target-def.h"
/*
#include "config.h"
#include "system.h"
#include "rtl.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "real.h"
#include "insn-config.h"
#include "conditions.h"
#include "output.h"
#include "insn-attr.h"
#include "tree.h"
#include "expr.h"
#include "c-tree.h"
#include "function.h"
#include "flags.h"
#include "recog.h"
#include "tm_p.h"
#include "target.h"
#include "target-def.h"
#include "optabs.h"
#include "ggc.h"
*/

int last_cmp_was_float;
const char* fpuid; /* to store co-proc number */

char* get_function_name PARAMS ((void));
void print_operand_address PARAMS ((FILE*, register rtx));
int print_operand_punct_valid_p PARAMS ((int));
void print_operand PARAMS ((FILE*, rtx, int));
int sym_ref_mem_operand PARAMS ((rtx, enum machine_mode));
int signed_comparison_operator PARAMS ((register rtx, enum machine_mode));
/*
int gen_call_value_1 ((rtx));
*/
void asm_output_ascii (FILE*, const char*, int);
void output_trap_def PARAMS ((FILE*,char*,int));
void output_function_prologue PARAMS ((FILE*, int));
void output_function_epilogue PARAMS ((FILE*, int));
int log_of_two PARAMS ((int));
char *rev_cond_name PARAMS ((rtx));
int call_address_operand PARAMS ((rtx, enum machine_mode));
int fp_reg_operand PARAMS ((rtx, enum machine_mode));
int symbolic_operand (rtx op, enum machine_mode mode);

struct gcc_target targetm = TARGET_INITIALIZER;

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#undef  TARGET_ASM_FUNCTION_PROLOGUE
#define TARGET_ASM_FUNCTION_PROLOGUE coffee_output_function_prologue
#undef  TARGET_ASM_FUNCTION_EPILOGUE
#define TARGET_ASM_FUNCTION_EPILOGUE coffee_output_function_epilogue


#define REG_NEEDS_SAVE(i) (regs_ever_live[i] && !(call_used_regs[i]))

/* Function to get function name out of the tree */
char* get_function_name(void)
{
  char *kind = "function";
  if ((current_function_decl != 0)
      && (TREE_CODE (TREE_TYPE (current_function_decl)) == METHOD_TYPE))
    kind = "method";
  
  if (current_function_decl == NULL)
    {
      return "top level";
    }
  else
    {
      /*      char *name = (*decl_printable_name) (current_function_decl, &kind);*/
      char *name = current_function_name();
      return name;
    }
}


/* This handles printing the addressing modes in assembly */
void 
print_operand_address (file, addr)
     FILE *file;
     register rtx addr;
{
  rtx op0,op1;

  switch (GET_CODE (addr))
    {
    case REG:
      fprintf (file, "%s", reg_names[REGNO (addr)]);
      break;

    case PLUS:
      /* can be 'symbol + reg' or 'reg + reg' */

      op0 = XEXP (addr, 0);
      op1 = XEXP (addr, 1);

      if (GET_CODE (op0) == REG && GET_CODE (op1) == REG)
	{
	  fprintf (file, "[%s](%s)",
		   reg_names[REGNO (op0)], reg_names[REGNO (op1)]);
	  break;
	}

      if (GET_CODE (op0) == REG && CONSTANT_ADDRESS_P (op1))
	{
	  output_addr_const (file, op1);
	  fprintf (file, "(%s)", reg_names[REGNO (op0)]);
	  break;
	}

      if (GET_CODE (op1) == REG && CONSTANT_ADDRESS_P (op0))
	{
	  output_addr_const (file, op0);
	  fprintf (file, "(%s)", reg_names[REGNO (op1)]);
	  break;
	}
      abort ();				/* Oh no */

    default:
      output_addr_const (file, addr);
    }
}


/* This function checks the %-operands in the md-file 
 * and return 1 for correct ones 
*/
int print_operand_punct_valid_p (code)
     int code;
{
  switch(code)
    {
    case 'k':
      return 1; /* lower immediate*/
    case 'j':
      return 1; /* upper immediate*/
    /* idea taken from sparc; output nop for %( if
    not optimizing or the slot is not filled. */
    case 'X':   /*for assembler, special case of base+offset */
      return 1;
    case '#':   /* print fpuid here */
      return 1;
    case '(':
      return 1;
    case 'S':
      return 1;
    }
  return 0;
}

/* This handles the general operand printing (constants, symbols
 * and a nop if the slot is not filled (not working now))
 */

void 
print_operand (file, x, code)
     FILE* file;
     rtx x;
     int code;
{
  if (code == 'C')
    fputs (rev_cond_name (x), file);
  else if (code == '#')
    {
      /*output fpuid*/
      fputs(fpuid, file);
    }
  else if (code == 'k')
    fprintf (file, "%d", INTVAL (x) & 0xffff);
  else if (code == 'j')
    fprintf (file, "%d", ((INTVAL (x) & 0xffff0000) >> 16));
  else if (code == '(')
    {
      /*
       These are commented out because the branch delay slot scheduling
       does not work
            if (dbr_sequence_length()==0)
      	{
	  fprintf(file, "\n\tnop\t;nop in slot");
	  	}
	    else
	  	{
	    fprintf(file, "\t;slot filled");
	  	}
      */
    }

  else if (code == 'X')
    {
      if (GET_CODE (x) == MEM)
	{
	  rtx addr = XEXP(x, 0);
	  int koodi = GET_CODE(addr);
      
	  switch(koodi)
	    {
	    case REG:
	      fprintf(file, " 0");
	      break;
	    case PLUS:
	      {
		rtx reg, offs;
		reg = XEXP(addr,0);
		offs = XEXP(addr,1);
	  
		if (GET_CODE(reg) != REG)
		  {
		    rtx temp = reg;
		    reg = offs;
		    offs = temp;
		  }
	    
		if (GET_CODE(reg) != REG || GET_CODE(offs) != CONST_INT)
		  {
		    fprintf(file, "fucktheshit!");
		    abort();
		  }

		  fprintf(file, " %d",INTVAL(offs));
		break;
	      }
	    case CONST_INT:
	      fprintf(file, " %d", INTVAL(addr));
	      break;

	    default:
	      output_address (XEXP (x, 0));
	      break;
	    }
	}
    }
    
  else if (GET_CODE (x) == REG)
    fprintf (file, "%s", reg_names[REGNO (x)]);
  else if (GET_CODE (x) == MEM)
    {
      rtx addr = XEXP(x, 0);
      int koodi = GET_CODE(addr);
      
      switch(koodi)
	{
	case REG:
	  fprintf(file, "%s, 0", reg_names[REGNO(addr)]);
	  break;
	case PLUS:
	  {
	    rtx reg, offs;
	    reg = XEXP(addr,0);
	    offs = XEXP(addr,1);
	  
	    if (GET_CODE(reg) != REG)
	      {
		rtx temp = reg;
		reg = offs;
		offs = temp;
	      }
	    
	    if (GET_CODE(reg) != REG || GET_CODE(offs) != CONST_INT)
	      {
		fprintf(file, "fucktheshit!");
		abort();
	      }
	    fprintf(file, "%s, %d",reg_names[REGNO(reg)], INTVAL(offs));
	    break;
	  }
	
	case CONST_INT:
	  fprintf(file, "%d", INTVAL(addr));
	  break;

	default:
	  output_address (XEXP (x, 0));
	  break;
	}
    }
  else if (code == 'S')
    {
      if (GET_CODE (x) == PLUS)
	assemble_name(file, XSTR(XEXP(x,0),0));   
    }
  else if (GET_CODE (x) == CONST_DOUBLE)
    {
      	  fprintf(file, "%d", INTVAL(x));
	  /*    output_operand_lossage ("floating point constant not a valid immediate operand");*/
    }
  else 
    { 
      output_addr_const (file, x);
    }
}

/* Function to check if tree-node is a symbolic memory operand */
int sym_ref_mem_operand (op, mode)
      rtx op;
     enum machine_mode mode;
{
  if(GET_CODE(op) == MEM)
    {
      rtx t1 = XEXP(op, 0);
      if(GET_CODE(t1) == SYMBOL_REF)
        {
          return 1;
        }
    }
  return 0;
}

/* Function to check if tree-node is a call-operand  */
int
call_address_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (symbolic_operand (op, mode)
	  || (GET_CODE (op) == CONST_INT && LEGITIMATE_CONSTANT_P (op))
	  || (GET_CODE (op) == REG));
}

/* Checks also if tree-node is a call-operand */
int
call_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  if (GET_CODE (op) != MEM)
    return 0;
  op = XEXP (op, 0);
  return call_address_operand (op, mode);
}

/* function to check if tree-node is a symbol */
int
symbolic_operand (op, mode)
     rtx op;
     enum machine_mode mode ATTRIBUTE_UNUSED;
{
  switch (GET_CODE (op))
    {
    case SYMBOL_REF:
    case LABEL_REF:
    case CONST :
      return 1;
    default:
      return 0;
    }
}


int
fp_reg_operand (op, mode)
     register rtx op;
     enum machine_mode mode;
{
  return IS_FP_REG(REGNO(op)) || IS_PSEUDO_REG(REGNO(op));
}

/*
int
fp_reg_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (register_operand (op, mode) &&
	  (GET_CODE (op) != SUBREG ||
	   GET_MODE_CLASS (GET_MODE (SUBREG_REG (op))) == MODE_FLOAT));
}
*/
/* Checks if comparison is signed */     
int signed_comparison_operator (op, mode)
    register rtx op;
    enum machine_mode mode;
{
  if(mode == VOIDmode || GET_MODE (op) == mode)
    {
      switch(GET_CODE(op))
        {
        case EQ:
        case NE:
        case LT:
        case LE:
        case GE:
        case GT:
	default:
          return 1;
        }
    }
  return 0;
}

int gen_call_value_1 (rtx operands[])
{
  rtx result = operands[0];
  rtx func = operands[1];
  rtx stacksize = operands[2];
  int mode = GET_MODE(result);

  switch(mode)
    {
/*
 [(set (reg:SI 1)
                  (call (match_operand 0 "sym_ref_mem_operand" "")
                        (match_operand 1 "" "i")))]
*/
/*
    HImode:
    QImode:
      printf("Subreg in gcv1.\n");
      emit_call_insn(gen_rtx(SET,mode,
			     gen_rtx(SUBREG,mode,result),
			     gen_rtx(CALL,VOIDmode,func,stacksize)));
      break;
*/

    default:
      emit_call_insn(gen_rtx(PARALLEL,VOIDmode,
		       gen_rtvec(2,
				 gen_rtx(SET,mode,result,
					 gen_rtx(CALL,VOIDmode,func,
						 stacksize)),
				 gen_rtx(CLOBBER,VOIDmode,
					 gen_rtx(REG,SImode,31)))));
      break;

    }

  return 0;
}

/*
 * Set up stack and frame pointers, and prepare
 * for function entry.
 *
 * Stack map for Coffee-GCC:
 *
 * incoming args
 *                      <--------------------------- new frame pointer
 * saved frame pointer          4 bytes
 * saved return addr            4 bytes
 *
 * local variables:             size rounded up to a multiple of 4.
 *
 * save caller regs area        (4*n_regs_to_save)
 * 
 *
*/



/* This is how to output a string.  */
void asm_output_ascii(FILE *stream, const char *ptr, int len)
{
  do {
    int i, c, length = len, cur_pos = 17;
    unsigned char *string = (unsigned char *)(ptr);
    fprintf (stream, "\t.ascii\t\"");
    for (i = 0; i < length; i++)
      {
	c = string[i];
      switch (c)
	{
	case '\"':
	case '\\':
	  putc ('\\', (stream));
	  putc (c, (stream));
	  cur_pos += 2;
	  break;

	case TARGET_NEWLINE:
	  fputs ("\\n", (stream));
	  if (i+1 < length
	      && (((c = string[i+1]) >= '\040' && c <= '~')
		  || c == TARGET_TAB))
	    cur_pos = 32767;		/* break right here */
	  else
	    cur_pos += 2;
	  break;

	case TARGET_TAB:
	  fputs ("\\t", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_FF:
	  fputs ("\\f", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_BS:
	  fputs ("\\b", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_CR:
	  fputs ("\\r", (stream));
	  cur_pos += 2;
	  break;

	default:
	  if (c >= ' ' && c < 0177)
	    {
	      putc (c, (stream));
	      cur_pos++;
	    }
	  else
	    {
	      fprintf ((stream), "\\%0o", c);
	      cur_pos += 2;
	    }
	}

      if (cur_pos > 72 && i+1 < length)
	{
	  cur_pos = 17;
	  fprintf ((stream), "\"\n\t.ascii\t\"");
	}
      }
    fprintf ((stream), "\"\n");
  } while (0);
}
       

/* 19082003 MJM: Made some changes to prologue/epilogue. Now it doesn't save
   frame pointer or link register unless it' required. */


/* This outputs the function prologue. Saves return pointer and stack pointer.
 * Saves registers that live across function calls (if used). And 
 * reserves space for temporaries and outgoing args.
 */

void 
output_function_prologue (file, size)
     FILE *file;
     int size;
{
  int reg_so;
  int local_space;
  int i;
  int stkoff;
  int n_regs_to_save;
  char *name = get_function_name();
  int is_main = 0;
  int size_in_words = size / 4;
  int cfoas_in_words = current_function_outgoing_args_size / 4;


  if(!strcmp("main",name)) 
    {
      is_main = 1;
      /*  printf("found main\n"); */
    }

  stkoff = 0;
  n_regs_to_save = 0;

  if(!is_main) {
    for(i = 0; i < FIRST_PSEUDO_REGISTER ; i++)
      if(REG_NEEDS_SAVE(i)) {
	stkoff += 4;
	n_regs_to_save++;
      }
  }

   if (frame_pointer_needed)
      {
	stkoff +=4;
      }
    if (!current_function_is_leaf)
      {
	stkoff +=4;
      }
 /* This is the rounding part i guess. Now is 4 bytes */
    stkoff = (stkoff+3)&(~3); 
  
    local_space = size + stkoff + current_function_outgoing_args_size;

    fprintf(file,";  Function '%s'; %d words of locals, %d regs to save.\n",
          name,size_in_words,n_regs_to_save);

  /* 
   * Treat main specially as it needs to be a DLX entry point.
   * This means we need to set the initial stack pointer, and 
   * that we need to do an exit instead of a return at the end.
   *
   * If -mnoargs was specified, then load r29 with memSize-8,
   * otherwise assume that it is set correctly on entry to main.
   */

/* Don't know what's that memSize */
/* 5.10.2004 Markus Moisio: Removed, OS takes care of this 

  if(is_main)
    {
      fputs("\tlli\tr28,((memSize-8)&0xffff)\n",file);
      fputs("\tlui\tr28,(((memSize-8)>>16)&0xffff)\n",file);
      }
*/
  
  if (frame_pointer_needed)
  {
    fputs("\tst\tr28,r27,-4\t; push fp\n",file);
    fputs("\tmov\tr28,r27\t; fp = sp\n",file);
  }
  if (!current_function_is_leaf)
    {
      fputs("\tst\tr31,r28,-8\t; push ret addr\n",file);
    }
  
  if(local_space <= 16384)
    fprintf(file,"\taddi\tr27,r27,-%d\t; alloc local storage\n",
            local_space);
  else
    fprintf(file,"\tldri\tr26,-%d\n\tadd\tr27,r27,r26\t; local storage > 16384\n",local_space);
  

  /* Removed from COFFEE
  else
    {
      unsigned int iv = (local_space>>16)&0xffff;

       We can get away with clobbering r1 because it will
         have the return value put into it anyway, I think. 
      fprintf(file,"\tlhi\tr1,%d\t; alloc local storage = %d\n",
              iv,local_space);
      fprintf(file,"\taddui\tr1,r1,0x%04x\n",local_space&0xffff);
      fputs("\tsubu\tr29,r29,r1\n",file);
    }*/

  if (frame_pointer_needed)
    {
      if (!current_function_is_leaf)
	{
	  reg_so = 12;
	}
      else
	{
	  reg_so = 8;
	}
    }
  else
    {
      reg_so = 4;
    }

  if(!is_main)
    {
      for(i = 0 ; i < FIRST_PSEUDO_REGISTER ; i++)
        {
          if(REG_NEEDS_SAVE(i))
            {
              fprintf(file,"\tst\t%s,r28,-%d\n",reg_names[i],reg_so);
              reg_so += 4;
            }
        }
    }
}


/* Outputs function epilogue. So this recalls the frame and stack pointers and
 * saved registers.
 */
void 
output_function_epilogue (file, size)
     FILE *file;
     int size;
{
  int i;
  int reg_so;
  char *name = get_function_name();
  int is_main = 0;

  if(!strcmp("main",name)) is_main = 1;

  if (frame_pointer_needed)
    {
      if (!current_function_is_leaf)
	{
	  reg_so = 12;
	}
      else
	{
	  reg_so = 8;
	}
    }
  else
    {
      reg_so = 4;
    }

  if(!is_main)
    {
      for(i = 0 ; i < FIRST_PSEUDO_REGISTER ; i++)
        {
          if(REG_NEEDS_SAVE(i))
            {
              fprintf(file,"\tld\t%s,r28,-%d\n",reg_names[i],reg_so);
              reg_so += 4;
            }
        }
      
      /*
       * Restore the return address, the stack pointer, and
       * the frame pointer. The frame pointer load can go in
       * the jump delay slot.
       */
      if (!current_function_is_leaf)
	{
	  fputs("\tld\tr31,r28,-8\n",file);
	}
      if (frame_pointer_needed)
	{
	  fputs("\tmov\tr27,r28\n",file);
	  fputs("\tld\tr28,r27,-4\n",file);
	  fputs("\tjmpr\tr31\n",file);
	  fputs("\tnop\n",file);
	}
      else
	{
	  fputs("\tjmpr\tr31\n",file);
	  fputs("\tnop\n",file);
	}
    }
  else
    {
      fputs("\tjal\texit\n",file);
      fputs("\tnop\n",file);
    }
  fprintf(file,".endproc %s\n",name);
}

/* Some weird algorithm for computing 2's logarithm. */
int
log_of_two (int x)
{
  int y;

  x >>= 1;
  for(y=0; x; x>>=1, y++);

  return y;
}

 
struct traptab_s {
  char *name;
  int num;
} traptab[] = {
  { "_exit",   0 },
  { "_open",   1 },
  { "_close",  2 },
  { "_read",   3 },
  { "_write",  4 },
  { "_printf", 5 },
  { "_sqrt",   29 },
  { NULL,      0 }};

/*void 
asm_file_end (file)
  FILE *file;
{
#ifdef NO_LOADER
  int i;

  text_section();

  i = 0;
  while(traptab[i].name != NULL)
    {
      output_trap_def(file,traptab[i].name,traptab[i].num);
      i++;
    }
#endif
}
*/


void output_trap_def(file,name,num)
     FILE *file;
     char *name;
     int num;
{
  fprintf(file,".global %s\n%s:\t",name,name);
  fprintf(file,"\ttrap\t#%d\n",num);
  fputs("\tjmpr\tr31\n",file);
  fputs("\tnop\n\n",file);
}


/* For reversing the condition code */
char *rev_cond_name (op)
     rtx op;
{
  switch (GET_CODE (op))
    {
    case EQ:
      return "ne";
    case NE:
      return "eq";
    case LT:
      return "gt";
    case LE:
      return "egt";
    case GT:
      return "lt";
    case GE:
      return "elt";
    case LTU:
      return "gt";
    case LEU:
      return "egt";
    case GTU:
      return "lt";
    case GEU:
      return "elt";

    default:
      abort ();
    }
}













