/*  COFFEE-risc machine description
 *  Version history:
 *  0.9  1.4.2004    By Markus Moisio    First Release                   
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

/* remove this define to remove crasm compatibility 
#define CRASM
*/

#define ASM_SPEC "-m"

#define HAS_INIT_SECTION

/* Some random defines for COFFEE */
#define FIRST_ARG_REG 0
#define MAX_ARGS_IN_REGS 5
#define LAST_GENERAL_REGISTER 31
#define FIRST_PSEUDO_REGISTER 33
#define CC_REG	32	/* Can't name it C_REG.  */

#define TARGET_CPU_CPP_BUILTINS()		\
  do						\
    {						\
      builtin_define_std ("COFFEE");		\
    }						\
  while (0)

/* Not definen in COFFEE yet, not in 3.4.4  
#define CPP_PREDEFINES ""
*/
/* runtime configuration flags */
extern int target_flags;

/* co-proc number */
extern const char* fpuid;

/* fp compares */
extern int last_cmp_was_float;
extern GTY(()) rtx cmpsf_op1;
extern GTY(()) rtx cmpsf_op2;
/*extern GTY(()) rtx scratch;*/

#define TARGET_VERSION printf(stderr," (COFFEE-risc core)");
 
/*
 * Prevent gcc from adding -lgcc & -lc
 */
#define LIBGCC_SPEC ""
#define LIB_SPEC ""
#define TARGET_MEM_FUNCTIONS 1


#define TARGET_HARD_FP 1
#define HWFP (target_flags & TARGET_HARD_FP)
#define SWFP !HWFP


/*  
 * 14.6.2005 MM: Tryid to add support for MILK-coprocessor 
*/ 
#define TARGET_SWITCHES \
      {{"hard-float", TARGET_HARD_FP, "Hw FP coproc"}, \
       {"soft-float", -TARGET_HARD_FP, "Sw FP"}, \
       { "", TARGET_DEFAULT, NULL}}

#ifndef SUBTARGET_OPTIONS
#define SUBTARGET_OPTIONS
#endif

#define TARGET_OPTIONS \
{{"fpu-id=", &fpuid, "fp-coprocessor number", 0 },\
  SUBTARGET_OPTIONS 	}



#ifndef TARGET_DEFAULT
#define TARGET_DEFAULT 0
#endif

/* Modified for COFFEE */
#define BITS_BIG_ENDIAN 0
#define BYTES_BIG_ENDIAN 1
#define WORDS_BIG_ENDIAN 1

/* fixme
#define FLOAT_WORDS_BIG_ENDIAN 1
*/

/* alignment and data sizes */
#define BITS_PER_UNIT 8
#define BITS_PER_WORD 32
#define UNITS_PER_WORD 4
#define POINTER_SIZE 32
#define POINTER_BOUNDARY 32

#define PARM_BOUNDARY 32
#define STACK_BOUNDARY 32
#define FUNCTION_BOUNDARY 32
#define BIGGEST_ALIGNMENT 64    /* double */
#define BIGGEST_FIELD_ALIGNMENT 64
#define EMPTY_FIELD_BOUNDARY 32
#define STRUCTURE_SIZE_BOUNDARY 32
#define STRICT_ALIGNMENT 1

#define TARGET_FLOAT_FORMAT IEEE_FLOAT_FORMAT
#define WORD_REGISTER_OPERATIONS
#define LOAD_EXTEND_OP(MODE) ZERO_EXTEND

/* built-in data type sizes */
#define INT_TYPE_SIZE 32
#define SHORT_TYPE_SIZE 16
#define LONG_TYPE_SIZE 32
#define LONG_LONG_TYPE_SIZE 64
#define CHAR_TYPE_SIZE 8
#define FLOAT_TYPE_SIZE 32
#define DOUBLE_TYPE_SIZE 64
#define LONG_DOUBLE_TYPE_SIZE 64
/* This way we can do char operations with regular 
   register-register ops and not worry about negative
   chars, so it should be faster. */
#define DEFAULT_SIGNED_CHAR 0

#define MAX_FIXED_MODE_SIZE 32

/* Bizarre, let's keep it at 1 */
#define STORE_FLAG_VALUE 1

/* Not necessary so not defined in COFFEE 
#define NO_FUNCTION_CSE
#define NO_RECURSIVE_FUNCTION_CSE
*/

/* Pointers are 32-bit and functions return 32-bit values */
#define FUNCTION_MODE SImode
#define Pmode SImode

/* prologue and epilogue are in coffee.c. These are for GCC 2.95. 
#define FUNCTION_PROLOGUE(FILE, SIZE) output_function_prologue (FILE,SIZE)
#define FUNCTION_EPILOGUE(FILE, SIZE) output_function_epilogue (FILE,SIZE)
*/
/* And these for GCC 3.x 
#undef  TARGET_ASM_FUNCTION_PROLOGUE
#define TARGET_ASM_FUNCTION_PROLOGUE coffee_output_function_prologue
#undef  TARGET_ASM_FUNCTION_EPILOGUE
#define TARGET_ASM_FUNCTION_EPILOGUE coffee_output_function_epilogue
*/

#define EXIT_IGNORE_STACK 0

#define CASE_VECTOR_MODE SImode

/* 3.2.2005 MM: Removed to fix switch-case statement 
#define CASE_VECTOR_PC_RELATIVE 1
*/

/* Define results of standard character escape sequences.
 * These are obsolete in GCC 3.x 
 */
#define TARGET_BELL     007
#define TARGET_BS       010
#define TARGET_TAB      011
#define TARGET_NEWLINE  012
#define TARGET_VT       013
#define TARGET_FF       014
#define TARGET_CR       015
#define TARGET_ESC      027



/* Coffee does not have byte loads and stores */
#define SLOW_BYTE_ACCESS 1


#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C) 0

/* 
 * Floating point immediates cannot be loaded directly in to fp-regs.
 */
/*
#define PREFERRED_RELOAD_CLASS(X,CLASS)			\
  (((GET_CODE (X) == CONST_DOUBLE) ? NO_REGS : (GET_CODE (X) == CONST_INT && CLASS == FP_REGS)) ? GENERAL_REGS : CLASS)
*/

#define PREFERRED_RELOAD_CLASS(X,CLASS)			\
  ((GET_CODE (X) == CONST_DOUBLE) ? NO_REGS : CLASS)
/*
#define PREFERRED_OUTPUT_RELOAD_CLASS(X,CLASS) \
((GET_CODE (X) == MEM && (CLASS) == FP_REGS) ? GENERAL_REGS : (CLASS))

#define SECONDARY_RELOAD_CLASS(CLASS, MODE, X)			\
 (((GET_CODE (X) == MEM) && ((CLASS) == FP_REGS)) ? GENERAL_REGS : NO_REGS)
*/
/*
#define SECONDARY_INPUT_RELOAD_CLASS(CLASS,MODE,IN) \
  picochip_secondary_reload_class((CLASS), (MODE), (IN), 1)

#define SECONDARY_OUTPUT_RELOAD_CLASS(CLASS,MODE,OUT) \
  picochip_secondary_reload_class((CLASS), (MODE), (OUT), 0)
*/

/* Taken from or32. */
#define PREDICATE_CODES                   \
 { "sym_ref_mem_operand",       { MEM }}, \
  { "fp_reg_operand",           { REG }},


/* 
 * It would be silly to try and profile a 
 * simulated machine, would it not?
 */
#define FUNCTION_PROFILER(file,labelno)

/* Modifed for COFFEE 
   Changed the order of adding and storingn
*/
#define ASM_OUTPUT_REG_PUSH(stream,regno)       \
{ if(regno <= LAST_INT_REG)                     \
    {                                           \
        fputs("\taddi\tr27,r27,-4\n",stream);        \
        fprintf(stream,"\tst\tr%d,r27\n",regno);    \
    }        \
}
    
#define ASM_OUTPUT_REG_POP(stream,regno)        \
{ if(regno <= LAST_INT_REG) \
    {   \
        fputs("\taddi\tr27,r27,4\n",stream);        \
        fprintf(stream,"\tld\tr%d,r27,-4\n",regno);  \
    }  \
}

/* memory copy with 32 bit words. */
/* 02.08.2005 MM: 4 -> 1 
   04.05.2006 MM: 1 -> 4, moved back to basic "word is 4*8" but forgot to 
   change this originally. Failed in caller-save.c 650.
*/

#define MOVE_MAX 4

/*
 * Small int constants have no cost since they
 * can be used as immediates.
 * Larger int constants and symbols/labels
 * cost 2 instruction (addui/lhi).
 * Doubles cost more, since we have to load the
 * address (addui/lhi) and then load the constant.
 */
/*
#define CONST_COSTS(X, CODE, OUTER_CODE)        \
 case CONST_INT:                                \
  if(SMALL_INT(X)) return 0;                    \
  else return COSTS_N_INSNS(2);                 \
 case CONST:                                    \
 case SYMBOL_REF:                               \
 case LABEL_REF:                                \
  return COSTS_N_INSNS(2);                      \
 case CONST_DOUBLE:                             \
  return COSTS_N_INSNS(8);
*/
/* Let's try cris version of it, not in 3.4.4 
#define CONST_COSTS(RTX,CODE, OUTER_CODE)                           \
  case CONST_INT:                                                   \
    if (INTVAL(RTX) == 0) return 0;                                 \
    if (INTVAL (RTX) < 32 && INTVAL(RTX) >= -32) return 1;          \
   8 or 16 bits                                                 \
    if (INTVAL (RTX) <= 32767 && INTVAL (RTX) >= -32768) return 2;  \
    return 4;   32 bits (or very seldom, unsigned 16 bits)      \
  case CONST:                                                       \
  case LABEL_REF:                                                   \
  case SYMBOL_REF:                                                  \
    return 6;                                                       \
  case CONST_DOUBLE:                                                \
    if (RTX != CONST0_RTX(GET_MODE(RTX) == VOIDmode ? DImode :      \
                          GET_MODE(RTX)))                           \
       return 12;                                                   \
    return 0;  Make 0 cheap, else test-insns will not be used. 
*/

/* Check this LATER, removed after checking. Using default 
#define MEMORY_MOVE_COST(mode, class, in) \
((GET_MODE_SIZE(m) > UNITS_PER_WORD)?8:4)  */

/* Assembly directives for .text and .data sections */
#define TEXT_SECTION_ASM_OP ".text\n"
#define DATA_SECTION_ASM_OP ".data\n"
#undef READONLY_DATA_SECTION_ASM_OP
#define READONLY_DATA_SECTION_ASM_OP ".data"
  /*#define EXTRA_SECTIONS rdata_section */
#undef READONLY_DATA_SECTION
#define READONLY_DATA_SECTION data_section
  /*
#define EXTRA_SECTION_FUCTIONS \
void rdata_section() \
{ \
  if (in_section != readonly_data) \
  { \
    fprintf (asm_out_file, "%s\n", READONLY_DATA_SECTION_ASM_OP); \
  } \
  in_section = readonly_data; \
} \
*/
/* not in 3.4.4
#undef CONST_SECTION_ASM_OP
#define CONST_SECTION_ASM_OP ".data"
*/

/* Given a decl node or constant node, choose the section to output it in
   and select that section.  */
/* These are from mips.h, simplified somewhat. */

/* Not needed in COFFEE 
#define SELECT_RTX_SECTION(MODE,RTX)            \
  data_section()
*/

/* Not needed in COFFEE 
#define SELECT_SECTION(DECL, RELOC)					\
{                                                                       \
  if(RELOC)                                                             \
    data_section();                                                     \
  else if(TREE_CODE(DECL) == STRING_CST)				\
    data_section();							\
  else if(TREE_CODE(DECL) != VAR_DECL)                                  \
    text_section();                                                     \
  else                                                                  \
    data_section();                                                     \
}
*/

/* Other misc. assembly directives */
/* 11.9.2005 MM: Removed for the assembler */
#define ASM_APP_ON ""
#define ASM_APP_OFF ""
/*
#undef ASM_IDENTIFY_GCC
#define ASM_IDENTIFY_GCC(file)
*/
#undef ASM_IDENTIFY_LANGUAGE
#define ASM_IDENTIFY_LANGUAGE(file) /*nothing*/
/*#define ASM_IDENTIFY_GCC(file) fputs("; Compiled by GCC\\n",file) */

#define ASM_COMMENT_START ";"

/*
#ifdef CRASM
#define ASM_FILE_START(file) \
{ \
  fprintf(file,".code32\n.include\t\"crt.s\"\n.include\t\"bstuff.s\"\n"); \
  if (HWFP) \
    { \
      fprintf(file, "milk=%d\n", atoi(fpuid)); \
    } \
}
#else
#define ASM_FILE_START(file) \
{ \
  fprintf(file,".code32\n"); \
  if (HWFP) \
    { \
      fprintf(file, "milk=%d\n", atoi(fpuid)); \
    } \
}
#endif
*/

/*
#define ASM_FILE_END(file)  
*/

#ifdef CRASM
#define ASM_LONG ".word"
#define ASM_SHORT ".half"
#else
#define ASM_LONG ".long"
#define ASM_SHORT ".word"
#endif

/*
#define ASM_OPEN_PAREN "(" 
#define ASM_CLOSE_PAREN ")"
*/

/* If defined, a C expression to compute the alignment given to a
   constant that is being placed in memory.  CONSTANT is the constant
   and ALIGN is the alignment that the object would ordinarily have.
   The value of this macro is used instead of that alignment to align
   the object.

   If this macro is not defined, then ALIGN is used.

   The typical use of this macro is to increase alignment for string
   constants to be word aligned so that `strcpy' calls that copy
   constants can be done inline.  */
/* Stolen from mips.h */

#define CONSTANT_ALIGNMENT(EXP, ALIGN)                                  \
  ((TREE_CODE (EXP) == STRING_CST  || TREE_CODE (EXP) == CONSTRUCTOR)   \
   && (ALIGN) < BITS_PER_WORD                                           \
        ? BITS_PER_WORD                                                 \
        : (ALIGN))

/* If defined, a C expression to compute the alignment for a static
   variable.  TYPE is the data type, and ALIGN is the alignment that
   the object would ordinarily have.  The value of this macro is used
   instead of that alignment to align the object.

   If this macro is not defined, then ALIGN is used.

   One use of this macro is to increase alignment of medium-size
   data to make it all fit in fewer cache lines.  Another is to
   cause character arrays to be word-aligned so that `strcpy' calls
   that copy constants to character arrays can be done inline.  */
/* Stolen from mips.h */

#undef DATA_ALIGNMENT
#define DATA_ALIGNMENT(TYPE, ALIGN)                                     \
  ((((ALIGN) < BITS_PER_WORD)                                           \
    && (TREE_CODE (TYPE) == ARRAY_TYPE                                  \
        || TREE_CODE (TYPE) == UNION_TYPE                               \
        || TREE_CODE (TYPE) == RECORD_TYPE)) ? BITS_PER_WORD : (ALIGN))

/* Assembly directive definitions */
#define ASM_OUTPUT_ALIGN(stream,val) fprintf(stream,".align %d\n",(val))
#define ASM_OUTPUT_SKIP(stream,val)  fprintf(stream,".space %d\n",(val))

/* No fps in COFFEE
 * 20.6.2005 MM: Now there is SFmode (or tries to be)
 */

#ifdef CRASM
#define ASM_OUTPUT_BYTE_FLOAT(stream,value) \
   { long l;                                 \
      REAL_VALUE_TO_TARGET_SINGLE(value,l); \
      fprintf(stream,"\t.word 0x%08x\t\n;; %26.7e\n",l,value); }

#define ASM_OUTPUT_FLOAT(stream,value) \
   { long l;                                 \
      REAL_VALUE_TO_TARGET_SINGLE(value,l); \
      fprintf(stream,"\t.word 0x%08x\t\n;; %26.7e\n",l,value); }

#define ASM_OUTPUT_DOUBLE(stream,value) 			\
   { long l[2];                                 		\
      REAL_VALUE_TO_TARGET_DOUBLE(value,&l[0]); 		\
      fprintf(stream,"\t.word 0x%08x,0x%08x\t\n;; %26.16le\n",	\
	      l[0],l[1],value); }
#else
#define ASM_OUTPUT_BYTE_FLOAT(stream,value) \
   { long l;                                 \
      REAL_VALUE_TO_TARGET_SINGLE(value,l); \
      fprintf(stream,"\t.long 0x%08x\t\n;; %26.7e\n",l,value); }

#define ASM_OUTPUT_FLOAT(stream,value) \
   { long l;                                 \
      REAL_VALUE_TO_TARGET_SINGLE(value,l); \
      fprintf(stream,"\t.long 0x%08x\t\n;; %26.7e\n",l,value); }

#define ASM_OUTPUT_DOUBLE(stream,value) 			\
   { long l[2];                                 		\
      REAL_VALUE_TO_TARGET_DOUBLE(value,&l[0]); 		\
      fprintf(stream,"\t.long 0x%08x,0x%08x\t\n;; %26.16le\n",	\
	      l[0],l[1],value); }
#endif

/*
#define ASM_OUTPUT_LONG_DOUBLE(stream,value) \
   { long l[4];                                 \
      REAL_VALUE_TO_TARGET_DOUBLE(value,&l[0]); \
      fprintf(stream,"\t.word 0x%08x,0x%08x,0x%08x,0x%08x\t\n;; %26.18lle\n", \
	      l[0],l[1],l[2],l[3],value); }
*/

/* Assembly for data types */
#ifdef CRASM
#define ASM_OUTPUT_INT(stream,exp) \
      fprintf(stream,"\t.word "); output_addr_const(stream,exp); \
      putc('\n',stream) 

#define ASM_OUTPUT_SHORT(stream,exp) \
      fprintf(stream,"\t.half "); output_addr_const(stream,exp); \
      putc('\n',stream) 

#define ASM_OUTPUT_CHAR(stream,exp) \
      fprintf(stream,"\t.byte "); output_addr_const(stream,exp); \
      putc('\n',stream) 
#else
#define ASM_OUTPUT_INT(stream,exp) \
      fprintf(stream,"\t.long "); output_addr_const(stream,exp); \
      putc('\n',stream) 

#define ASM_OUTPUT_SHORT(stream,exp) \
      fprintf(stream,"\t.word "); output_addr_const(stream,exp); \
      putc('\n',stream) 

#define ASM_OUTPUT_CHAR(stream,exp) \
      fprintf(stream,"\t.byte "); output_addr_const(stream,exp); \
      putc('\n',stream) 
#endif

#define ASM_OUTPUT_BYTE(stream,val) fprintf(stream,"\t.byte 0x%02x\n",val)
#define ASM_BYTE_OP ".byte"

/*
 * Need to split up .ascii directives to avoid breaking 
 * the linker. 9.6.2005 MM: removed, works fine without this
 */
#define ASM_OUTPUT_ASCII(stream, ptr, len)			\
   asm_output_ascii(stream,ptr,len)
  

/* Assembly directive to identify functions */
#define ASM_OUTPUT_FUNCTION_PREFIX(stream, fnname)		\
  fputs(".proc ",stream); assemble_name(stream,fnname);		\
  fputs("\n",stream);

/* Assembly directive to globalize label */
#define ASM_OUTPUT_COMMON(stream,name,size,rounded)             \
{ data_section();                                               \
  fputs(".global\t",stream); assemble_name(stream,name);        \
  fputs("\n",stream); assemble_name(stream,name);               \
  fprintf(stream,":\n\t.space %d\n",rounded); }

/* This assembles common data in assembly */
#define ASM_OUTPUT_ALIGNED_COMMON(stream, name, size, alignment) \
{ data_section();						 \
  if((alignment)>8) 						 \
    fprintf(stream,".align %d\n",log_of_two(alignment>>3));    \
  fputs(".global\t",stream); assemble_name(stream,name);         \
  fputs("\n",stream);						 \
  assemble_name(stream,name);                                    \
  fprintf(stream,":\n.space %d\n",size); }

/* And this local data, testing
#define ASM_OUTPUT_ALIGNED_LOCAL(stream, name, size, alignment)  \
{ data_section();                                                \
  if((alignment)>8)						 \
    fprintf(stream,".align %d\n",log_of_two(alignment>>3));    \
  assemble_name(stream,name);                                    \
  fprintf(stream,":\n.space %d\n",size); }
*/

/* Output label */
#define ASM_OUTPUT_LABEL(stream, label)                 \
{ assemble_name(stream,label); fputs(":\n",stream); }

/* Output global label, not in 3.4.4 
#define ASM_GLOBALIZE_LABEL(stream,label)               \
{ fputs(".global ",stream); assemble_name(stream,label); \
  fputs("\n",stream); }
*/

/* Output reference to a label, 15.12.2004 MM: removed fputc('_',stream); */
#define ASM_OUTPUT_LABELREF(stream,name)                \
{ fputs(name,stream); }

/*
#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)  \
( fputs (".data ", (FILE));			\
  assemble_name ((FILE), (NAME));		\
  fprintf ((FILE), ",%d,%d\n", (SIZE),(ROUNDED));)
*/

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)  \
( fputs (".data\n", (FILE)),			\
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), ":\n.space %d\n", (SIZE)), \
  fprintf ((FILE), "\n.align %d\n",(ROUNDED)))

/* Output internal label for loops and stuff, not in 3.4.4
#define ASM_OUTPUT_INTERNAL_LABEL(stream,prefix,num)    \
  fprintf(stream, "%s%d:\n", prefix, num)
*/

/* Outputs labels for case-statement 
#define ASM_OUTPUT_CASE_LABEL(stream,prefix,num,table)  \
  { data_section(); fprintf(stream,".align 2\n");     \
    ASM_OUTPUT_INTERNAL_LABEL(stream,prefix,num); }
*/

/* What to output at the end of case-statement */
#define ASM_OUTPUT_CASE_END(stream,num,table)           \
  text_section()

#ifdef CRASM
/* Output the difference between two labels */
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, BODY, VALUE, REL)	\
  fprintf (FILE, "\t.word L%d-L%d\n", VALUE, REL)

/* Output absolute label */
#define ASM_OUTPUT_ADDR_VEC_ELT(stream,value)           \
  fprintf(stream,"\t.word L%d\n",value)
#else
/* Output the difference between two labels */
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, BODY, VALUE, REL)	\
  fprintf (FILE, "\t.long L%d-L%d\n", VALUE, REL)

/* Output absolute label */
#define ASM_OUTPUT_ADDR_VEC_ELT(stream,value)           \
  fprintf(stream,"\t.long L%d\n",value)
#endif

/* Creates a internal label and allocates space for it */
#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO)			\
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 11),			\
  sprintf ((OUTPUT), "%s%d", (NAME), (LABELNO)))

/* Generates an internal label in string */ 
#define ASM_GENERATE_INTERNAL_LABEL(string,prefix,num)  \
  sprintf(string, "*%s%d",prefix, num)

#define GLOBAL_ASM_OP ".global "

/* These are put in coffee.c */
#define PRINT_OPERAND_ADDRESS(file,address) print_operand_address(file,address)
#define PRINT_OPERAND_PUNCT_VALID_P(code) print_operand_punct_valid_p(code)
#define PRINT_OPERAND(FILE, X, CODE) print_operand (FILE, X, CODE)

/* Register usage
 * 14.6.2005 MM: Modifications to support HW FP
 * There are 32 GPRS + 1 CCR, 8 FP 
*/
/*
#define CLASS_CANNOT_CHANGE_SIZE	FP_REGS
*/

#define DEFAULT_PCC_STRUCT_RETURN 1

/* Struct pointers are returned in R0 
#define STRUCT_VALUE_REGNUM 0
*/

/* Above is wrong. This indicates to return structs as invisible 
   first argument*/
#define STRUCT_VALUE 0

/* Defines for internal usage */
#define FIRST_INT_REG 0
#define LAST_INT_REG 31
#define FIRST_FP_REG 32
#define LAST_FP_REG 39
#define IS_FP_REG(regno) ((regno >= FIRST_FP_REG) && (regno <= LAST_FP_REG)) 
#define IS_PSEUDO_REG(regno)            ((regno) >= FIRST_PSEUDO_REGISTER)  

/* COFFEE: fixed r27 (stack), r28 (frame), R29 superuser mode register, 
   R30 superuser mode register, r31 (link register), CCR 
   14.6.2005 MM: modifed to support HW FP */

#define FIXED_REGISTERS { \
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }


/* Modifed for COFFEE r0-4 args, r20-26 temp, fp, sp, lr(=srp), 
 * Might need more  
 * 14.6.2005 MM: Added FP regs, problems in prologue/epilogue saving so all
 * FP regs are call-used
 */
#define CALL_USED_REGISTERS { \
 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, \
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}

/* Modifed for COFFEE 
 * 15.6.2005 MM: added fp regs
 */
#define REGISTER_NAMES                                    \
{ "r0" , "r1" , "r2" , "r3" , "r4" , "r5" , "r6" , "r7",  \
  "r8" , "r9" , "r10", "r11", "r12", "r13", "r14", "r15", \
  "r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23", \
  "r24", "r25", "r26", "r27", "r28", "r29", "r30", "r31", \
  "c0" }

/* 15.6.2005 MM: added to support FP 
 * modifies fixed_regs & call_used_regs according to flag hard_float
 
#define CONDITIONAL_REGISTER_USAGE                             \
{                                                              \
  if (!HWFP)                                                   \
  {                                                            \
    int regno;                                                 \
    for (regno = FIRST_FP_REG; regno <= LAST_FP_REG; regno++)  \
    {                                                          \
      fixed_regs[regno] = call_used_regs[regno] = 1;           \
    }                                                          \
  }                                                            \
}
*/ 

/* values that can go in particular registers. */
/* doubles will be the only thing that will take 2 registers. */
#define HARD_REGNO_NREGS(regno,mode) \
  ((GET_MODE_SIZE(mode) + UNITS_PER_WORD - 1)/UNITS_PER_WORD)

/* 1 if register number regno can hold a value of mode mode
 * On coffee floats can be anywhere, ints only in int registers.
 * 15.6.2005 MM: Changed to support FP
 * 18.1.2006 MM: int can be in float regs too
 */

#define HARD_REGNO_MODE_OK(regno,mode) 1



#define MODES_TIEABLE_P(mode1, mode2) 1

/* Basic register class names */
enum reg_class
{
  NO_REGS,                      /* no registers in set */
  GENERAL_REGS,                 /* integer registers */
  TWIN_REGS,
  /*  FP_REGS,                        floating point registers */
  CC,                           /* condition code */
  ALL_REGS,                     /* all registers */
  LIM_REG_CLASSES               /* max value + 1 */
};

#define N_REG_CLASSES (int) LIM_REG_CLASSES

#define REG_CLASS_NAMES                      \
{                                            \
  "NO_REGS",                                 \
  "GENERAL_REGS",                            \
  "TWIN_REGS", \
/*  "FP_REGS",                               */\
  "CC_REG",                                  \
  "ALL_REGS"                                 \
}

/* This defines which register belong in which register class names. 
 * First is NO_REGS and so on.
 */
#define REG_CLASS_CONTENTS    \
{                             \
  { 0x00000000, 0x00000000 }, \
  { 0xffffffff, 0x00000000 }, \
  { 0xffffffff, 0x00000000 }, \
/*  { 0x00000000, 0x000000ff }, */\
  { 0x00000000, 0x00000001 }, \
  { 0xffffffff, 0x00000001 }  \
}

/* Return the name of he smallest class containg register number regno
 * 15.6.2005 MM: Changed to support FP
 */
/*
#define REGNO_REG_CLASS(REGNO)              \
  ((REGNO >= 32) && (REGNO <= 39) ? FP_REGS : GENERAL_REGS)
*/
#define REGNO_REG_CLASS(REGNO) GENERAL_REGS

/* Pointers can be in general registers */
#define BASE_REG_CLASS GENERAL_REGS
#define INDEX_REG_CLASS NO_REGS

/* Register classes from letters in md
 * 15.6.2005 MM: Changed to support FP
 */

#define REG_CLASS_FROM_LETTER(C) NO_REGS
/*  (C == 'f' ? FP_REGS : NO_REGS)
*/

/* Canonicalize a comparison from one we don't have to one we do have.  */
/*
#define CANONICALIZE_COMPARISON(CODE,OP0,OP1) \
  do {									\
    if ((GET_MODE_CLASS ((GET_MODE (OP0))) == MODE_FLOAT) &&            \
	((CODE) == GE || (CODE) == GT))                                 \
      {									\
	rtx temp = (OP0);						\
	(OP0) = (OP1);							\
	(OP1) = temp;							\
	(CODE) = swap_condition (CODE);					\
      }                                                                 \
     else if ((GET_MODE_CLASS(GET_MODE (OP0)) == SFmode) &&            \
	((CODE) == NE))                                                 \
      {                                                                 \
	(CODE) = reverse_condition (CODE);                               \
      }                                                                 \
  } while (0)
*/

/*
#define CANONICALIZE_COMPARISON(CODE,OP0,OP1) \
  do {									\
    if (((CODE) == GE || (CODE) == GT || (CODE) == GEU || (CODE) == GTU) \
	&& (GET_CODE (OP1) == REG || (OP1) == const0_rtx))		\
      {									\
	rtx tem = (OP0);						\
	(OP0) = (OP1);							\
	(OP1) = tem;							\
	(CODE) = swap_condition (CODE);					\
      }									\
    if (((CODE) == LT || (CODE) == LTU)					\
	&& GET_CODE (OP1) == CONST_INT && INTVAL (OP1) == 256)		\
      {									\
	(CODE) = (CODE) == LT ? LE : LEU;				\
	(OP1) = GEN_INT (255);						\
      }									\
  } while (0)
*/
/*
#define SELECT_CC_MODE(OP,X,Y) \
  (GET_MODE_CLASS (GET_MODE (X)) == MODE_FLOAT ? CCFPmode : CCmode)    \
*/

#define NOTICE_UPDATE_CC(EXP, INSN) \
{									      \
  enum attr_cc cc = get_attr_cc (INSN);					      \
  rtx dest = SET_DEST (EXP);						      \
  switch (cc)								      \
    {									      \
     case CC_SET:							      \
/* if (GET_CODE (EXP) == PARALLEL) abort();				      \
 */ \
      cc_status.flags = 0;						      \
      cc_status.value1 = dest;						      \
      cc_status.value2 = 0;						      \
      break;								      \
									      \
    case CC_UNCHANGED:							      \
      break;								      \
									      \
    case CC_CLOBBER:							      \
      CC_STATUS_INIT;							      \
      break;								      \
									      \
    default:								      \
      abort ();								      \
    }									      \
}


/* If we use the normal load/store ops in DLX,
   it will always sign-extend sub-word types. */
/* Modified for COFFEE 
#define LOAD_EXTEND_OP(mode) SIGN_EXTEND
*/

/*
 * Memory address stuff.
 */
#define MAX_REGS_PER_ADDRESS 1

#define CONSTANT_ADDRESS_P(X) CONSTANT_P(X)


/* Taken from cris. Checks if register number is valid for a base-pointer. */
#define REGNO_OK_FOR_BASE_P(REGNO) \
((REGNO) <= LAST_GENERAL_REGISTER || \
 (unsigned) reg_renumber[REGNO] <= LAST_GENERAL_REGISTER)


#ifndef REG_OK_STRICT

/* Nonzero if X is a hard reg that can be used as a base reg
   or if it is a pseudo reg. This too from cris  */
#define REG_OK_FOR_BASE_P(X) \
  (REGNO(X) <= LAST_GENERAL_REGISTER || REGNO(X) >= FIRST_PSEUDO_REGISTER)

#define REG_OK_FOR_INDEX_P(C) 0
#define REGNO_OK_FOR_INDEX_P(C) 0

#else

/* Nonzero if X is a hard reg that can be used as a base reg.  */
#define REG_OK_FOR_BASE_P(X) REGNO_OK_FOR_BASE_P (REGNO (X))

#define REG_OK_FOR_INDEX_P(C) 0
#define REGNO_OK_FOR_INDEX_P(C) 0

#endif


/* I'll keep these for now. Change if problems arise. 
 * Checks that offset fits in immediate field.
 * This is a helper macro for LEGITIMATE_OFFSET_ADDRESS_P.
 */
#define LEGITIMATE_ADDRESS_INTEGER_P(X,OFFSET)          \
 (GET_CODE (X) == CONST_INT && SMALL_INT(X))

#define LEGITIMATE_ADDRESS_REGISTER(NUM, STRICT) \
   coffee_legitimate_address_register (NUM,STRICT)
 
/* Helper macro for GO_IF_LEGITIMATE_ADDRESS. Checks if rtx X of 
 * mode MODE is a legal offset address 
#define LEGITIMATE_OFFSET_ADDRESS_P(MODE,X)             \
 (GET_CODE (X) == PLUS                                  \
  && GET_CODE (XEXP (X, 0)) == REG                      \
  && REG_OK_FOR_BASE_P (XEXP (X, 0))                    \
  && LEGITIMATE_ADDRESS_INTEGER_P (XEXP (X, 1), 0)      \
  && (((MODE) != DFmode && ((MODE) != DImode) && ((MODE) != QImode) || ((MODE) != HImode))            \
      || LEGITIMATE_ADDRESS_INTEGER_P (XEXP (X, 1), 4)))
*/

#define LEGITIMATE_OFFSET_ADDRESS_P(MODE,X,STRICT)             \
 (GET_CODE (X) == PLUS                                  \
  && GET_CODE (XEXP (X, 0)) == REG                      \
  && LEGITIMATE_ADDRESS_REGISTER(XEXP(X,0),STRICT)        \
  && LEGITIMATE_ADDRESS_INTEGER_P (XEXP (X, 1), 0)      \
  && (((MODE) != DFmode && (MODE) != DImode)  \
      || LEGITIMATE_ADDRESS_INTEGER_P (XEXP (X, 1), 4)) \
  && ((MODE) != QImode) \
  && ((MODE) != HImode))
/* (MODE) != QImode && (MODE) != HImode)) */            

/* Same as previous but nonoffset address */
#define LEGITIMATE_NONOFFSET_ADDRESS_P(MODE,X, STRICT)          \
             (GET_CODE(X) == REG && LEGITIMATE_ADDRESS_REGISTER(X,STRICT))

      
#ifdef REG_OK_STRICT

/* If rtx X of mode MODE is legal address operand goto ADDR */
#define GO_IF_LEGITIMATE_ADDRESS(MODE,X,ADDR)           \
  if(LEGITIMATE_OFFSET_ADDRESS_P(MODE,X,1)) goto ADDR;    \
  if(LEGITIMATE_NONOFFSET_ADDRESS_P(MODE,X,1)) goto ADDR; 
/*  if(GET_CODE(X) == SYMBOL_REF) goto ADDR;*/

#else

#define GO_IF_LEGITIMATE_ADDRESS(MODE,X,ADDR)           \
  if(LEGITIMATE_OFFSET_ADDRESS_P(MODE,X,0)) goto ADDR;    \
  if(LEGITIMATE_NONOFFSET_ADDRESS_P(MODE,X,0)) goto ADDR; 

#endif

/* We don't need this */
#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN) {}

/*
#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN) {}   \
{ if (GET_CODE (X) == SYMBOL_REF)                               \
    (X) = copy_to_reg (X);                                      \
  if (memory_address_p (MODE, X))                               \
    goto WIN;                                                   \
}
*/

/* We don't have any mode dependant addresses */
#define GO_IF_MODE_DEPENDENT_ADDRESS(addr,label) 
/*
  if ((GET_MODE(addr) == QImode) && (XEXP(addr,0) == REG)) goto label;  \
  if ((GET_MODE(addr) != QImode)) goto label;
*/ 
/* Helper macro */
#define SMALL_INT(X) (INTVAL(X) >= -16383 && INTVAL(X) <= 16382)

/* I is 15-bit signed immediate. L is 15-bit unsigned immediate.
 *  J is 16-bit signed immediate. K is 6-bit unsigned
 *  Used in coffee.md for immediate value ranges 
 */

#define CONST_OK_FOR_LETTER_P(VALUE, C)  \
  ((C) == 'I' ? (VALUE) >= -16384 && (VALUE) <= 16383 \
   : (C) == 'J' ? (VALUE) >= 0 && (VALUE) <= 65536  \
   : (C) == 'K' ? (VALUE) >= 0 && (VALUE) <= 31           \
   : (C) == 'L' ? (VALUE) >= -32768 && (VALUE) <= 32767  \
   : (C) == 'M' ? (VALUE) >= 0 && (VALUE) <= 32767  \
   : (C) == 'N' ? (VALUE) >= -8388608 && (VALUE) <= 8388607  \
   : 0)

/* Check if rtx X is legitimate constant */
#define LEGITIMATE_CONSTANT_P(X) (GET_CODE (X) != CONST_DOUBLE)

  

/* Calculate the size mode takes */
#define CLASS_UNITS(mode, size)                                         \
  ((GET_MODE_SIZE (mode) + (size) - 1) / (size))

/* Calculate the number of registers mode MODE takes */
#define CLASS_MAX_NREGS(CLASS, MODE)    \
 ((MODE) == VOIDmode \
  ? 1 : ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD))


/* stack frame */

#define STACK_GROWS_DOWNWARD
#define FRAME_GROWS_DOWNWARD
#define STACK_POINTER_OFFSET 0
#define STARTING_FRAME_OFFSET 0

/* Taken from elxsi */
/* Changed offset +=1 -> 4
   also offset = 0 -> 8
*/
#define INITIAL_FRAME_POINTER_OFFSET(DEPTH)			\
{ int regno;							\
  int offset = 0;						\
  for( regno=0; regno < FIRST_PSEUDO_REGISTER;  regno++ )	\
    if( regs_ever_live[regno] && !call_used_regs[regno] )	\
      offset += 4;						\
  if (!current_function_is_leaf || regs_ever_live[LINK_REGNUM]) \
    offset +=4;                                                   \
  (DEPTH) = (offset + COFFEE_ALIGN(current_function_outgoing_args_size,4) + \
            ((get_frame_size() + 3) & ~3));		\
}

#define FIRST_PARM_OFFSET(FNDECL) 0


#define STACK_POINTER_REGNUM 27
#define FRAME_POINTER_REGNUM 28

#define PROMOTE_PROTOTYPES 1

/* access args with frame pointer */
#define ARG_POINTER_REGNUM FRAME_POINTER_REGNUM 

#define STRICT_ARGUMENT_NAMING 1

/* This is a (something, something) reg */
#define STATIC_CHAIN_REGNUM 5

/* Frame pointer is not required in leaf functions */
#define FRAME_POINTER_REQUIRED 0

/* Generate rtx for the function return value */
#define FUNCTION_VALUE(VALTYPE, FUNC)  \
  gen_rtx (REG, TYPE_MODE (VALTYPE), FIRST_ARG_REG)

/* Structs are returned in memory (stack). */
#define RETURN_IN_MEMORY(TYPE) (TYPE_MODE (TYPE) == BLKmode)


/* Argument passing function taken from clipper. Start here

**** Clipper argument passing functions *******   */   

/* This struct keeps track of the arguments 
struct _clipper_cum_args { int num; int size; };
*/

#define CUMULATIVE_ARGS int

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0.

   clipper passes the address of a struct in r0, set num = 1 in this case */

#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE,LIBNAME,INDIRECT, N_NAMED_ARGS) \
   ((CUM) = 0)

/* internal helper : size of an argument */
#define CLIPPER_ARG_SIZE(MODE, TYPE)				\
(((MODE) != BLKmode							\
  ? (GET_MODE_SIZE (MODE) + (UNITS_PER_WORD - 1)) / UNITS_PER_WORD 	\
  : (int_size_in_bytes(TYPE) + (UNITS_PER_WORD - 1)) / UNITS_PER_WORD)	\
    * UNITS_PER_WORD)

/* Update the data in CUM to advance over an argument
   of mode MODE and data type TYPE.
   (TYPE is null for libcalls where that information may not be available.)  */
#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED)			      \
do									      \
{									      \
  int reg = 0;								      \
									      \
  if ((CUM) <= 16							      \
      && (GET_MODE_CLASS(MODE)==MODE_INT || GET_MODE_CLASS(MODE)==MODE_FLOAT) \
      && (GET_MODE_SIZE (MODE) <= 4)					      \
      && ((TYPE) == NULL || !AGGREGATE_TYPE_P(TYPE))			      \
      && ((MODE) != DImode))				      \
    {									      \
       reg = 1; \
       (CUM) += 4; \
    }									      \
									      \
  if (! reg)								      \
    {									      \
      int align = FUNCTION_ARG_BOUNDARY (MODE, TYPE) / BITS_PER_UNIT;	      \
      (CUM) += align - 1;						      \
      (CUM) &= ~(align - 1);					      \
      (CUM) += CLIPPER_ARG_SIZE (MODE, TYPE);			      \
    }									      \
} while (0)

/* Define where to put the arguments to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).

   5 args may go into regs. These must be MODE_INT or MODE_FLOAT but only
   if they really fit into ONE register. The exception is a DImode arg
   that occupies both register slots. */
/*
#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)				     \
  (((CUM).num < 5							     \
    && (GET_MODE_CLASS(MODE)==MODE_INT || GET_MODE_CLASS(MODE)==MODE_FLOAT)  \
    && (GET_MODE_SIZE (MODE) <= 8)					     \
    && ((TYPE) == NULL || !AGGREGATE_TYPE_P(TYPE))			     \
    && ((MODE) != DImode || (CUM).num == 0))				     \
   ? gen_rtx (REG, (MODE),						     \
	      GET_MODE_CLASS(MODE) == MODE_FLOAT ? (CUM).num+16 : (CUM).num) \
   : 0)
*/

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)				     \
  (((CUM) < 16							     \
    && (GET_MODE_CLASS(MODE)==MODE_INT || GET_MODE_CLASS(MODE)==MODE_FLOAT)  \
    && (GET_MODE_SIZE (MODE) <= 4)					     \
    && ((TYPE) == NULL || !AGGREGATE_TYPE_P(TYPE))			     \
    && ((MODE) != DImode))				     \
   ? gen_rtx (REG, (MODE),(CUM) / 4) \
   : 0)

/*  ******* Clipper argument passing functions ********* */


/* Generates rtx for where to put library calls return value */
#define LIBCALL_VALUE(MODE)  gen_rtx (REG, MODE, FIRST_ARG_REG)

/*
 * As is usual in C, the caller pops all the arguments.
 */

#define RETURN_POPS_ARGS(FUNDECL, FUNTYPE, STACKSIZE) 0

/* Checks if register is a argument register */
#define FUNCTION_ARG_REGNO_P(REGNO) \
 ((REGNO) >= FIRST_ARG_REG && (REGNO) < FIRST_ARG_REG + (MAX_ARGS_IN_REGS))

/* Check if register is a return value register */
#define FUNCTION_VALUE_REGNO_P(regno) ((regno) == FIRST_ARG_REG)

/*
 * Trampoline stuff, stolen from mips.h.
 * This will need serious work.
 * I have no idea what is a trampoline MM.
 */

/* A C statement to output, on the stream FILE, assembler code for a
   block of data that contains the constant parts of a trampoline. 
   This code should not include a label--the label is taken care of
   automatically.  */

/* No trampolines yet for COFFEE too */
#define TRAMPOLINE_TEMPLATE(STREAM)                                      \
{                                                                        \
}

/* A C expression for the size in bytes of the trampoline, as an
   integer.  */

#define TRAMPOLINE_SIZE (9*4)

/* Alignment required for trampolines, in bits.

   If you don't define this macro, the value of `BIGGEST_ALIGNMENT'
   is used for aligning trampolines.  */

/* #define TRAMPOLINE_ALIGNMENT 32 */

/* A C statement to initialize the variable parts of a trampoline. 
   ADDR is an RTX for the address of the trampoline; FNADDR is an
   RTX for the address of the nested function; STATIC_CHAIN is an
   RTX for the static chain value that should be passed to the
   function when it is called.  */

#define INITIALIZE_TRAMPOLINE(ADDR, FUNC, CHAIN)                            \
{                                                                           \
  rtx addr = ADDR;                                                          \
  emit_move_insn (gen_rtx (MEM, SImode, plus_constant (addr, 28)), FUNC);   \
  emit_move_insn (gen_rtx (MEM, SImode, plus_constant (addr, 32)), CHAIN);  \
                                                                            \
  /* Flush the instruction cache.  */                                       \
  emit_library_call (gen_rtx (SYMBOL_REF, Pmode, "__gcc_flush_cache"), \
                     0, VOIDmode, 1, addr, Pmode);                          \
}

/* Flush the instruction cache.  */

#define TRANSFER_FROM_TRAMPOLINE                                        \
                                                                        \
void                                                                    \
__gcc_flush_cache (addr)                                                \
     char *addr;                                                        \
{                                                                       \
  if (cacheflush (addr, TRAMPOLINE_SIZE, 1) < 0)                        \
    perror ("cacheflush of trampoline code");                           \
}

/* Align an address */
#define COFFEE_ALIGN(n,a) (((n) + (a) - 1) & ~((a) - 1))

#define LINK_REGNUM 31

/* 23.01.2007 MM: Adding debugging support (dwarf2) */

         
/* How to renumber registers for dbx and gdb.
   Vax needs no change in the numeration.  */


#define DBX_REGISTER_NUMBER(REGNO) (REGNO)


#define DWARF2_DEBUGGING_INFO
#define PREFERRED_DEBUGGING_TYPE DWARF2_DEBUG
#define DWARF2_FRAME_INFO 1

/* Generate .file/.loc directives, so that the assembler generates the
   line table. */

#define DWARF2_ASM_LINE_DEBUG_INFO 1

/* Specify where the return address lives before entry to the
   prologue.  This is required to enable DWARF debug information to be
   generated. */

#define INCOMING_RETURN_ADDR_RTX  gen_rtx_REG (Pmode, LINK_REGNUM)

#define DWARF_FRAME_RETURN_COLUMN DWARF_FRAME_REGNUM (LINK_REGNUM)



/* Perform any needed actions needed for a function that is receiving a
   variable number of arguments.  */
#define SETUP_INCOMING_VARARGS(ARGSSOFAR, MODE, TYPE, PRETEND, SECTIME) \
    { \
       if (!SECTIME)\
        { \
	   if ((ARGSSOFAR) < (MAX_ARGS_IN_REGS * UNITS_PER_WORD)) \
            { \
	      (PRETEND) = ((MAX_ARGS_IN_REGS * UNITS_PER_WORD) - ARGSSOFAR); \
	     } \
         } \
     }
