/*  COFFEE-risc machine description  
 *   Version history:    
 *  0.9  1.4.2004   By Markus Moisio    First Release
 *		      	   
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include "system.h"
#include "rtl.h"
#include "coretypes.h"
#include "tm.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "real.h"
#include "insn-config.h"
#include "conditions.h"
#include "output.h"
#include "insn-attr.h"
#include "tree.h"
#include "expr.h"
#include "c-tree.h"
#include "function.h"
#include "flags.h"
#include "recog.h"
#include "toplev.h"
#include "ggc.h"

#include "tm_p.h"
#include "target.h"
#include "target-def.h"



int last_cmp_was_float;
char* fpuid; /* to store co-proc number */

/*static void clix_asm_out_destructor PARAMS ((rtx, int)); */
char* get_function_name PARAMS ((void));
void print_operand_address PARAMS ((FILE*, register rtx));
int print_operand_punct_valid_p PARAMS ((int));
void print_operand PARAMS ((FILE*, rtx, int));
int intsym_ref_mem_operand PARAMS ((rtx, enum machine_mode));
int signed_comparison_operator PARAMS ((register rtx, enum machine_mode));
int gen_call_value_1 PARAMS ((rtx[]));
void asm_output_ascii PARAMS ((FILE*, unsigned char*, int));
void output_trap_def PARAMS ((FILE*,char*,int));
/*void output_function_prologue PARAMS ((FILE*, int));
void output_function_epilogue PARAMS ((FILE*, int));
*/
int log_of_two PARAMS ((int));
char *rev_cond_name PARAMS ((rtx));
enum coffee_function_type coffee_compute_function_type PARAMS((tree));
int coffee_legitimate_pic_operand_p PARAMS ((rtx));
void coffee_finalize_pic PARAMS((void));
rtx coffee_legitimize_pic_address PARAMS ((rtx, rtx ));
void coffee_setup_incoming_varargs PARAMS((CUMULATIVE_ARGS*, enum machine_mode, tree, int*, int));
rtx coffee_va_arg PARAMS ((tree, tree));
static void coffee_reload_lr PARAMS ((rtx, int));
void coffee_load_pic_register PARAMS ((void));
void coffee_expand_epilogue PARAMS ((void));
void coffee_expand_prologue PARAMS ((void));


#include <stdio.h>
#include <string.h>
#include <ctype.h>



#define REG_NEEDS_SAVE(i) (regs_ever_live[i] && !(call_used_regs[i]))

/*struct gcc_target targetm = TARGET_INITIALIZER;*/

/* Structure to be filled in by coffee_compute_frame_size. From m32r port.*/
struct coffee_frame_info
{
  unsigned int total_size;	/* # bytes that the entire frame takes up.  */
  unsigned int extra_size;	/* # bytes of extra stuff.  */
  unsigned int pretend_size;	/* # bytes we push and pretend caller did.  */
  unsigned int args_size;	/* # bytes that outgoing arguments take up.  */
  unsigned int reg_size;	/* # bytes needed to store regs.  */
  unsigned int var_size;	/* # bytes that variables take up.  */
  unsigned int save_fp;		/* Nonzero if fp must be saved.  */
  unsigned int save_lr;		/* Nonzero if lr (return addr) must be saved.  */
  int          initialized;	/* Nonzero if frame size already calculated.  */
};

/* Current frame information calculated by coffee_compute_frame_size.  */
static struct coffee_frame_info current_frame_info;

/* Zero structure to initialize current_frame_info.  */
static struct coffee_frame_info zero_frame_info;

/* The table we use to reference PIC data.  */
static rtx global_offset_table;

/* Frame info from m32r */

unsigned int
coffee_compute_frame_size (int size)	/* # of var. bytes allocated.  */
{
  int regno;
  unsigned int total_size, var_size, args_size, pretend_size, extra_size;
  unsigned int reg_size, frame_size;
  unsigned int gmask;
  enum coffee_function_type fn_type;
  int interrupt_p;
  int pic_reg_used = flag_pic && (current_function_uses_pic_offset_table);

  var_size	= COFFEE_STACK_ALIGN (size);
  args_size	= COFFEE_STACK_ALIGN (current_function_outgoing_args_size);
  pretend_size	= current_function_pretend_args_size;
  extra_size	= FIRST_PARM_OFFSET (0);
  total_size	= extra_size + pretend_size + args_size + var_size;
  reg_size	= 0;
  gmask		= 0;

  /* See if this is an interrupt handler.  Call used registers must be saved
     for them too.  */
  fn_type = coffee_compute_function_type (current_function_decl);
  interrupt_p = COFFEE_INTERRUPT_P (fn_type);

  /* Calculate space needed for registers.  */
  for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)
    {
      if (MUST_SAVE_REGISTER (regno, interrupt_p)
          || (regno == PIC_OFFSET_TABLE_REGNUM && pic_reg_used))
	{
	  reg_size += UNITS_PER_WORD;
	}
    }

  current_frame_info.save_fp = frame_pointer_needed;
  current_frame_info.save_lr = !curren_function_is_leaf || pic_reg_used;

  reg_size += ((current_frame_info.save_fp + current_frame_info.save_lr)
	       * UNITS_PER_WORD);
  total_size += reg_size;

  /* ??? Not sure this is necessary, and I don't think the epilogue
     handler will do the right thing if this changes total_size.  */
  total_size = COFFEE_STACK_ALIGN (total_size);

  frame_size = total_size - (pretend_size + reg_size);

  /* Save computed information.  */
  current_frame_info.total_size   = total_size;
  current_frame_info.extra_size   = extra_size;
  current_frame_info.pretend_size = pretend_size;
  current_frame_info.var_size     = var_size;
  current_frame_info.args_size    = args_size;
  current_frame_info.reg_size	  = reg_size;
  current_frame_info.gmask	  = gmask;
  current_frame_info.initialized  = reload_completed;

  /* Ok, we're done.  */
  return total_size;
}

/* Type of function DECL.

   The result is cached.  To reset the cache at the end of a function,
   call with DECL = NULL_TREE.  */

enum coffee_function_type
coffee_compute_function_type (tree decl)
{
  /* Cached value.  */
  static enum coffee_function_type fn_type = COFFEE_FUNCTION_UNKNOWN;
  /* Last function we were called for.  */
  static tree last_fn = NULL_TREE;

  /* Resetting the cached value?  */
  if (decl == NULL_TREE)
    {
      fn_type = COFFEE_FUNCTION_UNKNOWN;
      last_fn = NULL_TREE;
      return fn_type;
    }

  if (decl == last_fn && fn_type != COFFEE_FUNCTION_UNKNOWN)
    return fn_type;

  /* Compute function type.  */
  fn_type = (lookup_attribute ("interrupt", DECL_ATTRIBUTES (current_function_decl)) != NULL_TREE
	     ? COFFEE_FUNCTION_INTERRUPT
	     : COFFEE_FUNCTION_NORMAL);

  last_fn = decl;
  return fn_type;
}

/* M32R stack frames look like:

             Before call                       After call
        +-----------------------+       +-----------------------+
        |                       |       |                       |
   high |  local variables,     |       |  local variables,     |
   mem  |  reg save area, etc.  |       |  reg save area, etc.  |
        |                       |       |                       |
        +-----------------------+       +-----------------------+
        |                       |       |                       |
        |  arguments on stack.  |       |  arguments on stack.  |
        |                       |       |                       |
  SP+0->+-----------------------+       +-----------------------+
                                        |  reg parm save area,  |
                                        |  only created for     |    
                                        |  variable argument    |    
                                        |  functions            |    
					+-----------------------+
                                        |   previous frame ptr  |
                                        +-----------------------+    
                                        |                       |    
                                        |  register save area   |    
                                        |                       |    
					+-----------------------+
                                        |    return address     |    
                                        +-----------------------+    
                                        |                       |    
                                        |  local variables      |    
                                        |                       |    
                                        +-----------------------+    
                                        |                       |    
                                        |  alloca allocations   |    
                                        |                       |    
                                        +-----------------------+    
                                        |                       |    
   low                                  |  arguments on stack   |    
   memory                               |                       |    
                                  SP+0->+-----------------------+    

Notes:
1) The "reg parm save area" does not exist for non variable argument fns.
2) The "reg parm save area" can be eliminated completely if we saved regs
   containing anonymous args separately but that complicates things too
   much (so it's not done).
3) The return address is saved after the register save area so as to have as
   many insns as possible between the restoration of `lr' and the `jmp lr'.  */

/* Structure to be filled in by m32r_compute_frame_size with register
   save masks, and offsets for the current function.  */

void
coffee_expand_prologue (void)
{
  int regno;
  int frame_size;
  unsigned int gmask;
  int pic_reg_used = flag_pic && (current_function_uses_pic_offset_table);
  int offset = 0;

  rtx stackp_mem = gen_rtx_MEM(SImode, plus_constant (stack_pointer_rtx,offset));

  if (! current_frame_info.initialized)
    coffee_compute_frame_size (get_frame_size ());

  /* These cases shouldn't happen.  Catch them now.  */
  if (current_frame_info.total_size == 0)
    abort ();

  /* Allocate space for register arguments if this is a variadic function.  */
  if (current_frame_info.pretend_size != 0)
    {
      /* Use a HOST_WIDE_INT temporary, since negating an unsigned int gives
	 the wrong result on a 64-bit host.  */
      HOST_WIDE_INT pretend_size = current_frame_info.pretend_size;
      emit_insn (gen_addsi3 (stack_pointer_rtx,
			     stack_pointer_rtx,
			     GEN_INT (-pretend_size)));
    }

  /* Save any registers we need to and set up fp.  */
  if (current_frame_info.save_fp)
    {
      offset += 4;
      stackp_mem = gen_rtx_MEM(SImode,plus_constant (stack_pointer_rtx, -offset));
      emit_insn (gen_movsi (stackp_mem, frame_pointer_rtx));
    }

  /* Save any needed call-saved regs (and call-used if this is an
     interrupt handler).  */
  for (regno = 0; regno < FIRST_PSEUDO_REGISTER; ++regno)
    {
      if ((REG_NEEDS_SAVE(regno))
      {
	offset += 4;
	stackp_mem = gen_rtx_MEM(SImode,plus_constant (stack_pointer_rtx, -offset));
	emit_insn (gen_movsi (stackp_mem,
				   gen_rtx_REG (SImode, regno)));
      }
    }

  if (current_frame_info.save_lr)
    {
      offset += 4;
      stackp_mem = gen_rtx_MEM(SImode,plus_constant (stack_pointer_rtx, -offset));
      emit_insn (gen_movsi (stackp_mem,
			    gen_rtx_REG (SImode, RETURN_ADDRESS_REGNUM)));
    }

  /* Allocate the stack frame.  */
  frame_size = (current_frame_info.total_size
		- (current_frame_info.pretend_size
		   + current_frame_info.reg_size));

  if (frame_size == 0)
    ; /* Nothing to do.  */
  else if (frame_size <= 16382)
    emit_insn (gen_addsi3 (stack_pointer_rtx, stack_pointer_rtx,
			   GEN_INT (-frame_size)));
  else
    {
      rtx tmp = gen_rtx_REG (Pmode, PROLOGUE_TMP_REGNUM);

      emit_insn (gen_movsi (tmp, GEN_INT (-frame_size)));
      emit_insn (gen_addsi3 (stack_pointer_rtx, stack_pointer_rtx, tmp));
    }

  if (frame_pointer_needed)
    emit_insn (gen_movsi (frame_pointer_rtx, stack_pointer_rtx));

  /* wtf?
  if (current_function_profile)
     Push lr for mcount (form_pc, x).  
    emit_insn (gen_movsi_push (stack_pointer_rtx,
                               gen_rtx_REG (Pmode, RETURN_ADDR_REGNUM)));
  */                                                                                
  if (pic_reg_used)
    {
      coffee_load_pic_register ();
      coffee_reload_lr (stack_pointer_rtx,
                      (current_function_profile ? 0 : frame_size));
    }

  if (current_function_profile && !pic_reg_used)
    emit_insn (gen_blockage ());
}

void
coffee_expand_epilogue(void)
{
  int regno;
  int noepilogue = FALSE;
  int total_size;
  enum coffee_function_type fn_type = coffee_compute_function_type (current_function_decl);

  int offset = 0;
  rtx stackp_mem = gen_rtx_MEM(SImode, plus_constant(stack_pointer_rtx, offset));

  /* These cases shouldn't happen.  Catch them now.  */
  if (current_frame_info.total_size == 0)
    abort ();
  
  total_size = current_frame_info.total_size;

  if (total_size == 0)
    {
      rtx insn = get_last_insn ();

      /* If the last insn was a BARRIER, we don't have to write any code
	 because a jump (aka return) was put there.  */
      if (GET_CODE (insn) == NOTE)
	insn = prev_nonnote_insn (insn);
      if (insn && GET_CODE (insn) == BARRIER)
	noepilogue = TRUE;
    }
  if (!noepilogue)
    {
      unsigned int var_size = current_frame_info.var_size;
      unsigned int args_size = current_frame_info.args_size;
      int can_trust_sp_p = !current_function_calls_alloca;
      const char * sp_str = reg_names[STACK_POINTER_REGNUM];
      const char * fp_str = reg_names[FRAME_POINTER_REGNUM];

      /* The first thing to do is point the sp at the bottom of the register
	 save area.  */
      if (can_trust_sp_p)
	{
	  unsigned int reg_offset = var_size + args_size;
	  if (reg_offset == 0)
	    ; /* Nothing to do.  */
	  else if (reg_offset < 16382)
	    emit_insn (gen_addsi3 (stack_pointer_rtx, stack_pointer_rtx,
				   GEN_INT (reg_offset)));	    
	  else
	    {
	      emit_insn(gen_movsi(PROLOGUE_TMP_REGNUM, GEN_INT(reg_offset)));
	      emit_insn(gen_addsi3(stack_pointer_rtx,stack_pointer_rtx, 
				   GEN_INT(reg_offset)));
	    }
	}
      else if (frame_pointer_needed)
	{
	  unsigned int reg_offset = var_size + args_size;

	  if (reg_offset == 0)
	    emit_insn(gen_movsi(frame_pointer_rtx, stack_pointer_rtx));
	  else if (reg_offset < 16382)
	      emit_insn(gen_addsi3(stack_pointer_rtx,frame_pointer_rtx, 
				   GEN_INT(reg_offset)));
	  else
	    {
	      emit_insn(gen_movsi(PROLOGUE_TMP_REGNUM, GEN_INT(reg_offset)));
	      emit_insn(gen_addsi3(stack_pointer_rtx,frame_pointer_rtx, 
				   GEN_INT(reg_offset)));
	    }
	}
      else
	abort ();

      if (current_frame_info.save_lr)
	{
	  emit_insn(gen_movsi(gen_rtx_REG(Pmode,RETURN_ADDR_REGNUM), gen_rtx_MEM(SImode, stack_pointer_rtx)));
	  offset +=4;
	}

  for (regno = FIRST_PSEUDO_REG - 1; regno < 0; regno--)
    {
      if ((REG_NEEDS_SAVE(regno)))
      {
	stackp_mem = gen_rtx_MEM(SImode,plus_constant (stack_pointer_rtx, -offset));
	emit_insn (gen_movsi(gen_rtx_REG (SImode,regno), stackp_mem));
	offset += 4;
      }
	  
    }

  if (current_frame_info.save_fp)
    {
      emit_insn(gen_movsi(gen_rtx_REG(SImode, frame_pointer_rtx), gen_rtx_MEM(SImode, stack_pointer_rtx)));
      offset +=4;
    }

  if (current_frame_info.pretend_size != 0)      
    {
      emit_insn (gen_addsi3 (stack_pointer_rtx, stack_pointer_rtx,
			     current_frame_info.pretend_size));
    }	    

  /*
    if (COFFEE_INTERRUPT_P (fn_type))
    fprintf (file, "\treti\n");
    else
    fprintf (file, "\tjmpr %s\n", reg_names[RETURN_ADDR_REGNUM]);
  */
    }

  emit_insn(gen_indirect_jump(gen_rtx_REG(SImode, RETURN_ADDRESS_REGNUM)));
  
  current_frame_info = zero_frame_info;
  coffee_compute_function_type (NULL_TREE);    
}

/* Function to get function name out of the tree */
char* get_function_name(void)
{
  char *kind = "function";
  if (current_function_decl != 0
      && TREE_CODE (TREE_TYPE (current_function_decl)) == METHOD_TYPE)
    kind = "method";
  
  if (current_function_decl == NULL)
    {
      return "top level";
    }
  else
    {
      char *name = (*decl_printable_name) (current_function_decl, &kind);
      return name;
    }
}


/* This handles printing the addressing modes in assembly */
void 
print_operand_address (file, addr)
     FILE *file;
     register rtx addr;
{
  rtx op0,op1;

  switch (GET_CODE (addr))
    {
    case REG:
      fprintf (file, "%s", reg_names[REGNO (addr)]);
      break;

    case PLUS:
      /* can be 'symbol + reg' or 'reg + reg' */

      op0 = XEXP (addr, 0);
      op1 = XEXP (addr, 1);

      if (GET_CODE (op0) == REG && GET_CODE (op1) == REG)
	{
	  fprintf (file, "[%s](%s)",
		   reg_names[REGNO (op0)], reg_names[REGNO (op1)]);
	  break;
	}

      if (GET_CODE (op0) == REG && CONSTANT_ADDRESS_P (op1))
	{
	  output_addr_const (file, op1);
	  fprintf (file, "(%s)", reg_names[REGNO (op0)]);
	  break;
	}

      if (GET_CODE (op1) == REG && CONSTANT_ADDRESS_P (op0))
	{
	  output_addr_const (file, op0);
	  fprintf (file, "(%s)", reg_names[REGNO (op1)]);
	  break;
	}
      abort ();				/* Oh no */

    default:
      output_addr_const (file, addr);
    }
}


/* This function checks the %-operands in the md-file 
 * and return 1 for correct ones 
*/
int print_operand_punct_valid_p (code)
     int code;
{
  switch(code)
    {
    case 'k':
      return 1; /* lower immediate*/
    case 'j':
      return 1; /* upper immediate*/
    /* idea taken from sparc; output nop for %( if
    not optimizing or the slot is not filled. */
    case 'X':   /*for assembler, special case of base+offset */
      return 1;
    case '#':   /* print fpuid here */
      return 1;
    case '(':
      return 1;
    case 'S':
      return 1;
    }
  return 0;
}

/* This handles the general operand printing (constants, symbols
 * and a nop if the slot is not filled (not working now))
 */

void 
print_operand (file, x, code)
     FILE* file;
     rtx x;
     int code;
{
  if (code == 'C')
    fputs (rev_cond_name (x), file);
  else if (code == '#')
    {
      /*output fpuid*/
      fputs(fpuid, file);
    }
  else if (code == 'k')
    fprintf (file, "%d", INTVAL (x) & 0xffff);
  else if (code == 'j')
    fprintf (file, "%d", ((INTVAL (x) & 0xffff0000) >> 16));
  else if (code == '(')
    {
      // These are commented out because the branch delay slot scheduling
      // does not work
      //      if (dbr_sequence_length()==0)
      //	{
	  fprintf(file, "\n\tnop\t;nop in slot");
	  //	}
	  //  else
	  //	{
	  //  fprintf(file, "\t;slot filled");
	  //	}
    }

  else if (code == 'X')
    {
      if (GET_CODE (x) == MEM)
	{
	  rtx addr = XEXP(x, 0);
	  int koodi = GET_CODE(addr);
      
	  switch(koodi)
	    {
	    case REG:
	      fprintf(file, " 0");
	      break;
	    case PLUS:
	      {
		rtx reg, offs;
		reg = XEXP(addr,0);
		offs = XEXP(addr,1);
	  
		if (GET_CODE(reg) != REG)
		  {
		    rtx temp = reg;
		    reg = offs;
		    offs = temp;
		  }
	    
		if (GET_CODE(reg) != REG || GET_CODE(offs) != CONST_INT)
		  {
		    fprintf(file, "fucktheshit!");
		    abort();
		  }

		  fprintf(file, " %d",INTVAL(offs));
		break;
	      }
	    case CONST_INT:
	      fprintf(file, " %d", INTVAL(addr));
	      break;

	    default:
	      output_address (XEXP (x, 0));
	      break;
	    }
	}
    }
    
  else if (GET_CODE (x) == REG)
    fprintf (file, "%s", reg_names[REGNO (x)]);
  else if (GET_CODE (x) == MEM)
    {
      rtx addr = XEXP(x, 0);
      int koodi = GET_CODE(addr);
      
      switch(koodi)
	{
	case REG:
	  fprintf(file, "%s, 0", reg_names[REGNO(addr)]);
	  break;
	case PLUS:
	  {
	    rtx reg, offs;
	    reg = XEXP(addr,0);
	    offs = XEXP(addr,1);
	  
	    if (GET_CODE(reg) != REG)
	      {
		rtx temp = reg;
		reg = offs;
		offs = temp;
	      }
	    
	    if (GET_CODE(reg) != REG || GET_CODE(offs) != CONST_INT)
	      {
		fprintf(file, "fucktheshit!");
		abort();
	      }
	    fprintf(file, "%s, %d",reg_names[REGNO(reg)], INTVAL(offs));
	    break;
	  }
	
	case CONST_INT:
	  fprintf(file, "%d", INTVAL(addr));
	  break;

	default:
	  output_address (XEXP (x, 0));
	  break;
	}
    }
  else if (code == 'S')
    {
      if (GET_CODE (x) == PLUS)
	assemble_name(file, XSTR(XEXP(x,0),0));   
    }
  else if (GET_CODE (x) == CONST_DOUBLE)
    {
      	  fprintf(file, "%d", INTVAL(x));
	  /*    output_operand_lossage ("floating point constant not a valid immediate operand");*/
    }
  else 
    { 
      output_addr_const (file, x);
    }
}

/* Function to check if tree-node is a symbolic memory operand */
int sym_ref_mem_operand (op, mode)
      rtx op;
     enum machine_mode mode;
{
  if(GET_CODE(op) == MEM)
    {
      rtx t1 = XEXP(op, 0);
      if(GET_CODE(t1) == SYMBOL_REF)
        {
          return 1;
        }
    }
  return 0;
}

/* Function to check if tree-node is a call-operand  */
int
call_address_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (symbolic_operand (op, mode)
	  || (GET_CODE (op) == CONST_INT && LEGITIMATE_CONSTANT_P (op))
	  || (GET_CODE (op) == REG));
}

/* Checks also if tree-node is a call-operand */
int
call_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  if (GET_CODE (op) != MEM)
    return 0;
  op = XEXP (op, 0);
  return call_address_operand (op, mode);
}

/* function to check if tree-node is a symbol */
int
symbolic_operand (op, mode)
     rtx op;
     enum machine_mode mode ATTRIBUTE_UNUSED;
{
  switch (GET_CODE (op))
    {
    case SYMBOL_REF:
    case LABEL_REF:
    case CONST :
      return 1;
    default:
      return 0;
    }
}


int
fp_reg_operand (op, mode)
     register rtx op;
     enum machine_mode mode;
{
  return IS_FP_REG(REGNO(op)) || IS_PSEUDO_REG(REGNO(op));
}

/*
int
fp_reg_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (register_operand (op, mode) &&
	  (GET_CODE (op) != SUBREG ||
	   GET_MODE_CLASS (GET_MODE (SUBREG_REG (op))) == MODE_FLOAT));
}
*/
/* Checks if comparison is signed */     
int signed_comparison_operator (op, mode)
    register rtx op;
    enum machine_mode mode;
{
  if(mode == VOIDmode || GET_MODE (op) == mode)
    {
      switch(GET_CODE(op))
        {
        case EQ:
        case NE:
        case LT:
        case LE:
        case GE:
        case GT:
	default:
          return 1;
        }
    }
  return 0;
}

int gen_call_value_1(operands)
     rtx operands[];
{
  rtx result = operands[0];
  rtx func = operands[1];
  rtx stacksize = operands[2];
  int mode = GET_MODE(result);

  switch(mode)
    {
/*
 [(set (reg:SI 1)
                  (call (match_operand 0 "sym_ref_mem_operand" "")
                        (match_operand 1 "" "i")))]
*/
/*
    HImode:
    QImode:
      printf("Subreg in gcv1.\n");
      emit_call_insn(gen_rtx(SET,mode,
			     gen_rtx(SUBREG,mode,result),
			     gen_rtx(CALL,VOIDmode,func,stacksize)));
      break;
*/

    default:
      emit_call_insn(gen_rtx(PARALLEL,VOIDmode,
		       gen_rtvec(2,
				 gen_rtx(SET,mode,result,
					 gen_rtx(CALL,VOIDmode,func,
						 stacksize)),
				 gen_rtx(CLOBBER,VOIDmode,
					 gen_rtx(REG,SImode,31)))));
      break;

    }

  return 0;
}


/* This is how to output a string.  */
void asm_output_ascii(stream, ptr, len)
     FILE* stream;
     unsigned char* ptr;
     int len;
{
  do {
    int i, c, length = len, cur_pos = 17;
    unsigned char *string = (unsigned char *)(ptr);
    fprintf (stream, "\t.ascii\t\"");
    for (i = 0; i < length; i++)
      {
	c = string[i];
      switch (c)
	{
	case '\"':
	case '\\':
	  putc ('\\', (stream));
	  putc (c, (stream));
	  cur_pos += 2;
	  break;

	case TARGET_NEWLINE:
	  fputs ("\\n", (stream));
	  if (i+1 < length
	      && (((c = string[i+1]) >= '\040' && c <= '~')
		  || c == TARGET_TAB))
	    cur_pos = 32767;		/* break right here */
	  else
	    cur_pos += 2;
	  break;

	case TARGET_TAB:
	  fputs ("\\t", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_FF:
	  fputs ("\\f", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_BS:
	  fputs ("\\b", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_CR:
	  fputs ("\\r", (stream));
	  cur_pos += 2;
	  break;

	default:
	  if (c >= ' ' && c < 0177)
	    {
	      putc (c, (stream));
	      cur_pos++;
	    }
	  else
	    {
	      fprintf ((stream), "\\%0o", c);
	      cur_pos += 2;
	    }
	}

      if (cur_pos > 72 && i+1 < length)
	{
	  cur_pos = 17;
	  fprintf ((stream), "\"\n\t.ascii\t\"");
	}
      }
    fprintf ((stream), "\"\n");
  } while (0);
}
       

/* Some weird algorithm for computing 2's logarithm. */
int
log_of_two (int x)
{
  int y;

  x >>= 1;
  for(y=0; x; x>>=1, y++);

  return y;
}

 
struct traptab_s {
  char *name;
  int num;
} traptab[] = {
  { "_exit",   0 },
  { "_open",   1 },
  { "_close",  2 },
  { "_read",   3 },
  { "_write",  4 },
  { "_printf", 5 },
  { "_sqrt",   29 },
  { NULL,      0 }};

/*void 
asm_file_end (file)
  FILE *file;
{
#ifdef NO_LOADER
  int i;

  text_section();

  i = 0;
  while(traptab[i].name != NULL)
    {
      output_trap_def(file,traptab[i].name,traptab[i].num);
      i++;
    }
#endif
}
*/


void output_trap_def(file,name,num)
     FILE *file;
     char *name;
     int num;
{
  fprintf(file,".global %s\n%s:\t",name,name);
  fprintf(file,"\ttrap\t#%d\n",num);
  fputs("\tjmpr\tr31\n",file);
  fputs("\tnop\n\n",file);
}


/* For reversing the condition code */
char *rev_cond_name (op)
     rtx op;
{
  switch (GET_CODE (op))
    {
    case EQ:
      return "ne";
    case NE:
      return "eq";
    case LT:
      return "gt";
    case LE:
      return "egt";
    case GT:
      return "lt";
    case GE:
      return "elt";
    case LTU:
      return "gt";
    case LEU:
      return "egt";
    case GTU:
      return "lt";
    case GEU:
      return "elt";

    default:
      abort ();
    }
}
/*
int
coffee_legitimate_pic_operand_p (rtx x)
{
  if (GET_CODE (x) == SYMBOL_REF || GET_CODE (x) == LABEL_REF)
    return 0;
                                                                                
  if (GET_CODE (x) == CONST
      && GET_CODE (XEXP (x, 0)) == PLUS
      && (GET_CODE (XEXP (XEXP (x, 0), 0)) == SYMBOL_REF
          || GET_CODE (XEXP (XEXP (x, 0), 0)) == LABEL_REF)
      && (GET_CODE (XEXP (XEXP (x, 0), 1)) == CONST_INT))
    return 0;
                                                                                
  return 1;
}
*/
/*
void
coffee_finalize_pic (void)
{
  current_function_uses_pic_offset_table |= current_function_profile;
}

*/
/*
rtx
coffee_legitimize_pic_address (rtx orig, rtx reg)
{
#ifdef DEBUG_PIC
  printf("coffee_legitimize_pic_address()\n");
#endif

  if (GET_CODE (orig) == SYMBOL_REF || GET_CODE (orig) == LABEL_REF)
    {
      rtx pic_ref, address;
      rtx insn;
      int subregs = 0;

      if (reg == 0)
        {
          if (reload_in_progress || reload_completed)
            abort ();
          else
            reg = gen_reg_rtx (Pmode);

          subregs = 1;
        }

      if (subregs)
        address = gen_reg_rtx (Pmode);
      else
        address = reg;

      emit_insn (gen_pic_load_addr (address, orig));

      emit_insn (gen_addsi3 (address, address, pic_offset_table_rtx));
      pic_ref = gen_rtx (MEM, Pmode, address);

      RTX_UNCHANGING_P (pic_ref) = 1;
      insn = emit_move_insn (reg, pic_ref);
      current_function_uses_pic_offset_table = 1;
#if 0
      /* Put a REG_EQUAL note on this insn, so that it can be optimized
         by loop.  */
      REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_EQUAL, orig,
                  REG_NOTES (insn));
#endif
      return reg;
    }
  else if (GET_CODE (orig) == CONST)
    {
      rtx base, offset;

      if (GET_CODE (XEXP (orig, 0)) == PLUS
          && XEXP (XEXP (orig, 0), 1) == pic_offset_table_rtx)
        return orig;

      if (reg == 0)
        {
          if (reload_in_progress || reload_completed)
            abort ();
          else
            reg = gen_reg_rtx (Pmode);
        }

      if (GET_CODE (XEXP (orig, 0)) == PLUS)
        {
          base = coffee_legitimize_pic_address (XEXP (XEXP (orig, 0), 0), reg);
          if (base == reg)
            offset = coffee_legitimize_pic_address (XEXP (XEXP (orig, 0), 1), NULL_RTX);
          else
            offset = coffee_legitimize_pic_address (XEXP (XEXP (orig, 0), 1), reg);
        }
      else
        return orig;

      if (GET_CODE (offset) == CONST_INT)
        {
          if (INT16_P (INTVAL (offset)))
            return plus_constant (base, INTVAL (offset));
          else if (! reload_in_progress && ! reload_completed)
            offset = force_reg (Pmode, offset);
          else
            /* If we reach here, then something is seriously wrong.  */
            abort ();
        }

      return gen_rtx (PLUS, Pmode, base, offset);
    }

  return orig;
}
*/
/*
void
coffee_setup_incoming_varargs (CUMULATIVE_ARGS *cum, enum machine_mode mode,
			     tree type, int *pretend_size, int no_rtl)
{
  int first_anon_arg;

  if (no_rtl)
    return;

   All BLKmode values are passed by reference.  
  if (mode == BLKmode)
    abort ();

  first_anon_arg = (ROUND_ADVANCE_CUM (*cum, mode, type)
		    + ROUND_ADVANCE_ARG (mode, type));

  if (first_anon_arg < MAX_ARGS_IN_REGS)
    {
       Note that first_reg_offset < MAX_ARGS_IN_REGS.  
      int first_reg_offset = first_anon_arg;
       Size in words to "pretend" allocate.  
      int size = MAX_ARGS_IN_REGS - first_reg_offset;
      rtx regblock;

      regblock = gen_rtx_MEM (BLKmode,
			      plus_constant (arg_pointer_rtx,
					     FIRST_PARM_OFFSET (0)));
      set_mem_alias_set (regblock, get_varargs_alias_set ());
      move_block_from_reg (first_reg_offset, regblock, size);

      *pretend_size = (size * UNITS_PER_WORD);
    }
}

/*
rtx
coffee_va_arg (tree valist, tree type)
{
  HOST_WIDE_INT size, rsize;
  tree t;
  rtx addr_rtx;

  size = int_size_in_bytes (type);
  rsize = (size + UNITS_PER_WORD - 1) & -UNITS_PER_WORD;

  if (coffee_pass_by_reference (type))
    {
      tree type_ptr, type_ptr_ptr;

      /* Pass by reference.  */
      type_ptr = build_pointer_type (type);
      type_ptr_ptr = build_pointer_type (type_ptr);

      t = build (POSTINCREMENT_EXPR, va_list_type_node, valist, 
		 build_int_2 (UNITS_PER_WORD, 0));
      TREE_SIDE_EFFECTS (t) = 1;
      t = build1 (NOP_EXPR, type_ptr_ptr, t);
      TREE_SIDE_EFFECTS (t) = 1;
      t = build1 (INDIRECT_REF, type_ptr, t);

      addr_rtx = expand_expr (t, NULL_RTX, Pmode, EXPAND_NORMAL);
    }
  else
    {
       Pass by value.  
      if (size < UNITS_PER_WORD)
	{
	   Care for bigendian correction on the aligned address.  
	  t = build (PLUS_EXPR, ptr_type_node, valist,
		     build_int_2 (rsize - size, 0));
	  addr_rtx = expand_expr (t, NULL_RTX, Pmode, EXPAND_NORMAL);
	  addr_rtx = copy_to_reg (addr_rtx);

	   Increment AP.  
	  t = build (PLUS_EXPR, va_list_type_node, valist,
		     build_int_2 (rsize, 0));
	  t = build (MODIFY_EXPR, va_list_type_node, valist, t);
	  TREE_SIDE_EFFECTS (t) = 1;
	  expand_expr (t, const0_rtx, VOIDmode, EXPAND_NORMAL);
	}
      else
	{
	  t = build (POSTINCREMENT_EXPR, va_list_type_node, valist, 
		     build_int_2 (rsize, 0));
	  TREE_SIDE_EFFECTS (t) = 1;
	  addr_rtx = expand_expr (t, NULL_RTX, Pmode, EXPAND_NORMAL);
	}
    }

  return addr_rtx;
}
*/

/*
void
coffee_load_pic_register (void)
{
  global_offset_table = gen_rtx_SYMBOL_REF (Pmode, "_GLOBAL_OFFSET_TABLE_");
  emit_insn (gen_get_pc (pic_offset_table_rtx, global_offset_table,
                         gen_rtx_CONST_INT(SImode, 1)));
 
   Need to emit this whether or not we obey regdecls,
     since setjmp/longjmp can cause life info to screw up.  
  emit_insn (gen_rtx_USE (VOIDmode, pic_offset_table_rtx));
}

*/

static void
coffee_reload_lr (rtx sp, int size)
{
  rtx lr = gen_rtx_REG (Pmode, RETURN_ADDR_REGNUM);

  if (size == 0)
    emit_insn (gen_movsi (lr, gen_rtx_MEM (Pmode, sp)));
  else if (size <= 32768)
    emit_insn (gen_movsi (lr, gen_rtx_MEM (Pmode,
					   gen_rtx_PLUS (Pmode, sp,
							 GEN_INT (size)))));
  else
    {   
      rtx tmp = gen_rtx_REG (Pmode, PROLOGUE_TMP_REGNUM);

      emit_insn (gen_movsi (tmp, GEN_INT (size)));
      emit_insn (gen_addsi3 (tmp, tmp, sp));
      emit_insn (gen_movsi (lr, gen_rtx_MEM (Pmode, tmp)));
    }

  emit_insn (gen_rtx_USE (VOIDmode, lr));
}
