/*  COFFEE-risc machine description  
 *   Version history:    
 *  0.9  1.4.2004   By Markus Moisio    First Release
 *		      	   
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "rtl.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "real.h"
#include "insn-config.h"
#include "conditions.h"
#include "insn-attr.h"
#include "flags.h"
#include "recog.h"
#include "obstack.h"
#include "tree.h"
#include "expr.h"
#include "optabs.h"
#include "except.h"
#include "function.h"
#include "output.h"
#include "basic-block.h"
#include "integrate.h"
#include "toplev.h"
#include "ggc.h"
#include "hashtab.h"
#include "tm_p.h"
#include "target.h"
#include "target-def.h"
#include "langhooks.h"
#include "reload.h"


#include "insn-attr.h"		/* For DFA state_t. */
#include "insn-config.h"	/* Required by recog.h */
#include "insn-codes.h"		/* For CODE_FOR_? */
#include "optabs.h"		/* For GEN_FCN */
#include "basic-block.h"	/* UPDATE_LIFE_GLOBAL* for picochip_reorg. */
#include "coffee-protos.h"

int last_cmp_was_float;
const char* fpuid="0"; /* to store co-proc number */
/* Cached operands, and operator to compare for use in set/branch/trap
   on condition codes.  */
rtx branch_cmp[3];
rtx cmpsf_op1;
rtx cmpsf_op2;



char* get_function_name PARAMS ((void));
void print_operand_address PARAMS ((FILE*, register rtx));
int print_operand_punct_valid_p PARAMS ((int));
void print_operand PARAMS ((FILE*, rtx, int));
int sym_ref_mem_operand PARAMS ((rtx, enum machine_mode));
int signed_comparison_operator PARAMS ((register rtx, enum machine_mode));
/*
int gen_call_value_1 ((rtx));
*/
void asm_output_ascii (FILE*, const char*, int);
void output_trap_def PARAMS ((FILE*,char*,int));
void output_function_prologue PARAMS ((FILE*, int));
void output_function_epilogue PARAMS ((FILE*, int));
int log_of_two PARAMS ((int));
char *rev_cond_name PARAMS ((rtx));
int call_address_operand PARAMS ((rtx, enum machine_mode));
int fp_reg_operand PARAMS ((rtx, enum machine_mode));
int symbolic_operand (rtx op, enum machine_mode mode);
static int picochip_is_aligned (int byte_offset, int bit_alignment);

const char *or32_output_move_double (rtx * operands);

void print_condcode (FILE* file, rtx x);
rtx coffee_gen_compare_reg (enum rtx_code code);


extern int leaf_function;
extern FILE * asm_out_file;

#include <stdio.h>
#include <string.h>
#include <ctype.h>

/*
#undef  TARGET_ASM_FUNCTION_PROLOGUE
#define TARGET_ASM_FUNCTION_PROLOGUE coffee_output_function_prologue
#undef  TARGET_ASM_FUNCTION_EPILOGUE
#define TARGET_ASM_FUNCTION_EPILOGUE coffee_output_function_epilogue
*/


void coffee_expand_prologue (void);
void coffee_expand_epilogue (void);
HOST_WIDE_INT coffee_compute_frame_size (HOST_WIDE_INT size);
static bool coffee_save_reg_p (int regno);
static rtx emit_frame_insn (rtx insn);
static rtx indexed_memory (rtx base, HOST_WIDE_INT disp);
static void or32_maybe_dead (rtx insn);
static void coffee_asm_file_start (void);


#undef TARGET_ASM_FILE_START
#define TARGET_ASM_FILE_START coffee_asm_file_start


#undef TARGET_ASM_FILE_START
#define TARGET_ASM_FILE_START coffee_asm_file_start


#undef TARGET_ASM_NAMED_SECTION
#define TARGET_ASM_NAMED_SECTION  default_elf_asm_named_section

#undef TARGET_ASM_BYTE_OP
#define TARGET_ASM_BYTE_OP "\t.byte\t"
#undef TARGET_ASM_ALIGNED_HI_OP 
#define TARGET_ASM_ALIGNED_HI_OP "\t.word\t"
#undef TARGET_ASM_ALIGNED_SI_OP
#define TARGET_ASM_ALIGNED_SI_OP "\t.long\t"


/* We need to define these, since the 2byte, 4byte, 8byte op:s are only
   available in ELF.  These "normal" pseudos do not have any alignment
   constraints or side-effects.  */
#undef TARGET_ASM_UNALIGNED_HI_OP
#define TARGET_ASM_UNALIGNED_HI_OP TARGET_ASM_ALIGNED_HI_OP

#undef TARGET_ASM_UNALIGNED_SI_OP
#define TARGET_ASM_UNALIGNED_SI_OP TARGET_ASM_ALIGNED_SI_OP


/* initialize the target structure. All defines of the form TARGET_ and 
mentione as target hooks  should be defined before this statement */

struct gcc_target targetm = TARGET_INITIALIZER;


/* Stack layout we use for pushing and poping saved registers */
struct coffee_frame_info
{
  bool save_lr_p;
  int lr_save_offset;
  bool save_fp_p;
  int fp_save_offset;
  int gpr_size;
  int gpr_offset;
  int total_size;
  int vars_size;
  int args_size;
  int pretend_args_size;
  HOST_WIDE_INT mask;
};
static struct coffee_frame_info frame_info;


#undef SECONDARY_INPUT_RELOAD_CLASS
#define SECONDARY_INPUT_RELOAD_CLASS(CLASS,MODE,IN) \
  picochip_secondary_reload_class((CLASS), (MODE), (IN), 1)

#undef SECONDARY_OUTPUT_RELOAD_CLASS
#define SECONDARY_OUTPUT_RELOAD_CLASS(CLASS,MODE,OUT) \
  picochip_secondary_reload_class((CLASS), (MODE), (OUT), 0)


#define REG_NEEDS_SAVE(i) (regs_ever_live[i] && !(call_used_regs[i]))

/* Function to get function name out of the tree */
char* get_function_name(void)
{
  char *kind = "function";
  if ((current_function_decl != 0)
      && (TREE_CODE (TREE_TYPE (current_function_decl)) == METHOD_TYPE))
    kind = "method";
  
  if (current_function_decl == NULL)
    {
      return "top level";
    }
  else
    {
      /*      char *name = (*decl_printable_name) (current_function_decl, &kind);*/
      char *name = current_function_name();
      return name;
    }
}


/* This handles printing the addressing modes in assembly */
void 
print_operand_address (file, addr)
     FILE *file;
     register rtx addr;
{
  rtx op0,op1;

  switch (GET_CODE (addr))
    {
    case REG:
      fprintf (file, "%s", reg_names[REGNO (addr)]);
      break;

    case PLUS:
      /* can be 'symbol + reg' or 'reg + reg' */

      op0 = XEXP (addr, 0);
      op1 = XEXP (addr, 1);

      if (GET_CODE (op0) == REG && GET_CODE (op1) == REG)
	{
	  fprintf (file, "[%s](%s)",
		   reg_names[REGNO (op0)], reg_names[REGNO (op1)]);
	  break;
	}

      if (GET_CODE (op0) == REG && CONSTANT_ADDRESS_P (op1))
	{
	  output_addr_const (file, op1);
	  fprintf (file, "(%s)", reg_names[REGNO (op0)]);
	  break;
	}

      if (GET_CODE (op1) == REG && CONSTANT_ADDRESS_P (op0))
	{
	  output_addr_const (file, op0);
	  fprintf (file, "(%s)", reg_names[REGNO (op1)]);
	  break;
	}
      abort ();				/* Oh no */

    default:
      output_addr_const (file, addr);
    }
}


/* This function checks the %-operands in the md-file 
 * and return 1 for correct ones 
*/
int print_operand_punct_valid_p (code)
     int code;
{
  switch(code)
    {
    case 'k':
      return 1; /* lower immediate*/
    case 'j':
      return 1; /* upper immediate*/
    /* idea taken from sparc; output nop for %( if
    not optimizing or the slot is not filled. */
    case 'X':   /*for assembler, special case of base+offset */
      return 1;
    case '#':   /* print fpuid here */
      return 1;
    case '(':
      return 1;
    case 'S':
      return 1;
    case 'H':
      return 1;
    case 'A':
      return 1;
    }
  return 0;
}

/* This handles the general operand printing (constants, symbols
 * and a nop if the slot is not filled (not working now))
 */

void 
print_operand (file, x, code)
     FILE* file;
     rtx x;
     int code;
{
  if (code == 'C')
    fputs (rev_cond_name (x), file);
  else if (code == '#')
    {
      /*output fpuid */
	fprintf(file,"1");
    }
  else if (code == 'k')
    fprintf (file, "%d", INTVAL (x) & 0xffff);
  else if (code == 'j')
    fprintf (file, "%d", ((INTVAL (x) & 0xffff0000) >> 16));
  else if (code == '(')
    {
      if (dbr_sequence_length()==0)
      	{
	  fprintf(file, "\n\tnop\t;nop in slot");
	}
      else
	{
	  fprintf(file, "\t;slot filled");
	}
    }
  else if (code == 'X')
    {
      if (GET_CODE (x) == MEM)
	{
	  rtx addr = XEXP(x, 0);
	  int koodi = GET_CODE(addr);
      
	  switch(koodi)
	    {
	    case REG:
	      fprintf(file, " 0");
	      break;
	    case PLUS:
	      {
		rtx reg, offs;
		reg = XEXP(addr,0);
		offs = XEXP(addr,1);
	  
		if (GET_CODE(reg) != REG)
		  {
		    rtx temp = reg;
		    reg = offs;
		    offs = temp;
		  }
	    
		if (GET_CODE(reg) != REG || GET_CODE(offs) != CONST_INT)
		  {
		    fprintf(file, "fucktheshit!");
		    abort();
		  }

		  fprintf(file, " %d",INTVAL(offs));
		break;
	      }
	    case CONST_INT:
	      fprintf(file, " %d", INTVAL(addr));
	      break;

	    default:
	      output_address (XEXP (x, 0));
	      break;
	    }
	}
    }
    
  else if (GET_CODE (x) == REG)
    fprintf (file, "%s", reg_names[REGNO (x)]);
  else if (GET_CODE (x) == MEM)
    {
      rtx addr = XEXP(x, 0);
      int koodi = GET_CODE(addr);
      
      switch(koodi)
	{
	case REG:
	  fprintf(file, "%s, 0", reg_names[REGNO(addr)]);
	  break;
	case PLUS:
	  {
	    rtx reg, offs;
	    reg = XEXP(addr,0);
	    offs = XEXP(addr,1);
	  
	    if (GET_CODE(reg) != REG)
	      {
		rtx temp = reg;
		reg = offs;
		offs = temp;
	      }
	    
	    if (GET_CODE(reg) != REG || GET_CODE(offs) != CONST_INT)
	      {
		fprintf(file, "fucktheshit!");
		abort();
	      }
	    fprintf(file, "%s, %d",reg_names[REGNO(reg)], INTVAL(offs));
	    break;
	  }
	
	case CONST_INT:
	  fprintf(file, "%d", INTVAL(addr));
	  break;

	default:
	  output_address (XEXP (x, 0));
	  break;
	}
    }
  else if (code == 'S')
    {
      if (GET_CODE (x) == PLUS)
	assemble_name(file, XSTR(XEXP(x,0),0));   
    }
  else if (GET_CODE (x) == CONST_DOUBLE)
    {
      	  fprintf(file, "%d", INTVAL(x));
	  /*    output_operand_lossage ("floating point constant not a valid immediate operand");*/
    }
  else if (code == 'H')
    {
      if (GET_CODE (x) == REG)
	fprintf (file, "%s", reg_names[REGNO (x) + 1]);
      else
	abort ();
    }
  else if (code == 'A')
    {
      print_condcode(file, x);
    }
  else 
    { 
      output_addr_const (file, x);
    }
}

/* Function to check if tree-node is a symbolic memory operand */
int sym_ref_mem_operand (op, mode)
      rtx op;
     enum machine_mode mode;
{
  if(GET_CODE(op) == MEM)
    {
      rtx t1 = XEXP(op, 0);
      if(GET_CODE(t1) == SYMBOL_REF)
        {
          return 1;
        }
    }
  return 0;
}

/* Function to check if tree-node is a call-operand  */
int
call_address_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (symbolic_operand (op, mode)
	  || (GET_CODE (op) == CONST_INT && LEGITIMATE_CONSTANT_P (op))
	  || (GET_CODE (op) == REG));
}

/* Checks also if tree-node is a call-operand */
int
call_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  if (GET_CODE (op) != MEM)
    return 0;
  op = XEXP (op, 0);
  return call_address_operand (op, mode);
}

/* function to check if tree-node is a symbol */
int
symbolic_operand (op, mode)
     rtx op;
     enum machine_mode mode ATTRIBUTE_UNUSED;
{
  switch (GET_CODE (op))
    {
    case SYMBOL_REF:
    case LABEL_REF:
    case CONST :
      return 1;
    default:
      return 0;
    }
}


int
fp_reg_operand (op, mode)
     register rtx op;
     enum machine_mode mode;
{
  return IS_FP_REG(REGNO(op)) || IS_PSEUDO_REG(REGNO(op));
}

/*
int
fp_reg_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (register_operand (op, mode) &&
	  (GET_CODE (op) != SUBREG ||
	   GET_MODE_CLASS (GET_MODE (SUBREG_REG (op))) == MODE_FLOAT));
}
*/
/* Checks if comparison is signed */     
int signed_comparison_operator (op, mode)
    register rtx op;
    enum machine_mode mode;
{
  if(mode == VOIDmode || GET_MODE (op) == mode)
    {
      switch(GET_CODE(op))
        {
        case EQ:
        case NE:
        case LT:
        case LE:
        case GE:
        case GT:
	default:
          return 1;
        }
    }
  return 0;
}

int gen_call_value_1 (rtx operands[])
{
  rtx result = operands[0];
  rtx func = operands[1];
  rtx stacksize = operands[2];
  int mode = GET_MODE(result);

  switch(mode)
    {
/*
 [(set (reg:SI 1)
                  (call (match_operand 0 "sym_ref_mem_operand" "")
                        (match_operand 1 "" "i")))]
*/
/*
    HImode:
    QImode:
      printf("Subreg in gcv1.\n");
      emit_call_insn(gen_rtx(SET,mode,
			     gen_rtx(SUBREG,mode,result),
			     gen_rtx(CALL,VOIDmode,func,stacksize)));
      break;
*/

    default:
      emit_call_insn(gen_rtx(PARALLEL,VOIDmode,
		       gen_rtvec(2,
				 gen_rtx(SET,mode,result,
					 gen_rtx(CALL,VOIDmode,func,
						 stacksize)),
				 gen_rtx(CLOBBER,VOIDmode,
					 gen_rtx(REG,SImode,31)))));
      break;

    }

  return 0;
}

/*
 * Set up stack and frame pointers, and prepare
 * for function entry.
 *
 * Stack map for Coffee-GCC:
 *
 * incoming args
 *                      <--------------------------- new frame pointer
 * saved frame pointer          4 bytes
 * saved return addr            4 bytes
 *
 * local variables:             size rounded up to a multiple of 4.
 *
 * save caller regs area        (4*n_regs_to_save)
 * 
 *
*/



/* This is how to output a string.  */
void asm_output_ascii(FILE *stream, const char *ptr, int len)
{
  do {
    int i, c, length = len, cur_pos = 17;
    unsigned char *string = (unsigned char *)(ptr);
    fprintf (stream, "\t.ascii\t\"");
    for (i = 0; i < length; i++)
      {
	c = string[i];
      switch (c)
	{
	case '\"':
	case '\\':
	  putc ('\\', (stream));
	  putc (c, (stream));
	  cur_pos += 2;
	  break;

	case TARGET_NEWLINE:
	  fputs ("\\n", (stream));
	  if (i+1 < length
	      && (((c = string[i+1]) >= '\040' && c <= '~')
		  || c == TARGET_TAB))
	    cur_pos = 32767;		/* break right here */
	  else
	    cur_pos += 2;
	  break;

	case TARGET_TAB:
	  fputs ("\\t", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_FF:
	  fputs ("\\f", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_BS:
	  fputs ("\\b", (stream));
	  cur_pos += 2;
	  break;

	case TARGET_CR:
	  fputs ("\\r", (stream));
	  cur_pos += 2;
	  break;

	default:
	  if (c >= ' ' && c < 0177)
	    {
	      putc (c, (stream));
	      cur_pos++;
	    }
	  else
	    {
	      fprintf ((stream), "\\%0o", c);
	      cur_pos += 2;
	    }
	}

      if (cur_pos > 72 && i+1 < length)
	{
	  cur_pos = 17;
	  fprintf ((stream), "\"\n\t.ascii\t\"");
	}
      }
    fprintf ((stream), "\"\n");
  } while (0);
}
       

/* 19082003 MJM: Made some changes to prologue/epilogue. Now it doesn't save
   frame pointer or link register unless it' required. */



/* Some weird algorithm for computing 2's logarithm. */
int
log_of_two (int x)
{
  int y;

  x >>= 1;
  for(y=0; x; x>>=1, y++);

  return y;
}

 
struct traptab_s {
  char *name;
  int num;
} traptab[] = {
  { "_exit",   0 },
  { "_open",   1 },
  { "_close",  2 },
  { "_read",   3 },
  { "_write",  4 },
  { "_printf", 5 },
  { "_sqrt",   29 },
  { NULL,      0 }};

/*void 
asm_file_end (file)
  FILE *file;
{
#ifdef NO_LOADER
  int i;

  text_section();

  i = 0;
  while(traptab[i].name != NULL)
    {
      output_trap_def(file,traptab[i].name,traptab[i].num);
      i++;
    }
#endif
}
*/


void output_trap_def(file,name,num)
     FILE *file;
     char *name;
     int num;
{
  fprintf(file,".global %s\n%s:\t",name,name);
  fprintf(file,"\ttrap\t#%d\n",num);
  fputs("\tjmpr\tr31\n",file);
  fputs("\tnop\n\n",file);
}

char *rev_cond_name (op)
     rtx op;
{
  switch (GET_CODE (op))
    {
    case EQ:
      return "ne";
    case NE:
      return "eq";
    case LT:
      return "gt";
    case LE:
      return "egt";
    case GT:
      return "lt";
    case GE:
      return "elt";
    case LTU:
      return "gt";
    case LEU:
      return "egt";
    case GTU:
      return "lt";
    case GEU:
      return "elt";

    default:
      abort ();
    }
}

void print_condcode (FILE* file, rtx x)
{
  switch (GET_CODE (x))
    {
    case EQ:
      fprintf(file, "eq");
      break;
    case NE:
      fprintf(file, "ne");
      break;
    case LT:
      fprintf(file, "lt");
      break;
    case LE:
      fprintf(file, "elt");
      break;
    case GT:
      fprintf(file, "gt");
      break;
    case GE:
      fprintf(file, "egt");
      break;
    case LTU:
      fprintf(file, "lt");
      break;
    case LEU:
      fprintf(file, "elt");
      break;
    case GTU:
      fprintf(file, "gt");
      break;
    case GEU:
      fprintf(file, "egt");
      break;
    default:
      break;
    }
}



/* Loading and storing QImode values to and from memory in a machine
   without byte access requires might require a scratch
   register.  However, the scratch register might correspond to the
   register in which the value is being loaded.  To ensure that a
   scratch register is supplied which is definitely different to the
   output register, request a register pair.  This effectively gives a
   choice of two registers to choose from, so that we a guaranteed to
   get at least one register which is different to the output
   register.  This trick is taken from the alpha implementation. */
enum reg_class
picochip_secondary_reload_class (enum reg_class class ATTRIBUTE_UNUSED,
				 enum machine_mode mode,
				 rtx x ATTRIBUTE_UNUSED,
				 int in ATTRIBUTE_UNUSED)
{

  if (mode == QImode)
    return GENERAL_REGS;

  return NO_REGS;

}

int
picochip_word_aligned_memory_reference (rtx operand)
{
  /* The address must be the SP register, or a constant, aligned
     offset from SP which doesn't exceed the FP+offset
     restrictions. */
  return ((PLUS == GET_CODE (operand)
	   && REGNO (XEXP (operand, 0)) <= LAST_GENERAL_REGISTER
	   && picochip_is_aligned (INTVAL (XEXP (operand, 1)), 32)
	   && CONST_OK_FOR_LETTER_P (INTVAL (XEXP (operand, 1)),
				     'I')));
}


/* Check that the given byte offset is aligned to the given number of
   bits. */
static int
picochip_is_aligned (int byte_offset, int bit_alignment)
{
  int byte_alignment = bit_alignment / BITS_PER_UNIT;
  return (byte_offset % byte_alignment) == 0;
}

/* Determine whether the given operand is a valid QImode reload
   address.  Such an address must either be a register, or an aligned
   register+offset. */
int
picochip_reloadqi_memory_address (rtx operand,
				  enum machine_mode mode ATTRIBUTE_UNUSED)
{
  int result;

  if (MEM != GET_CODE (operand))
    return 0;

  result = ((REG == GET_CODE (XEXP (operand, 0))) ||
	    picochip_word_aligned_memory_reference (XEXP (operand, 0)));

  return result;

}

/* Given an alignable memory location, convert the memory location
   into a HI mode access, storing the new memory reference in
   paligned_mem, and the number of bits by which to shift in pbitnum
   (i.e., given a reference to FP+3, this creates an aligned reference
   of FP+2, with an 8-bit shift). This code is a modification of that
   found in the Alpha port. */
void
picochip_get_hi_aligned_mem (rtx ref, rtx * paligned_mem, rtx * pbitnum)
{
  rtx base;
  HOST_WIDE_INT offset = 0;

  if (GET_CODE (ref) != MEM)
    abort ();

  if (reload_in_progress && !memory_address_p (GET_MODE (ref), XEXP (ref, 0)))
    {
      base = find_replacement (&XEXP (ref, 0));

      if (!memory_address_p (GET_MODE (ref), base))
	abort ();
    }
  else
    {
      base = XEXP (ref, 0);
    }

  if (GET_CODE (base) == PLUS)
    {
      offset += INTVAL (XEXP (base, 1));
      base = XEXP (base, 0);
    }

  *paligned_mem = widen_memory_access (ref, SImode, (offset & ~3) - offset);

  if (offset > 0)
    {
      /*      if (TARGET_DEBUG)
	{
	  printf
	    ("Found non-zero offset in get_hi_aligned_mem - check that the correct value is being used (as this functionality hasn't been exploited yet).\n");
	    }*/
    }

  *pbitnum = GEN_INT ((offset & 3) * 8);

}

/* Return true if the given memory operand can be aligned to a
   word+offset memory reference (e.g., FP+3 can be converted into the
   memory operand FP+2, with the offset 1). */
int
picochip_alignable_memory_operand (rtx mem_operand,
				   enum machine_mode mode ATTRIBUTE_UNUSED)
{
  rtx address;

  /* Not a mem operand. Refuse immediately. */
  if (MEM != GET_CODE (mem_operand))
    return 0;

  address = XEXP (mem_operand, 0);

  /* Return true if a PLUS of the SP and a (valid) constant, or SP itself. */
  return ((PLUS == GET_CODE (address) &&
	   REGNO (XEXP (address, 0)) == GENERAL_REGS &&
	   CONST_INT == GET_CODE (XEXP (address, 1)) &&
	  CONST_OK_FOR_LETTER_P (INTVAL (XEXP (address, 1)),'I')) 
	   || (REG == GET_CODE (address)
	       && REGNO (address) == GENERAL_REGS));

}

const char *
or32_output_move_double (rtx * operands)
{
  rtx xoperands[3];

  switch (GET_CODE (operands[0]))
    {
    case REG:
      if (GET_CODE (operands[1]) == REG)
	{
	  if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	    {
	      output_asm_insn ("\tmov\t%H0, %H1", operands);
	      output_asm_insn ("\tmov\t%0, %1", operands);
	      return "";
	    }
	  else
	    {
	      output_asm_insn ("\tmov\t%0, %1", operands);
	      output_asm_insn ("\tmov\t%H0, %H1", operands);
	      return "";
	    }
	}
      else if (GET_CODE (operands[1]) == MEM)
	{
	  xoperands[1] = XEXP (operands[1], 0);
	  if (GET_CODE (xoperands[1]) == REG)
	    {
	      xoperands[0] = operands[0];
	      if (REGNO (xoperands[0]) == REGNO (xoperands[1]))
		{
		  output_asm_insn ("\tld\t%H0,%1,4", xoperands);
		  output_asm_insn ("\tld\t%0,%1,0", xoperands);
		  return "";
		}
	      else
		{
		  output_asm_insn ("\tld\t%0,%1,0", xoperands);
		  output_asm_insn ("\tld\t%H0,%1,4", xoperands);
		  return "";
		}
	    }
	  else if (GET_CODE (xoperands[1]) == PLUS)
	    {
	      if (GET_CODE (xoperands[2] = XEXP (xoperands[1], 1)) == REG)
		{
		  xoperands[0] = operands[0];
		  xoperands[1] = XEXP (xoperands[1], 0);
		  if (REGNO (xoperands[0]) == REGNO (xoperands[2]))
		    {
		      output_asm_insn ("\tld\t%H0,%2,%1+4",
				       xoperands);
		      output_asm_insn ("\tld\t%0,%2,%1", xoperands);
		      return "";
		    }
		  else
		    {
		      output_asm_insn ("\tld\t%0,%2,%1", xoperands);
		      output_asm_insn ("\tld\t%H0,%2,%1+4",
				       xoperands);
		      return "";
		    }
		}
	      else if (GET_CODE (xoperands[2] = XEXP (xoperands[1], 0)) ==
		       REG)
		{
		  xoperands[0] = operands[0];
		  xoperands[1] = XEXP (xoperands[1], 1);
		  if (REGNO (xoperands[0]) == REGNO (xoperands[2]))
		    {
		      output_asm_insn ("\tld\t%H0,%2,%1+4",
				       xoperands);
		      output_asm_insn ("\tld\t%0,%2,%1", xoperands);
		      return "";
		    }
		  else
		    {
		      output_asm_insn ("\tld\t%0,%2,%1", xoperands);
		      output_asm_insn ("\tld\t%H0,%2,%1+4",
				       xoperands);
		      return "";
		    }
		}
	      else
		abort ();
	    }
	  else
	    abort ();
	}
      else if (GET_CODE (operands[1]) == CONST_INT)
	{
	  if (INTVAL (operands[1]) < 0)
	    output_asm_insn ("\txor\t%0,%0,%0\n\taddi\t%0,%0, -1", operands);
	  else
	    output_asm_insn ("\txor\t%0,%0,%0", operands);
	  output_asm_insn ("\tldri\t%H0,%1", operands);
	  /*	  output_asm_insn ("\tl.ori   \t%H0, %H0, lo(%1)", operands);*/
	  return "";
	}
      else
	abort ();
    case MEM:
      xoperands[0] = XEXP (operands[0], 0);
      if (GET_CODE (xoperands[0]) == REG)
	{
	  xoperands[1] = operands[1];
	  output_asm_insn ("\tst\t%1,%0,0", xoperands);
	  output_asm_insn ("\tst\t%H1,%0,4", xoperands);
	  return "";
	}
      else if (GET_CODE (xoperands[0]) == PLUS)
	{
	  if (GET_CODE (xoperands[1] = XEXP (xoperands[0], 1)) == REG)
	    {
	      xoperands[0] = XEXP (xoperands[0], 0);
	      xoperands[2] = operands[1];
	      output_asm_insn ("\tst\t%2,%1,%0", xoperands);
	      output_asm_insn ("\tst\t%H2,%1,%0+4", xoperands);
	      return "";
	    }
	  else if (GET_CODE (xoperands[1] = XEXP (xoperands[0], 0)) == REG)
	    {
	      xoperands[0] = XEXP (xoperands[0], 1);
	      xoperands[2] = operands[1];
	      output_asm_insn ("\tst\t%2,%1,%0", xoperands);
	      output_asm_insn ("\tst\t%H2,%1,%0+4", xoperands);
	      return "";
	    }
	  else
	    abort ();
	}
      else
	abort ();
    default:
      abort ();
    }
}

void coffee_expand_prologue(void)
{
  int total_size = coffee_compute_frame_size (get_frame_size ());
  rtx sp_rtx;
  rtx value_rtx;
  rtx value_rtx_neg;

  if (!total_size)
    /* No frame needed.  */
    return;

  sp_rtx = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);

  if (total_size > 32767)
    {
      value_rtx_neg = gen_rtx_REG (Pmode, 26);
      emit_frame_insn (gen_rtx_SET (Pmode, value_rtx_neg, GEN_INT (-total_size)));
      value_rtx = gen_rtx_REG (Pmode, 26);
      emit_frame_insn (gen_rtx_SET (Pmode, value_rtx, GEN_INT (total_size)));
    }
  else
    {
    value_rtx_neg = GEN_INT (-total_size);
    value_rtx = GEN_INT (total_size-frame_info.pretend_args_size);
    }
  /* Update the stack pointer to reflect frame size.  */
  emit_frame_insn
    (gen_rtx_SET (Pmode, stack_pointer_rtx,
		  gen_rtx_PLUS (Pmode, stack_pointer_rtx, value_rtx_neg)));

  if (frame_info.save_fp_p)
    {
      emit_frame_insn
	(gen_rtx_SET (Pmode,
		      indexed_memory (stack_pointer_rtx,
				      frame_info.fp_save_offset),
		      frame_pointer_rtx));

      emit_frame_insn
	(gen_rtx_SET (Pmode, frame_pointer_rtx,
		      gen_rtx_PLUS (Pmode, stack_pointer_rtx, value_rtx)));
    }
  if (frame_info.save_lr_p)
    {

      emit_frame_insn
	(gen_rtx_SET (Pmode,
		      indexed_memory (stack_pointer_rtx,
				      frame_info.lr_save_offset),
		      gen_rtx_REG (Pmode, LINK_REGNUM)));
    }
  if (frame_info.gpr_size)
    {
      int offset = 0;
      int regno;

      for (regno = 0; regno <= LAST_INT_REG; regno++)
	{
	  HOST_WIDE_INT disp = frame_info.gpr_offset + offset;

	  if (REG_NEEDS_SAVE(regno))
	    {
	      emit_frame_insn
		(gen_rtx_SET (Pmode,
			      indexed_memory (stack_pointer_rtx, disp),
			      gen_rtx_REG (Pmode, regno)));
	      offset = offset + UNITS_PER_WORD;
	    }
	}
    }
}

void coffee_expand_epilogue(void)
{
  int total_size = coffee_compute_frame_size (get_frame_size ());
  rtx value_rtx;
  rtx value_rtx_neg;

  if (total_size > 32767)
    {
      value_rtx = gen_rtx_REG (Pmode, 26);
      emit_insn (gen_rtx_SET (Pmode, value_rtx, GEN_INT (total_size)));
      value_rtx_neg = gen_rtx_REG (Pmode, 26);
      emit_insn (gen_rtx_SET (Pmode, value_rtx_neg, GEN_INT (-total_size)));
    }
  else
    {
    value_rtx = GEN_INT (total_size);
    value_rtx_neg = GEN_INT (-total_size);
    }

  if (frame_info.save_lr_p)
    {
      or32_maybe_dead
	(emit_insn
	 (gen_rtx_SET (Pmode, gen_rtx_REG (Pmode, LINK_REGNUM),
		       indexed_memory (stack_pointer_rtx,
				       frame_info.lr_save_offset))));
    }
  if (frame_info.save_fp_p)
    {
      emit_insn
	(gen_rtx_SET (Pmode, gen_rtx_REG (Pmode, FRAME_POINTER_REGNUM),
		      indexed_memory (stack_pointer_rtx,
				      frame_info.fp_save_offset)));
    }

  if (frame_info.gpr_size)
    {
      int offset = 0;
      int regno;

      for (regno = 0; regno <= LAST_INT_REG; regno++)
	{
	  HOST_WIDE_INT disp = frame_info.gpr_offset + offset;

	  if (REG_NEEDS_SAVE(regno))
	    {
	      emit_insn
		(gen_rtx_SET (Pmode, gen_rtx_REG (Pmode, regno),
			      indexed_memory (stack_pointer_rtx, disp)));
	      offset = offset + UNITS_PER_WORD;
	    }
	}
    }

  emit_insn(gen_blockage ());

  if (total_size)
    {
      emit_insn (gen_rtx_SET (Pmode, stack_pointer_rtx,
			      gen_rtx_PLUS (Pmode,
					    stack_pointer_rtx, value_rtx)));
    }

  emit_insn (gen_indirect_jump (gen_rtx_REG (Pmode, LINK_REGNUM)));
  
  emit_insn(gen_blockage());

}

/* Compuate full frame size and layout.  SIZE is the size of the
   functions local variables.  Store information in FRAME_INFO and
   return total size of stack frame.  */

HOST_WIDE_INT
coffee_compute_frame_size (HOST_WIDE_INT size)
{
  HOST_WIDE_INT args_size;
  HOST_WIDE_INT vars_size;
  HOST_WIDE_INT stack_offset;
  HOST_WIDE_INT pretend_args_size;
  int regno;

  args_size = current_function_outgoing_args_size;
  vars_size = COFFEE_ALIGN (size, 4);
  pretend_args_size = current_function_pretend_args_size;

  frame_info.args_size = args_size;
  frame_info.vars_size = vars_size;
  frame_info.vars_size = pretend_args_size;

  /* If the function has local variables, we're committed to
     allocating it anyway.  Otherwise reclaim it here.  */
  /* FIXME: Verify this.  Got if from the MIPS port.  */
  if (vars_size == 0 && current_function_is_leaf)
    args_size = 0;

  stack_offset = args_size;

  /* Save link register right after possible outgoing arguments.  */
  if (coffee_save_reg_p (LINK_REGNUM))
    {
      frame_info.lr_save_offset = stack_offset;
      frame_info.save_lr_p = true;
      stack_offset = stack_offset + UNITS_PER_WORD;
    }
  else
    frame_info.save_lr_p = false;

  /* Save frame pointer right after possible link register.  */
  if (coffee_save_reg_p (FRAME_POINTER_REGNUM))
    {
      frame_info.fp_save_offset = stack_offset;
      frame_info.save_fp_p = true;
      stack_offset = stack_offset + UNITS_PER_WORD;
    }
  else
    frame_info.save_fp_p = false;

  frame_info.gpr_size = 0;
  frame_info.mask = 0;
  frame_info.gpr_offset = stack_offset;

  for (regno = 0; regno <= LAST_GENERAL_REGISTER; regno++)
    {
      if (regno == LINK_REGNUM || regno == FRAME_POINTER_REGNUM)
	/* These has already been saved if so needed.  */
	continue;

      if (coffee_save_reg_p (regno))
	{
	  frame_info.gpr_size += UNITS_PER_WORD;
	}
    }

  frame_info.total_size = ((frame_info.save_fp_p ? UNITS_PER_WORD : 0)
			   + (frame_info.save_lr_p ? UNITS_PER_WORD : 0)
			   + args_size + frame_info.gpr_size + vars_size
			   + pretend_args_size);

  return frame_info.total_size;
}


/* Return true if current function must save REGNO.  */
static bool
coffee_save_reg_p (int regno)
{
  /* Check call-saved registers.  */
  if (regs_ever_live[regno] && !call_used_regs[regno])
    return true;

  /* We need to save the old frame pointer before setting up a new
     one.  */
  if (regno == FRAME_POINTER_REGNUM && frame_pointer_needed)
    return true;

  /* We need to save the incoming return address if it is ever clobbered
     within the function.  */
  if (regno == LINK_REGNUM && !current_function_is_leaf)
    return true;

  return false;
}

/* Emit a frame related insn.  Same as emit_insn, but sets
   RTX_FRAME_RELATED_P to one.  */

static rtx
emit_frame_insn (rtx insn)
{
  insn = emit_insn (insn);
  RTX_FRAME_RELATED_P (insn) = 1;
  return (insn);
}

static rtx
indexed_memory (rtx base, HOST_WIDE_INT disp)
{
  return gen_rtx_MEM (Pmode, gen_rtx_PLUS (Pmode, base, GEN_INT (disp)));
}

/* Add a REG_MAYBE_DEAD note to the insn.  */
static void
or32_maybe_dead (rtx insn)
{
  REG_NOTES (insn) = gen_rtx_EXPR_LIST (REG_MAYBE_DEAD,
					const0_rtx, REG_NOTES (insn));
}

/*
static void coffee_asm_file_start()
{
  default_file_start();
  fprintf(asm_out_file,".code32\n.include\t\"crt.s\"\n.include\t\"bstuff.s\"\n");
  if (HWFP) 
    {
      fprintf(asm_out_file, "milk=%d\n", atoi(fpuid));
    }
}
*/


static void coffee_asm_file_start()
{
  default_file_start ();
  /*  fprintf(asm_out_file,".code32\n");*/
  if (HWFP)
    {
      fprintf(asm_out_file, "milk=%d\n", atoi(fpuid));
    }
}

/*
void
expand_float_branch (rtx *operands, enum rtx_code test_code)
{
  rtx cmp_operands[3];
  rtx inv_label_operands[2];

  cmp_operands[0] = cmpsf_op1;
  cmp_operands[1] = cmpsf_op2;
  cmp_operands[2] = scratch;

  inv_label_operands[0] = pc_rtx;
  inv_label_operands[1] = gen_rtx_LABEL_REF (VOIDmode, operands[0]);


  switch (test_code)
    {
    case EQ: 
      output_asm_insn("\tfc.eq0\t%2,%0,%1\n",cmp_operands);
      output_asm_insn("\tbeq\tc0,%l0%(\n",operands);
      break;
    case NE:
      output_asm_insn("\tfc.eq0\t%2,%0,%1\n",cmp_operands);
      output_asm_insn("\tbeq\tc0,%l0%(\n",inv_label_operands);
      break;
    case LE:
      output_asm_insn("\tfc.ole0\t%2,%0,%1\n",cmp_operands);
      output_asm_insn("\tbelt\tc0,%l0%\n",operands);
      break;      
    case GT: 
      output_asm_insn("\tfc.olt0\t%2,%1,%0\n",cmp_operands);
      output_asm_insn("\tblt\tc0,%l0%(\n",operands);
      break;
    case LT: 
      output_asm_insn("\tfc.olt0\t%2,%0,%1\n",cmp_operands);
      output_asm_insn("\tblt\tc0,%l0%(\n",operands);
      break;
    case GE: 
      output_asm_insn("\tfc.ole0\t%2,%1,%0\n",cmp_operands);
      output_asm_insn("\tbelt\tc0,%l0%\n",operands);
      break;
    default:
      break;
    }
}		    
		      
*/
rtx
coffee_gen_compare_reg (enum rtx_code code)
{
  rtx op0 = cmpsf_op1;
  rtx op1 = cmpsf_op2;
  rtx scratch;
  rtx cc_reg_si = gen_rtx (REG, CCmode, CC_REG);
  rtx cc_reg_sf = gen_rtx (REG, CCFPmode, CC_REG);
  int invert;

  scratch = gen_reg_rtx (SFmode);

  if (last_cmp_was_float)
    {
      switch (code)
	{
	case EQ:
	  break;
	case NE:
	  invert = 1;
	  code = EQ;
	  break;
	case LT:
	  break;
	case GT:
	  invert = 1;
	  code = LE;
	  break;
	case LE:
	  break;
	case GE:
	  invert = 1;
	  code = LT;
	default:
	  abort();
	}
      emit_insn (gen_rtx_SET (VOIDmode, cc_reg_sf, gen_rtx (code, CCFPmode, op0, op1)));
      emit_insn (gen_rtx (CLOBBER,SFmode, scratch));
      return cc_reg_sf;
    }
  else
    {
      if (GET_CODE (op1) == CONST_INT)
	{
	  if (!(INTVAL(op1) >= -32768 && INTVAL(op1) <= 32767))
	    {
	      op1 = force_reg(SImode, op1);
	    }
	}
      emit_insn (gen_rtx_SET (VOIDmode, cc_reg_si, gen_rtx_COMPARE (CCmode, op0, op1)));
        return cc_reg_si;
    }
}
