(define_expand "beq"
  [(set (pc)
	(if_then_else (eq (match_dup 1)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(EQ);
  ")

(define_expand "bne"
  [(set (pc)
	(if_then_else (ne (match_dup 1)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(NE);	
  ")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (gt (match_dup 1)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(GT);	
  ")

;; No unsigned comparisons. Needed so use the same as signed
(define_expand "bgtu"
  [(set (pc)
	(if_then_else (gtu (match_dup 1)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(GTU);
  ")

(define_expand "blt"
  [(set (pc)
	(if_then_else (lt (match_dup 1)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(LT);
  ")


(define_expand "bltu"
  [(set (pc)
	(if_then_else (ltu (match_dup 1)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  " 	
	operands[1] = coffee_gen_compare_reg(LTU);
  ")



(define_expand "bge"
  [(set (pc)
	(if_then_else (ge (match_dup 1)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(GE);
  ")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (geu (match_dup 1)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(GEU);
  ")

(define_expand "ble"
  [(set (pc)
	(if_then_else (le (match_dup 1)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
	operands[1] = coffee_gen_compare_reg(LE);
  ")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (leu (match_dup 1)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "
	operands[1] = coffee_gen_compare_reg(LEU);
 ")

(define_insn "*beq"
  [(set (pc)
	(if_then_else (eq (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "beq\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bne"
  [(set (pc)
	(if_then_else (ne (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "bne\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bgt"
  [(set (pc)
	(if_then_else (gt (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "bgt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bge"
  [(set (pc)
	(if_then_else (ge (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "begt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*blt"
  [(set (pc)
	(if_then_else (lt (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "blt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*ble"
  [(set (pc)
	(if_then_else (le (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "ble\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bgtu"
  [(set (pc)
	(if_then_else (gtu (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "bgt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bgeu"
  [(set (pc)
	(if_then_else (geu (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "begt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bltu"
  [(set (pc)
	(if_then_else (ltu (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "blt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bleu"
  [(set (pc)
	(if_then_else (leu (reg:CC CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "belt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*beq"
  [(set (pc)
	(if_then_else (eq (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "beq\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bne"
  [(set (pc)
	(if_then_else (ne (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "bne\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bgt"
  [(set (pc)
	(if_then_else (gt (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "bgt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bge"
  [(set (pc)
	(if_then_else (ge (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "begt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*blt"
  [(set (pc)
	(if_then_else (lt (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "blt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*ble"
  [(set (pc)
	(if_then_else (le (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "ble\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bgtu"
  [(set (pc)
	(if_then_else (gtu (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "bgt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bgeu"
  [(set (pc)
	(if_then_else (geu (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "begt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bltu"
  [(set (pc)
	(if_then_else (ltu (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "blt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])

(define_insn "*bleu"
  [(set (pc)
	(if_then_else (leu (reg:CCFP CC_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
 ""
 "belt\\tc0,%l0%(" ;; %C0 negates condition
 [(set_attr "type" "branch")
 (set_attr "cc" "unchanged")
  (set_attr "slottable" "has_slot")
])
