// picoChip ASM file
//
//   Support for 16-bit signed division/modulus.
//
//   Copyright (C) 2003, 2004, 2005  Free Software Foundation, Inc.
//   Contributed by picoChip Designs Ltd.
//   Maintained by Daniel Towner (daniel.towner@picochip.com)
//
//   This file is free software; you can redistribute it and/or modify it
//   under the terms of the GNU General Public License as published by the
//   Free Software Foundation; either version 2, or (at your option) any
//   later version.
//
//   In addition to the permissions in the GNU General Public License, the
//   Free Software Foundation gives you unlimited permission to link the
//   compiled version of this file into combinations with other programs,
//   and to distribute those combinations without any restriction coming
//   from the use of this file.  (The General Public License restrictions
//   do apply in other respects; for example, they cover modification of
//   the file, and distribution when not linked into a combine
//   executable.)
//
//   This file is distributed in the hope that it will be useful, but
//   WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//   Boston, MA 02110-1301, USA..global __divmodhi4

.section .text

.align 8		
.global __divmodhi4
__divmodhi4:                                      --Rn in r0,src in r1

  TOP:

--Test to see if src is zero.
-- In this code if src is zero 32767 is copied to the quotient and the remainder

        sub.0 0, r1, r15
        beq SRC_IS_ZERO

--Test to see if Rn is zero.
-- In this code if Rn is zero, zero is copied to the quotient and the remainder

        sub.0 0, r0, r15
        beq RN_IS_ZERO

-- Check to see if inputs are equal.

        sub.0 r0, r1, r15
        beq SOURCES_EQUAL

--Check to see if src is 1

        sub.0 1, r1, r15 
        beq SRC_IS_ONE

--Catering for the max negative problem

        sub.0 16#8000#, r0, r15
        beq RN_IS_MAX_NEGATIVE

--Calculate absolute values

        xor.0[asr r0, 15], r0, r2               --absolute value of Rn
        add.0 [lsr r0, 15], r2, r2

        xor.0[asr r1, 15], r1, r3               --absolute value of Src
        add.0 [lsr r1, 15], r3, r3

--Perform the sign bit count required to enable alignment
        sbc     r0, r4   		--Signed bit count (Need to know for alignment)
        sbc     r1, r5 		        --Signed bit count (Need to know for alignment
        sub.0   r5, r4, r5              --Calculate N
        add.0   r5, 1, r4               --Calculate N+1

--Test to see if Rn > src 

BiggestOperand:

        cmpsp r2, r3, r15
        blo RN_WAS_BIGGEST

SRC_WAS_BIGGEST:

        bra SRC_BIGGER_DEFAULT_RESULT

--Align src to Rn when Rn is the bigger number

RN_WAS_BIGGEST:
	 
        lsl.0   r3, r5, r3 \ copy.1 r4, r5      --Align src to Rn
       

IN_TO_DIV_STEP_LOOP:

--loop for N+1 (r4)

        divstep r2, r3
        sub.0 r4, 1, r4        --sub 1 from N+1
        bne IN_TO_DIV_STEP_LOOP

--Extract Quotient

        sub.0 16, r5, r4                                    
        lsl.0 r2, r4, r3
        lsr.0 r3, r4, r3 

        lsr.0 r2, r5, r2        -- Quotient in r3 (to preserve r2 for remainder calc / Remainder in r2)

----Work out whether the Quotient  needs to be negated (Negates quotient if one (but not both) of the inputs were negative)
SIGN_OF_OUTPUT:

        xor.0 r0, r1, r4
        lsr.0 r4, 15, r5 \ asr.1 r4, 15, r4

        xor.0 r3, r4, r1
        add.0 r1, r5, r1

--Work out whether the Remainder needs to be negated because Rn was negative

        lsr.0 r0, 15, r5 \ asr.1 r0, 15, r4
        xor.0 r2, r4, r0 
        add.0 r0, r5, r0 

--Output resulting Quotient and remainder

        jr (r12)

SRC_BIGGER_DEFAULT_RESULT:

        copy.1 0, r1
        jr (r12)

SOURCES_EQUAL:

        copy.0 0, r0 \ copy.1 1, r1
        jr (r12)

SRC_IS_ZERO:                            -- Currently, if src is zero both quotient and remainder set to maximum 
                                        -- value to indicate a divide by zero.The user of this routine should set 
                                        -- up the result of a divide by zero as appropriate to the application.

        copy.0 16#7fff#, r0 \ copy.1 16#7fff#, r1
        jr (r12)

RN_IS_ZERO:

        copy.0 0, r0 \ copy.1 0, r1
        jr (r12)

SRC_IS_ONE:

        copy.0 0, r0 \ copy.1 r0, r1
        jr (r12)

SRC_IS_POWER_OF_TWO:
        
        lsl.0 2#0000000000000001#,r5, r3\copy.1 0, r2 
        bra SIGN_OF_OUTPUT

RN_IS_MAX_NEGATIVE:

        xor.0[asr r1, 15], r1, r3               --absolute value of Src
        add.0 [lsr r1, 15], r3, r3

        sbc     r3, r5 		        --Signed bit count (Need to know for alignment (r5 contains N since we know sbc of r0 == 0)

        lsl.0 r3, r5, r3                --align divisor with dividend (N)

        and.0 r3, 2#0011111111111111#, r15 \ add.1 r5, 1, r4          -- (N+1 in r4)
        beq SRC_IS_POWER_OF_TWO \ copy.1 r4, r5 \ copy.0 r0, r2                        --(N+1 in r5 too)
                           
        bra IN_TO_DIV_STEP_LOOP         --Otherwise branch into divstep loop           

.section .endFile

