// picoChip ASM file
//
//   Support for 32-bit signed division/modulus.
//
//   Copyright (C) 2003, 2004, 2005  Free Software Foundation, Inc.
//   Contributed by picoChip Designs Ltd.
//   Maintained by Daniel Towner (daniel.towner@picochip.com)
//
//   This file is free software; you can redistribute it and/or modify it
//   under the terms of the GNU General Public License as published by the
//   Free Software Foundation; either version 2, or (at your option) any
//   later version.
//
//   In addition to the permissions in the GNU General Public License, the
//   Free Software Foundation gives you unlimited permission to link the
//   compiled version of this file into combinations with other programs,
//   and to distribute those combinations without any restriction coming
//   from the use of this file.  (The General Public License restrictions
//   do apply in other respects; for example, they cover modification of
//   the file, and distribution when not linked into a combine
//   executable.)
//
//   This file is distributed in the hope that it will be useful, but
//   WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//   Boston, MA 02110-1301, USA.

.section .text

.align 8
.global __divmodsi4
__divmodsi4:
// picoChip Function Prologue : &__divmodsi4 = 8 bytes

	STL R[9:8],(FP)-2
	STL R[13:12],(FP)-1
        SUB.0 FP,8,FP

	// Negate flag set to 0
	COPY.0 0,R9
	
	// If dividend is negative, invert the dividend and flag.
	SUB.0 R1,0,r15
	BGE dividendNotNegative

	// Divisor is negative - negate divisor and set flag
        SUB.0 0,R0,R0
        SUBB.0 0,R1,R1
	XOR.0 1,R9,R9

dividendNotNegative:
		
	// If divisor is negative, invert the divisor and flag.
	SUB.0 R3,0, r15
	BGE divisorNotNegative

	// Divisor is negative - negate divisor and set flag
        SUB.0 0,R2,R2
        SUBB.0 0,R3,R3
	XOR.0 1,R9,R9

divisorNotNegative:	
	
        JL (&__udivmodsi4)

	// If negation flag was set, negate the answers (in R[4,5] R[6,7])
	AND.0 R9,1,r15
	BEQ epilogue

        SUB.0 0,R4,R4
        SUBB.0 0,R5,R5
        SUB.0 0,R6,R6
        SUBB.0 0,R7,R7
	
epilogue:	
	
        LDL (FP)1,R[13:12]
        LDL (FP)-2,R[9:8]
        JR (R12)

// picoChip Function Epilogue : __divmodsi4

.section .endFile
// End of picoChip ASM file
