// picoChip ASM file
//.file "firstSetBit32.c"

.section .text

.align 8
.global _firstSetBit32
_firstSetBit32:
// picoChip Function Prologue : &_firstSetBit32 = 0 bytes

// The result is stored in R0.

	// Note that trace scheduling has been used in some places to
	// improve speed (placing a computation on two paths, so that
	// whichever is taken still computes the value).
	
// If the top word is empty, copy the lower word into the upper register
// and set the initial result to 16.
// :TODO: Use COPYEQ instructions.
	ADD.0 0,R1,r15
	BNE secondStage
=->	ASR.0 R1,15,r15 \ COPY.1 0,R2	// Initialise result value

	ASR.0 R0,15,r15 \ COPY.1 R0,R1	
	COPY.0 16,R2

secondStage:

// R1 now contains the value on which to operate. Is the top bit set?
	SBC R1,R1 \ BLT finish
=->	ADD.0 R1,1,R1	// Result doesn't always get used.

	JR (R12)
=->	ADD.0 R1,R2,R0

// Finished. Return to caller.
finish:
	JR (R12)
=->	COPY.0 R2,R0

// picoChip Function Epilogue : firstSetBit32

.section .endFile
// End of picoChip ASM file
