// picoChip ASM file
//
//   Support for 32-bit unsigned division/modulus.
//
//   Copyright (C) 2003, 2004, 2005  Free Software Foundation, Inc.
//   Contributed by picoChip Designs Ltd.
//   Maintained by Daniel Towner (daniel.towner@picochip.com)
//
//   This file is free software; you can redistribute it and/or modify it
//   under the terms of the GNU General Public License as published by the
//   Free Software Foundation; either version 2, or (at your option) any
//   later version.
//
//   In addition to the permissions in the GNU General Public License, the
//   Free Software Foundation gives you unlimited permission to link the
//   compiled version of this file into combinations with other programs,
//   and to distribute those combinations without any restriction coming
//   from the use of this file.  (The General Public License restrictions
//   do apply in other respects; for example, they cover modification of
//   the file, and distribution when not linked into a combine
//   executable.)
//
//   This file is distributed in the hope that it will be useful, but
//   WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, 51 Franklin Street, Fifth Floor,
//   Boston, MA 02110-1301, USA.
	
.section .text

.align 8
.global __udivmodsi4
__udivmodsi4:
// picoChip Function Prologue : &__udivmodsi4 = 24 bytes
	
	// Schedule the register saves alongside the special cases, so that
	// if the special cases fail, the registers will have already
	// been stored onto the stack.
	SUB.0 R3,R1,r15 \ STL R[13:12],(FP)-1
	BHS skipCommonCase \ STL R[9:8],(FP)-4
=->	SUB.0 R2,1,r15 \ STL R[11:10],(FP)-3
	
_L2:
	// Flags set above, and in _L2 caller.
	BNE restOfCode
=->	SUB.0 R3,0,r15
	BNE restOfCode 
=->	COPY.0 R0,R4 \ COPY.1 R1,R5
	JR (R12)	// Return to caller
=->	COPY.0 0,R6 \ COPY.1 0,R7
	// Never reach here

skipCommonCase:
	SUB.0 R3,R1,r15
	BNE _L3	// (Reversed branch) 
=->	SUB.0 R2,R0,r15 // Must be set in delay slot, so ready by _L9

_L9:
	BLO _L2	// (Reversed branch)
=->	SUB.0 R2,1,r15
	
_L3:
	SUB.0 R2,R0,r15
	BEQ _L10	// (Reversed branch)
=->	SUB.0 R1,R3,r15 // Set flags for branch at _L10 
	
_L4:
	// greater than
	COPY.0 0,R4 \ COPY.1 0,R5 \ JR (R12)	// Return to caller
=->	COPY.0 R0,R6 \ COPY.1 R1,R7
	// Doesn't reach here.
		
_L10:
	// Flags set in _L10 call delay slot.
	BNE _L4 
=->	COPY.0 1,R4 \ COPY.1 0,R5
	JR (R12)	// Return to caller
=->	COPY.0 0,R6 \ COPY.1 0,R7

restOfCode:	

// Prologue
	
	// Register saves scheduled alongside special cases above.
	ADD.0 FP,-20,FP \ STW R14,(FP)-4

	// The following can be scheduled together.
	// dividend in R[9:8] (from R[1:0])
	// divisor in R[7:6] (from R[3:2])
	// R14 := firstSetBit32 (dividend)	
	// R0 := firstSetBit32 (divisor)
	JL (&_firstSetBit32) \ COPY.0 R0,R8 \ COPY.1 R1,R9
=->	COPY.0 R2,R6 \ COPY.1 R3,R7
	COPY.0 R0,R14 \ JL (&_firstSetBit32)
=->	COPY.0 R6,R0 \ COPY.1 R7,R1

	// R14 := R0 - R14
	SUB.0 R0,R14,R14

	ADD.0 R14,1,R0	// R0 := R14 + 1 (HI)
	
	// R[11:10] = R[7,6] << R14
	SUB.0 15,R14,r15
	LSL.0 R6,R14,R11 \ BLT setupDivstepLoop
=->	SUB.0 0,R14,R4 \ COPY.1 0,R10

	// Zero shift is a special case. Shifting by zero within a 16-bit
	// source object is fine, but don't execute the OR of the right-shift
	// into the final result.
	LSL.0 R7,R14,R11 \ BEQ setupDivstepLoop
=->	LSL.0 R6,R14,R10
	
	LSR.0 R6,R4,R4
	OR.0 R11,R4,R11
	
setupDivstepLoop:

	// R[5:4] := R[9:8] (SI)
	COPY.0 R8,R4 \ COPY.1 R9,R5
	COPY.0 0,R6 \ COPY.1 R0,R8

	// Store original value of loopCount for use after the loop.
	// The Subtraction is handled in the tail of the loop iteration
	// after this point.
	SUB.0 R4,R10,R0 \ COPY.1 R8,R14
	
	// workingResult in R4,5,6
	// temps in r0,1,2 and r7
	// alignedDivisor in R10,11
	// loopCount in r8
	// r3, r9 scratch, used for renaming.
	
loopStart:	
	// R0 := R4 - zeroExtend (R10) - only need 33-bits (i.e., 48-bits)
	SUBB.0 R5,R11,R1 \ LSR.1 R0,15,R3
	SUBB.0 R6,0,R2 \ LSR.1 R1,15,R6

	// if (carry) goto shiftOnly
	SUB.0 R8,1,R8 \ BNE shiftOnly
=->	LSR.0 R4,15,R7 \ LSL.1 R1,1,R9
	
	OR.0 [LSL R0,1],1,R4 \ BNE loopStart
=->	SUB.0 R4,R10,R0 \ OR.1 R9,R3,R5
	
	BRA loopEnd
	
shiftOnly:	

	OR.0 [LSL R5,1],R7,R5 \ BNE loopStart \ LSR.1 R5,15,R6
=->	SUB.0 [LSL R4,1],R10,R0 \LSL.1 R4,1,R4
	
// End of loop
loopEnd:

	// Schedule the computation of the upper word after shifting
	// alongside the decision over whether to branch, and the register
	// restores.
	// R10 is filled with a useful constant.
	SUB.0 15,r14,r15 \ LDL (FP)4,R[13:12]
	SUB.1 0,R14,R1 // Don't set flags!
	LSL.0 R6,R1,R3 \ LDL (FP)-4,R[9:8]

	BLT remainderHasMoreThan16Bits \ LSR.0 R5,R14,R7 \ COPY.1 -1,R10
=->	LSL.0 R5,R1,R2 \ OR.1 R7,R3,R3

	LSR.0 R4,R14,R3 \ COPY.1 R3,R7
	BRA epilogue \ LSR.0 -1,R1,R0 \ COPY.1 0,R5
=->	OR.0 R3,R2,R6 \ AND.1 R0,R4,R4
	
remainderHasMoreThan16Bits:	

	LSL.0 R10,R14,R1 \ COPY.1 R3,R6
	XOR.0 R10,R1,R1 \ COPY.1 0,R7
	AND.0 R1,R5,R5

epilogue:
	
	JR (R12) \ LDW (FP)-4,R14
=->	LDL (FP)-3,R[11:10]
	
// picoChip Function Epilogue : udivmodsi4

.section .endFile
// End of picoChip ASM file
