/* Prototypes for exported functions defined in picochip.c
   
   Copyright (C) 2000, 2001 Free Software Foundation, Inc.
   Contributed by picoChip Designs Ltd. (http://www.picochip.com)
   Maintained by Daniel Towner (daniel.towner@picochip.com)

   This file is part of GNU CC.

   GNU CC is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU CC is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

extern void picochip_function_prologue (FILE *, HOST_WIDE_INT);
extern void picochip_function_epilogue (FILE *, HOST_WIDE_INT);

extern enum reg_class picochip_reg_class_from_letter (unsigned);
extern int picochip_legitimate_address_p (int, struct rtx_def *, unsigned);
int picochip_const_ok_for_letter_p (unsigned HOST_WIDE_INT value, unsigned c);

#ifdef RTX_CODE			/* inside TREE_CODE */

extern int picochip_reg_mode_ok_for_base_p (int mode, rtx x, unsigned strict);
extern void picochip_print_operand (FILE * file, rtx op, int letter);
extern void picochip_print_operand_address (FILE * file, rtx operand);

extern const char *picochip_output_cbranch (rtx operands[]);
extern const char *picochip_output_branch (rtx operands[],
					   int is_short_branch);
extern const char *picochip_output_reversed_branch (rtx operands[],
						    int is_short_branch);
extern const char *picochip_output_comparison (rtx operands[]);

extern const char *picochip_output_movhi (rtx dest, rtx source);
extern const char *picochip_output_movqi (rtx dest, rtx source);
extern const char *picochip_output_movsi (rtx dest, rtx source);

rtx picochip_function_arg (CUMULATIVE_ARGS cum, int mode, tree type,
			   int named);
rtx picochip_function_incoming_arg (CUMULATIVE_ARGS cum, int mode, tree type,
				    int named);

rtx picochip_incoming_function_arg (CUMULATIVE_ARGS, int, tree, int);
CUMULATIVE_ARGS picochip_arg_advance (CUMULATIVE_ARGS cum, int mode,
				      tree type, int named);
unsigned picochip_setup_incoming_varargs (CUMULATIVE_ARGS cum,
					  enum machine_mode mode, tree type);

extern int picochip_regno_nregs (int regno, int mode);
extern int picochip_class_max_nregs (int class, int mode);
extern int picochip_extra_constraint (rtx value, int c);

int picochip_legitimate_constant (rtx x);
int legitimate_address_register (rtx x, unsigned strict);

int picochip_cmov_operator (rtx op, enum machine_mode mode);
int picochip_word_aligned_memory_reference (rtx operand);
int picochip_alignable_memory_operand (rtx operand, enum machine_mode mode);
int picochip_reloadqi_memory_address (rtx operand, enum machine_mode mode);
int picochip_absolute_memory_operand (rtx op, enum machine_mode mode);

int picochip_is_call_operand (rtx operand, enum machine_mode);
int picochip_vliw_si_immediate (rtx operand, enum machine_mode);

void picochip_output_int (FILE * stream, const rtx value);
rtx picochip_function_value (tree valtype, tree func);
int picochip_symbol_offset (rtx operand);

int picochip_get_function_arg_boundary (enum machine_mode mode);

const char *picochip_lshrsi3_const (rtx operands[]);
const char *picochip_ashiftrt (rtx operands[]);
const char *picochip_ashlsi3_const (rtx operands[]);

const char *picochip_output_movhi_address (rtx dest, rtx source);
const char *picochip_addhi3 (rtx operands[]);
const char *picochip_adddi3 (rtx operands[]);
const char *picochip_subdi3 (rtx operands[]);
const char *picochip_ashiftrtsi_const (rtx operands[]);
const char *picochip_movqi (rtx operands[]);
const char *picochip_output_mulhisi3 (rtx operands[]);
const char *picochip_generate_synthesised_storeqi (rtx operands[]);
const char *picochip_output_synthesised_loadqi (rtx operands[]);

enum reg_class picochip_secondary_reload_class (enum reg_class class,
						enum machine_mode mode,
						rtx x, int in);

void picochip_get_hi_aligned_mem (rtx ref, rtx * paligned_mem, rtx * pbitnum);

rtx picochip_get_low_const (rtx value);
rtx picochip_get_high_const (rtx value);

void picochip_expand_prologue (void);
void picochip_expand_epilogue (int is_sibling_call);

void picochip_final_prescan_insn (rtx insn, rtx * operand, int num_operands);
const char *picochip_asm_output_opcode (FILE * f, const char *ptr);
void picochip_override_options (void);

int picochip_gen_conditional_copy (rtx * operands);

#endif /* RTX_CODE inside TREE_CODE */

void picochip_output_ascii (FILE * file, const char *str, int length);

extern int picochip_hard_regno_mode_ok (int regno, enum machine_mode mode);
extern void picochip_asm_output_labelref (FILE * file, const char *name);
extern void picochip_generate_internal_label (char *str, const char *prefix,
					      long num);

extern int initial_elimination_offset (int from, int to);

extern void picochip_output_aligned_common (FILE * stream, const char *name,
					    unsigned size, unsigned align);

extern void picochip_output_global (FILE * stream, const char *name);

extern void picochip_output_aligned_local (FILE * stream, const char *name,
					   unsigned size, unsigned alignment);

void picochip_output_label (FILE * stream, const char name[]);
void picochip_output_labelref (FILE * stream, const char name[]);
void picochip_output_internal_label (FILE * stream, const char *prefix,
				     unsigned long num);
void picochip_output_short (FILE * stream, const rtx value);
void picochip_output_char (FILE * stream, const rtx value);

void picochip_warn_inefficient (const char *msg);
void picochip_error_unimplemented (const char *msg);
void warn_of_byte_access (void);

void picochip_init_expanders (void);
void picochip_init_cpp_builtins (void);

/* True if VLIW scheduling is enabled (i.e., second scheduling pass). */
extern int picochip_flag_schedule_insns2;

void picochip_init_optabs (void);
