/*                    QPUX-Kernel Timer Header File                         */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/
#include <stdio.h>

/* different states a task can have*/
#define TASK_RUNNING		0
#define TASK_INTERRUPTIBLE	1
#define TASK_UNINTERRUPTIBLE	2
#define TASK_WAITING		3
#define TASK_STOPPED		4
#define TASK_SWAPPING		5

#define QUANTUM 4        //runtime quantum for a process



#define INIT_TASK \
/* state    */	  { 0, \
/* Pid      */      0, \
/* priority */      0, \
/* prev_task*/      &init_task, \
/* next_task*/	    &init_task, \
/* prev_run */	    &init_task, \
/* next_run */	    &init_task, \
/* counter  */      0,  \
/* timeout  */      0}

struct task_struct{
        int state;
        int pid;
	int priority;
        struct task_struct *prev_task,*next_task;
        struct task_struct *next_run,  *prev_run;
        long counter;
        unsigned long timeout;
	unsigned long kernel_stack_page;
};


struct mm_struct {
	unsigned long start_code, end_code, start_data, end_data;
	unsigned long start_stack, start_mmap;
};
  
/************************FUNCTIONS PROTOTYPES ARE HERE************************/
void Print_Runqueue( );
struct task_struct * ScheduleTaskStruct();
void schedule(void);
void add_to_runqueue(struct task_struct * );
void add_to_waitqueue(struct task_struct *);
inline void del_from_runqueue(struct task_struct *);
inline void wake_up_process(struct task_struct * p);
inline void move_last_runqueue(struct task_struct * p);
static inline int goodness(struct task_struct * p, struct task_struct * prev);
/************************FUNCTION PROTOTYPES ENDS HERE************************/


#ifndef NULL
#define NULL ((void *) 0)
#endif

#define for_each_task(p) \
	for (p = &init_task ; (p = p->next_task) != &init_task ; )
