/*                    QPUX-Kernel Timer Header File                         */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

#include <sched.h>

#define HZ 50000000     /* frequency at which COFFEE is working now      */
#define WAIT_TIME 4     /* number of ticks a process waits in wait queue */

struct timer_struct {
	unsigned long expires;
	void (*fn)(void);
}; /*for now i am not using this but i may use it in future*/


/*
 * The "data" field is in case you want to use the same
 * timeout function for several timeouts. You can use this
 * to distinguish between the different invocations.
 */
struct timer_list {
	struct timer_list *next;
	struct timer_list *prev;
	unsigned long expires;
	unsigned long data;
	void (*function)(unsigned long);
};


/************************FUNCTIONS PROTOTYPES ARE HERE*************************/
void initialize_timers();
void init_timer(struct timer_list * timer);
void process_waittimeout (unsigned long data);
//void add_timer(struct timer_list * timer);
void del_timer(struct timer_list *);
void add_timer(struct timer_list *);
void update_process_times(); 
void get_expired_timer();

/************************FUNCTION PROTOTYPES ENDS HERE*************************/
 

/* This is going to be the header of all timer list just like  INIT_TASK */

#define INIT_TIMER  \
/* next     */	  { &head_timer, \
/* prev     */      &head_timer, \
/* expires  */      0x7D0,   \
/* data     */    (unsigned long) &head_timer, \
/* function */    process_waittimeout  \
  }


  

  
