 /*--------------------------------------------------------------------------*/
/*                CUP-OS  Assembly-Interface routines                       */
/*              ---------------------------------------                     */
/*
 *  /arch/coffee/kernel/unistd.h
 *
 *  Author :	Nuguru Susheel Raj
 *  Email  :	susheel.nuguru@tut.fi	
 */

/* These is the very crucial point of OS please dont change anything unless *
 * you are very sure what are doing and what all things get affected by     *
 * even changing one location */


/*
 * Here resides the system-call numbers...U found them :-)
 */
#define __NR_setup		  0/* used only by init, to get system going */
#define __NR_exit		  1
#define __NR_vfork		  2
#define __NR_read		  3
#define __NR_write		  4
#define __NR_open		  5
#define __NR_close		  6
#define __NR_waitpid		  7
#define __NR_creat		  8
#define __NR_link		  9
#define __NR_unlink		 10
#define __NR_execve		 11
#define __NR_chdir		 12
#define __NR_time		 13
#define __NR_mknod		 14
#define __NR_chmod		 15
#define __NR_chown		 16
#define __NR_break		 17
#define __NR_oldstat		 18
#define __NR_lseek		 19
#define __NR_getpid		 20
#define __NR_mount		 21
#define __NR_umount		 22
#define __NR_setuid		 23
#define __NR_getuid		 24
#define __NR_stime		 25
#define __NR_ptrace		 26
#define __NR_alarm		 27
#define __NR_oldfstat		 28
#define __NR_pause		 29
#define __NR_utime		 30
#define __NR_stty		 31
#define __NR_gtty		 32
#define __NR_access		 33
#define __NR_nice		 34
#define __NR_ftime		 35
#define __NR_sync		 36
#define __NR_kill		 37
#define __NR_rename		 38
#define __NR_mkdir		 39
#define __NR_rmdir		 40
#define __NR_dup		 41
#define __NR_pipe		 42
#define __NR_times		 43
#define __NR_prof		 44
#define __NR_brk		 45
#define __NR_setgid		 46
#define __NR_getgid		 47
#define __NR_signal		 48
#define __NR_geteuid		 49
#define __NR_getegid		 50
#define __NR_acct		 51
#define __NR_phys		 52
#define __NR_lock		 53
#define __NR_ioctl		 54
#define __NR_fcntl		 55
#define __NR_mpx		 56
#define __NR_setpgid		 57
#define __NR_ulimit		 58
#define __NR_oldolduname	 59
#define __NR_umask		 60
#define __NR_chroot		 61
#define __NR_ustat		 62
#define __NR_dup2		 63
#define __NR_getppid		 64
#define __NR_getpgrp		 65
#define __NR_setsid		 66
#define __NR_sigaction		 67
#define __NR_sgetmask		 68
#define __NR_ssetmask		 69
#define __NR_setreuid		 70
#define __NR_setregid		 71
#define __NR_sigsuspend		 72
#define __NR_sigpending		 73
#define __NR_sethostname	 74
#define __NR_setrlimit		 75
#define __NR_getrlimit		 76
#define __NR_getrusage		 77
#define __NR_gettimeofday	 78
#define __NR_settimeofday	 79
#define __NR_getgroups		 80
#define __NR_setgroups		 81
#define __NR_select		 82
#define __NR_symlink		 83
#define __NR_oldlstat		 84
#define __NR_readlink		 85
#define __NR_uselib		 86
#define __NR_swapon		 87
#define __NR_reboot		 88
#define __NR_readdir		 89
#define __NR_mmap		 90
#define __NR_munmap		 91
#define __NR_truncate		 92
#define __NR_ftruncate		 93
#define __NR_fchmod		 94
#define __NR_fchown		 95
#define __NR_getpriority	 96
#define __NR_setpriority	 97
#define __NR_profil		 98
#define __NR_statfs		 99
#define __NR_fstatfs		100
#define __NR_ioperm		101
#define __NR_socketcall		102
#define __NR_syslog		103
#define __NR_setitimer		104
#define __NR_getitimer		105
#define __NR_stat		106
#define __NR_lstat		107
#define __NR_fstat		108
#define __NR_olduname		109
#define __NR_iopl		110
#define __NR_vhangup		111
#define __NR_idle		112
#define __NR_vm86		113
#define __NR_wait4		114
#define __NR_swapoff		115
#define __NR_sysinfo		116
#define __NR_ipc		117
#define __NR_fsync		118
#define __NR_sigreturn		119
#define __NR_clone		120
#define __NR_setdomainname	121
#define __NR_uname		122
#define __NR_modify_ldt		123
#define __NR_adjtimex		124
#define __NR_mprotect		125
#define __NR_sigprocmask	126
#define __NR_create_module	127
#define __NR_init_module	128
#define __NR_delete_module	129
#define __NR_get_kernel_syms	130
#define __NR_quotactl		131
#define __NR_getpgid		132
#define __NR_fchdir		133
#define __NR_bdflush		134
#define __NR_sysfs		135
#define __NR_personality	136
#define __NR_afs_syscall	137 /* Syscall for Andrew File System */
#define __NR_setfsuid		138
#define __NR_setfsgid		139
#define __NR__llseek		140
#define __NR_getdents		141
#define __NR__newselect		142
#define __NR_flock		143
#define __NR_msync		144
#define __NR_readv		145
#define __NR_writev		146
#define __NR_getsid		147
#define __NR_fdatasync		148
#define __NR__sysctl		149
#define __NR_mlock		150
#define __NR_munlock		151
#define __NR_mlockall		152
#define __NR_munlockall		153
#define __NR_sched_setparam		154
#define __NR_sched_getparam		155
#define __NR_sched_setscheduler		156
#define __NR_sched_getscheduler		157
#define __NR_sched_yield		158
#define __NR_sched_get_priority_max	159
#define __NR_sched_get_priority_min	160
#define __NR_sched_rr_get_interval	161
#define __NR_nanosleep		162
#define __NR_mremap		163
#define __NR_poll		168
#define __NR_dummy_idle_brain   169
#define __NR_malloc             170
#define __NR_free               171
#define __NR_getpmsg		188
#define __NR_putpmsg		189

int errno;   // Using it to store error number if anything goes wrong
long res; 

/* System call number is in Register-5 of set-2 becareful of its use */
/* compiler optimiszing sys_no .. its keeps the required sysno in r0, so we can use it */
/*
#define _syscall0(type,name) \
type name(void) \
{ \
long sys_no = __NR_##name;   \
asm("ldra r16,sys_no\n\t"    \
"ld r5,r16,0\n\t" \
"push r31\n\t" \
"scall\n\t"    \
"nop\n\t"      \
"pop r31\n\t"  \
"ldra r16,res\n\t"   \
"st r0,r16,0\n\t");    \
if (res >= 0) \
return (type) res; \
errno = -res; \
return -1; \
}*/


#define _syscall0(type,name) \
type name(void) \
{ \
long sys_no = __NR_##name;   \
asm("mov r5,r0\n\t"    \
"push r31\n\t" \
"scall\n\t"    \
"nop\n\t"      \
"pop r31\n\t"  \
"ldra r16,res\n\t"   \
"st r0,r16,0\n\t");    \
if (res >= 0) \
return (type) res; \
errno = -res; \
return -1; \
}


#define _syscall1(type,name,type1,arg1) \
type name(type1 arg1) \
{ \
long sys_no = __NR_##name;  \
asm("mov r5,r0\n\t"    \
"push r31\n\t" \
"scall\n\t"           \
"nop\n\t"             \
"pop r31\n\t"  \
"ldra r16,res\n\t"  \
"st r0,r16,0\n\t");   \
if (res >= 0)       \
return (type) res; \
errno = -res; \
return (type) -1; \
}

#define _syscall2(type,name,type1,arg1,type2,arg2) \
type name(type1 arg1,type2 arg2) \
{ \
long sys_no = __NR_##name;  \
asm("mov r5,r0\n\t"    \
"push r31\n\t" \
"scall\n\t"    \
"nop\n\t"      \
"pop r31\n\t"  \
"ldra r16,res\n\t"   \
"st r0,r16,0\n\t");    \
if (res >= 0) \
return (type) res; \
errno = -res; \
return -1; \
}


#define _syscall3(type,name,type1,arg1,type2,arg2,type3,arg3) \
type name(type1 arg1,type2 arg2,type3 arg3) \
{ \
long sys_no = __NR_##name;  \
asm("mov r5,r0\n\t"    \
"push r31\n\t" \
"scall\n\t"    \
"nop\n\t"      \
"pop r31\n\t"  \
"ldra r16,res\n\t"   \
"st r0,r16,0\n\t");    \
if (res >= 0) \
return (type) res; \
errno = -res; \
return -1; \
}


#define _syscall4(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4) \
type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4) \
{ \
long sys_no = __NR_##name;  \
asm("mov r5,r0\n\t"    \
"push r31\n\t" \
"scall\n\t"    \
"nop\n\t"      \
"pop r31\n\t"  \
"ldra r16,res\n\t"   \
"st r0,r16,0\n\t");    \
if (res >= 0) \
return (type) res; \
errno = -res; \
return -1; \
}


/******************************coffee.h****************************/

typedef int pid_t;

static inline _syscall0(int,pause);//sched.c
static inline _syscall0(int,getpid);//sched.c
static inline _syscall0(int,getppid);//sched.c
//static inline _syscall0(int,getpuid);//sched.c
static inline _syscall0(int,geteuid);//sched.c
static inline _syscall0(int,getgid);//sched.c
static inline _syscall0(int,sched_yield);//sched.c
static inline _syscall0(int,dummy_idle_brain);//sched.c

static inline _syscall0(int,idle);
static inline _syscall0(int,vfork);
static inline _syscall0(int,setup);
static inline _syscall0(int,sync);



static inline _syscall1(int,sched_getscheduler,pid_t,pid);//sched.c
static inline _syscall1(int,sched_get_priority_max,int,policy);//sched.c
static inline _syscall1(int,sched_get_priority_min,int,policy);//sched.c
static inline _syscall1(int,nice,int,increment);//sched.c
static inline _syscall1(int,close,int,fd);
static inline _syscall1(int,dup,int,fd);

//malloc and free are not sys calls in linux but here they are

//uncomment the below two statements

static inline _syscall1(int *,malloc,int,size);//malloc.c
static inline _syscall1(int,free,void *,where);//malloc.c

static inline _syscall2(int,sched_setparam,pid_t,pid,int,sched_priority);//sched.c
static inline _syscall2(int,clone,unsigned long,flags,char *,esp);
static inline _syscall2(int,getpriority,int,which,int,who)//sys.c

     static inline _syscall3(int,sched_setscheduler,pid_t,pid,int,policy,int,sched_priority);//sched.c
static inline _syscall3(int,open,const char *,file,int,flag,int,mode);
static inline _syscall3(int,execve,const char *,file,char **,argv,char **,envp);
static inline _syscall3(int,setpriority,int,which,int,who,int,niceval);//sys.c
static inline _syscall3(long,reboot,int,magic1,int,magic2,unsigned int,cmd);//sys.c


/************************signal.h*****************************/

/*                    QPUX-Kernel Signals Header File                       */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/



#define _NSIG             32
#define NSIG		_NSIG

#define SIGHUP		 1
#define SIGINT		 2
#define SIGQUIT		 3
#define SIGILL		 4
#define SIGTRAP		 5
#define SIGABRT		 6
#define SIGIOT		 6
#define SIGBUS		 7
#define SIGFPE		 8
#define SIGKILL		 9
#define SIGUSR1		10
#define SIGSEGV		11
#define SIGUSR2		12
#define SIGPIPE		13
#define SIGALRM		14
#define SIGTERM		15
#define SIGSTKFLT	16
#define SIGCHLD		17
#define SIGCONT		18
#define SIGSTOP		19
#define SIGTSTP		20
#define SIGTTIN		21
#define SIGTTOU		22
#define SIGURG		23
#define SIGXCPU		24
#define SIGXFSZ		25
#define SIGVTALRM	26
#define SIGPROF		27
#define SIGWINCH	28
#define SIGIO		29
#define SIGPOLL		SIGIO
/*
#define SIGLOST		29
*/
#define SIGPWR		30
#define	SIGUNUSED	31



/*
 * These values of sa_flags are used only by the kernel as part of the
 * irq handling routines.
 *
 * SA_INTERRUPT is also used by the irq handling routines.
 */
#define SA_PROBE SA_ONESHOT
#define SA_SAMPLE_RANDOM SA_RESTART



#define SIG_BLOCK          0	/* for blocking signals */
#define SIG_UNBLOCK        1	/* for unblocking signals */
#define SIG_SETMASK        2	/* for setting the signal mask */


typedef long sigset_t;		/* at least 32 bits */

/* Type of a signal handler.  */
typedef void (*__sighandler_t)(int);

#define SIG_DFL	((__sighandler_t)0)	/* default signal handling */
#define SIG_IGN	((__sighandler_t)1)	/* ignore signal */
#define SIG_ERR	((__sighandler_t)-1)	/* error return from signal */

struct sigaction {
	__sighandler_t sa_handler;
	sigset_t sa_mask;
	unsigned long sa_flags;
	void (*sa_restorer)(void);
};

#define INIT_SIGNALS { \
		1, \
		{ {0,}, } }

struct signal_struct {
	int count;
	struct sigaction action[NSIG];
};


/***********************sched.h*******************************/

/*                    QPUX-Kernel Schedulingg Header File                   */
/*              -------------------------------------------                 */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

#define MAX_MEMORY_SLOTS 4

#define HZ 50000000     /* frequency at which COFFEE is working now      */
#define DEF_PRIORITY	(20*HZ/100)	/* 200 ms time slices */
#define NR_TASKS     10     /*total number of tasks allowed including from INIT */

/* different states a task can have*/
#define TASK_RUNNING		0
#define TASK_INTERRUPTIBLE	1
#define TASK_UNINTERRUPTIBLE	2
#define TASK_WAITING		3
#define TASK_STOPPED		4
#define TASK_SWAPPING		5

/*
 * Scheduling policies
 */
#define SCHED_OTHER		0
#define SCHED_FIFO		1
#define SCHED_RR		2

/*
 * Limit the stack by to some sane default: root can always
 * increase this limit if needed..  8MB seems reasonable.
 */
#define _STK_LIM	(8*1024*1024)
#define INIT_RT_PRIORITY 15


/*
 * Per process flags
 */
#define PF_ALIGNWARN	0x00000001	/* Print alignment warning msgs */
					/* Not implemented yet, only for 486*/
#define PF_PTRACED	0x00000010	/* set if ptrace (0) has been called. */
#define PF_TRACESYS	0x00000020	/* tracing system calls */
#define PF_FORKNOEXEC	0x00000040	/* forked but didn't exec */
#define PF_SUPERPRIV	0x00000100	/* used super-user privileges */
#define PF_DUMPCORE	0x00000200	/* dumped core */
#define PF_SIGNALED	0x00000400	/* killed by a signal */

#define PF_STARTING	0x00000002	/* being created */
#define PF_EXITING	0x00000004	/* getting shut down */ 

#define PF_USEDFPU	0x00100000	/* Process used the FPU this quantum (SMP only) */

struct sched_param {
	int sched_priority; 
};

//typedef int pid_t;


#define QUANTUM 100        //runtime quantum for a process

extern unsigned long volatile jiffies;
extern struct task_struct init_task;
extern struct signal_struct init_signals;
extern struct pt_regs init_ptregs;
extern struct task_struct * current;
extern struct mm_struct mm0;


/* -------------------------------------------------------*/
/*           Included from timer.h file to here           */
/* -------------------------------------------------------*/

#define HZ 50000000     /* frequency at which COFFEE is working now      */
#define WAIT_TIME 4     /* number of ticks a process waits in wait queue */

struct timer_struct {
	unsigned long expires;
	void (*fn)(void);
}; /*for now i am not using this but i may use it in future*/


/*
 * The "data" field is in case you want to use the same
 * timeout function for several timeouts. You can use this
 * to distinguish between the different invocations.
 */
struct timer_list {
	struct timer_list *next;
	struct timer_list *prev;
	unsigned long expires;
	unsigned long data;
	void (*function)(unsigned long);
};


/************************FUNCTIONS PROTOTYPES ARE HERE*************************/
void initialize_timers();
void init_timer(struct timer_list * timer);
void process_waittimeout (unsigned long data);
//void add_timer(struct timer_list * timer);
int del_timer(struct timer_list *);
void add_timer(struct timer_list *);
void update_process_times(); 
void get_expired_timer();

/************************FUNCTION PROTOTYPES ENDS HERE*************************/
 

/* This is going to be the header of all timer list just like  INIT_TASK */

#define INIT_TIMER  \
/* next     */	  { &head_timer, \
/* prev     */      &head_timer, \
/* expires  */      0x7D0,   \
/* data     */    (unsigned long) &head_timer, \
/* function */    process_waittimeout  \
  }
/*------------DONE WITH timer.h----------------------*/

/*
 * This struct defines the way the registers are stored on the stack during *
 * a system call/exception. I am saving all registers no compromise, bcos i *
 * am a bad GUY :-).  */

/* change anything here then also change in entry.c */

struct pt_regs { 
	/*
	 * saved current process registers
	 */
	long	 reg0,  reg1,  reg2,  reg3,  reg4,  reg5,  reg6,  reg7;
	long	 reg8,  reg9, reg10, reg11, reg12, reg13, reg14, reg15;
	long	reg16, reg17, reg18, reg19, reg20, reg21, reg22, reg23;
        long	reg24, reg25, reg26, reg27, reg28, reg29, reg30, reg31;

	/*
	 * Saved special registers
	 */
	long	spsr;
        long    LR;
  long  conditional_regs;
  long  su_reg0; // for saving system call return values
};


struct mm_pointers {
  long start;
  long end;
};

/************************FUNCTIONS PROTOTYPES ARE HERE************************/
void Print_Runqueue( );
struct task_struct * ScheduleTaskStruct();
void schedule(void);

void add_to_runqueue(struct task_struct * );
void add_to_waitqueue(struct task_struct *);
inline void del_from_runqueue(struct task_struct *);
inline void wake_up_process(struct task_struct * p);
inline void move_last_runqueue(struct task_struct * p);
inline int goodness(struct task_struct * p, struct task_struct * prev);
/************************FUNCTION PROTOTYPES ENDS HERE************************/

/* changing order for these might result in system crash.. change at ur own *
 * risk and if u know the consequences. If u wanna add something,add at the*
 * end  of structure */

extern struct task_struct task1;
extern struct task_struct task2;
extern struct task_struct task3;
extern struct task_struct task4;


#define INIT_TASK \
/* state    */	  { TASK_RUNNING, \
/* Pid      */      0, \
/* priority */      10, \
/* prev_task*/      &init_task, \
/* next_task*/	    &init_task, \
/* prev_run */	    &task4, \
/* next_run */	    &task1, \
/* counter  */      DEF_PRIORITY,  \
/* timeout  */      0,  \
/* pt_regs  */      &init_ptregs,  \
/* mm_struct*/      &mm0,  \
/* proc links*/     &init_task,&init_task,NULL,NULL,NULL,NULL, \
/* policy    */     SCHED_OTHER,INIT_RT_PRIORITY,  \
/* exit_code,..*/   0,0,0,    \
/* signals */       0}


struct task_struct{
        int state;
        int pid;
	int priority;
        struct task_struct *prev_task,*next_task;
        struct task_struct *prev_run, *next_run;
        long counter;
        unsigned long timeout;
        struct pt_regs *regs;
        struct mm_struct *mm;
	struct task_struct *p_opptr, *p_pptr, *p_cptr, *p_ysptr, *p_osptr;
	struct wait_queue *wait_chldexit;	/* for wait4() */
        unsigned long policy,rt_priority;
	int exit_code, exit_signal;
	unsigned long signal;
/* signal handlers */ 
	struct signal_struct *sig;
        struct timer_list timer;
        int syscall_called_timer; //  If equals to 2000 then delete this task
                                   //  from runqueue
};

  
struct mm_struct {
        unsigned long start_code,end_code;
        unsigned long start_data, end_data,start_kernel_stack;//,kernel_sp;
	unsigned long task_sp,task_fp,end_stack;
	unsigned long def_flags;
        unsigned int memory_slot;
        unsigned int task_stack_size;
};

#define INIT_MM { \
		1, \
		((unsigned long)&init_thread()), 0, 0, 0, \
		0, 0, 0, 0, \
		0, 0, 0, 0, \
        	0, 0}


#ifndef NULL
#define NULL ((void *) 0)
#endif

#define for_each_task(p) \
	for (p = &init_task ; (p = p->next_run) != &init_task ; )

/*****************************errorno.h******************************/

/*               CUP-OS  Error Numbers Header File                          */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/



#define	EPERM		 1	/* Operation not permitted */
#define	ENOENT		 2	/* No such file or directory */
#define	ESRCH		 3	/* No such process */
#define	EINTR		 4	/* Interrupted system call */
#define	EIO		 5	/* I/O error */
#define	ENXIO		 7	/* No such device or address */
                                /* odd value for sys_malloc */
#define	E2BIG		 6	/* Arg list too long */
#define	ENOEXEC		 8	/* Exec format error */
#define	EBADF		 9	/* Bad file number */
#define	ECHILD		10	/* No child processes */
#define	EAGAIN		11	/* Try again */
#define	ENOMEM		13	/* Out of memory .. odd value for sys_malloc*/
#define	EACCES		12	/* Permission denied */
#define	EFAULT		14	/* Bad address */
#define	ENOTBLK		15	/* Block device required */
#define	EBUSY		16	/* Device or resource busy */
#define	EEXIST		17	/* File exists */
#define	EXDEV		18	/* Cross-device link */
#define	ENODEV		19	/* No such device */
#define	ENOTDIR		20	/* Not a directory */
#define	EISDIR		21	/* Is a directory */
#define	EINVAL		22	/* Invalid argument */
#define	ENFILE		23	/* File table overflow */
#define	EMFILE		24	/* Too many open files */
#define	ENOTTY		25	/* Not a typewriter */
#define	ETXTBSY		26	/* Text file busy */
#define	EFBIG		27	/* File too large */
#define	ENOSPC		28	/* No space left on device */
#define	ESPIPE		29	/* Illegal seek */
#define	EROFS		30	/* Read-only file system */
#define	EMLINK		31	/* Too many links */
#define	EPIPE		32	/* Broken pipe */
#define	EDOM		33	/* Math argument out of domain of func */
#define	ERANGE		34	/* Math result not representable */
#define	EDEADLK		35	/* Resource deadlock would occur */
#define	ENAMETOOLONG	36	/* File name too long */
#define	ENOLCK		37	/* No record locks available */
#define	ENOSYS		38	/* Function not implemented */
#define	ENOTEMPTY	39	/* Directory not empty */
#define	ELOOP		40	/* Too many symbolic links encountered */
#define	EWOULDBLOCK	EAGAIN	/* Operation would block */
#define	ENOMSG		42	/* No message of desired type */
#define	EIDRM		43	/* Identifier removed */
#define	ECHRNG		44	/* Channel number out of range */
#define	EL2NSYNC	45	/* Level 2 not synchronized */
#define	EL3HLT		46	/* Level 3 halted */
#define	EL3RST		47	/* Level 3 reset */
#define	ELNRNG		48	/* Link number out of range */
#define	EUNATCH		49	/* Protocol driver not attached */
#define	ENOCSI		50	/* No CSI structure available */
#define	EL2HLT		51	/* Level 2 halted */
#define	EBADE		52	/* Invalid exchange */
#define	EBADR		53	/* Invalid request descriptor */
#define	EXFULL		54	/* Exchange full */
#define	ENOANO		55	/* No anode */
#define	EBADRQC		56	/* Invalid request code */
#define	EBADSLT		57	/* Invalid slot */
#define	EDEADLOCK	58	/* File locking deadlock error */
#define	EBFONT		59	/* Bad font file format */
#define	ENOSTR		60	/* Device not a stream */
#define	ENODATA		61	/* No data available */
#define	ETIME		62	/* Timer expired */
#define	ENOSR		63	/* Out of streams resources */
#define	ENONET		64	/* Machine is not on the network */
#define	ENOPKG		65	/* Package not installed */
#define	EREMOTE		66	/* Object is remote */
#define	ENOLINK		67	/* Link has been severed */
#define	EADV		68	/* Advertise error */
#define	ESRMNT		69	/* Srmount error */
#define	ECOMM		70	/* Communication error on send */
#define	EPROTO		71	/* Protocol error */
#define	EMULTIHOP	72	/* Multihop attempted */
#define	EDOTDOT		73	/* RFS specific error */
#define	EBADMSG		74	/* Not a data message */
#define	EOVERFLOW	75	/* Value too large for defined data type */
#define	ENOTUNIQ	76	/* Name not unique on network */
#define	EBADFD		77	/* File descriptor in bad state */
#define	EREMCHG		78	/* Remote address changed */
#define	ELIBACC		79	/* Can not access a needed shared library */
#define	ELIBBAD		80	/* Accessing a corrupted shared library */
#define	ELIBSCN		81	/* .lib section in a.out corrupted */
#define	ELIBMAX		82	/* Attempting to link in too many shared libraries */
#define	ELIBEXEC	83	/* Cannot exec a shared library directly */
#define	EILSEQ		84	/* Illegal byte sequence */
#define	ERESTART	85	/* Interrupted system call should be restarted */
#define	ESTRPIPE	86	/* Streams pipe error */
#define	EUSERS		87	/* Too many users */
#define	ENOTSOCK	88	/* Socket operation on non-socket */
#define	EDESTADDRREQ	89	/* Destination address required */
#define	EMSGSIZE	90	/* Message too long */
#define	EPROTOTYPE	91	/* Protocol wrong type for socket */
#define	ENOPROTOOPT	92	/* Protocol not available */
#define	EPROTONOSUPPORT	93	/* Protocol not supported */
#define	ESOCKTNOSUPPORT	94	/* Socket type not supported */
#define	EOPNOTSUPP	95	/* Operation not supported on transport endpoint */
#define	EPFNOSUPPORT	96	/* Protocol family not supported */
#define	EAFNOSUPPORT	97	/* Address family not supported by protocol */
#define	EADDRINUSE	98	/* Address already in use */
#define	EADDRNOTAVAIL	99	/* Cannot assign requested address */
#define	ENETDOWN	100	/* Network is down */
#define	ENETUNREACH	101	/* Network is unreachable */
#define	ENETRESET	102	/* Network dropped connection because of reset */
#define	ECONNABORTED	103	/* Software caused connection abort */
#define	ECONNRESET	104	/* Connection reset by peer */
#define	ENOBUFS		105	/* No buffer space available */
#define	EISCONN		106	/* Transport endpoint is already connected */
#define	ENOTCONN	107	/* Transport endpoint is not connected */
#define	ESHUTDOWN	108	/* Cannot send after transport endpoint shutdown */
#define	ETOOMANYREFS	109	/* Too many references: cannot splice */
#define	ETIMEDOUT	110	/* Connection timed out */
#define	ECONNREFUSED	111	/* Connection refused */
#define	EHOSTDOWN	112	/* Host is down */
#define	EHOSTUNREACH	113	/* No route to host */
#define	EALREADY	114	/* Operation already in progress */
#define	EINPROGRESS	115	/* Operation now in progress */
#define	ESTALE		116	/* Stale NFS file handle */
#define	EUCLEAN		117	/* Structure needs cleaning */
#define	ENOTNAM		118	/* Not a XENIX named type file */
#define	ENAVAIL		119	/* No XENIX semaphores available */
#define	EISNAM		120	/* Is a named type file */
#define	EREMOTEIO	121	/* Remote I/O error */
#define	EDQUOT		122	/* Quota exceeded */


/*************************all_macros.h***************************/

/*                CUP-OS Assembly Instruction macros defined here           */
/*              --------------------------------------------------          */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/




#define CCB_END  0xffffffff

/* Important note here is that i am using definitions of variables that *
 * were defined in some other files here. As i intend to club all the files *
 * into one file manually i am not redefining then here. compiling this     *
 * single file will flood u with errors */


//**************************************************************************** 
//* Registers Usage only for SuperUser
//****************************************************************************
asm("FP = r27\n\t"
  "SP   = r28\n\t"
  "PSR  = r29\n\t"   
  "SPSR = r30\n\t"   
  "LR   = r31\n\t");

/*************************************************************************** 
 *      Macros 
 ****************************************************************************/

/* PUSH AND POP MACROS */
/* when pushed increments the stack pointer by 4 bytes and stores Register *
 * contents to it and similarly when poped loads register from stack and   *
 * decrements the stack by 4 bytes...as simple as it looks                 */

__asm__(".macro push(rname)\n\t" 
"addi SP,SP,-4\n\t"  
"st rname,SP,0\n\t"   
".endm\n\t"    

".macro pop(rname)\n\t" 
"ld rname,SP,0\n\t"    
"addi SP,SP,4\n\t"    
".endm\n\t");

/* MACRO TO USE SOURCE REGISTERS FROM TWO DIFFERENT SETS */

/* This is done by copying contents of reg of one set to reg of other set *
 * so that sources are now in one set after macro is done remember that   *
 * default set for READ and WRITE is SET2                                 */

__asm__ (".macro set1_to_set2(set1,set2)\n\t"
		     "chrs 2\n\t"       
		     "mov set2,set1\n\t" 
		     "chrs 3\n\t"        
		     ".endm\n\t");

__asm__ (".macro set2_to_set1(set2,set1)\n\t"
		     "chrs 1\n\t"       
		     "mov set1,set2\n\t" 
		     "chrs 3\n\t"       
		     ".endm\n\t");
/* get the address of Current task_struct into specified reg*/

__asm__ (".macro get_current(reg)\n\t"
	 "push r16\n\t"
	 "ldra r16,current\n\t"
	 "ld   reg,r16,0\n\t"
	 "pop  r16\n\t"
	 ".endm\n\t");

/* Load variable in the specified register */
__asm__ (".macro load_variable(variable,reg)\n\t"
         "ldra reg,variable\n\t"
         "ld reg,reg,0\n\t"
	 ".endm\n\t");

/* macro for siabling and enabling interrupts */
__asm__(".macro disable_interrupts\n\t"
	"di\n\t"
	"nop\n\t"
	".endm\n\t"	);
__asm__(".macro enable_interrupts\n\t"
	"ei\n\t"
	"nop\n\t"
	".endm\n\t"	);

/* These macros are used to block interrupts and restore them using      *
 * The INT_MASK register in CCB . Using this macros has an advantage     *
 * of restoring interrupts to their states that were before blocking them */
__asm__(".macro block_interrupts(variable)\n\t"
	"lli  r10,CCB_BASE_REMAPPED_LO\n\t" 
	"lui  r10,CCB_BASE_REMAPPED_HI\n\t"
	"ld   r11,r10,INT_MASK_OFFSET\n\t"
	"ldra r10,variable\n\t"
	"st   r11,r10,0\n\t"
	"di   \n\t"
	"nop  \n\t"
	".endm\n\t");

__asm__(".macro restore_interrupts(variable)\n\t"
	"ldra r10,variable\n\t"
	"ld   r11,r10,0\n\t"
	"lli  r10,CCB_BASE_REMAPPED_LO\n\t" 
	"lui  r10,CCB_BASE_REMAPPED_HI\n\t"
	"st   r11,r10,INT_MASK_OFFSET\n\t"
	"nop  \n\t"
	".endm\n\t");

/***************************entry.h***************************/

/*                CUP-OS All Defines for saving registers                   */
/*              ------------------------------------------                  */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


/*
 * entry.h and entry.c contains the system-call and fault low-level handling routines. This also contains the timer-interrupt handler, as well as all interrupts * and faults that can result in a task-switch.
 *
 * NOTE: This code handles signal-recognition, which happens every time
 * after a timer-interrupt and after each system call.*/


#define NR_syscalls 180
#define count_exception 11  // Number of exceptions to date in coffee
#define KERNEL_STACK_POINTER 0x10000000

long NR_systemcall = NR_syscalls;  //for assembler

long KERNEL_FP = KERNEL_STACK_POINTER;
long KERNEL_SP = KERNEL_STACK_POINTER;

//  These are offsets into task_struct

asm("state = 0\n\t"
"Pid       = 4\n\t"
"priority  = 8\n\t"
"prev_task = 12\n\t"
"next_task = 16\n\t"
"prev_run  = 20\n\t"
"next_run  = 24\n\t"
"counter   = 28\n\t"
"timeout   = 32\n\t"
"pt_regs   = 36\n\t"
"mm_struct = 40\n\t");






//________________________________________________________________________//

/* saves all set2 registers on the stack except PSR bcos u cant write back *
 * to it when u try to restore :-(        bad bad bad register             */

#define SAVE_ALL \
asm("chrs 3\n\t"  \
"push r0\n\t"  \
"push r1\n\t"  \
"push r2\n\t"  \
"push r3\n\t"  \
"push r4\n\t"  \
"push r5\n\t"  \
"push r6\n\t"  \
"push r7\n\t"  \
"push r8\n\t"  \
"push r9\n\t"  \
"push r10\n\t" \
"push r11\n\t" \
"push r12\n\t" \
"push r13\n\t"  \
"push r14\n\t"  \
"push r15\n\t"  \
"push r16\n\t"  \
"push r17\n\t"  \
"push r18\n\t"  \
"push r19\n\t"  \
"push r20\n\t"  \
"push r21\n\t"  \
"push r22\n\t"  \
"push r23\n\t"  \
"push r24\n\t"  \
"push r25\n\t"  \
"push r26\n\t"  \
"push r27\n\t"  \
"push r28\n\t"  \
"push SPSR\n\t" \
"push LR\n\t"   \
"scon r0\n\t"   \
"push r0\n\t");


#define RESTORE_ALL  \
asm("pop r0\n\t"   \
"rcon r0\n\t"  \
"pop LR\n\t"   \
"pop SPSR\n\t" \
"pop r28\n\t"  \
"pop r27\n\t"  \
"pop r26\n\t"  \
"pop r25\n\t"  \
"pop r24\n\t"  \
"pop r23\n\t"  \
"pop r22\n\t"  \
"pop r21\n\t"  \
"pop r20\n\t"  \
"pop r19\n\t"  \
"pop r18\n\t"  \
"pop r17\n\t"  \
"pop r16\n\t"  \
"pop r15\n\t"  \
"pop r14\n\t"  \
"pop r13\n\t"  \
"pop r12\n\t"  \
"pop r11\n\t"  \
"pop r10\n\t"  \
"pop r9\n\t"   \
"pop r8\n\t"   \
"pop r7\n\t"   \
"pop r6\n\t"   \
"pop r5\n\t"   \
"pop r4\n\t"   \
"pop r3\n\t"   \
"pop r2\n\t"   \
"pop r1\n\t"   \
"pop r0\n\t");


/*\/* saves and restores SPSR ,PR31 *\/ i no more need it

#define SAVE_SPSR_PR31     \
asm("chrs 3\n\t"  \
"get_current r16\n\t"       \
"ld r17,r16,pt_regs\n\t"     \
"st SPSR,r17,128\n\t"        \
"st LR,r17,132\n\t");

#define RESTORE_SPSR_PR31     \
asm("chrs 3\n\t"  \
"get_current r16\n\t"       \
"ld r17,r16,pt_regs\n\t"     \
"ld SPSR,r17,128\n\t"        \
"ld LR,r17,132\n\t");   */

#define SAVE_STACK_POINTER   \
asm("ldra r16,current\n\t"     \
"ld  r16,r16,0\n\t"       \
"ld r17,r16,mm_struct\n\t"   \
"push r18\n\t"  \
"push r19\n\t"  \
"chrs 2\n\t"    \
"mov r18,FP\n\t"   \
"mov r19,SP\n\t"   \
"chrs 3\n\t"   \
"st r19,r17,20\n\t"           \
"st r18,r17,24\n\t"           \
"ldra r17,KERNEL_FP\n\t"   \
"ld FP,r17,0\n\t"           \
"ldra r17,KERNEL_SP\n\t"   \
"ld SP,r17,0\n\t");

#define RESTORE_STACK_POINTER \
asm("ldra r17,KERNEL_FP\n\t"  \
"st FP,r17,0\n\t"       \
"ldra r17,KERNEL_SP\n\t"  \
"st SP,r17,0\n\t"       \
"ldra r16,current\n\t"     \
"ld  r16,r16,0\n\t"       \
"ld r17,r16,mm_struct\n\t"   \
"chrs 1\n\t"                 \
"ld SP,r17,20\n\t"           \
"ld FP,r17,24\n\t"           \
"chrs 3\n\t");

#define MOVE_INCOMING_ARGUMENTS  \
asm("chrs 2\n\t"        \
"mov r0,r0\n\t"         \
"mov r1,r1\n\t"         \
"mov r2,r2\n\t"         \
"mov r3,r3\n\t"         \
"mov r4,r4\n\t"         \
"mov r5,r5\n\t"         \
"chrs 3\n\t");


/*  Trying to get the address of current "pt_regs" and store all user regs   *
 *  into it . It might be useful for task to know its register contents      *
 

/* While this macro is running interrupts cannot occur */

#define SAVE_USR_PT_REGS  \
asm("ldra r0,current\n\t"  \
"ld   r1,r0,0\n\t"     \
"addiu r1,r1,pt_regs\n\t"   \
"ld r1,r1,0\n\t"      	\
"push r2\n\t"		\
"chrs 2 \n\t"		\
"mov r2,r1\n\t"     	\
"chrs 3 \n\t"		\
"st r2,r1,4\n\t" 	\
"pop r2\n\t"		\
"chrs 1\n\t"            \
"mov r1,r1\n\t"     	\
"chrs 0\n\t"	   \
"st r0,r1,0\n\t"   \
"st r2,r1,8\n\t"  \
"st r3,r1,12\n\t"  \
"st r4,r1,16\n\t"  \
"st r5,r1,20\n\t"  \
"st r6,r1,24\n\t"  \
"st r7,r1,28\n\t"  \
"st r8,r1,32\n\t"  \
"st r9,r1,36\n\t"  \
"st r10,r1,40\n\t"  \
"st r11,r1,44\n\t"  \
"st r12,r1,48\n\t"   \
"st r13,r1,52\n\t"   \
"st r14,r1,56\n\t"   \
"st r15,r1,60\n\t"   \
"st r16,r1,64\n\t"   \
"st r17,r1,68\n\t"   \
"st r18,r1,72\n\t"   \
"st r19,r1,76\n\t"   \
"st r20,r1,80\n\t"   \
"st r21,r1,84\n\t"   \
"st r22,r1,88\n\t"   \
"st r23,r1,92\n\t"   \
"st r24,r1,96\n\t"   \
"st r25,r1,100\n\t"  \
"st r26,r1,104\n\t"  \
"st r27,r1,108\n\t"  \
"st r28,r1,112\n\t"  \
"st r29,r1,116\n\t"  \
"st r30,r1,120\n\t"  \
"st r31,r1,124\n\t"  \
"chrs 3\n\t"        \
"st r30,r1,128\n\t"     \
"st r31,r1,132\n\t"     \
"scon r16\n\t"        \
"st r16,r1,136\n\t");


//set2 are super user registers and set1 are user registers 
/* While this macro is running interrupts cannot occur */

 
#define RESTORE_USR_PT_REGS  \
asm("ldra r16,current\n\t"     \
"ld  r1,r16,0\n\t"       \
"addiu r1,r1,pt_regs\n\t"   \
"ld r1,r1,0\n\t"    \
"chrs 1\n\t"        \
"mov r1,r1\n\t"     \
"chrs 0\n\t"        \
"ld r0,r1,0\n\t"    \
"ld r2,r1,8\n\t"  \
"ld r3,r1,12\n\t"  \
"ld r4,r1,16\n\t"  \
"ld r5,r1,20\n\t"  \
"ld r6,r1,24\n\t"  \
"ld r7,r1,28\n\t"  \
"ld r8,r1,32\n\t"  \
"ld r9,r1,36\n\t"  \
"ld r10,r1,40\n\t"  \
"ld r11,r1,44\n\t"  \
"ld r12,r1,48\n\t"  \
"ld r13,r1,52\n\t"  \
"ld r14,r1,56\n\t"  \
"ld r15,r1,60\n\t"  \
"ld r16,r1,64\n\t"  \
"ld r17,r1,68\n\t"  \
"ld r18,r1,72\n\t"  \
"ld r19,r1,76\n\t"  \
"ld r20,r1,80\n\t"  \
"ld r21,r1,84\n\t"  \
"ld r22,r1,88\n\t"  \
"ld r23,r1,92\n\t"  \
"ld r24,r1,96\n\t"  \
"ld r25,r1,100\n\t"  \
"ld r26,r1,104\n\t"  \
"ld r27,r1,108\n\t"  \
"ld r28,r1,112\n\t"  \
"ld r29,r1,116\n\t"  \
"ld r30,r1,120\n\t"  \
"ld r31,r1,124\n\t"  \
"ld r1,r1,4\n\t"  \
"chrs 3\n\t"	    \
"ld r30,r1,128\n\t"  \
"ld r31,r1,132\n\t"  \
"ld r16,r1,136\n\t"  \
"rcon r16\n\t");

/* Looks bad isnt it.. sorry ..ill try not to do so bad again :-)  */  


/*                   System_Call Table       */
/*                 Adding all entries Here    */
extern long *system_call_table[170];


/***********************sys.h*********************/


/*                    QPUX-Kernel System Header File                        */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


/*
 * Magic values required to use _reboot() system call.
 */

#define	LINUX_REBOOT_MAGIC1	0xfee1dead
#define	LINUX_REBOOT_MAGIC2	672274793
#define	LINUX_REBOOT_MAGIC2A	85072278
#define	LINUX_REBOOT_MAGIC2B	369367448
#define	LINUX_REBOOT_MAGIC2C	537993216


/*
 * Commands accepted by the _reboot() system call.
 *
 * RESTART     Restart system using default command and mode.
 * HALT        Stop OS and give system control to ROM monitor, if any.
 * CAD_ON      Ctrl-Alt-Del sequence causes RESTART command.
 * CAD_OFF     Ctrl-Alt-Del sequence sends SIGINT to init task.
 * POWER_OFF   Stop OS and remove all power from system, if possible.
 * RESTART2    Restart system using given command string.
 * SW_SUSPEND  Suspend system using software suspend if compiled in.
 */

#define	LINUX_REBOOT_CMD_RESTART	0x01234567
#define	LINUX_REBOOT_CMD_HALT		0xCDEF0123
#define	LINUX_REBOOT_CMD_CAD_ON		0x89ABCDEF
#define	LINUX_REBOOT_CMD_CAD_OFF	0x00000000
#define	LINUX_REBOOT_CMD_POWER_OFF	0x4321FEDC
#define	LINUX_REBOOT_CMD_RESTART2	0xA1B2C3D4
#define	LINUX_REBOOT_CMD_SW_SUSPEND	0xD000FCE2


/*
 * Architecture-specific implementations of sys_reboot commands.
 */

extern void machine_reboot();
//extern void machine_halt();
//extern void machine_power_off();



#define	PRIO_MIN	(-20)
#define	PRIO_MAX	20

#define	PRIO_PROCESS	0
#define	PRIO_PGRP	1
#define	PRIO_USER	2

/***********************sys.c**********************/
/*                    QPUX-Kernel Harware Stuff File                        */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/




/* So many cases are taken assuming that they will be implemented in *
 * in near future */


 int proc_sel(struct task_struct *p, int which, int who)
{
	if(p->pid)
	{
		switch (which) {
			case PRIO_PROCESS:
				if (!who && p == current)
					return 1;
				return(p->pid == who);
			case PRIO_PGRP:
			  /*	if (!who)
					who = current->pgrp;
					return(p->pgrp == who);*/
			        break;
			case PRIO_USER:
			  /*if (!who)
					who = current->uid;
					return(p->uid == who);*/
			  break;
		}
	}
	return 0;
} 

int sys_setpriority(int which, int who, int niceval)
{
	struct task_struct *p;
	int error = ESRCH;
	unsigned int priority;

	if (which > 2 || which < 0)
		return -EINVAL;

	/* normalize: avoid signed division (rounding problems) */
	priority = niceval;
	if (niceval < 0)
		priority = -niceval;
	if (priority > 20)
		priority = 20;

		if (!priority)
			priority = 1;

	for_each_task(p) {
		if (!proc_sel(p, which, who))
			continue;

		if (error == ESRCH)
			error = 0;
     //		if (priority > p->priority && !suser())
	   //		error = EACCES;
		else
			p->priority = priority;
	}
	return -error;
}


/*
 * Ugh. To avoid negative return values, "getpriority()" will
 * not return the normal nice-value, but a value that has been
 * offset by 20 (ie it returns 0..40 instead of -20..20)
 */
int sys_getpriority(int which, int who)
{
	struct task_struct *p;
	long max_prio = -ESRCH;

	if (which > 2 || which < 0)
		return -EINVAL;

	for_each_task (p) {
		if (!proc_sel(p, which, who))
			continue;
		if (p->priority > max_prio)
			max_prio = p->priority;
	}

	/* scale the priority from timeslice to 0..40 */
//	if (max_prio > 0)
//		max_prio = (max_prio * 20 + (DEF_PRIORITY>>1)) / DEF_PRIORITY;
	return max_prio;
}

void machine_reboot()
{ 
   asm("push r10\n\t"
       "push r11\n\t"
       "xor  r10,r10,r10\n\t"
       "lli  r10,0xbf00\n\t"
       "lui  r10,0xffff\n\t"
       "lli  r11,0xf7ff\n\t"
       "st   r11,r10,37\n\t"
       "pop r11\n\t"
       "pop r10\n\t"
);
}


long sys_reboot(int magic1, int magic2,unsigned int cmd)
{
        
	if (magic1 != LINUX_REBOOT_MAGIC1 ||
	    magic2 != LINUX_REBOOT_MAGIC2)
		return -EINVAL;

	switch (cmd) {
	case LINUX_REBOOT_CMD_RESTART:
		machine_reboot();
		for(;;)
                {}
		break;

	case LINUX_REBOOT_CMD_CAD_ON:
	  //break;

	case LINUX_REBOOT_CMD_CAD_OFF:
	  //break;

	case LINUX_REBOOT_CMD_HALT:
	  //break;

	case LINUX_REBOOT_CMD_POWER_OFF:
	  //break;

	case LINUX_REBOOT_CMD_RESTART2:
	  //break;

	case LINUX_REBOOT_CMD_SW_SUSPEND:
	  //break;

	default:
		return -EINVAL;
	}
	return 0;
}


/**********************sched.c*******************************/
/*--------------------------------------------------------------------------*/
/*                    CUP-OS  scheduler routines                            */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Modified on       --->                                                  */
/*--------------------------------------------------------------------------*/

struct timer_list head_timer = INIT_TIMER;
extern struct task_struct *current;
extern struct task_struct idle_task;
int nr_running = 4;    //4 task initially in runqueue
unsigned int Global_Pid = 1;
int need_resched = 0; 
unsigned long volatile jiffies=0;
unsigned long int_mask_temp; // for enabling and disbling interrupts
                           // other than that used in interrupts and exceptions
//struct task_struct *task[NR_TASKS]={&init_task,};


struct task_struct init_task = INIT_TASK;


void check_priority(struct task_struct * p)
{
  if ( p->priority > current->priority )
    schedule();
}


void add_to_runqueue(struct task_struct * p)
{
#if 1	/* sanity tests */
	if (p->next_run || p->prev_run) {
//		printf("task already on run-queue\n");
		return;
	}
#endif
        nr_running++;
        p->timeout = WAIT_TIME;
        //p->counter = QUANTUM;
        (p->prev_run = init_task.prev_run)->next_run = p;
	p->next_run = &init_task;
	init_task.prev_run = p;
	check_priority(p);
	return;
}

inline void wake_up_process(struct task_struct * p)
{

  asm("block_interrupts int_mask_temp\n\t");
      	p->state = TASK_RUNNING;
	if (!p->next_run)
	  {
                p->next_task = p->prev_task = NULL;
		add_to_runqueue(p);
	  }

  asm("restore_interrupts int_mask_temp\n\t");
	return;
}


void process_waittimeout(unsigned long l_data)
{
	struct task_struct * p = (struct task_struct *) l_data;

	p->timeout = WAIT_TIME;
	wake_up_process(p); /*  defined in sched.h   */
	return;
}

struct signal_struct init_signals = INIT_SIGNALS;
struct task_struct *current=&init_task; /*points to currect task under execution */


extern inline void init_timer(struct timer_list * timer);



/* This verifies if the task is really in run queue so that it may be deleted.
   Note that the memory allocated to this is not removed, just its information
   regarding run queue is removed linking its neighbours in the queue together 
   also decrements the count of number of tasks in run queue  */

inline void del_from_runqueue(struct task_struct * p)
{
	struct task_struct *next = p->next_run;
	struct task_struct *prev = p->prev_run;

#if 1	/* sanity tests */
	if (!next || !prev) {
//		printf("task not on run-queue\n");
		return;
	}
#endif
	if (p == &init_task) 
          {
//	    printf("idle task may not sleep\n");
	    return;
	  }
	nr_running--;
        p->state = TASK_WAITING;
	next->prev_run = prev;
	prev->next_run = next;
	p->next_run = NULL;
	p->prev_run = NULL;
	if (p = current) 
	  {
	    need_resched = 1;
	    sys_getuid();
          }           // calling dummy system call which means calling the
	              // schedule() indirectly to make another high prioritized
	              // task = current
        
	return;
}

/* We dont actually need so many wait queues now but let me see how it ends up
   This is some what peculiar, we have only one queue when we wrote this 
   function.... versions of linux used some what complex waitqueues  */

void add_to_waitqueue(struct task_struct *to_wait)
{   struct task_struct *ptr = to_wait;

	    if (ptr->next_task != NULL || ptr->prev_task != NULL) 
             {
	       //	   printf("task already on wait-queue\n");
		   return;
	     }
       
        (ptr->prev_task = init_task.prev_task)->next_task = ptr;
	ptr->next_task = &init_task;
	init_task.prev_task = ptr;
	return;
    
} 


/* printf doesnt work unless it has been ported */

/* void Print_Runqueue( ) */
/* { */
/* 	struct task_struct* tmp_init = init_task.next_run; */


/* 	//Adding these printf bcos PrintTaskStruct doesnt print INIT */
/*        printf("PID:: 0,  PRIORITY:: 1 ----> INIT\n"); */

/*       while ( tmp_init != &init_task) */
/* 	{ */
/*               printf("PID:: %d,  PRIORITY:: %d\n",tmp_init->pid, tmp_init->priority); */
/* 	      tmp_init=tmp_init->next_run; */
/* 	}	;        */

/* } */
  

   
inline void move_last_runqueue(struct task_struct * p)
{
	struct task_struct *next = p->next_run;
	struct task_struct *prev = p->prev_run;

	/* remove from list */
	next->prev_run = prev;
	prev->next_run = next;
	/* add back to list */
	p->next_run = &init_task;
	prev = init_task.prev_run;
	init_task.prev_run = p;
	p->prev_run = prev;
	prev->next_run = p;
}

 inline int goodness(struct task_struct * p, struct task_struct * prev)
{
	int weight;

	/*
	 * Realtime process, select the first one on the
	 * runqueue (taking priorities within processes
	 * into account).
	 */
	if (p->policy != SCHED_OTHER)
		return 1000 + p->rt_priority;

	/*
	 * Give the process a first-approximation goodness value
	 * according to the number of clock-ticks it has left.
	 *
	 * Don't do any other calculations if the time slice is
	 * over..
	 */

	weight = p->counter;
	if (weight) {

		/* .. and a slight advantage to the current process */
		if (p == prev)
			weight += 1;
	}

	return weight;
}


#define TVN_BITS 6
#define TVR_BITS 8
#define TVN_SIZE (1 << TVN_BITS)
#define TVR_SIZE (1 << TVR_BITS)
#define TVN_MASK (TVN_SIZE - 1)
#define TVR_MASK (TVR_SIZE - 1)

#define SLOW_BUT_DEBUGGING_TIMERS 0

struct timer_vec {
        int index;
        struct timer_list *vec[TVN_SIZE];
};

struct timer_vec_root {
        int index;
        struct timer_list *vec[TVR_SIZE];
};

 struct timer_vec tv5 = { 0 };
 struct timer_vec tv4 = { 0 };
 struct timer_vec tv3 = { 0 };
 struct timer_vec tv2 = { 0 };
 struct timer_vec_root tv1 = { 0 };

 struct timer_vec * const tvecs[] = {
	(struct timer_vec *)&tv1, &tv2, &tv3, &tv4, &tv5
};

#define NOOF_TVECS (sizeof(tvecs) / sizeof(tvecs[0]))

 unsigned long timer_jiffies = 0;

 inline void insert_timer(struct timer_list *timer,
				struct timer_list **vec, int idx)
{
	if ((timer->next = vec[idx]))
		vec[idx]->prev = timer;
	vec[idx] = timer;
	timer->prev = (struct timer_list *)&vec[idx];
}

 inline void internal_add_timer(struct timer_list *timer)
{
	/*
	 * must be cli-ed when calling this
	 */
	unsigned long expires = timer->expires;
	unsigned long idx = expires - timer_jiffies;

	if (idx < TVR_SIZE) {
		int i = expires & TVR_MASK;
		insert_timer(timer, tv1.vec, i);
	} else if (idx < 1 << (TVR_BITS + TVN_BITS)) {
		int i = (expires >> TVR_BITS) & TVN_MASK;
		insert_timer(timer, tv2.vec, i);
	} else if (idx < 1 << (TVR_BITS + 2 * TVN_BITS)) {
		int i = (expires >> (TVR_BITS + TVN_BITS)) & TVN_MASK;
		insert_timer(timer, tv3.vec, i);
	} else if (idx < 1 << (TVR_BITS + 3 * TVN_BITS)) {
		int i = (expires >> (TVR_BITS + 2 * TVN_BITS)) & TVN_MASK;
		insert_timer(timer, tv4.vec, i);
	} else if (expires < timer_jiffies) {
		/* can happen if you add a timer with expires == jiffies,
		 * or you set a timer to go off in the past
		 */
		insert_timer(timer, tv1.vec, tv1.index);
	} else if (idx < 0xffffffffUL) {
		int i = (expires >> (TVR_BITS + 3 * TVN_BITS)) & TVN_MASK;
		insert_timer(timer, tv5.vec, i);
	} else {
		/* Can only get here on architectures with 64-bit jiffies */
		timer->next = timer->prev = timer;
	}
}

void add_timer(struct timer_list *timer)
{
	unsigned long flags;
	//save_flags(flags);
	//cli();
  asm("block_interrupts int_mask_temp\n\t");
	internal_add_timer(timer);

	//restore_flags(flags);
  asm("restore_interrupts int_mask_temp\n\t");
}

void add_to_timer_queue(struct timer_list *timer)
{

}

/* Very important change here ... greater the value of priority in the *
 * task_struct , heigher is its importance (Linus has opposite meaning)*
 * I dont wanna confuse myself */

void schedule(void)
{
	int c;
	struct task_struct * p;
	struct task_struct * prev, * next;
	unsigned long timeout = 0; //wait for so many ticks in timer wait queue

//	allow_interrupts();


	need_resched = 0;
	prev = current;
	//	cli();
  asm("block_interrupts int_mask_temp\n\t");

	if (!prev->counter && prev->policy == SCHED_RR) {
		prev->counter = prev->priority;
		move_last_runqueue(prev);
	}
	switch (prev->state) {
		case TASK_INTERRUPTIBLE:
		  //signals and bottom halves not supported
		  //	if (prev->signal & ~prev->blocked)
		  //		goto makerunnable;
			timeout = prev->timeout;
			if (timeout && (timeout <= jiffies)) {
				prev->timeout = 0;
				timeout = 0;
		makerunnable:
				prev->state = TASK_RUNNING;
				break;
			}
		case TASK_RUNNING:
		                   break;
		default:
			del_from_runqueue(prev);
			prev = init_task.prev_run;
	}
	p = init_task.next_run;
	//sti();
  asm("restore_interrupts int_mask_temp\n\t");
	
#define idle_task (&init_task)
	

/*
 * Note! there may appear new tasks on the run-queue during this, as
 * interrupts are enabled. However, they will be put on front of the
 * list, so our list starting at "p" is essentially fixed.
 */
/* this is the scheduler proper: */
	c = -1000;
	next = idle_task;
	while (p != idle_task) {
		int weight = goodness(p, prev);
		if (weight > c)
			c = weight, next = p;
		p = p->next_run;
	}

    /* if all runnable processes have "counter == 0", re-calculate counters */
	if (c == 0) {
		for_each_task(p)
			p->counter = (p->counter >> 1) +  p->priority;
	}

	if (prev != next) {
		struct timer_list *timer_pointer;
                timer_pointer = &prev->timer;
		if (timeout) {
			init_timer(timer_pointer);
			prev->timer.expires = timeout+jiffies;
			prev->timer.data = (unsigned long) prev;
			prev->timer.function = process_waittimeout;
			//add_timer(timer_pointer);
			//add_to_timer_queue(timer_pointer);
		} 

                current = next;

	}
	return;
}   


 inline int detach_timer(struct timer_list *timer)
{
	int ret = 0;
	struct timer_list *next, *prev;
	next = timer->next;
	prev = timer->prev;
	if (next) {
		next->prev = prev;
	}
	if (prev) {
		ret = 1;
		prev->next = next;
	}
	return ret;
}


extern int del_timer(struct timer_list * timer)
{
	int ret;
	unsigned long flags;
	//save_flags(flags);
	//cli();
  asm("block_interrupts int_mask_temp\n\t");
	ret = detach_timer(timer);
	timer->next = timer->prev = 0;
	//restore_flags(flags);
  asm("restore_interrupts int_mask_temp\n\t");
	return ret;
}

 inline void cascade_timers(struct timer_vec *tv)
{
        /* cascade all the timers from tv up one level */
        struct timer_list *timer;
        timer = tv->vec[tv->index];
        /*
         * We are removing _all_ timers from the list, so we don't  have to
         * detach them individually, just clear the list afterwards.
         */
        while (timer) {
                struct timer_list *tmp = timer;
                timer = timer->next;
                internal_add_timer(tmp);
        }
        tv->vec[tv->index] = NULL;
        tv->index = (tv->index + 1) & TVN_MASK;
}

 inline void run_timer_list(void)
{
  //cli();
  asm("block_interrupts int_mask_temp\n\t");
	while ((long)(jiffies - timer_jiffies) >= 0) {
		struct timer_list *timer;
		if (!tv1.index) {
			int n = 1;
			do {
				cascade_timers(tvecs[n]);
			} while (tvecs[n]->index == 1 && ++n < NOOF_TVECS);
		}
		while ((timer = tv1.vec[tv1.index])) {
			void (*fn)(unsigned long) = timer->function;
			unsigned long data = timer->data;
			detach_timer(timer);
			timer->next = timer->prev = NULL;
			//sti();
  asm("restore_interrupts int_mask_temp\n\t");
			fn(data);
			//cli();
  asm("block_interrupts int_mask_temp\n\t");
		}
		++timer_jiffies; 
		tv1.index = (tv1.index + 1) & TVR_MASK;
	}
       //sti();
  asm("restore_interrupts int_mask_temp\n\t");
}

unsigned long timer_active = 0;
struct timer_struct timer_table[32];

 inline void run_old_timers(void)
{
	struct timer_struct *tp;
	unsigned long mask;

	for (mask = 1, tp = timer_table+0 ; mask ; tp++,mask += mask) {
		if (mask > timer_active)
			break;
		if (!(mask & timer_active))
			continue;
		if (tp->expires > jiffies)
			continue;
		timer_active &= ~mask;
		tp->fn();
	}
}



/* This timer just removes the timer from the list of timers     */
/* Note if the timer is a newly created one then it is good practice to */
/* make its all pointers to NULL    */
  
inline void init_timer(struct timer_list * timer)
{
	timer->next = NULL;
	timer->prev = NULL;
}

/* update_process_times increments the number of ticks it had been since
   the system started and decrements the time quatum of current process,
   checks if current process is out of quantum, if yes then it enables
   rescheduling field in it, then it checks for any expired timers in the
   timer_list, if so put all the process whose timers expired in run_queue
   and then returns from the interrupt handler */
void update_process_times()
{   
      struct task_struct * p = current;   
      
        jiffies += 1;
	if(p->pid)
        {
            current->counter -= 1;
            if (current->counter <= 0)
            {
               current->counter = 0;
               need_resched = 1;
            }
            else
              need_resched = 0;
        }

	if(++current->syscall_called_timer == 200 && current->pid != 0)
	 {
	  current->state = TASK_STOPPED;
	
/*
 * someone told me that scheduler should be called only from system_call handler, keeping that in mind
 * scheduler is called indirectly here as dummy_idle_brain makes system_calls with a very high frequency
 * and thus calling the scheduler, If someone feels this is very bad IDEA (as i am feeling now) then just
 * replace dummy_idle_brain() with schedule(). In fact this replacement would save hundreds of instructions.
 * Ok leaving choice to the developers :-)
 */
	  dummy_idle_brain();
	 }
          
        get_expired_timer();

	if((current->pid == 0) && (nr_running != 0))
	  {
	    need_resched=1;
            dummy_idle_brain(); 
	  }
}

/*  This one searches the whole timer list for expired timers */
/*  and if expired put the task in the run queue              */

void get_expired_timer()
{
  extern struct timer_list head_timer;
  struct timer_list *p = head_timer.next;
       while(p != &head_timer)
      {
	if((p->expires - jiffies) <= 0)
	  { 
	    process_waittimeout(p->data);  /* declared in sched.h */
            del_timer(p);
          }
        p = p->next; 
      }
      return;
}


/* init executes this function always */
/* Make this function a user application now it is in kernel which is wrong*/

void init_thread(void)
{ int temp;
 start:
  for(temp=0;temp<HZ;temp++){}
  schedule();
  goto start;
}



/*
 * For backwards compatibility?  This can be done in libc so Alpha
 * and all newer ports shouldn't need it.
 */
int sys_pause(void)
{
	current->state = TASK_INTERRUPTIBLE;
	schedule();
	return -ERESTART;
}

int sys_getpid(void)
{
	return current->pid;
}

int sys_getppid(void)
{
  if(current->p_opptr->pid)
    return current->p_opptr->pid;
  else
    return -10;//current->p_opptr->pid;
}

int sys_getuid(void)
{
	return ENOSYS;
}

int sys_geteuid(void)
{
	return ENOSYS;
}

int sys_getgid(void)
{
	return ENOSYS;
}

int sys_getegid(void)
{
	return ENOSYS;
}

/*
 * This has been replaced by sys_setpriority.  Maybe it should be
 * moved into the arch dependent tree for those ports that require
 * it for backward compatibility?
 */
int sys_nice(int increment)
{
	unsigned long newprio;
	int increase = 0;

	newprio = increment;
	if (increment < 0) {
	  //	if (!suser())          everyone is super user right now
	      //	return -EPERM;
		newprio = -increment;
		increase = 1;
	}
	if (newprio > 40)
		newprio = 40;
	/*
	 * do a "normalization" of the priority (traditionally
   	 * unix nice values are -20..20, linux doesn't really
	 * use that kind of thing, but uses the length of the
	 * timeslice instead (default 150 msec). The rounding is
	 * why we want to avoid negative values.
	 */
	newprio = (newprio * DEF_PRIORITY + 10) / 20;
	increment = newprio;
	if (increase)
		increment = -increment;
	newprio = current->priority - increment;
	if ((signed) newprio < 1)
		newprio = 1;
	if (newprio > DEF_PRIORITY*2)
		newprio = DEF_PRIORITY*2;
	current->priority = newprio;
	return 0;
}

 struct task_struct *find_process_by_pid(pid_t pid) {
	struct task_struct *p, *q;

	if (pid == 0)
		p = current;
	else {
		p = 0;
		for_each_task(q) {
			if (q && q->pid == pid) {
				p = q;
				break;
			}
		}
	}
	return p;
}

/* Note here third argument changed a bit from Uclinux codes to suit here */
int setscheduler(pid_t pid, int policy, 
			int  sched_priority)
{
  //	int error;
  //	struct sched_param lp;
	struct task_struct *p;

	if (pid < 0)
		return -EINVAL;


	p = find_process_by_pid(pid);
	if (!p)
		return -ESRCH;
			
	if (policy < 0)
		policy = p->policy;

	else if (policy != SCHED_FIFO && policy != SCHED_RR &&
		 policy != SCHED_OTHER)
		return -EINVAL;
	
	/*
	 * Valid priorities for SCHED_FIFO and SCHED_RR are 1..99, valid
	 * priority for SCHED_OTHER is 0.
	 */

	if (sched_priority < 0 || sched_priority > 99)
		return -EINVAL;

	if ((policy == SCHED_OTHER) != (sched_priority == 0))
		return -EINVAL;


	p->policy = policy;
	p->rt_priority = sched_priority;
	//	cli();
  asm("block_interrupts int_mask_temp\n\t");
	if (p->next_run)
		move_last_runqueue(p);
	//	sti();
  asm("restore_interrupts int_mask_temp\n\t");
	need_resched = 1;
	return 0;
}

int sys_sched_setscheduler(pid_t pid, int policy, 
				      int sched_priority)
{
	return setscheduler(pid, policy, sched_priority);
}

int sys_sched_setparam(pid_t pid,int sched_priority)
{
	return setscheduler(pid, -1, sched_priority);
}


int sys_sched_getscheduler(pid_t pid)
{
	struct task_struct *p;

	if (pid < 0)
		return -EINVAL;

	p = find_process_by_pid(pid);
	if (!p)
		return -ESRCH;
			
	return p->policy;
}

int sys_sched_yield(void)
{
  //	cli();
  asm("block_interrupts int_mask_temp\n\t");
	move_last_runqueue(current);
	current->counter = 0;
	need_resched = 1;
 //	sti();
  asm("restore_interrupts int_mask_temp\n\t");
	return 1;
}

int sys_sched_get_priority_max(int policy)
{
	switch (policy) {
	      case SCHED_FIFO:
	      case SCHED_RR:
		return 99;
	      case SCHED_OTHER:
		return 0;
	}

	return -EINVAL;
}

int sys_sched_get_priority_min(int policy)
{
	switch (policy) {
	      case SCHED_FIFO:
	      case SCHED_RR:
		return 1;
	      case SCHED_OTHER:
		return 0;
	}

	return -EINVAL;
}

int sys_dummy_idle_brain()
{
  need_resched = 1;  /*this is called only when init_task is running and when
returning from this systemcall need_resched will make scheduler check if there 
are any running tasks on the run queue*/
  return 0;
}

// unimplemented syscalls when called the kernel executes the below function
int nosys()
{
  return ENOSYS;
}

/************************entry.c***********************/
/*--------------------------------------------------------------------------*/
/*                 CUP-OS  Syscall,INT and Exception handlers               */
/*              -----------------------------------------------             */
/*  Author   :	Nuguru Susheel Raj                                          */
/*  Email    :	susheel.nuguru@tut.fi                                       */
/*  File     :  entry.c                                                     */
/*  modified :  14/09/2004                                                  */
/*--------------------------------------------------------------------------*/

 unsigned long exception_code;

unsigned long int_mask_int; // for interrupts
unsigned long int_mask_excep; // for exceptions

 unsigned int servicing_syscall = 0; /* an interrupt may occer when the processor is executing user tasks or when executing systemcall. This variable along with servicing_interrupt will let us know if user tasks were running before interrupt occured or system task was executing before interrupt occured*/

long servicing_interrupt = 0; /* This will tell us if interrupt occured
while servicing and interrupt  */
//asm(".data\n\t\t"
//    ".globl ret_from_sys_call\n\t\t");

/* Macro to add syscall_address into its address with the assumption  *
 * that r16 has address of system_call_table[]'s arrayth address to which this * * entry should be added                                              */

asm(".text\n\t"
    ".global ret_from_sys_call\n\t\t"
    ".align 2\n\t"
    ".global reschedule\n\t"
    ".align 2\n\t"
    ".code32\n\t"
    "reschedule: \n\t"
    "ldra r16,need_resched\n\t "
    "lli r17,0\n\t"
    "st r17,r16,0\n\t");
SAVE_USR_PT_REGS   // here there is possiility that the task may change
asm("ldra r16,schedule\n\t"
    "push r31\n\t"
    "jalr r16\n\t"
    "nop\n\t"
    "nop\n\t"
    "pop r31\n\t");
RESTORE_USR_PT_REGS

     /* here the current process may be different or same one which made the system call,
        restoring the R0 which contains the system return value for the current process that
        madea  system call this time if the scheduler did not change the 
        selection, else if it made the change it is the return value of the
        system call made by the process last time when it got the cpu time*/
     
     /* Restoring R0 (return value of the system call Related to the 
        newly selected process), R0 goes to its own process and restored */

       asm("ldra r16,current\n\t"  
       "ld   r1,r16,0\n\t"     
       "addiu r1,r1,pt_regs\n\t"   
       "ld r1,r1,0\n\t"
       "addiu r1,r1,140\n\t"
       "ld r0,r1,0\n\t"
       "chrs 1\n\t"
       "mov r0,r0\n\t"
       "chrs 3\n\t");

     /* DONE restoring of R0 value related to the current new process 
        if scheuler is called, else the old one if it isnt called */
asm("ldra r16,servicing_syscall\n\t"
    "lli  r17,0\n\t"
    "st   r17,r16,0\n\t");
	
      asm("enable_interrupts\n\t");
  //  RESTORE_ALL
asm("retu\n\t"
"nop\n\t"
"nop\n\t");


    

/* even if the interrupts are enabled in kernel routines it should 
   work fine ..lets test it and find it out in thetesting phase */

extern void system_call(void)
{ 
  current->syscall_called_timer = 0; //time units since syscall called
 servicing_syscall = 1;//switch from task to kernel is true
 asm("disable_interrupts\n\t");
   
 //    SAVE_ALL
  /* Scheduler when selects a new process then it just r        */
  
     SAVE_STACK_POINTER
     MOVE_INCOMING_ARGUMENTS //incoming arugments from set1 to set2


   asm("ldra r16,NR_systemcall\n\t"
       "ld r16,r16,0\n\t"
       "cmp c0,r5,r16\n\t"    
       "bgt c0,ret_from_sys_call\n\t"
       "nop\n\t"
       "ldra r16,system_call_table\n\t"
       "muli r6,r5,4\n\t"
       "addu r16,r16,r6\n\t"
       "ld r16,r16,0\n\t"
       "push r5\n\t"
       "push r31\n\t"
       "jalr r16\n\t"
       "nop\n\t"
       "pop r31\n\n"
       "pop r5\n\t"
       
       "ret_from_sys_call :\n\t"
       "ldra r16,NR_systemcall\n\t"
       "ld r16,r16,0\n\t"
       "cmp c0,r5,r16\n\t"
       "belt c0,extf2\n\t"
       "nop\n\t"
       "lli r0,38\n\t"    //ENOSYS	38	/* systemcall not implemented or syscall number overflow*/
       //"jmp extf3\n\t"
       //"nop\n\t"

/*   Because there is no guarentee that the task that made a valid system call will continue before      *
 *   readings its return value in register R0, we will put this value  into *
 *   USR_PT_REGS register 0 */

       "extf2      :\n\t"
       "ldra r16,current\n\t"  
       "ld   r1,r16,0\n\t"     
       "addiu r1,r1,pt_regs\n\t"   
       "ld r1,r1,0\n\t"
       "st r0,r1,0\n\t"  // in user register current->pt_reg->r0 memory space 
       "addiu r1,r1,140\n\t"
       "st r0,r1,0\n\t"      
      /*-------------------Done Saving R0-------------------*/
/* Here the current task may change, that is why system call return value was saved into user registers
    before schedule() have chances to change the task.. doesnt look optimum but really secure way  */
    
       "extf3      :\n\t"
       "ldra r16,need_resched\n\t"
       "ld r16,r16,0\n\t"
       "cmpi c0,r16,0\n\t"
       "beq  c0,extf4\n\t"
       "nop\n\t"
       "ldra r16,reschedule\n\t"
       "jmpr r16\n\t"
       "nop\n\t"
       "nop\n\t"
       "extf4:\n\t"

     /* here the current process may be different or same one which made the system call,
        restoring the R0 which contains the system return value for the current process that
        madea  system call this time if the scheduler did not change the 
        selection, else if it made the change it is the return value of the
        system call made by the process last time when it got the cpu time*/
     
     /* Restoring R0 (return value of the system call Related to the 
        newly selected process), R0 goes to its own process and restored */

       "ldra r16,current\n\t"  
       "ld   r1,r16,0\n\t"     
       "addiu r1,r1,pt_regs\n\t"   
       "ld r1,r1,0\n\t"
       "addiu r1,r1,140\n\t"
       "ld r0,r1,0\n\t"
       "chrs 1\n\t"
       "mov r0,r0\n\t"
       "chrs 3\n\t");

     /* DONE restoring of R0 value related to the current new process 
        if scheuler is called, else the old one if it isnt called */

  RESTORE_STACK_POINTER
 
  servicing_syscall = 0; //switched from task to kernel is false
    asm("enable_interrupts\n\t");
  //  RESTORE_ALL
asm("retu\n\t"
"nop\n\t"
"nop\n\t");
}

/*---------------Done With Scall Handler------------------------*/

static void interrupt_handler(void)
{
 long timer_interrupt = 0;

  asm("START_INTERRUPT_HANDLER:\n\t"
      "block_interrupts int_mask_int\n\t");

    if(servicing_syscall != 0  || servicing_interrupt != 0)
    { 
	SAVE_ALL }                                  /* save only when kernel registers were in use 
	                                           * previously */ 
    /* if interrupt occured while kernel service routine continue with
the same stack usage which was used to service the syscall ...else if the
interrupt occured while appllication was running then shift to kernel stack*/
    if(servicing_syscall == 1 || servicing_interrupt >= 1)
      {
        servicing_interrupt += 1;
	/* if anything goes wrong try not storing SP and FP in KERNEL_SP
   and KERENL_FP respectively */

	asm("push r17\n\t"
	    "push r16\n\t"
	    "ldra r17,KERNEL_FP\n\t"
	    "ld   r16,r17,0\n\t"
	    "push r16\n\t"
	    "st   FP,r17,0\n\t"
	    "ldra r17,KERNEL_SP\n\t"
	    "ld   r16,r17,0\n\t"
	    "push r16\n\t"
	    "st   SP,r17,0\n\t"
	    "jmpr r31\n\t"
	    "nop  \n\t");
      }
    else
      {
        servicing_interrupt = 1;
	servicing_syscall = 0;

 /* set1 SP and FP are undisturbed which have task stack information only 
    set2 SP and FP are corrupted which has no stack information of the kernel
    at this point */
/*	asm("push r17\n\t"
	    "ldra r17,KERNEL_FP\n\t"   
	    "ld   FP,r17,0\n\t"
	    "ldra r17,KERNEL_SP\n\t"            
	    "ld   SP,r17,0\n\t"
	    "pop r17\n\t"
	    "jmpr r31\n\t"
	    "nop  \n\t");
      */
      
 /* Something wrong so these two lines are here */
      asm(  "jmpr r31\n\t"
	    "nop  \n\t");
      }

  asm("Co_Processor0_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor1_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor2_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor3_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT0_ISR:\n\t\t" 
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT1_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT2_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT3_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT4_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT5_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT6_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"


/* Timer interrupt service routine is here */
      "EXT_INT7_ISR: \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,update_process_times\n\t"
      "push LR\n\t"
      "jalr r16\n\t"
      "nop  \n\t"
      "pop  LR\n\t\t");
      
      //asm("ldra r16,final\n\t\t"
      //"jmpr r16\n\t\t"
      //"nop  \n\t");

  asm("final:\n\t");
   if((servicing_syscall == 1)|| (servicing_interrupt > 1))
      {
       if(servicing_interrupt > 1)
          servicing_interrupt -= 1 ;
       else
	 {
	   servicing_interrupt = 0;
	   servicing_syscall = 1;
         }
	asm("ldra r17,KERNEL_SP\n\t"
	    "ld SP,r17,0\n\t"
	    "pop r16\n\t"
	    "st r16,r17,0\n\t"
	    "ldra r17,KERNEL_FP\n\t"
	    "ld FP,r17,0\n\t"
	    "pop r16\n\t"
	    "st r16,r17,0\n\t"
	    "pop r16\n\t"
	    "pop r17\n\t");
      }
    else
      {
	servicing_interrupt = 0;
        servicing_syscall = 0;  
	asm("ldra r17,KERNEL_FP\n\t"   
	    "ld   FP,r17,0\n\t");
      }

    if(servicing_syscall != 0  || servicing_interrupt != 0) 
    {     
	RESTORE_ALL
    }
    asm("restore_interrupts int_mask_int\n\t"
	"reti\n\t\t"
	"nop\n\t\t"
	"nop\n\t"
	"nop\n\t");

}

static void exception_handler(void)
{
  /* get the exception code*/
  asm("block_interrupts int_mask_excep\n\t"
      "lli r16,0xbf00\n\t"
      "lui r16,0xffff\n\t"
      "ld  r17,r16,EXCEPTION_CS_OFFSET\n\t"
      "ldra r18,exception_code\n\t"
      "st  r17,r18,0\n\t");

  /* now the decision of the exception handler is to make the tasks not able *
   * get the CPU by changing its state to TASK_STOPPED then the scheduler will
   * remove it from the runqueue .in later versions more efficient decisions 
   * depending ont he context will be made */

  /* Here the value of PSR should be decimal 14 (01110)->Hardware design*/
  
/* 
 * Not saving register bcos the task that made this exception call will be killed brutally, so right now no need 
 * to save the register values of the (about to  be) killed task. Later when the exception handler makes make
 * good decisions depending on the exception code then we have to uncomment this below line to save the registers 
 * of the current->task.
 */  
  //SAVE_USR_PT_REGS
  
  
  switch(exception_code){
  case 0 :

  case 1 :	

  case 2 :
    
  case 3 :	
    
  case 4 :	

  case 5 :	

  case 6 :

  case 7 :	

  case 8 :	

  case 9 :	
    if((servicing_syscall == 0) && (servicing_interrupt == 0))
      {
	current->state = TASK_STOPPED;//exception by application
	schedule();
      } 
    else
      {
	sys_reboot(LINUX_REBOOT_MAGIC1,LINUX_REBOOT_MAGIC2,LINUX_REBOOT_CMD_RESTART); //this means exception in kernel restarts the core.(laughter)
      }
    break;
  default:
    if(exception_code >=224)
      // handle trap here
      break;
  }
RESTORE_USR_PT_REGS
  asm("restore_interrupts int_mask_excep\n\t"
      "retu\n\t"
      "nop\n\t"
      "nop\n\t");
}

/******************process.c**********************/
/*                    QPUX-Kernel Some more routines                        */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

extern struct task_struct *current;
extern unsigned long volatile jiffies;
extern int need_resched;
 int hlt_counter=0;
char hlt_works_ok = 0;		/* set if the "hlt" instruction works */

#define HARD_IDLE_TIMEOUT (HZ / 3)

void disable_hlt(void)
{
	hlt_counter++;
}

void enable_hlt(void)
{
	hlt_counter--;
}


 void hard_idle(void)
{
	while (!need_resched) {
		if (hlt_works_ok && !hlt_counter)
		        //__asm__("hlt");         
 		if (need_resched) 
 			break;
		schedule();
	}
}

/*
 * The idle loop on a uniprocessor coffee..
 */
 
int sys_idle(void)
{
        unsigned long start_idle = 0;

	if (current->pid)
		return -EPERM;
	/* endless idle loop with no priority at all */
	current->counter = -100;
	for (;;) 
	{

		if (!start_idle) 
			start_idle = jiffies;
		if (jiffies - start_idle > HARD_IDLE_TIMEOUT) 
		{
			hard_idle();
		} 
		else 
		{
			if (hlt_works_ok && !hlt_counter && !need_resched){}
		        	//__asm__("hlt");
		}
		if (need_resched) 
			start_idle = 0;
		schedule();
	}
}



/*************************malloc.c*****************************/


#define DYNAMIC_MEMORY_STARTS_AT 0x01200
#define NULL ((void *) 0)

static unsigned long free_mem_ptr = DYNAMIC_MEMORY_STARTS_AT;
static unsigned long free_mem_end_ptr = 0x90000;


/* ENOMEM and ENXIO are selected to me odd .. if these values are
   even,then the return values are type casted by the the caller and the
   error value will be assumed to be the pointer returned...if it is odd
   then there will be an exception and the kernel removes this task from 
   the current running list */
static void *sys_malloc(int size)
{
	void *p;

	if (size <0) return NULL  ;
	if (free_mem_ptr <= 0) 
		free_mem_ptr = 0;

		free_mem_ptr = (free_mem_ptr + 3) & ~3;	/* Align */

	if ((free_mem_ptr + size) >= free_mem_end_ptr)
	       return NULL;

	p = (void *)free_mem_ptr;
	free_mem_ptr += size;
	
	return p;
}


static void sys_free(void *where)
{	/* Don't care */
}


/***********************exit.c*****************************/

/*               CUP-OS  Syscalls to terminate the task                     */
/*              -----------------------------------------                   */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


extern int mem_slots[MAX_MEMORY_SLOTS];
/* Modified a lot hope this works out*/

 inline void generate(unsigned long sig, struct task_struct * p)
{
	unsigned long flags;
	unsigned long mask = 1 << (sig-1);
	struct sigaction * sa = sig + p->sig->action - 1;

	/*
	 * Optimize away the signal, if it's a signal that can
	 * be handled immediately (ie non-blocked and untraced)
	 * and that is ignored (either explicitly or by default)
	 */
	//	save_flags(flags); cli();
	if (!(mask ) && !(PF_PTRACED)) {
		/* don't bother with ignored signals (but SIGCHLD is special) */
		if (sa->sa_handler == SIG_IGN && sig != SIGCHLD) {
		  //			restore_flags(flags);
			return;
		}
		/* some signals are ignored by default.. (but SIGCONT already did its deed) */
		if ((sa->sa_handler == SIG_DFL) &&
		    (sig == SIGCONT || sig == SIGCHLD || sig == SIGWINCH || sig == SIGURG)) {
		  //			restore_flags(flags);
			return;
		}
	}
	p->signal |= mask;
	if (p->state == TASK_INTERRUPTIBLE && (p->signal ))
		wake_up_process(p);
	//	restore_flags(flags);
}



int send_sig(unsigned long sig,struct task_struct * p,int priv)
{
	unsigned long flags;

	if (!p || sig > 32)
		return -EINVAL;
	if (!priv && (sig != SIGCONT)) 
		return -EPERM;
	if (!sig)
		return 0;
	/*
	 * Forget it if the process is already zombie'd.
	 */
	if (!p->sig)
		return 0;
	//	save_flags(flags); cli();
	if ((sig == SIGKILL) || (sig == SIGCONT)) {
		if (p->state == TASK_STOPPED)
			wake_up_process(p);
		p->exit_code = 0;
		p->signal &= ~( (1<<(SIGSTOP-1)) | (1<<(SIGTSTP-1)) |
				(1<<(SIGTTIN-1)) | (1<<(SIGTTOU-1)) );
	}
	if (sig == SIGSTOP || sig == SIGTSTP || sig == SIGTTIN || sig == SIGTTOU)
		p->signal &= ~(1<<(SIGCONT-1));
	//	restore_flags(flags);

	/* Actually generate the signal */
	generate(sig,p);
	return 0;
}


/*
 * kill_pg() sends a signal to a process group: this is what the tty
 * control characters do (^C, ^Z etc) and now there are no groups so
/* i have to modify this funtion a bit removing pgrp fields. :-(
 */
//int kill_pg(int pgrp, int sig, int priv)
int kill_pg(int sig, int priv)
{
	struct task_struct *p;
	int err,retval = -ESRCH;

	if (sig<0 || sig>32)
		return -EINVAL;

	return 0;
}



int kill_proc(int pid, int sig, int priv)
{
 	struct task_struct *p;

	if (sig<0 || sig>32)
		return -EINVAL;
	for_each_task(p) {
		if (p && p->pid == pid)
			return send_sig(sig,p,priv);
	}
	return(-ESRCH);
}



/*
 * POSIX specifies that kill(-1,sig) is unspecified, but what we have
 * is probably wrong.  Should make it like BSD or SYSV.
 */
int sys_kill(int pid,int sig)
{
	int err, retval = 0, count = 0;

	if (!pid)
		return(kill_pg(sig,0));
	if (pid == -1) {
		struct task_struct * p;
		for_each_task(p) {
			if (p->pid > 1 && p != current) {
				++count;
				if ((err = send_sig(sig,p,0)) != -EPERM)
					retval = err;
			}
		}
		return(count ? retval : -ESRCH);
	}
	if (pid < 0) 
		return(kill_pg(sig,0));
	/* Normal kill */
	return(kill_proc(pid,sig,1));
}

/* sys_exit work is satisfactory, unless u suggest betterments */

void  sys_exit(struct task_struct *p)
{     int temp = 0;
 temp = p->mm->memory_slot; //getting the number of memory slot used by the
                            // task
 mem_slots[temp] = 0;       // making that slot reusable for other forked tasks

 /* Trying to retrieve  all the information of the remaining tasks that the 
    exiting  process hold in its structure */

 del_from_runqueue(p);/* this not only deletes from the
      run_queue but also links its neighbouring tasks to one another in that
      queue */
 if(p->prev_task != NULL || p->next_task!= NULL)
   {
     (p->prev_task->next_task = p->next_task)->prev_task = p->prev_task;
      p->prev_task = p->next_task = NULL; /* actually we should free the memory
      of this structure task_struct but bcos CUP-OS doesnot support 
      Dynamic memory, it cant be freed now.*/
  }

 /* Here We need to free all the parent-child  relations for this process and 
    connect this process' childs to the parent of the exiting process if it 
    exists  or to INIT... but as fork is not supported for now there are no 
    parent and child relationships even though the task_struct has those 
    fields , we will use them after sys_fork() is implemented by one of us */

      
}

/*************************main.c*****************************/

/*                  CUP-OS       MAIN() is here                             */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

/* the concept of mem_slots[] is here so that sys_fork would be designed in 
   future otherwise now mem_slots are of no use.*/

  /* Need to fill many fields in many structures ... check  *
   * manually and do try to remember those fields           */


// #include "entry.h" uncomment it at the end

/* If anyone adds more tasks then do not forget to change the fields
   of the INIT_TASK in sched.h else the new added task are not recognised
   by the kernel or even worse the system may crash :-( */

void idle_brain();

#define task_0_address (int)&idle_brain  // task0 = idle_task
#define task_1_address 16620
#define task_2_address 16676
#define task_3_address 16732
#define task_4_address 16788

#define task_0_stack_size 1000
#define task_1_stack_size 1000
#define task_2_stack_size 1000
#define task_3_stack_size 1000
#define task_4_stack_size 1000

#define STACK_STARTS_AT 100000
#define task0_STACK_START STACK_STARTS_AT
#define task1_STACK_START task0_STACK_START+task_0_stack_size
#define task2_STACK_START task1_STACK_START+task_1_stack_size
#define task3_STACK_START task2_STACK_START+task_2_stack_size
#define task4_STACK_START task3_STACK_START+task_3_stack_size

extern struct task_struct task1;
extern struct task_struct task2;
extern struct task_struct task3;
extern struct task_struct task4;

extern int nr_running;
int mem_slots[MAX_MEMORY_SLOTS];

// --------------------------------------------------------------
// memory information gathering is here
// --------------------------------------------------------------








// ________________________________________________________________

  /* here the idea is to build structures manually in the beginning *
   * then for sys_fork automatically using some functions          */
/* r27 and r28 in pt_regs are frame pointe & stack pointer respectively*/

//  struct signal_struct sig4;
 struct mm_struct mm4={0,0,0,0,0,0,0,0,0,3,task_4_stack_size};
 struct pt_regs regs4={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,task4_STACK_START,task4_STACK_START,
			     0,0,task_4_address,0x0019,task_4_address,0
                              };

//   struct signal_struct sig3;
   struct mm_struct mm3={0,0,0,0,0,0,0,0,0,2,task_3_stack_size};
   struct pt_regs regs3={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                               0,0,0,0,0,0,0,task3_STACK_START,task3_STACK_START,
			       0,0,task_3_address,0x0019,task_3_address,0
                              };


//   struct signal_struct sig2;
   struct mm_struct mm2={0,0,0,0,0,0,0,0,0,1,task_2_stack_size};
   struct pt_regs regs2={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                               0,0,0,0,0,0,0,task2_STACK_START,task2_STACK_START,
			       0,0,task_2_address,0x0019,task_2_address,0
                              };


//   struct signal_struct sig1;
   struct mm_struct mm1={0,0,0,0,0,0,0,0,0,0,task_1_stack_size};
   struct pt_regs regs1={1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0,0,0,0,0,
                               0,0,0,0,0,0,0,task1_STACK_START,task1_STACK_START,
                               0,0,task_1_address,0x0019,task_1_address,0
                              };

struct mm_struct mm0= {0,0,0,0,0,0,0,0,0,0,task_0_stack_size};
struct pt_regs init_ptregs = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                              0,0,0,0,0,0,0,0,0,0,0,task0_STACK_START,
			      task0_STACK_START,0,0,task_0_address,0x0019,
			      task_0_address,0};


struct task_struct task1 = {TASK_RUNNING,1,10,NULL,NULL,&init_task,
/* next_run */  &task2,
/* counter  */  3,0,
/* pt_regs  */  &regs1,&mm1,&init_task,&init_task,NULL,NULL,NULL,NULL,
/* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
};


struct task_struct task2 =  {TASK_RUNNING,2,10,NULL,NULL,&task1,
    /* next_run */  &task3,
    /* counter  */  3,0,
    /* pt_regs  */  &regs2,&mm2,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };

struct task_struct task3 =  {TASK_RUNNING,3,10,NULL,NULL,&task2,
    /* next_run */  &task4,
    /* counter  */  3,0,
    /* pt_regs  */  &regs3,&mm3,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };



struct task_struct task4 =  {TASK_RUNNING,4,10,NULL,NULL,&task3,
    /* next_run */  &init_task,
    /* counter  */  3,0,
    /* pt_regs  */  &regs4,&mm4,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };






void initialize_memory(void)
{
  int i;
  long * pointer;
  /* making all the slots for thememory free for usage */
  for(i=0;i<MAX_MEMORY_SLOTS;i++)
    mem_slots[i] = 0;

  /* The start of stack is the Frame Pointer. Here we make the first FP
     points to itself. That is the contents of the address in FP has the 
     address in which it is stored */

  pointer  = (long *)task0_STACK_START;
  *pointer  = task0_STACK_START;  

   pointer  = (long *)task1_STACK_START;
  *pointer  = task1_STACK_START;

   pointer  = (long *)task2_STACK_START;
  *pointer  = task2_STACK_START;

  pointer  = (long *)task3_STACK_START;
  *pointer  = task3_STACK_START;

   pointer  = (long *)task4_STACK_START;
  *pointer  = task4_STACK_START;
  
  } 


void start_kernel(void)
{
  initialize_memory();

 
  mem_slots[3] = 1;  //fourth slot occupied


  
  mem_slots[2] = 1;  //third slot occupied


  mem_slots[1] = 1;  //second slot occupied


  mem_slots[0] = 1;  //first slot occupied

  Global_Pid  = 5; // this could be useful after sys_fork is implemented

  current = &task1; /*points to currect task under execution */
  RESTORE_USR_PT_REGS 

  asm("ldra r17,KERNEL_FP\n\t"
      "st FP,r17,0\n\t"
      "ldra r17,KERNEL_SP\n\t"
      "st SP,r17,0\n\t"
      "enable_interrupts\n\t");// saving kernel fp into a variable kernel_fpx
  
  //  RESTORE_ALL

  servicing_syscall = 0;
  servicing_interrupt = 0;
asm("retu\n\t"
"nop\n\t"
"nop\n\t");
}


void Print_Runqueue( )
{
	struct task_struct* tmp_init = init_task.next_run;


	//Adding these printf bcos PrintTaskStruct doesnt print INIT
	//       printf("\n\nPID:: 0,  PRIORITY:: 1 ----> INIT\n");

      while ( tmp_init != &init_task)
	{
	  //              printf("PID:: %d,  PRIORITY:: %d\n",tmp_init->pid, tmp_init->priority);
	      tmp_init=tmp_init->next_run;
	}	;       

}


int maintain()
{ 
  /* set2 sp and fp are to be initialized here, i forgot them .. let me 
     initialize them in boot.x  bcos main willbe called after boot.x  */

  start_kernel();
  asm("\n\tretu\n\t"
      "nop\n\t"
      "nop\n\t"); //these are never executed
  return 0; 
}

void idle_brain()
{long tin;
  asm("\n\tei    \n\t"
      "nop   \n\t");
  for(;;)
    {
      for(tin=0;tin < 1000000;tin++)
	{}
      dummy_idle_brain();  /*dummy sys_call to check if any interrupt changed
                            anything on the runqueue */
    }
}


asm("\n.global system_call_table\n\t"
"\n.data"
	"\n.align 2"
"\nsystem_call_table:"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_getpid"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_pause"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_nice"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_geteuid"
	"\n.word sys_getegid"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_getppid"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_reboot"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_getpriority"
	"\n.word sys_setpriority"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_idle"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_sched_setparam"
	"\n.word nosys"
	"\n.word sys_sched_setscheduler"
	"\n.word sys_sched_getscheduler"
	"\n.word sys_sched_yield"
	"\n.word sys_sched_get_priority_max"
	"\n.word sys_sched_get_priority_min"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word nosys"
	"\n.word sys_dummy_idle_brain"
	"\n.word sys_malloc"
	"\n.word sys_free"
	"\n.word nosys"
	"\n.word nosys\n\t");
 


int i,j,k,l;
void application()
{


asm(".text\n\t"
    ".code32\n\t");

asm("\nLL1:\n");
i = getpid();        
asm("xor r0,r0,r0\n\t"
    "ldra r0,i\n\t"
    "ld r0,r0,0\n\t"
    "nop\n\t"
    "addu r1,r1,r0\n\t"
    "jmp LL1\n\t"
    "nop\n\t"); 
    
asm("\nLL2:\n");
j = getpid();        
asm("xor r0,r0,r0\n\t"
    "ldra r0,j\n\t"
    "ld r0,r0,0\n\t"
    "nop\n\t"
    "addu r2,r2,r0\n\t"
    "jmp LL2\n\t"
    "nop\n\t");
    
asm("\nLL3:\n");
k = getpid();        
asm("xor r0,r0,r0\n\t"
    "ldra r0,k\n\t"
    "ld r0,r0,0\n\t"
    "nop\n\t"
    "addu r3,r3,r0\n\t"
    "jmp LL3\n\t"
    "nop\n\t"); 
    
asm("\nLL4:\n");
asm("	mov	r5,r27\n\t"
	"lli 	r10,48896\n\t"
	"lui	r10,65535\n\t"
	"lli	r11,0\n\t"
	"st 	r11,r10,0\n\t"
	"lli 	r10,0\n\t"
	"lli	r11,0\n\t"
	"jmp	LL4\n\t"
	"nop\n\t"
	"nop\n\t");

}