
/*                CUP-OS Assembly Instruction macros defined here           */
/*              --------------------------------------------------          */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

#ifndef __ALL_MACRO__
#define __ALL_MACRO__

#define CCB_BASE 0xffffbf00
#define CCB_END  0xffffffff

/* Important note here is that i am using definitions of variables that *
 * were defined in some other files here. As i intend to club all the files *
 * into one file manually i am not redefining then here. compiling this     *
 * single file will flood u with errors */


//**************************************************************************** 
//* Registers Usage only for SuperUser
//****************************************************************************
asm("FP = r27\n\t"
  "SP   = r28\n\t"
  "PSR  = r29\n\t"   
  "SPSR = r30\n\t"   
  "LR   = r31\n\t");

/*************************************************************************** 
 *      Macros 
 ****************************************************************************/

/* PUSH AND POP MACROS */
/* when pushed increments the stack pointer by 4 bytes and stores Register *
 * contents to it and similarly when poped loads register from stack and   *
 * decrements the stack by 4 bytes...as simple as it looks                 */

__asm__(".macro push(rname)\n\t" 
"addi SP,SP,-4\n\t"  
"st rname,SP,0\n\t"   
".endm\n\t"    

".macro pop(rname)\n\t" 
"ld rname,SP,0\n\t"    
"addi SP,SP,4\n\t"    
".endm\n\t");

/* MACRO TO USE SOURCE REGISTERS FROM TWO DIFFERENT SETS */

/* This is done by copying contents of reg of one set to reg of other set *
 * so that sources are now in one set after macro is done remember that   *
 * default set for READ and WRITE is SET2                                 */

__asm__ (".macro set1_to_set2(set1,set2)\n\t"
		     "chrs 2\n\t"       
		     "mov set2,set1\n\t" 
		     "chrs 3\n\t"        
		     ".endm\n\t");

__asm__ (".macro set2_to_set1(set2,set1)\n\t"
		     "chrs 1\n\t"       
		     "mov set1,set2\n\t" 
		     "chrs 3\n\t"       
		     ".endm\n\t");
/* get the address of Current task_struct into specified reg*/

__asm__ (".macro get_current(reg)\n\t"
	 "push r16\n\t"
	 "ldra r16,current\n\t"
	 "ld   reg,r16,0\n\t"
	 "pop  r16\n\t"
	 ".endm\n\t");

/* Load variable in the specified register */
__asm__ (".macro load_variable(variable,reg)\n\t"
         "ldra reg,variable\n\t"
         "ld reg,reg,0\n\t"
	 ".endm\n\t");

/* macro for siabling and enabling interrupts */
__asm__(".macro disable_interrupts\n\t"
	"di\n\t"
	"nop\n\t"
	".endm\n\t"	);
__asm__(".macro enable_interrupts\n\t"
	"ei\n\t"
	"nop\n\t"
	".endm\n\t"	);

/* These macros are used to block interrupts and restore them using      *
 * The INT_MASK register in CCB . Using this macros has an advantage     *
 * of restoring interrupts to their states that were before blocking them */
__asm__(".macro block_interrupts(variable)\n\t"
	"lli  r10,CCB_BASE_REMAPPED_LO\n\t" 
	"lui  r10,CCB_BASE_REMAPPED_HI\n\t"
	"ld   r11,r10,INT_MASK_OFFSET\n\t"
	"ldra r10,variable\n\t"
	"st   r11,r10,0\n\t"
	"di   \n\t"
	"nop  \n\t"
	".endm\n\t");

__asm__(".macro restore_interrupts(variable)\n\t"
	"ldra r10,variable\n\t"
	"ld   r11,r10,0\n\t"
	"lli  r10,CCB_BASE_REMAPPED_LO\n\t" 
	"lui  r10,CCB_BASE_REMAPPED_HI\n\t"
	"st   r11,r10,INT_MASK_OFFSET\n\t"
	"nop  \n\t"
	".endm\n\t");

	
	
#endif //__ALL_MACRO__
	