/*-----------------------------------------------------------------------------
 * Boot Sequence
 *-----------------------------------------------------------------------------
 * Author      : Nuguru Susheel Raj
 * Date        : 06/07/2005
 * Email       : susheel.nuguru@tut.fi
 * modified by : Nuguru Susheel Raj
 *-----------------------------------------------------------------------------
 */
 
/*-----------------------------------------------------------------------------
 * Core configuration register offsets. 
 *-----------------------------------------------------------------------------
  */
#define		CCB_BASE_AT_BOOT	0x00010000 
#define		CCB_BASE_OFFSET		0 
#define		CCB_END_OFFSET		1 
#define		COP0_INT_VEC_OFFSET	2 
#define		COP1_INT_VEC_OFFSET	3 
#define		COP2_INT_VEC_OFFSET	4 
#define		COP3_INT_VEC_OFFSET	5 
#define		EXT_INT0_VEC_OFFSET	6 
#define		EXT_INT1_VEC_OFFSET	7 
#define		EXT_INT2_VEC_OFFSET	8 
#define		EXT_INT3_VEC_OFFSET	9 
#define		EXT_INT4_VEC_OFFSET	10 
#define		EXT_INT5_VEC_OFFSET	11 
#define		EXT_INT6_VEC_OFFSET	12 
#define		EXT_INT7_VEC_OFFSET	13 
#define		INT_MODE_IL_OFFSET	14 
#define		INT_MODE_UM_OFFSET	15 
#define		INT_MASK_OFFSET		16 
#define		INT_SERV_OFFSET		17 
#define		INT_PEND_OFFSET		18 
#define		EXT_INT_PRI_OFFSET	19 
#define		COP_INT_PRI_OFFSET	20 
#define		EXCEPTION_CS_OFFSET	21 
#define		EXCEPTION_PC_OFFSET	22 
#define		EXCEPTION_PSR_OFFSET	23 
#define		DMEM_BOUND_LO_OFFSET	24 
#define		DMEM_BOUND_HI_OFFSET	25 
#define		IMEM_BOUND_LO_OFFSET	26 
#define		IMEM_BOUND_HI_OFFSET	27 
#define		MEM_PCONF_OFFSET	28 
#define		SYSTEM_ADDR_OFFSET	29 
#define		EXCEP_ADDR_OFFSET	30 
#define		WAIT_STATES_OFFSET	31 
#define		CREG_INDX_I_OFFSET	32 
#define		TMR0_CNT_OFFSET		33 
#define		TMR0_MAX_CNT_OFFSET	34 
#define		TMR1_CNT_OFFSET		35 
#define		TMR1_MAX_CNT_OFFSET	36 
#define		TMR_CONF_OFFSET		37 
#define		RETI_ADDR_OFFSET	38 
#define		RETI_PSR_OFFSET		39
#define		RETI_CR0		40



#define		CCB_BASE	0x00010000

/* Instruction memory and data memory wait cycles 1, cop zero. */
#define		WAIT_CYCLES		0x011
/* all ISR's executed in 32 bit mode */
#define		INT_MODE_IL		0xfff 
/* ISR should have superuser privilages */
#define		INT_MODE_UM		0
/* enable cop0..cop1 and int0...int3, and int7  */
#define		INT_MASK		0x08f3
#define		EXT_INT_PRI		0
#define		COP_INT_PRI		0

/* This were to protect CCB's At reset, its not neccesaary to protect
 * at reset as at boot they are being remmaped
 */

#define		DMEM_BOUND_LO_LS	0x0000
#define		DMEM_BOUND_LO_MS	0x0001
	
#define		DMEM_BOUND_HI_LS	0x00ff
#define		DMEM_BOUND_HI_MS	0x0001 

/* CCBs are remmaped at the end of this sequence so i am trying to protect
 * only that remapped area and remember to ddisable interrupts thoughout this
 * boot routine
 */
 
#define		DMEM_BOUND_LO_REMAPPED	0xffffbf00
	
#define		DMEM_BOUND_HI_REMAPPED	0xffffffff
	
/* Instruction memory visible for users(Read only) */
#define		IMEM_BOUND_LO		0 

#define		IMEM_BOUND_HI	0
	
/* nothing protected for making testing easy */
#define		MEM_PCONF		0x0000

/*  	Continuous interrupting mode for timer 0, timer 1 disabled 
 *	EN	31/15	EN = 1 enables timer. 
 *	CONT	30/14	CONT = 1: Continuous mode. 
 *	GINT	29/13	GINT = 1: Generate an interrupt when maximum count is reached. 
 *	WDOG	28/12	WDOG = 0: Enable watchdog function 
 *	-	27/11	Reserved, 0 or 1 can be written. 
 *	INTN	[26:24]/[10:8]	Bit field defining which interrupt to associate the timer with 
 *	DIV	[23:16]/ [7:0] = 0xFF = Decimal 255Divider value 
 
 *	Timer0 generates an interrupt every 10ms assuming 50MHz processor speed

 *	Writes to instruction memory are mapped to 
 *	0xffffc000...0xffffffff 
 *	via PCB address space, see COFFEE documentation. 
 */
 
 #define	CCB_BASE_REMAPPED	0xffffbf00
 #define	CCB_BASE_REMAPPED_LO	0xbf00
 #define	CCB_BASE_REMAPPED_HI	0xffff
 #define	CCB_END			0xffffffff
 #define	CCB_END_HI		0xffff
 #define	CCB_END_LO		0xffff
 
 /* TIMER 1 diabled */
 #define	TMR1_CONF		0x0000
 /* TIMER 0 active */
 #define	TMR0_CONF		0xe7ff
 
 /* This need to be changed if any of the above two are changed */
 #define 	TMR_CONF                0x0000e7ff
 
 /*  10ms tick assuming 50MHz processor Speed */
 #define	TMR0_MAX_CNT		0x7A120
 #define	TMR0_MAX_CNT_LO         0xA120
 #define	TMR0_MAX_CNT_HI         0x0007
 #define	TMR1_MAX_CNT		0
 /* Stack and Frame Pointers need to be changed as required */
 #define	STACKPOINTER_VALUE_AT_INIT_LO	0x1234
 #define	STACKPOINTER_VALUE_AT_INIT_HI	0x5678
 
 #define	FRAMEPOINTER_VALUE_AT_INIT_LO   0x1234
 #define	FRAMEPOINTER_VALUE_AT_INIT_HI   0x5678
 
 /* Some more defines */ 
 #define	SPSR        r30
 #define	LR          r31
 #define	FP	    r27
 #define	SP	    r28
 
 typedef char _u8;
 
 /* As these are memory mapped registers which are one byte spaced from each other */
 struct ccb_block {
  _u8 ccb_base;
  _u8 ccb_end;
  _u8 cop0_int_vec;
  _u8 cop1_int_vec;
  _u8 cop2_int_vec;
  _u8 cop3_int_vec;
  _u8 ext_int0_vec;
  _u8 ext_int1_vec;
  _u8 ext_int2_vec;
  _u8 ext_int3_vec;
  _u8 ext_int4_vec;
  _u8 ext_int5_vec;
  _u8 ext_int6_vec;
  _u8 ext_int7_vec;
  _u8 int_mode_il;
  _u8 int_mode_um;
  _u8 int_mask;
  _u8 int_serv;
  _u8 int_pend;
  _u8 ext_int_pri;
  _u8 cop_int_pri;
  _u8 exception_cs;
  _u8 exception_pc;
  _u8 exception_psr;
  _u8 dmem_bound_lo;
  _u8 dmem_bound_hi;
  _u8 imem_bound_lo;
  _u8 imem_bound_hi;
  _u8 mem_conf;
  _u8 system_addr;
  _u8 excep_addr;
  _u8 bus_conf;
  _u8 cop_conf;
  _u8 tmr0_cnt;
  _u8 tmr0_max_cnt;
  _u8 tmr1_cnt;
  _u8 tmr1_max_cnt;
  _u8 tmr_conf;
  _u8 reti_addr;
  _u8 reti_psr;
  _u8 reti_cr0;
 };
 
static struct ccb_block *ccb_block_ptr = (struct ccb_block *)CCB_BASE; //ptr points to start of CCB block
 

void start_of_boot()
{
    
/* compile assigning 4 bytes for type char, I thouhgt it was one byte !!!!
 * each entry should just take one byte in the structure but it is taking
 * 4 (four) so Lets try the other way */
 
/* 
    ccb_block_ptr->ccb_end            = CCB_END;
    ccb_block_ptr->ccb_base           = CCB_BASE_REMAPPED; // now CCB_BLOCK is moved
    ccb_block_ptr->cop0_int_vec       = Co_Processor0_INT_ISR; //in entry.c file
    ccb_block_ptr->cop1_int_vec       = Co_Processor1_INT_ISR; 
    ccb_block_ptr->cop2_int_vec       = Co_Processor2_INT_ISR; 
    ccb_block_ptr->cop3_int_vec       = Co_Processor3_INT_ISR; 
    ccb_block_ptr->ext_int0_vec       = EXT_INT0_ISR;	      //in entry.c file
    ccb_block_ptr->ext_int1_vec       = EXT_INT1_ISR;	      
    ccb_block_ptr->ext_int2_vec       = EXT_INT2_ISR;	      
    ccb_block_ptr->ext_int3_vec       = EXT_INT3_ISR;	      
    ccb_block_ptr->ext_int4_vec       = EXT_INT4_ISR;	      
    ccb_block_ptr->ext_int5_vec       = EXT_INT5_ISR;	      
    ccb_block_ptr->ext_int6_vec       = EXT_INT6_ISR;	      
    ccb_block_ptr->ext_int7_vec       = EXT_INT7_ISR;
    ccb_block_ptr->int_mode_il	      = INT_MODE_IL;
    ccb_block_ptr->int_mode_um        = INT_MODE_UM;
    ccb_block_ptr->int_mask           = INT_MASK;
    ccb_block_ptr->ext_int_pri        = EXT_INT_PRI;
    ccb_block_ptr->cop_int_pri        = COP_INT_PRI;
    ccb_block_ptr->dmem_bound_lo      = DMEM_BOUND_LO_REMAPPED;
    ccb_block_ptr->dmem_bound_hi      = DMEM_BOUND_HI_REMAPPED;
    ccb_block_ptr->imem_bound_lo      = IMEM_BOUND_LO;
    ccb_block_ptr->imem_bound_hi      = IMEM_BOUND_HI;
    ccb_block_ptr->mem_conf	      = MEM_PCONF;
    ccb_block_ptr->system_addr	      = system_call;
    ccb_block_ptr->excep_addr	      = exception_handler;
    ccb_block_ptr->bus_conf	      = WAIT_CYCLES;
    ccb_block_ptr->tmr0_cnt	      = 0;
    ccb_block_ptr->tmr0_max_cnt       = TMR0_MAX_CNT;
    ccb_block_ptr->tmr1_cnt	      = 0;
    ccb_block_ptr->tmr_conf	      = TMR_CONF;
    
*/    


    *(ccb_block_ptr + CCB_END_OFFSET)           = CCB_END;
    *(ccb_block_ptr + CCB_BASE_OFFSET)          = CCB_BASE_REMAPPED; 		/* now CCB_BLOCK is moved */
    *(ccb_block_ptr + COP0_INT_VEC_OFFSET)      = Co_Processor0_INT_ISR; 	/* In entry.c file */
    *(ccb_block_ptr + COP1_INT_VEC_OFFSET)      = Co_Processor1_INT_ISR; 
    *(ccb_block_ptr + COP2_INT_VEC_OFFSET)      = Co_Processor2_INT_ISR; 
    *(ccb_block_ptr + COP3_INT_VEC_OFFSET)      = Co_Processor3_INT_ISR; 
    *(ccb_block_ptr + EXT_INT0_VEC_OFFSET)      = EXT_INT0_ISR;	      		/* in entry.c file */
    *(ccb_block_ptr + EXT_INT1_VEC_OFFSET)      = EXT_INT1_ISR;	      
    *(ccb_block_ptr + EXT_INT2_VEC_OFFSET)      = EXT_INT2_ISR;	      
    *(ccb_block_ptr + EXT_INT3_VEC_OFFSET)      = EXT_INT3_ISR;	      
    *(ccb_block_ptr + EXT_INT4_VEC_OFFSET)      = EXT_INT4_ISR;	      
    *(ccb_block_ptr + EXT_INT5_VEC_OFFSET)      = EXT_INT5_ISR;	      
    *(ccb_block_ptr + EXT_INT6_VEC_OFFSET)      = EXT_INT6_ISR;	      
    *(ccb_block_ptr + EXT_INT7_VEC_OFFSET)      = EXT_INT7_ISR;
    *(ccb_block_ptr + INT_MODE_IL_OFFSET)       = INT_MODE_IL;
    *(ccb_block_ptr + INT_MODE_UM_OFFSET)       = INT_MODE_UM;
    *(ccb_block_ptr + INT_MASK_OFFSET)          = INT_MASK;
    *(ccb_block_ptr + EXT_INT_PRI_OFFSET)       = EXT_INT_PRI;
    *(ccb_block_ptr + COP_INT_PRI_OFFSET)       = COP_INT_PRI;
    *(ccb_block_ptr + DMEM_BOUND_LO_OFFSET )    = DMEM_BOUND_LO_REMAPPED;
    *(ccb_block_ptr + DMEM_BOUND_HI_OFFSET)     = DMEM_BOUND_HI_REMAPPED;
    *(ccb_block_ptr + IMEM_BOUND_LO_OFFSET)     = IMEM_BOUND_LO;
    *(ccb_block_ptr + IMEM_BOUND_HI_OFFSET)     = IMEM_BOUND_HI;
    *(ccb_block_ptr + MEM_PCONF_OFFSET)	        = MEM_PCONF;
    *(ccb_block_ptr + SYSTEM_ADDR_OFFSET)	= system_call;
    *(ccb_block_ptr + EXCEP_ADDR_OFFSET)	= exception_handler;
    *(ccb_block_ptr + WAIT_STATES_OFFSET)	= WAIT_CYCLES;
    *(ccb_block_ptr + TMR0_CNT_OFFSET)	        = 0;
    *(ccb_block_ptr + TMR0_MAX_CNT_OFFSET)      = TMR0_MAX_CNT;
    *(ccb_block_ptr + TMR1_CNT_OFFSET)	        = 0;
    *(ccb_block_ptr + TMR_CONF_OFFSET)          = TMR_CONF;
    
    
/* Initializing Stack registers  */

    asm("\n\tSTACKPOINTER_VALUE_AT_INIT_LO	= 0x1234" 
 	"\n\tSTACKPOINTER_VALUE_AT_INIT_HI	= 0x5678"
	"\n\tFRAMEPOINTER_VALUE_AT_INIT_LO      = 0x1234"
	"\n\tFRAMEPOINTER_VALUE_AT_INIT_HI      = 0x5678"
	"\n\tlli	SP,STACKPOINTER_VALUE_AT_INIT_LO"
	"\n\tlui	SP,STACKPOINTER_VALUE_AT_INIT_HI"
	"\n\tst 	SP,SP,0"
	"\n\tlli 	FP,FRAMEPOINTER_VALUE_AT_INIT_LO"
	"\n\tlui	FP,FRAMEPOINTER_VALUE_AT_INIT_HI"
	"\n\tst 	FP,FP,0");
	
maintain();  /* Jump to maintain() in main.c file */
    
}
asm("\n\tEXCEPTION_CS_OFFSET = 21\n");// This is for the exception handler which needs this offset in entry.c file assembly code













	 