//-----------------------------------------------------------------------------
// Boot Sequence 
//-----------------------------------------------------------------------------
// Author      : Nuguru Susheel Raj
// Date        : 15/09/2004 
// Email       : gadipudi@cs.tut.fi
// modified by : Nuguru Susheel Raj
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Core configuration register offsets. 
//-----------------------------------------------------------------------------
	CCB_BASE_AT_BOOT       		= 0x0001000 
	CCB_BASE_OFFSET			= 0 
	CCB_END_OFFSET			= 1 
	COP0_INT_VEC_OFFSET		= 2 
	COP1_INT_VEC_OFFSET		= 3 
	COP2_INT_VEC_OFFSET		= 4 
	COP3_INT_VEC_OFFSET		= 5 
	EXT_INT0_VEC_OFFSET		= 6 
	EXT_INT1_VEC_OFFSET		= 7 
	EXT_INT2_VEC_OFFSET		= 8 
	EXT_INT3_VEC_OFFSET		= 9 
	EXT_INT4_VEC_OFFSET		= 10 
	EXT_INT5_VEC_OFFSET		= 11 
	EXT_INT6_VEC_OFFSET		= 12 
	EXT_INT7_VEC_OFFSET		= 13 
	INT_MODE_IL_OFFSET		= 14 
	INT_MODE_UM_OFFSET		= 15 
	INT_MASK_OFFSET			= 16 
	INT_SERV_OFFSET			= 17 
	INT_PEND_OFFSET			= 18 
	EXT_INT_PRI_OFFSET		= 19 
	COP_INT_PRI_OFFSET		= 20 
	EXCEPTION_CS_OFFSET		= 21 
	EXCEPTION_PC_OFFSET		= 22 
	EXCEPTION_PSR_OFFSET		= 23 
	DMEM_BOUND_LO_OFFSET		= 24 
	DMEM_BOUND_HI_OFFSET		= 25 
	IMEM_BOUND_LO_OFFSET		= 26 
	IMEM_BOUND_HI_OFFSET		= 27 
	MEM_PCONF_OFFSET		= 28 
	SYSTEM_ADDR_OFFSET		= 29 
	EXCEP_ADDR_OFFSET		= 30 
	WAIT_STATES_OFFSET		= 31 
	CREG_INDX_I_OFFSET		= 32 
	TMR0_CNT_OFFSET			= 33 
	TMR0_MAX_CNT_OFFSET		= 34 
	TMR1_CNT_OFFSET			= 35 
	TMR1_MAX_CNT_OFFSET		= 36 
	TMR_CONF_OFFSET			= 37 
	RETI_ADDR_OFFSET		= 38 
	RETI_PSR_OFFSET			= 39
	RETI_CR0			= 40
 

// Initialising the CCB registers
	
//	CCB_BASE =  0x00010000

// Instruction memory and data memory wait cycles 1, cop zero. 
	WAIT_CYCLES 	= 0x011

        INT_MODE_IL = 0xfff// all ISR's executed in 32 bit mode
	
        INT_MODE_UM = 0  // ISR should have superuser privilages

	// enable cop0..cop1 and int0...int3, and int7 
	INT_MASK = 0x08f3

	EXT_INT_PRI = 0  //highly prioritized (all of them)
	COP_INT_PRI = 0
	
// This were to protect CCB's At reset, its not neccesaary to protect
// at reset as at boot they are being remmaped

//	DMEM_BOUND_LO_LS = 0x0000 //Just trying to protect CCB from user access
//	DMEM_BOUND_LO_MS = 0x0001 //
	
//	DMEM_BOUND_HI_LS = 0x00ff // 256B boundry
//	DMEM_BOUND_HI_MS = 0x0001 

// CCBs are remmaped at the end of this sequence so i am trying to protect
// only that remapped area and remember to ddisable interrupts thoughout this
// boot routine
   
	DMEM_BOUND_LO_REMAPPED_LS	= 0xbf00 
	DMEM_BOUND_LO_REMAPPED_MS	= 0xffff

	DMEM_BOUND_HI_REMAPPED_LS = 0xffff // 256B boundry
	DMEM_BOUND_HI_REMAPPED_MS = 0xffff
	
	IMEM_BOUND_LO_LS = 0 // Instruction memory visible for users(Read only)
	IMEM_BOUND_LO_MS = 0 //
	
	IMEM_BOUND_HI_LS = 0x0000 //only until the end of the kernel
	IMEM_BOUND_HI_MS = 0x0000
	
	MEM_PCONF = 0x0000 //nothing protected for making testing easy

//--------------------------------------------------------------------
	
	// Continuous interrupting mode for timer 0, timer 1 disabled 
	//EN	31/15	EN = 1 enables timer. 
	//CONT	30/14	CONT = 1: Continuous mode. 
	//GINT	29/13	GINT = 1: Generate an interrupt when maximum count is reached. 
	//WDOG	28/12	WDOG = 0: Enable watchdog function 
	//-	27/11	Reserved, 0 or 1 can be written. 
	//INTN	[26:24]/[10:8]	Bit field defining which interrupt to associate the timer with 
	//DIV	[23:16]/ [7:0] = 0xFF = Decimal 255Divider value 
 
	// Timer0 generates an interrupt every 10ms assuming 50MHz processor speed

	// Writes to instruction memory are mapped to 
	// 0xffffc000...0xffffffff 
	// via PCB address space, see COFFEE documentation. 
	CCB_BASE_REMAPPED	= 0xffffbf00 // 0xffffc000 - 0x100 
	CCB_BASE_REMAPPED_LO	= 0xbf00 
	CCB_BASE_REMAPPED_HI	= 0xffff

	CCB_END_LO		= 0xffff 
	CCB_END_HI		= 0xffff 

// I dont know if timer value is reasonable.Ihave to try it checking practically// and then put some optimal value.
	
	TMR1_CONF			= 0x0000 // TIMER 1 diabled
	TMR0_CONF			= 0xe7ff // TIMER 0 active

	TMR0_MAX_CNT		     	= 0x7A120  // 10ms tick assuming 50MHz processor Speed
        TMR0_MAX_CNT_LO                 = 0xA120
        TMR0_MAX_CNT_HI                 = 0x0007
	
	TMR1_MAX_CNT		     	= 0       // disabled

 	STACKPOINTER_VALUE_AT_INIT_LO	= 0x1234  //need to be changed 
 	STACKPOINTER_VALUE_AT_INIT_HI	= 0x5678  //need to be changed

	FRAMEPOINTER_VALUE_AT_INIT_LO      = 0x1234  //need to be changed   
	FRAMEPOINTER_VALUE_AT_INIT_HI      = 0x5678  //need to be changed
 
//-----------------------------------------------------------------------------
// reg aliases. These refer to super user register bank! 
//-----------------------------------------------------------------------------
	data           = r10
	addr           = r11 
	SPSR           = r30 
	LR             = r31
	FP	       = r27
        SP	       = r28 

//-----------------------------------------------------------------------------
// CCB initialization. Interrupt vectors, memory configuration etc... 
//-----------------------------------------------------------------------------
 
.text
.code 32 
BOOT_ROUTINE:
	        xor	addr, addr, addr
	        lui	addr,1
		lli	data,CCB_END_LO
		lui	data,CCB_END_HI
		st	data,addr,CCB_END_OFFSET

		lli	data, CCB_BASE_REMAPPED_LO 
		lui	data, CCB_BASE_REMAPPED_HI 
		st	data, addr, CCB_BASE_OFFSET 

		lli 	addr,CCB_BASE_REMAPPED_LO
		lui	addr,CCB_BASE_REMAPPED_HI

		ldra    data,Co_Processor0_INT_ISR   // in entry.c file
	        st	data,addr,COP0_INT_VEC_OFFSET

		ldra    data,Co_Processor1_INT_ISR  
	        st	data,addr,COP1_INT_VEC_OFFSET

		ldra    data,Co_Processor2_INT_ISR  
	        st	data,addr,COP2_INT_VEC_OFFSET

		ldra    data,Co_Processor3_INT_ISR  
	        st	data,addr,COP3_INT_VEC_OFFSET

		ldra    data,EXT_INT0_ISR 
	        st	data,addr,EXT_INT0_VEC_OFFSET

		ldra    data,EXT_INT1_ISR 
	        st	data,addr,EXT_INT1_VEC_OFFSET

		ldra    data,EXT_INT2_ISR 
	        st	data,addr,EXT_INT2_VEC_OFFSET

		ldra    data,EXT_INT3_ISR 
	        st	data,addr,EXT_INT3_VEC_OFFSET

		ldra    data,EXT_INT4_ISR 
	        st	data,addr,EXT_INT4_VEC_OFFSET

		ldra    data,EXT_INT5_ISR 
	        st	data,addr,EXT_INT5_VEC_OFFSET

		ldra    data,EXT_INT6_ISR 
	        st	data,addr,EXT_INT6_VEC_OFFSET

   //     timer Interrupt Service Routine is addressed here 

		ldra    data,EXT_INT7_ISR 
	        st	data,addr,EXT_INT7_VEC_OFFSET

		lli	data,INT_MODE_IL
		st	data,addr,INT_MODE_IL_OFFSET

		lli	data,INT_MODE_UM  
		st	data,addr,INT_MODE_UM_OFFSET

		lli	data,INT_MASK
		st	data,addr,INT_MASK_OFFSET

		lli	data,EXT_INT_PRI
		st	data,addr,EXT_INT_PRI_OFFSET

		lli	data,COP_INT_PRI
		st	data,addr,COP_INT_PRI_OFFSET

		lli	data,DMEM_BOUND_LO_REMAPPED_LS
		lui	data,DMEM_BOUND_LO_REMAPPED_MS
		st	data,addr,DMEM_BOUND_LO_OFFSET

		lli	data,DMEM_BOUND_HI_REMAPPED_LS
		lui	data,DMEM_BOUND_HI_REMAPPED_MS
		st	data,addr,DMEM_BOUND_HI_OFFSET

		lli	data,IMEM_BOUND_LO_LS
		lui	data,IMEM_BOUND_LO_MS
		st	data,addr,IMEM_BOUND_LO_OFFSET

		lli	data,IMEM_BOUND_HI_LS
		lui	data,IMEM_BOUND_HI_MS
		st	data,addr,IMEM_BOUND_HI_OFFSET

		lli	data,MEM_PCONF
		st	data,addr,MEM_PCONF_OFFSET

		ldra	data,system_call
		st	data,addr,SYSTEM_ADDR_OFFSET

		ldra	data,exception_handler
		st	data,addr,EXCEP_ADDR_OFFSET

		lli	data,WAIT_CYCLES
		st	data,addr,WAIT_STATES_OFFSET

		lli	data, 0 
		st	data, addr, TMR0_CNT_OFFSET 
		st	data, addr, TMR1_CNT_OFFSET 

	 	lli	data, TMR0_MAX_CNT_LO
	 	lui	data, TMR0_MAX_CNT_HI
		st	data, addr, TMR0_MAX_CNT_OFFSET 

 		lli	data, TMR1_MAX_CNT 
		st	data, addr, TMR1_MAX_CNT_OFFSET 

 		lli	data, TMR0_CONF 
		lui	data, TMR1_CONF 
		st	data, addr, TMR_CONF_OFFSET

		lli	SP,STACKPOINTER_VALUE_AT_INIT_LO
		lui	SP,STACKPOINTER_VALUE_AT_INIT_HI

		lli 	FP,FRAMEPOINTER_VALUE_AT_INIT_LO
		lui	FP,FRAMEPOINTER_VALUE_AT_INIT_HI
		st 	FP,FP,0

		ldri	addr,maintain
		jmp	maintain

			
