/*--------------------------------------------------------------------------*/
/*                 CUP-OS  Syscall,INT and Exception handlers               */
/*              -----------------------------------------------             */
/*  Author   :	Nuguru Susheel Raj                                          */
/*  Email    :	susheel.nuguru@tut.fi                                       */
/*  File     :  entry.c                                                     */
/*  modified :  14/09/2004                                                  */
/*--------------------------------------------------------------------------*/

#include "entry.h"
#include "sched.h"
#include "sys.h"

#define KERNEL_STACK_POINTER 0x10000000


long KERNEL_FP = KERNEL_STACK_POINTER;
long KERNEL_SP = KERNEL_STACK_POINTER;
unsigned long exception_code;
unsigned long int_mask_int; // for interrupts
unsigned long int_mask_excep; // for exceptions
unsigned int servicing_syscall = 0; /* an interrupt may occer when the processor is executing user tasks or when executing systemcall. This variable along with servicing_interrupt will let us know if user tasks were running before interrupt occured or system task was executing before interrupt occured*/

long servicing_interrupt = 0; /* This will tell us if interrupt occured
while servicing and interrupt  */
//asm(".data\n\t\t"
//    ".globl ret_from_sys_call\n\t\t");

/* Macro to add syscall_address into its address with the assumption  *
 * that r16 has address of system_call_table[]'s arrayth address to which this * * entry should be added                                              */

asm(".text\n\t"
    ".global ret_from_sys_call\n\t\t"
    ".align 2\n\t"
    ".global reschedule\n\t"
    ".align 2\n\t"
    ".code32\n\t"
    "reschedule: \n\t"
    "ldra r16,need_resched\n\t "
    "lli r17,0\n\t"
    "st r17,r16,0\n\t");
SAVE_USR_PT_REGS   // here there is possiility that the task may change
asm("ldra r16,schedule\n\t"
    "push r31\n\t"
    "jalr r16\n\t"
    "nop\n\t"
    "nop\n\t"
    "pop r31\n\t");
RESTORE_USR_PT_REGS

     /* here the current process may be different or same one which made the system call,
        restoring the R0 which contains the system return value for the current process that
        madea  system call this time if the scheduler did not change the 
        selection, else if it made the change it is the return value of the
        system call made by the process last time when it got the cpu time*/
     
     /* Restoring R0 (return value of the system call Related to the 
        newly selected process), R0 goes to its own process and restored */

       asm("ldra r16,current\n\t"  
       "ld   r1,r16,0\n\t"     
       "addiu r1,r1,pt_regs\n\t"   
       "ld r1,r1,0\n\t"
       "addiu r1,r1,140\n\t"
       "ld r0,r1,0\n\t"
       "chrs 1\n\t"
       "mov r0,r0\n\t"
       "chrs 3\n\t");

     /* DONE restoring of R0 value related to the current new process 
        or the old one if the scheduler didnt change anything */
asm("ldra r16,servicing_syscall\n\t"
    "lli  r17,0\n\t"
    "st   r17,r16,0\n\t");
	
      asm("enable_interrupts\n\t");
  //  RESTORE_ALL
asm("retu\n\t"
"nop\n\t"
"nop\n\t");


    

/* even if the interrupts are enabled in kernel routines it should 
   work fine ..lets test it and find it out in thetesting phase */

extern void system_call(void)
{ 
  current->syscall_called_timer = 0; //time units since syscall called
 servicing_syscall = 1;//switch from task to kernel is true
 asm("disable_interrupts\n\t");
   
 //    SAVE_ALL
  /* Scheduler when selects a new process then it just r        */
  
     SAVE_STACK_POINTER
     MOVE_INCOMING_ARGUMENTS //incoming arugments from set1 to set2


   asm("ldra r16,NR_systemcall\n\t"
       "ld r16,r16,0\n\t"
       "cmp c0,r5,r16\n\t"    
       "bgt c0,ret_from_sys_call\n\t"
       "nop\n\t"
       "ldra r16,system_call_table\n\t"
       "muli r6,r5,4\n\t"
       "addu r16,r16,r6\n\t"
       "ld r16,r16,0\n\t"
       "push r5\n\t"
       "push r31\n\t"
       "jalr r16\n\t"
       "nop\n\t"
       "pop r31\n\n"
       "pop r5\n\t"
       
       "ret_from_sys_call :\n\t"
       "ldra r16,NR_systemcall\n\t"
       "ld r16,r16,0\n\t"
       "cmp c0,r5,r16\n\t"
       "belt c0,extf2\n\t"
       "nop\n\t"
       "lli r0,38\n\t"    //ENOSYS	38	/* systemcall not implemented or syscall number overflow*/
       //"jmp extf3\n\t"
       //"nop\n\t"

/*   Because there is no guarentee that the task that made a valid system call will continue before      *
 *   readings its return value in register R0, we will put this value  into *
 *   USR_PT_REGS register 0 */

       "extf2      :\n\t"
       "ldra r16,current\n\t"  
       "ld   r1,r16,0\n\t"     
       "addiu r1,r1,pt_regs\n\t"   
       "ld r1,r1,0\n\t"
       "st r0,r1,0\n\t"  // in user register current->pt_reg->r0 memory space 
       "addiu r1,r1,140\n\t"
       "st r0,r1,0\n\t"      
      /*-------------------Done Saving R0-------------------*/
/* Here the current task may change, that is why system call return value was saved into user registers
    before schedule() have chances to change the task.. doesnt look optimum but really secure way  */
    
       "extf3      :\n\t"
       "ldra r16,need_resched\n\t"
       "ld r16,r16,0\n\t"
       "cmpi c0,r16,0\n\t"
       "beq  c0,extf4\n\t"
       "nop\n\t"
       "ldra r16,reschedule\n\t"
       "jmpr r16\n\t"
       "nop\n\t"
       "nop\n\t"
       "extf4:\n\t"

     /* here the current process may be different or same one which made the system call,
        restoring the R0 which contains the system return value for the current process that
        madea  system call this time if the scheduler did not change the 
        selection, else if it made the change it is the return value of the
        system call made by the process last time when it got the cpu time*/
     
     /* Restoring R0 (return value of the system call Related to the 
        newly selected process), R0 goes to its own process and restored */

       "ldra r16,current\n\t"  
       "ld   r1,r16,0\n\t"     
       "addiu r1,r1,pt_regs\n\t"   
       "ld r1,r1,0\n\t"
       "addiu r1,r1,140\n\t"
       "ld r0,r1,0\n\t"
       "chrs 1\n\t"
       "mov r0,r0\n\t"
       "chrs 3\n\t");

     /* DONE restoring of R0 value related to the current new process 
        if scheuler is called, else the old one if it isnt called */

  RESTORE_STACK_POINTER
 
  servicing_syscall = 0; //switched from task to kernel is false
    asm("enable_interrupts\n\t");
  //  RESTORE_ALL
asm("retu\n\t"
"nop\n\t"
"nop\n\t");
}

/*---------------Done With Scall Handler------------------------*/

static void interrupt_handler(void)
{
 long timer_interrupt = 0;

  asm("START_INTERRUPT_HANDLER:\n\t"
      "block_interrupts int_mask_int\n\t");

    if(servicing_syscall != 0  || servicing_interrupt != 0)
    { 
	SAVE_ALL }                                  /* save only when kernel registers were in use 
	                                           * previously */ 
    /* if interrupt occured while kernel service routine continue with
the same stack usage which was used to service the syscall ...else if the
interrupt occured while appllication was running then shift to kernel stack*/
    if(servicing_syscall == 1 || servicing_interrupt >= 1)
      {
        servicing_interrupt += 1;
	/* if anything goes wrong try not storing SP and FP in KERNEL_SP
   and KERENL_FP respectively */

	asm("push r17\n\t"
	    "push r16\n\t"
	    "ldra r17,KERNEL_FP\n\t"
	    "ld   r16,r17,0\n\t"
	    "push r16\n\t"
	    "st   FP,r17,0\n\t"
	    "ldra r17,KERNEL_SP\n\t"
	    "ld   r16,r17,0\n\t"
	    "push r16\n\t"
	    "st   SP,r17,0\n\t"
	    "jmpr r31\n\t"
	    "nop  \n\t");
      }
    else
      {
        servicing_interrupt = 1;
	servicing_syscall = 0;

 /* set1 SP and FP are undisturbed which have task stack information only 
    set2 SP and FP are corrupted which has no stack information of the kernel
    at this point */
/*	asm("push r17\n\t"
	    "ldra r17,KERNEL_FP\n\t"   
	    "ld   FP,r17,0\n\t"
	    "ldra r17,KERNEL_SP\n\t"            
	    "ld   SP,r17,0\n\t"
	    "pop r17\n\t"
	    "jmpr r31\n\t"
	    "nop  \n\t");
      */
      
 /* still here???FIXME so these two lines are here */
      asm(  "jmpr r31\n\t"
	    "nop  \n\t");
      }

  asm("Co_Processor0_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor1_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor2_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor3_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT0_ISR:\n\t\t" 
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT1_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT2_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT3_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT4_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT5_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT6_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"


/* Timer interrupt service routine is here */
      "EXT_INT7_ISR: \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,update_process_times\n\t"
      "push LR\n\t"
      "jalr r16\n\t"
      "nop  \n\t"
      "pop  LR\n\t\t");
      
      //asm("ldra r16,final\n\t\t"
      //"jmpr r16\n\t\t"
      //"nop  \n\t");

  asm("final:\n\t");
   if((servicing_syscall == 1)|| (servicing_interrupt > 1))
      {
       if(servicing_interrupt > 1)
          servicing_interrupt -= 1 ;
       else
	 {
	   servicing_interrupt = 0;
	   servicing_syscall = 1;
         }
	asm("ldra r17,KERNEL_SP\n\t"
	    "ld SP,r17,0\n\t"
	    "pop r16\n\t"
	    "st r16,r17,0\n\t"
	    "ldra r17,KERNEL_FP\n\t"
	    "ld FP,r17,0\n\t"
	    "pop r16\n\t"
	    "st r16,r17,0\n\t"
	    "pop r16\n\t"
	    "pop r17\n\t");
      }
    else
      {
	servicing_interrupt = 0;
        servicing_syscall = 0;  
	asm("ldra r17,KERNEL_FP\n\t"   
	    "ld   FP,r17,0\n\t");
      }

    if(servicing_syscall != 0  || servicing_interrupt != 0) 
    {     
	RESTORE_ALL
    }
    asm("restore_interrupts int_mask_int\n\t"
	"reti\n\t\t"
	"nop\n\t\t"
	"nop\n\t"
	"nop\n\t");

}

static void exception_handler(void)
{
  /* get the exception code*/
  asm("block_interrupts int_mask_excep\n\t"
      "lli r16,0xbf00\n\t"
      "lui r16,0xffff\n\t"
      "ld  r17,r16,EXCEPTION_CS_OFFSET\n\t"
      "ldra r18,exception_code\n\t"
      "st  r17,r18,0\n\t");

  /* now the decision of the exception handler is to make the tasks not able *
   * get the CPU by changing its state to TASK_STOPPED then the scheduler will
   * remove it from the runqueue .in later versions more efficient decisions 
   * depending ont he context will be made */

  /* Here the value of PSR should be decimal 14 (01110)->Hardware design*/
  
/* 
 * Not saving register bcos the task that made this exception call will be killed brutally, so right now no need 
 * to save the register values of the (about to  be) killed task. Later when the exception handler makes make
 * good decisions depending on the exception code then we have to uncomment this below line to save the registers 
 * of the current->task.
 */  
  //SAVE_USR_PT_REGS
  
  
  switch(exception_code){
  case 0 :

  case 1 :	

  case 2 :
    
  case 3 :	
    
  case 4 :	

  case 5 :	

  case 6 :

  case 7 :	

  case 8 :	

  case 9 :	
    if((servicing_syscall == 0) && (servicing_interrupt == 0))
      {
	current->state = TASK_STOPPED;//exception by application
	schedule();
      } 
    else
      {
	sys_reboot(LINUX_REBOOT_MAGIC1,LINUX_REBOOT_MAGIC2,LINUX_REBOOT_CMD_RESTART); //this means exception in kernel restarts the core.(laughter)
      }
    break;
  default:
    if(exception_code >=224)
      // handle trap here
      break;
  }
 /* New task should have been selected by the scheduler, so restoring the new task's registers */
RESTORE_USR_PT_REGS
  asm("restore_interrupts int_mask_excep\n\t"
      "retu\n\t"
      "nop\n\t"
      "nop\n\t");
}
