
/*                CUP-OS All Defines for saving registers                   */
/*              ------------------------------------------                  */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


/*
 * entry.h and entry.c contains the system-call and fault low-level handling routines. This also contains the timer-interrupt handler, as well as all interrupts * and faults that can result in a task-switch.
 *
 * NOTE: This code handles signal-recognition, which happens every time
 * after a timer-interrupt and after each system call.*/

#ifndef __ENTRY__
#define __ENTRY__

//#include "all_macros.h"
#define count_exception 11  // Number of exceptions to date in coffee


//________________________________________________________________________//

/* saves all set2 registers on the stack except PSR bcos u cant write back *
 * to it when u try to restore :-(        bad bad bad register             */

#define SAVE_ALL \
asm("chrs 3\n\t"  \
"push r0\n\t"  \
"push r1\n\t"  \
"push r2\n\t"  \
"push r3\n\t"  \
"push r4\n\t"  \
"push r5\n\t"  \
"push r6\n\t"  \
"push r7\n\t"  \
"push r8\n\t"  \
"push r9\n\t"  \
"push r10\n\t" \
"push r11\n\t" \
"push r12\n\t" \
"push r13\n\t"  \
"push r14\n\t"  \
"push r15\n\t"  \
"push r16\n\t"  \
"push r17\n\t"  \
"push r18\n\t"  \
"push r19\n\t"  \
"push r20\n\t"  \
"push r21\n\t"  \
"push r22\n\t"  \
"push r23\n\t"  \
"push r24\n\t"  \
"push r25\n\t"  \
"push r26\n\t"  \
"push r27\n\t"  \
"push r28\n\t"  \
"push SPSR\n\t" \
"push LR\n\t"   \
"scon r0\n\t"   \
"push r0\n\t");


#define RESTORE_ALL  \
asm("pop r0\n\t"   \
"rcon r0\n\t"  \
"pop LR\n\t"   \
"pop SPSR\n\t" \
"pop r28\n\t"  \
"pop r27\n\t"  \
"pop r26\n\t"  \
"pop r25\n\t"  \
"pop r24\n\t"  \
"pop r23\n\t"  \
"pop r22\n\t"  \
"pop r21\n\t"  \
"pop r20\n\t"  \
"pop r19\n\t"  \
"pop r18\n\t"  \
"pop r17\n\t"  \
"pop r16\n\t"  \
"pop r15\n\t"  \
"pop r14\n\t"  \
"pop r13\n\t"  \
"pop r12\n\t"  \
"pop r11\n\t"  \
"pop r10\n\t"  \
"pop r9\n\t"   \
"pop r8\n\t"   \
"pop r7\n\t"   \
"pop r6\n\t"   \
"pop r5\n\t"   \
"pop r4\n\t"   \
"pop r3\n\t"   \
"pop r2\n\t"   \
"pop r1\n\t"   \
"pop r0\n\t");


/*\/* saves and restores SPSR ,PR31 *\/ i no more need it

#define SAVE_SPSR_PR31     \
asm("chrs 3\n\t"  \
"get_current r16\n\t"       \
"ld r17,r16,pt_regs\n\t"     \
"st SPSR,r17,128\n\t"        \
"st LR,r17,132\n\t");

#define RESTORE_SPSR_PR31     \
asm("chrs 3\n\t"  \
"get_current r16\n\t"       \
"ld r17,r16,pt_regs\n\t"     \
"ld SPSR,r17,128\n\t"        \
"ld LR,r17,132\n\t");   */

#define SAVE_STACK_POINTER   \
asm("ldra r16,current\n\t"     \
"ld  r16,r16,0\n\t"       \
"ld r17,r16,mm_struct\n\t"   \
"push r18\n\t"  \
"push r19\n\t"  \
"chrs 2\n\t"    \
"mov r18,FP\n\t"   \
"mov r19,SP\n\t"   \
"chrs 3\n\t"   \
"st r19,r17,20\n\t"           \
"st r18,r17,24\n\t"           \
"ldra r17,KERNEL_FP\n\t"   \
"ld FP,r17,0\n\t"           \
"ldra r17,KERNEL_SP\n\t"   \
"ld SP,r17,0\n\t");

#define RESTORE_STACK_POINTER \
asm("ldra r17,KERNEL_FP\n\t"  \
"st FP,r17,0\n\t"       \
"ldra r17,KERNEL_SP\n\t"  \
"st SP,r17,0\n\t"       \
"ldra r16,current\n\t"     \
"ld  r16,r16,0\n\t"       \
"ld r17,r16,mm_struct\n\t"   \
"chrs 1\n\t"                 \
"ld SP,r17,20\n\t"           \
"ld FP,r17,24\n\t"           \
"chrs 3\n\t");

#define MOVE_INCOMING_ARGUMENTS  \
asm("chrs 2\n\t"        \
"mov r0,r0\n\t"         \
"mov r1,r1\n\t"         \
"mov r2,r2\n\t"         \
"mov r3,r3\n\t"         \
"mov r4,r4\n\t"         \
"mov r5,r5\n\t"         \
"chrs 3\n\t");


/*  Trying to get the address of current "pt_regs" and store all user regs   *
 *  into it . It might be useful for task to know its register contents      *
 */ 


#define SAVE_USR_PT_REGS  \
asm("ldra r0,current\n\t"  \
"ld   r1,r0,0\n\t"     \
"addiu r1,r1,pt_regs\n\t"   \
"ld r1,r1,0\n\t"      	\
"push r2\n\t"		\
"chrs 2 \n\t"		\
"mov r2,r1\n\t"     	\
"chrs 3 \n\t"		\
"st r2,r1,4\n\t" 	\
"pop r2\n\t"		\
"chrs 1\n\t"            \
"mov r1,r1\n\t"     	\
"chrs 0\n\t"	   \
"st r0,r1,0\n\t"   \
"st r2,r1,8\n\t"  \
"st r3,r1,12\n\t"  \
"st r4,r1,16\n\t"  \
"st r5,r1,20\n\t"  \
"st r6,r1,24\n\t"  \
"st r7,r1,28\n\t"  \
"st r8,r1,32\n\t"  \
"st r9,r1,36\n\t"  \
"st r10,r1,40\n\t"  \
"st r11,r1,44\n\t"  \
"st r12,r1,48\n\t"   \
"st r13,r1,52\n\t"   \
"st r14,r1,56\n\t"   \
"st r15,r1,60\n\t"   \
"st r16,r1,64\n\t"   \
"st r17,r1,68\n\t"   \
"st r18,r1,72\n\t"   \
"st r19,r1,76\n\t"   \
"st r20,r1,80\n\t"   \
"st r21,r1,84\n\t"   \
"st r22,r1,88\n\t"   \
"st r23,r1,92\n\t"   \
"st r24,r1,96\n\t"   \
"st r25,r1,100\n\t"  \
"st r26,r1,104\n\t"  \
"st r27,r1,108\n\t"  \
"st r28,r1,112\n\t"  \
"st r29,r1,116\n\t"  \
"st r30,r1,120\n\t"  \
"st r31,r1,124\n\t"  \
"chrs 3\n\t"        \
"st r30,r1,128\n\t"     \
"st r31,r1,132\n\t"     \
"scon r16\n\t"        \
"st r16,r1,136\n\t");


/* set2 are super user registers and set1 are user registers */

 
#define RESTORE_USR_PT_REGS  \
asm("ldra r16,current\n\t"     \
"ld  r1,r16,0\n\t"       \
"addiu r1,r1,pt_regs\n\t"   \
"ld r1,r1,0\n\t"    \
"chrs 1\n\t"        \
"mov r1,r1\n\t"     \
"chrs 0\n\t"        \
"ld r0,r1,0\n\t"    \
"ld r2,r1,8\n\t"  \
"ld r3,r1,12\n\t"  \
"ld r4,r1,16\n\t"  \
"ld r5,r1,20\n\t"  \
"ld r6,r1,24\n\t"  \
"ld r7,r1,28\n\t"  \
"ld r8,r1,32\n\t"  \
"ld r9,r1,36\n\t"  \
"ld r10,r1,40\n\t"  \
"ld r11,r1,44\n\t"  \
"ld r12,r1,48\n\t"  \
"ld r13,r1,52\n\t"  \
"ld r14,r1,56\n\t"  \
"ld r15,r1,60\n\t"  \
"ld r16,r1,64\n\t"  \
"ld r17,r1,68\n\t"  \
"ld r18,r1,72\n\t"  \
"ld r19,r1,76\n\t"  \
"ld r20,r1,80\n\t"  \
"ld r21,r1,84\n\t"  \
"ld r22,r1,88\n\t"  \
"ld r23,r1,92\n\t"  \
"ld r24,r1,96\n\t"  \
"ld r25,r1,100\n\t"  \
"ld r26,r1,104\n\t"  \
"ld r27,r1,108\n\t"  \
"ld r28,r1,112\n\t"  \
"ld r29,r1,116\n\t"  \
"ld r30,r1,120\n\t"  \
"ld r31,r1,124\n\t"  \
"ld r1,r1,4\n\t"  \
"chrs 3\n\t"	    \
"ld r30,r1,128\n\t"  \
"ld r31,r1,132\n\t"  \
"ld r16,r1,136\n\t"  \
"rcon r16\n\t");



#endif  //__ENTRY__