/*               CUP-OS  Syscalls to terminate the task                     */
/*              -----------------------------------------                   */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


//#include "signal.h" 
#include "errno.h"
#include "sched.h"

extern int mem_slots[MAX_MEMORY_SLOTS];
/* Modified a lot hope this works out*/

 inline void generate(unsigned long sig, struct task_struct * p)
{
	unsigned long flags;
	unsigned long mask = 1 << (sig-1);
	struct sigaction * sa = sig + p->sig->action - 1;

	/*
	 * Optimize away the signal, if it's a signal that can
	 * be handled immediately (ie non-blocked and untraced)
	 * and that is ignored (either explicitly or by default)
	 */
	//	save_flags(flags); cli();
	if (!(mask ) && !(PF_PTRACED)) {
		/* don't bother with ignored signals (but SIGCHLD is special) */
		if (sa->sa_handler == SIG_IGN && sig != SIGCHLD) {
			restore_flags(flags);
			return;
		}
		/* some signals are ignored by default.. (but SIGCONT already did its deed) */
		if ((sa->sa_handler == SIG_DFL) &&
		    (sig == SIGCONT || sig == SIGCHLD || sig == SIGWINCH || sig == SIGURG)) {
			restore_flags(flags);
			return;
		}
	}
	p->signal |= mask;
	if (p->state == TASK_INTERRUPTIBLE && (p->signal ))
		wake_up_process(p);
	//	restore_flags(flags);
}



int send_sig(unsigned long sig,struct task_struct * p,int priv)
{
	unsigned long flags;

	if (!p || sig > 32)
		return -EINVAL;
	if (!priv && (sig != SIGCONT)) 
		return -EPERM;
	if (!sig)
		return 0;
	/*
	 * Forget it if the process is already zombie'd.
	 */
	if (!p->sig)
		return 0;
	//	save_flags(flags); cli();
	if ((sig == SIGKILL) || (sig == SIGCONT)) {
		if (p->state == TASK_STOPPED)
			wake_up_process(p);
		p->exit_code = 0;
		p->signal &= ~( (1<<(SIGSTOP-1)) | (1<<(SIGTSTP-1)) |
				(1<<(SIGTTIN-1)) | (1<<(SIGTTOU-1)) );
	}
	if (sig == SIGSTOP || sig == SIGTSTP || sig == SIGTTIN || sig == SIGTTOU)
		p->signal &= ~(1<<(SIGCONT-1));
	//	restore_flags(flags);

	/* Actually generate the signal */
	generate(sig,p);
	return 0;
}


/*
 * kill_pg() sends a signal to a process group: this is what the tty
 * control characters do (^C, ^Z etc) and now there are no groups so
/* i have to modify this funtion a bit removing pgrp fields. :-(
 */
//int kill_pg(int pgrp, int sig, int priv)
int kill_pg(int sig, int priv)
{
	struct task_struct *p;
	int err,retval = -ESRCH;

	if (sig<0 || sig>32)
		return -EINVAL;

	return 0;
}



int kill_proc(int pid, int sig, int priv)
{
 	struct task_struct *p;

	if (sig<0 || sig>32)
		return -EINVAL;
	for_each_task(p) {
		if (p && p->pid == pid)
			return send_sig(sig,p,priv);
	}
	return(-ESRCH);
}



/*
 * POSIX specifies that kill(-1,sig) is unspecified, but what we have
 * is probably wrong.  Should make it like BSD or SYSV.
 */
int sys_kill(int pid,int sig)
{
	int err, retval = 0, count = 0;

	if (!pid)
		return(kill_pg(sig,0));
	if (pid == -1) {
		struct task_struct * p;
		for_each_task(p) {
			if (p->pid > 1 && p != current) {
				++count;
				if ((err = send_sig(sig,p,0)) != -EPERM)
					retval = err;
			}
		}
		return(count ? retval : -ESRCH);
	}
	if (pid < 0) 
		return(kill_pg(sig,0));
	/* Normal kill */
	return(kill_proc(pid,sig,1));
}

/* sys_exit work is satisfactory, unless u suggest betterments */

void  sys_exit(struct task_struct *p)
{     int temp = 0;
 temp = p->mm->memory_slot; //getting the number of memory slot used by the
                            // task
 mem_slots[temp] = 0;       // making that slot reusable for other forked tasks

 /* Trying to retrieve  all the information of the remaining tasks that the 
    exiting  process hold in its structure */

 del_from_runqueue(p);/* this not only deletes from the
      run_queue but also links its neighbouring tasks to one another in that
      queue */
 if(p->prev_task != NULL || p->next_task!= NULL)
   {
     (p->prev_task->next_task = p->next_task)->prev_task = p->prev_task;
      p->prev_task = p->next_task = NULL; /* actually we should free the memory
      of this structure task_struct but bcos CUP-OS doesnot support 
      Dynamic memory, it cant be freed now.*/
  }

 /* Here We need to free all the parent-child  relations for this process and 
    connect this process' childs to the parent of the exiting process if it 
    exists  or to INIT... but as fork is not supported for now there are no 
    parent and child relationships even though the task_struct has those 
    fields , we will use them after sys_fork() is implemented by one of us */

      
}

